/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.fairscheduler;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;

public class FairSchedulerJsonVerifications {
    private static final Set<String> RESOURCE_FIELDS = Sets.newHashSet((Object[])new String[]{"minResources", "amUsedResources", "amMaxResources", "fairResources", "clusterResources", "reservedResources", "maxResources", "usedResources", "steadyFairResources", "demandResources"});
    private final Set<String> customResourceTypes;

    FairSchedulerJsonVerifications(List<String> customResourceTypes) {
        this.customResourceTypes = Sets.newHashSet(customResourceTypes);
    }

    public void verify(JSONObject jsonObject) {
        try {
            this.verifyResourcesContainDefaultResourceTypes(jsonObject, RESOURCE_FIELDS);
            this.verifyResourcesContainCustomResourceTypes(jsonObject, RESOURCE_FIELDS);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private void verifyResourcesContainDefaultResourceTypes(JSONObject queue, Set<String> resourceCategories) throws JSONException {
        for (String resourceCategory : resourceCategories) {
            boolean hasResourceCategory = queue.has(resourceCategory);
            Assert.assertTrue((String)("Queue " + queue + " does not have resource category key: " + resourceCategory), (boolean)hasResourceCategory);
            this.verifyResourceContainsDefaultResourceTypes(queue.getJSONObject(resourceCategory));
        }
    }

    private void verifyResourceContainsDefaultResourceTypes(JSONObject jsonObject) {
        Object memory = jsonObject.opt("memory");
        Object vCores = jsonObject.opt("vCores");
        Assert.assertNotNull((String)("Key 'memory' not found in: " + jsonObject), (Object)memory);
        Assert.assertNotNull((String)("Key 'vCores' not found in: " + jsonObject), (Object)vCores);
    }

    private void verifyResourcesContainCustomResourceTypes(JSONObject queue, Set<String> resourceCategories) throws JSONException {
        for (String resourceCategory : resourceCategories) {
            Assert.assertTrue((String)("Queue " + queue + " does not have resource category key: " + resourceCategory), (boolean)queue.has(resourceCategory));
            this.verifyResourceContainsAllCustomResourceTypes(queue.getJSONObject(resourceCategory));
        }
    }

    private void verifyResourceContainsAllCustomResourceTypes(JSONObject resourceCategory) throws JSONException {
        Assert.assertTrue((String)("resourceCategory does not have resourceInformations: " + resourceCategory), (boolean)resourceCategory.has("resourceInformations"));
        JSONObject resourceInformations = resourceCategory.getJSONObject("resourceInformations");
        Assert.assertTrue((String)("resourceInformations does not have resourceInformation object: " + resourceInformations), (boolean)resourceInformations.has("resourceInformation"));
        JSONArray customResources = resourceInformations.getJSONArray("resourceInformation");
        Assert.assertEquals((String)"Different number of custom resource types found than expected", (long)this.customResourceTypes.size(), (long)(customResources.length() - 2));
        for (int i = 0; i < customResources.length(); ++i) {
            JSONObject customResource = customResources.getJSONObject(i);
            Assert.assertTrue((String)("Resource type does not have name field: " + customResource), (boolean)customResource.has("name"));
            Assert.assertTrue((String)("Resource type does not have name resourceType field: " + customResource), (boolean)customResource.has("resourceType"));
            Assert.assertTrue((String)("Resource type does not have name units field: " + customResource), (boolean)customResource.has("units"));
            Assert.assertTrue((String)("Resource type does not have name value field: " + customResource), (boolean)customResource.has("value"));
            String name = customResource.getString("name");
            String unit = customResource.getString("units");
            String resourceType = customResource.getString("resourceType");
            Long value = customResource.getLong("value");
            if ("memory-mb".equals(name) || "vcores".equals(name)) continue;
            Assert.assertTrue((String)("Custom resource type " + name + " not found"), (boolean)this.customResourceTypes.contains(name));
            Assert.assertEquals((Object)"k", (Object)unit);
            Assert.assertEquals((Object)ResourceTypes.COUNTABLE, (Object)ResourceTypes.valueOf((String)resourceType));
            Assert.assertNotNull((String)("Custom resource value " + value + " is null!"), (Object)value);
        }
    }
}

