/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.Application;
import org.apache.hadoop.yarn.server.resourcemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.Task;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerHealth;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestSchedulerHealth {
    private ResourceManager resourceManager;

    public void setup() {
        this.resourceManager = new ResourceManager(){

            protected RMNodeLabelsManager createNodeLabelManager() {
                NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
                mgr.init(this.getConfig());
                return mgr;
            }
        };
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.resourceManager.init((Configuration)conf);
        this.resourceManager.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        this.resourceManager.getRMContext().getNMTokenSecretManager().rollMasterKey();
        ((AsyncDispatcher)this.resourceManager.getRMContext().getDispatcher()).start();
    }

    @Test
    public void testCounts() {
        SchedulerHealth sh = new SchedulerHealth();
        int value = 1;
        for (int i = 0; i < 2; ++i) {
            sh.updateSchedulerPreemptionCounts((long)value);
            sh.updateSchedulerAllocationCounts((long)value);
            sh.updateSchedulerReservationCounts((long)value);
            sh.updateSchedulerReleaseCounts((long)value);
            Assert.assertEquals((long)value, (long)sh.getAllocationCount());
            Assert.assertEquals((long)value, (long)sh.getReleaseCount());
            Assert.assertEquals((long)value, (long)sh.getReservationCount());
            Assert.assertEquals((long)value, (long)sh.getPreemptionCount());
            Assert.assertEquals((long)(value * (i + 1)), (long)sh.getAggregateAllocationCount());
            Assert.assertEquals((long)(value * (i + 1)), (long)sh.getAggregateReleaseCount());
            Assert.assertEquals((long)(value * (i + 1)), (long)sh.getAggregateReservationCount());
            Assert.assertEquals((long)(value * (i + 1)), (long)sh.getAggregatePreemptionCount());
        }
    }

    @Test
    public void testOperationDetails() {
        SchedulerHealth sh = new SchedulerHealth();
        long now = Time.now();
        sh.updateRelease(now, NodeId.newInstance((String)"testhost", (int)1234), ContainerId.fromString((String)"container_1427562107907_0002_01_000001"), "testqueue");
        Assert.assertEquals((Object)"container_1427562107907_0002_01_000001", (Object)sh.getLastReleaseDetails().getContainerId().toString());
        Assert.assertEquals((Object)"testhost:1234", (Object)sh.getLastReleaseDetails().getNodeId().toString());
        Assert.assertEquals((Object)"testqueue", (Object)sh.getLastReleaseDetails().getQueue());
        Assert.assertEquals((long)now, (long)sh.getLastReleaseDetails().getTimestamp());
        Assert.assertEquals((long)0L, (long)sh.getLastSchedulerRunTime());
        now = Time.now();
        sh.updateReservation(now, NodeId.newInstance((String)"testhost1", (int)1234), ContainerId.fromString((String)"container_1427562107907_0003_01_000001"), "testqueue1");
        Assert.assertEquals((Object)"container_1427562107907_0003_01_000001", (Object)sh.getLastReservationDetails().getContainerId().toString());
        Assert.assertEquals((Object)"testhost1:1234", (Object)sh.getLastReservationDetails().getNodeId().toString());
        Assert.assertEquals((Object)"testqueue1", (Object)sh.getLastReservationDetails().getQueue());
        Assert.assertEquals((long)now, (long)sh.getLastReservationDetails().getTimestamp());
        Assert.assertEquals((long)0L, (long)sh.getLastSchedulerRunTime());
        now = Time.now();
        sh.updateAllocation(now, NodeId.newInstance((String)"testhost2", (int)1234), ContainerId.fromString((String)"container_1427562107907_0004_01_000001"), "testqueue2");
        Assert.assertEquals((Object)"container_1427562107907_0004_01_000001", (Object)sh.getLastAllocationDetails().getContainerId().toString());
        Assert.assertEquals((Object)"testhost2:1234", (Object)sh.getLastAllocationDetails().getNodeId().toString());
        Assert.assertEquals((Object)"testqueue2", (Object)sh.getLastAllocationDetails().getQueue());
        Assert.assertEquals((long)now, (long)sh.getLastAllocationDetails().getTimestamp());
        Assert.assertEquals((long)0L, (long)sh.getLastSchedulerRunTime());
        now = Time.now();
        sh.updatePreemption(now, NodeId.newInstance((String)"testhost3", (int)1234), ContainerId.fromString((String)"container_1427562107907_0005_01_000001"), "testqueue3");
        Assert.assertEquals((Object)"container_1427562107907_0005_01_000001", (Object)sh.getLastPreemptionDetails().getContainerId().toString());
        Assert.assertEquals((Object)"testhost3:1234", (Object)sh.getLastPreemptionDetails().getNodeId().toString());
        Assert.assertEquals((Object)"testqueue3", (Object)sh.getLastPreemptionDetails().getQueue());
        Assert.assertEquals((long)now, (long)sh.getLastPreemptionDetails().getTimestamp());
        Assert.assertEquals((long)0L, (long)sh.getLastSchedulerRunTime());
    }

    @Test
    public void testResourceUpdate() {
        SchedulerHealth sh = new SchedulerHealth();
        long now = Time.now();
        sh.updateSchedulerRunDetails(now, Resource.newInstance((int)1024, (int)1), Resource.newInstance((int)2048, (int)1));
        Assert.assertEquals((long)now, (long)sh.getLastSchedulerRunTime());
        Assert.assertEquals((Object)Resource.newInstance((int)1024, (int)1), (Object)sh.getResourcesAllocated());
        Assert.assertEquals((Object)Resource.newInstance((int)2048, (int)1), (Object)sh.getResourcesReserved());
        now = Time.now();
        sh.updateSchedulerReleaseDetails(now, Resource.newInstance((int)3072, (int)1));
        Assert.assertEquals((long)now, (long)sh.getLastSchedulerRunTime());
        Assert.assertEquals((Object)Resource.newInstance((int)3072, (int)1), (Object)sh.getResourcesReleased());
    }

    private NodeManager registerNode(String hostName, int containerManagerPort, int httpPort, String rackName, Resource capability) throws IOException, YarnException {
        NodeManager nm = new NodeManager(hostName, containerManagerPort, httpPort, rackName, capability, this.resourceManager);
        NodeAddedSchedulerEvent nodeAddEvent1 = new NodeAddedSchedulerEvent((RMNode)this.resourceManager.getRMContext().getRMNodes().get(nm.getNodeId()));
        this.resourceManager.getResourceScheduler().handle((Event)nodeAddEvent1);
        return nm;
    }

    private void nodeUpdate(NodeManager nm) {
        RMNode node = (RMNode)this.resourceManager.getRMContext().getRMNodes().get(nm.getNodeId());
        NodeUpdateSchedulerEvent nodeUpdate = new NodeUpdateSchedulerEvent(node);
        this.resourceManager.getResourceScheduler().handle((Event)nodeUpdate);
    }

    @Test
    public void testCapacitySchedulerAllocation() throws Exception {
        this.setup();
        boolean isCapacityScheduler = this.resourceManager.getResourceScheduler() instanceof CapacityScheduler;
        Assume.assumeTrue((String)"This test is only supported on Capacity Scheduler", (boolean)isCapacityScheduler);
        String host_0 = "host_0";
        NodeManager nm_0 = this.registerNode(host_0, 1234, 2345, "/default-rack", Resources.createResource((int)5120, (int)1));
        Priority priority_0 = Priority.newInstance((int)0);
        Priority priority_1 = Priority.newInstance((int)1);
        Application application_0 = new Application("user_0", "default", this.resourceManager);
        application_0.submit();
        application_0.addNodeManager(host_0, 1234, nm_0);
        Resource capability_0_0 = Resources.createResource((int)1024, (int)1);
        application_0.addResourceRequestSpec(priority_1, capability_0_0);
        Resource capability_0_1 = Resources.createResource((int)2048, (int)1);
        application_0.addResourceRequestSpec(priority_0, capability_0_1);
        Task task_0_0 = new Task(application_0, priority_1, new String[]{host_0});
        application_0.addTask(task_0_0);
        Task task_0_1 = new Task(application_0, priority_0, new String[]{host_0});
        application_0.addTask(task_0_1);
        application_0.schedule();
        this.nodeUpdate(nm_0);
        SchedulerHealth sh = ((CapacityScheduler)this.resourceManager.getResourceScheduler()).getSchedulerHealth();
        Assert.assertEquals((long)1L, (long)sh.getAllocationCount());
        Assert.assertEquals((Object)Resource.newInstance((int)1024, (int)1), (Object)sh.getResourcesAllocated());
        Assert.assertEquals((long)2L, (long)sh.getAggregateAllocationCount());
        Assert.assertEquals((Object)"host_0:1234", (Object)sh.getLastAllocationDetails().getNodeId().toString());
        Assert.assertEquals((Object)"root.default", (Object)sh.getLastAllocationDetails().getQueue());
        Task task_0_2 = new Task(application_0, priority_0, new String[]{host_0});
        application_0.addTask(task_0_2);
        application_0.schedule();
        this.nodeUpdate(nm_0);
        Assert.assertEquals((long)1L, (long)sh.getAllocationCount());
        Assert.assertEquals((Object)Resource.newInstance((int)2048, (int)1), (Object)sh.getResourcesAllocated());
        Assert.assertEquals((long)3L, (long)sh.getAggregateAllocationCount());
        Assert.assertEquals((Object)"host_0:1234", (Object)sh.getLastAllocationDetails().getNodeId().toString());
        Assert.assertEquals((Object)"root.default", (Object)sh.getLastAllocationDetails().getQueue());
    }

    @Test
    public void testCapacitySchedulerReservation() throws Exception {
        this.setup();
        boolean isCapacityScheduler = this.resourceManager.getResourceScheduler() instanceof CapacityScheduler;
        Assume.assumeTrue((String)"This test is only supported on Capacity Scheduler", (boolean)isCapacityScheduler);
        String host_0 = "host_0";
        NodeManager nm_0 = this.registerNode(host_0, 1234, 2345, "/default-rack", Resources.createResource((int)2048, (int)1));
        String host_1 = "host_1";
        NodeManager nm_1 = this.registerNode(host_1, 1234, 2345, "/default-rack", Resources.createResource((int)5120, (int)1));
        this.nodeUpdate(nm_0);
        this.nodeUpdate(nm_1);
        Priority priority_0 = Priority.newInstance((int)0);
        Priority priority_1 = Priority.newInstance((int)1);
        Application application_0 = new Application("user_0", "default", this.resourceManager);
        application_0.submit();
        application_0.addNodeManager(host_0, 1234, nm_0);
        application_0.addNodeManager(host_1, 1234, nm_1);
        Resource capability_0_0 = Resources.createResource((int)1024, (int)1);
        application_0.addResourceRequestSpec(priority_1, capability_0_0);
        Resource capability_0_1 = Resources.createResource((int)2048, (int)1);
        application_0.addResourceRequestSpec(priority_0, capability_0_1);
        Task task_0_0 = new Task(application_0, priority_1, new String[]{host_0});
        application_0.addTask(task_0_0);
        application_0.schedule();
        this.nodeUpdate(nm_0);
        SchedulerHealth sh = ((CapacityScheduler)this.resourceManager.getResourceScheduler()).getSchedulerHealth();
        Assert.assertEquals((long)1L, (long)sh.getAllocationCount());
        Assert.assertEquals((Object)Resource.newInstance((int)1024, (int)1), (Object)sh.getResourcesAllocated());
        Assert.assertEquals((long)1L, (long)sh.getAggregateAllocationCount());
        Assert.assertEquals((Object)"host_0:1234", (Object)sh.getLastAllocationDetails().getNodeId().toString());
        Assert.assertEquals((Object)"root.default", (Object)sh.getLastAllocationDetails().getQueue());
        Task task_0_1 = new Task(application_0, priority_0, new String[]{host_0});
        application_0.addTask(task_0_1);
        application_0.schedule();
        this.nodeUpdate(nm_0);
        Assert.assertEquals((long)0L, (long)sh.getAllocationCount());
        Assert.assertEquals((long)1L, (long)sh.getReservationCount());
        Assert.assertEquals((Object)Resource.newInstance((int)2048, (int)1), (Object)sh.getResourcesReserved());
        Assert.assertEquals((long)1L, (long)sh.getAggregateAllocationCount());
        Assert.assertEquals((Object)"host_0:1234", (Object)sh.getLastAllocationDetails().getNodeId().toString());
        Assert.assertEquals((Object)"root.default", (Object)sh.getLastAllocationDetails().getQueue());
    }
}

