/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.LocalConfigurationProvider;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCSAllocateCustomResource {
    private YarnConfiguration conf;
    private RMNodeLabelsManager mgr;
    private File resourceTypesFile = null;
    private final int g = 1024;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
    }

    @After
    public void tearDown() {
        if (this.resourceTypesFile != null && this.resourceTypesFile.exists()) {
            this.resourceTypesFile.delete();
        }
    }

    @Test
    public void testCapacitySchedulerJobWhenConfigureCustomResourceType() throws Exception {
        ResourceUtils.resetResourceTypes();
        String resourceTypesFileName = "resource-types-test.xml";
        File source = new File(this.conf.getClassLoader().getResource(resourceTypesFileName).getFile());
        this.resourceTypesFile = new File(source.getParent(), "resource-types.xml");
        FileUtils.copyFile((File)source, (File)this.resourceTypesFile);
        CapacitySchedulerConfiguration newConf = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithMultipleQueues((Configuration)this.conf);
        newConf.setClass("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class, ResourceCalculator.class);
        newConf.set(CapacitySchedulerConfiguration.getQueuePrefix((String)"root.a") + "maximum-allocation-mb", "4096");
        newConf.setBoolean("yarn.test.reset-resource-types", false);
        MockRM rm = new MockRM((Configuration)newConf);
        rm.start();
        String customResourceType = "yarn.io/gpu";
        Resource nodeResource = Resources.createResource((int)4096, (int)4);
        nodeResource.setResourceValue(customResourceType, 10L);
        MockNM nm1 = rm.registerNode("h1:1234", nodeResource);
        Resource amResource = Resources.createResource((int)1024, (int)1);
        amResource.setResourceValue(customResourceType, 1L);
        RMApp app1 = rm.submitApp(amResource, "app", "user", null, "a");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        Resource cResource = Resources.createResource((int)1024, (int)1);
        amResource.setResourceValue(customResourceType, 1L);
        am1.allocate("*", cResource, 2, new ArrayList<ContainerId>(), null);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId());
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        rm.drainEvents();
        Assert.assertEquals((long)2L, (long)schedulerApp1.getLiveContainers().size());
        rm.close();
    }

    @Test
    public void testCapacitySchedulerInitWithCustomResourceType() throws IOException {
        ResourceUtils.resetResourceTypes();
        String resourceTypesFileName = "resource-types-test.xml";
        File source = new File(this.conf.getClassLoader().getResource(resourceTypesFileName).getFile());
        this.resourceTypesFile = new File(source.getParent(), "resource-types.xml");
        FileUtils.copyFile((File)source, (File)this.resourceTypesFile);
        CapacityScheduler cs = new CapacityScheduler();
        CapacityScheduler spyCS = (CapacityScheduler)Mockito.spy((Object)cs);
        CapacitySchedulerConfiguration csConf = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithMultipleQueues((Configuration)this.conf);
        csConf.setClass("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class, ResourceCalculator.class);
        spyCS.setConf((Configuration)csConf);
        NullRMNodeLabelsManager nodeLabelsManager = new NullRMNodeLabelsManager();
        nodeLabelsManager.init((Configuration)csConf);
        PlacementManager pm = new PlacementManager();
        RMContext mockContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)mockContext.getConfigurationProvider()).thenReturn((Object)new LocalConfigurationProvider());
        mockContext.setNodeLabelManager((RMNodeLabelsManager)nodeLabelsManager);
        Mockito.when((Object)mockContext.getNodeLabelManager()).thenReturn((Object)nodeLabelsManager);
        Mockito.when((Object)mockContext.getQueuePlacementManager()).thenReturn((Object)pm);
        spyCS.setRMContext(mockContext);
        spyCS.init((Configuration)csConf);
        Assert.assertNotEquals((long)0L, (long)ResourceUtils.fetchMaximumAllocationFromConfig((Configuration)spyCS.getConfiguration()).getResourceValue("yarn.io/gpu"));
        Assert.assertNotEquals((long)0L, (long)spyCS.getMaximumResourceCapability("a").getResourceValue("yarn.io/gpu"));
    }
}

