/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.FSSchedulerConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFSSchedulerConfigurationStore {
    private FSSchedulerConfigurationStore configurationStore;
    private Configuration conf;
    private File testSchedulerConfigurationDir;

    @Before
    public void setUp() throws Exception {
        this.configurationStore = new FSSchedulerConfigurationStore();
        this.testSchedulerConfigurationDir = new File(TestFSSchedulerConfigurationStore.class.getResource("").getPath() + FSSchedulerConfigurationStore.class.getSimpleName());
        this.testSchedulerConfigurationDir.mkdirs();
        this.conf = new Configuration();
        this.conf.set("yarn.scheduler.configuration.fs.path", this.testSchedulerConfigurationDir.getAbsolutePath());
    }

    private void writeConf(Configuration config) throws IOException {
        FileSystem fileSystem = FileSystem.get((Configuration)new Configuration(config));
        String schedulerConfigurationFile = "capacity-scheduler.xml." + System.currentTimeMillis();
        FSDataOutputStream outputStream = fileSystem.create(new Path(this.testSchedulerConfigurationDir.getAbsolutePath(), schedulerConfigurationFile));
        config.writeXml((OutputStream)outputStream);
        outputStream.close();
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.testSchedulerConfigurationDir);
    }

    @Test
    public void confirmMutationWithValid() throws Exception {
        this.conf.setInt("yarn.scheduler.configuration.max.version", 2);
        this.conf.set("a", "a");
        this.conf.set("b", "b");
        this.conf.set("c", "c");
        this.writeConf(this.conf);
        this.configurationStore.initialize(this.conf, this.conf, null);
        Configuration storeConf = this.configurationStore.retrieve();
        this.compareConfig(this.conf, storeConf);
        HashMap<String, String> updates = new HashMap<String, String>();
        updates.put("a", null);
        updates.put("b", "bb");
        Configuration expectConfig = new Configuration(this.conf);
        expectConfig.unset("a");
        expectConfig.set("b", "bb");
        YarnConfigurationStore.LogMutation logMutation = new YarnConfigurationStore.LogMutation(updates, "test");
        this.configurationStore.logMutation(logMutation);
        this.configurationStore.confirmMutation(true);
        storeConf = this.configurationStore.retrieve();
        Assert.assertEquals(null, (Object)storeConf.get("a"));
        Assert.assertEquals((Object)"bb", (Object)storeConf.get("b"));
        Assert.assertEquals((Object)"c", (Object)storeConf.get("c"));
        this.compareConfig(expectConfig, storeConf);
        updates.put("b", "bbb");
        this.configurationStore.logMutation(logMutation);
        this.configurationStore.confirmMutation(true);
        storeConf = this.configurationStore.retrieve();
        Assert.assertEquals(null, (Object)storeConf.get("a"));
        Assert.assertEquals((Object)"bbb", (Object)storeConf.get("b"));
        Assert.assertEquals((Object)"c", (Object)storeConf.get("c"));
    }

    @Test
    public void confirmMutationWithInValid() throws Exception {
        this.conf.set("a", "a");
        this.conf.set("b", "b");
        this.conf.set("c", "c");
        this.writeConf(this.conf);
        this.configurationStore.initialize(this.conf, this.conf, null);
        Configuration storeConf = this.configurationStore.retrieve();
        this.compareConfig(this.conf, storeConf);
        HashMap<String, String> updates = new HashMap<String, String>();
        updates.put("a", null);
        updates.put("b", "bb");
        YarnConfigurationStore.LogMutation logMutation = new YarnConfigurationStore.LogMutation(updates, "test");
        this.configurationStore.logMutation(logMutation);
        this.configurationStore.confirmMutation(false);
        storeConf = this.configurationStore.retrieve();
        this.compareConfig(this.conf, storeConf);
    }

    @Test
    public void retrieve() throws Exception {
        Configuration schedulerConf = new Configuration();
        schedulerConf.set("a", "a");
        schedulerConf.setLong("long", 1L);
        schedulerConf.setBoolean("boolean", true);
        this.writeConf(schedulerConf);
        this.configurationStore.initialize(this.conf, this.conf, null);
        Configuration storedConfig = this.configurationStore.retrieve();
        this.compareConfig(schedulerConf, storedConfig);
    }

    @Test
    public void checkVersion() {
        try {
            this.configurationStore.checkVersion();
        }
        catch (Exception e) {
            Assert.fail((String)"checkVersion throw exception");
        }
    }

    private void compareConfig(Configuration schedulerConf, Configuration storedConfig) {
        for (Map.Entry entry : schedulerConf) {
            Assert.assertEquals((String)((String)entry.getKey()), (Object)schedulerConf.get((String)entry.getKey()), (Object)storedConfig.get((String)entry.getKey()));
        }
        for (Map.Entry entry : storedConfig) {
            Assert.assertEquals((String)((String)entry.getKey()), (Object)storedConfig.get((String)entry.getKey()), (Object)schedulerConf.get((String)entry.getKey()));
        }
    }
}

