/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.LocalConfigurationProvider;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourceRequestPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.InvalidLabelResourceRequestException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceBlacklistRequestException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.resourcetypes.ResourceTypesTestHelper;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.TestAMAuthorization;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestSchedulerUtils {
    private static final Log LOG = LogFactory.getLog(TestSchedulerUtils.class);
    private static Resource configuredMaxAllocation;
    private RMContext rmContext = TestSchedulerUtils.getMockRMContext();
    private static YarnConfiguration conf;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    private void initResourceTypes() {
        Configuration yarnConf = new Configuration();
        yarnConf.set("yarn.resourcemanager.configuration.provider-class", CustomResourceTypesConfigurationProvider.class.getName());
        ResourceUtils.resetResourceTypes((Configuration)yarnConf);
    }

    @Before
    public void setUp() {
        this.initResourceTypes();
        configuredMaxAllocation = Resource.newInstance((long)8192L, (int)4, (Map)ImmutableMap.builder().put((Object)"custom-resource-1", (Object)Long.MAX_VALUE).put((Object)"custom-resource-2", (Object)Long.MAX_VALUE).put((Object)"custom-resource-3", (Object)Long.MAX_VALUE).build());
    }

    @Test(timeout=30000L)
    public void testNormalizeRequest() {
        DefaultResourceCalculator resourceCalculator = new DefaultResourceCalculator();
        int minMemory = 1024;
        int maxMemory = 8192;
        Resource minResource = Resources.createResource((int)1024, (int)0);
        Resource maxResource = Resources.createResource((int)8192, (int)0);
        ResourceRequestPBImpl ask = new ResourceRequestPBImpl();
        ask.setCapability(Resources.createResource((int)-1024));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((long)1024L, (long)ask.getCapability().getMemorySize());
        ask.setCapability(Resources.createResource((int)0));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((long)1024L, (long)ask.getCapability().getMemorySize());
        ask.setCapability(Resources.createResource((int)2048));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((long)2048L, (long)ask.getCapability().getMemorySize());
        ask.setCapability(Resources.createResource((int)1034));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((long)2048L, (long)ask.getCapability().getMemorySize());
        ask.setCapability(Resources.createResource((int)8192));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((long)8192L, (long)ask.getCapability().getMemorySize());
        ask.setCapability(Resources.createResource((int)8182));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((long)8192L, (long)ask.getCapability().getMemorySize());
        maxResource = Resources.createResource((int)8182, (int)0);
        ask.setCapability(Resources.createResource((int)8092));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((long)maxResource.getMemorySize(), (long)ask.getCapability().getMemorySize());
        maxResource = Resources.createResource((int)8192, (int)0);
        ask.setCapability(Resources.createResource((int)8292));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((long)maxResource.getMemorySize(), (long)ask.getCapability().getMemorySize());
    }

    @Test(timeout=30000L)
    public void testNormalizeRequestWithDominantResourceCalculator() {
        DominantResourceCalculator resourceCalculator = new DominantResourceCalculator();
        Resource minResource = Resources.createResource((int)1024, (int)1);
        Resource maxResource = Resources.createResource((int)10240, (int)10);
        Resource clusterResource = Resources.createResource((int)10240, (int)10);
        ResourceRequestPBImpl ask = new ResourceRequestPBImpl();
        ask.setCapability(Resources.createResource((int)-1024, (int)-1));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((Object)minResource, (Object)ask.getCapability());
        ask.setCapability(Resources.createResource((int)0, (int)0));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((Object)minResource, (Object)ask.getCapability());
        Assert.assertEquals((long)1L, (long)ask.getCapability().getVirtualCores());
        Assert.assertEquals((long)1024L, (long)ask.getCapability().getMemorySize());
        ask.setCapability(Resources.createResource((int)1536, (int)0));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((Object)Resources.createResource((int)2048, (int)1), (Object)ask.getCapability());
        Assert.assertEquals((long)1L, (long)ask.getCapability().getVirtualCores());
        Assert.assertEquals((long)2048L, (long)ask.getCapability().getMemorySize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test(timeout=30000L)
    public void testValidateResourceRequestWithErrorLabelsPermission() throws IOException {
        ResourceRequest resReq1;
        ResourceRequest resReq;
        Resource resource;
        ResourceRequest resReq22;
        Resource resource2;
        ResourceScheduler scheduler = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        HashSet queueAccessibleNodeLabels = Sets.newHashSet();
        QueueInfo queueInfo = (QueueInfo)Mockito.mock(QueueInfo.class);
        Mockito.when((Object)queueInfo.getQueueName()).thenReturn((Object)"queue");
        Mockito.when((Object)queueInfo.getAccessibleNodeLabels()).thenReturn((Object)queueAccessibleNodeLabels);
        Mockito.when((Object)scheduler.getQueueInfo((String)Matchers.any(String.class), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)queueInfo);
        Mockito.when((Object)this.rmContext.getScheduler()).thenReturn((Object)scheduler);
        Resource maxResource = Resources.createResource((int)8192, (int)4);
        try {
            queueAccessibleNodeLabels.clear();
            queueAccessibleNodeLabels.addAll(Arrays.asList("x", "y"));
            this.rmContext.getNodeLabelManager().addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x"), (Object)NodeLabel.newInstance((String)"y")));
            resource2 = Resources.createResource((int)0, (int)1);
            resReq22 = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource2, (int)1);
            resReq22.setNodeLabelExpression("x");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq22, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
            resReq22.setNodeLabelExpression("y");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq22, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
            resReq22.setNodeLabelExpression("");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq22, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
            resReq22.setNodeLabelExpression(" ");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq22, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
        }
        catch (InvalidResourceRequestException e) {
            try {
                e.printStackTrace();
                Assert.fail((String)"Should be valid when request labels is a subset of queue labels");
            }
            catch (Throwable throwable) {
                this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x", "y"));
                throw throwable;
            }
            this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x", "y"));
        }
        this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x", "y"));
        try {
            queueAccessibleNodeLabels.clear();
            queueAccessibleNodeLabels.addAll(Arrays.asList("x", "y"));
            resource2 = Resources.createResource((int)0, (int)1);
            resReq22 = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource2, (int)1);
            resReq22.setNodeLabelExpression("x");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq22, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
            Assert.fail((String)"Should fail");
        }
        catch (InvalidResourceRequestException resource3) {
            // empty catch block
        }
        try {
            queueAccessibleNodeLabels.clear();
            queueAccessibleNodeLabels.addAll(Arrays.asList("x", "y"));
            this.rmContext.getNodeLabelManager().addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x"), (Object)NodeLabel.newInstance((String)"y")));
            resource2 = Resources.createResource((int)0, (int)1);
            resReq22 = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource2, (int)1);
            resReq22.setNodeLabelExpression("z");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq22, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
            Assert.fail((String)"Should fail");
        }
        catch (InvalidResourceRequestException resource4) {
            this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x", "y"));
            catch (Throwable throwable) {
                this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x", "y"));
                throw throwable;
            }
        }
        this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x", "y"));
        try {
            queueAccessibleNodeLabels.clear();
            queueAccessibleNodeLabels.addAll(Arrays.asList("x", "y"));
            this.rmContext.getNodeLabelManager().addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x"), (Object)NodeLabel.newInstance((String)"y")));
            resource2 = Resources.createResource((int)0, (int)1);
            resReq22 = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource2, (int)1);
            resReq22.setNodeLabelExpression("x && y");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq22, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
            Assert.fail((String)"Should fail");
        }
        catch (InvalidResourceRequestException resource5) {
            this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x", "y"));
            catch (Throwable throwable) {
                this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x", "y"));
                throw throwable;
            }
        }
        this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x", "y"));
        queueAccessibleNodeLabels.clear();
        try {
            queueAccessibleNodeLabels.clear();
            resource2 = Resources.createResource((int)0, (int)1);
            resReq22 = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource2, (int)1);
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq22, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
            resReq22.setNodeLabelExpression("");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq22, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
            resReq22.setNodeLabelExpression("  ");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq22, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
        }
        catch (InvalidResourceRequestException e) {
            e.printStackTrace();
            Assert.fail((String)"Should be valid when request labels is empty");
        }
        boolean invalidlabelexception = false;
        try {
            queueAccessibleNodeLabels.clear();
            this.rmContext.getNodeLabelManager().addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x")));
            resource = Resources.createResource((int)0, (int)1);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            resReq.setNodeLabelExpression("x");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
            Assert.fail((String)"Should fail");
        }
        catch (InvalidLabelResourceRequestException e222222) {
            invalidlabelexception = true;
            this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x"));
        }
        catch (InvalidResourceRequestException e222222) {
            this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x"));
            {
                catch (Throwable throwable) {
                    this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x"));
                    throw throwable;
                }
            }
        }
        this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x"));
        Assert.assertTrue((String)"InvalidLabelResourceRequestException expected", (boolean)invalidlabelexception);
        try {
            queueAccessibleNodeLabels.clear();
            queueAccessibleNodeLabels.add("*");
            this.rmContext.getNodeLabelManager().addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x"), (Object)NodeLabel.newInstance((String)"y"), (Object)NodeLabel.newInstance((String)"z")));
            resource = Resources.createResource((int)0, (int)1);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            resReq.setNodeLabelExpression("x");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
            resReq.setNodeLabelExpression("y");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
            resReq.setNodeLabelExpression("z");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
        }
        catch (InvalidResourceRequestException e) {
            try {
                e.printStackTrace();
                Assert.fail((String)"Should be valid when queue can access any labels");
            }
            catch (Throwable throwable) {
                this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x", "y", "z"));
                throw throwable;
            }
            this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x", "y", "z"));
        }
        this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x", "y", "z"));
        try {
            queueAccessibleNodeLabels.clear();
            queueAccessibleNodeLabels.add("*");
            resource = Resources.createResource((int)0, (int)1);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            resReq.setNodeLabelExpression("x");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
            Assert.fail((String)"Should fail");
        }
        catch (InvalidResourceRequestException resource6) {
            // empty catch block
        }
        try {
            queueAccessibleNodeLabels.clear();
            queueAccessibleNodeLabels.addAll(Arrays.asList("x", "y"));
            this.rmContext.getNodeLabelManager().addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x"), (Object)NodeLabel.newInstance((String)"y")));
            resource = Resources.createResource((int)0, (int)1);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"rack", (Resource)resource, (int)1);
            resReq.setNodeLabelExpression("x");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
            Assert.fail((String)"Should fail");
        }
        catch (InvalidResourceRequestException resource7) {
            this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x", "y"));
            catch (Throwable throwable) {
                this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x", "y"));
                throw throwable;
            }
        }
        this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x", "y"));
        try {
            queueAccessibleNodeLabels.clear();
            queueAccessibleNodeLabels.addAll(Arrays.asList("*"));
            this.rmContext.getNodeLabelManager().addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x")));
            resource = Resources.createResource((int)0, (int)1);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"rack", (Resource)resource, (int)1);
            resReq.setNodeLabelExpression("x");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
            Assert.fail((String)"Should fail");
        }
        catch (InvalidResourceRequestException resource8) {
            this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x"));
            catch (Throwable throwable) {
                this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x"));
                throw throwable;
            }
        }
        this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x"));
        try {
            resource = Resources.createResource((int)0, (int)1);
            resReq1 = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1, (String)"x");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq1, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
            Assert.fail((String)"Should fail");
        }
        catch (InvalidResourceRequestException e) {
            Assert.assertEquals((Object)"Invalid label resource request, cluster do not contain , label= x", (Object)e.getMessage());
        }
        try {
            this.rmContext.getYarnConfiguration().set("yarn.node-labels.enabled", "false");
            resource = Resources.createResource((int)0, (int)1);
            resReq1 = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1, (String)"x");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq1, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
            Assert.assertEquals((Object)"", (Object)resReq1.getNodeLabelExpression());
        }
        catch (InvalidResourceRequestException e) {
            Assert.assertEquals((Object)"Invalid resource request, node label not enabled but request contains label expression", (Object)e.getMessage());
        }
    }

    @Test(timeout=30000L)
    public void testValidateResourceRequest() throws IOException {
        ResourceRequest resReq;
        Resource resource;
        ResourceScheduler mockScheduler = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        QueueInfo queueInfo = (QueueInfo)Mockito.mock(QueueInfo.class);
        Mockito.when((Object)queueInfo.getQueueName()).thenReturn((Object)"queue");
        Resource maxResource = Resources.createResource((int)8192, (int)4);
        Mockito.when((Object)this.rmContext.getScheduler()).thenReturn((Object)mockScheduler);
        Mockito.when((Object)mockScheduler.getQueueInfo(Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)queueInfo);
        try {
            resource = Resources.createResource((int)0, (int)1);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq, null, (YarnScheduler)mockScheduler, this.rmContext, maxResource);
        }
        catch (InvalidResourceRequestException e) {
            Assert.fail((String)"Zero memory should be accepted");
        }
        try {
            resource = Resources.createResource((int)1024, (int)0);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq, null, (YarnScheduler)mockScheduler, this.rmContext, maxResource);
        }
        catch (InvalidResourceRequestException e) {
            Assert.fail((String)"Zero vcores should be accepted");
        }
        try {
            resource = Resources.createResource((int)8192, (int)1);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq, null, (YarnScheduler)mockScheduler, this.rmContext, maxResource);
        }
        catch (InvalidResourceRequestException e) {
            Assert.fail((String)"Max memory should be accepted");
        }
        try {
            resource = Resources.createResource((int)1024, (int)4);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq, null, (YarnScheduler)mockScheduler, this.rmContext, maxResource);
        }
        catch (InvalidResourceRequestException e) {
            Assert.fail((String)"Max vcores should not be accepted");
        }
        try {
            resource = Resources.createResource((int)-1, (int)1);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq, null, (YarnScheduler)mockScheduler, this.rmContext, maxResource);
            Assert.fail((String)"Negative memory should not be accepted");
        }
        catch (InvalidResourceRequestException e) {
            Assert.assertEquals((Object)InvalidResourceRequestException.InvalidResourceType.LESS_THAN_ZERO, (Object)e.getInvalidResourceType());
        }
        try {
            resource = Resources.createResource((int)1024, (int)-1);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq, null, (YarnScheduler)mockScheduler, this.rmContext, maxResource);
            Assert.fail((String)"Negative vcores should not be accepted");
        }
        catch (InvalidResourceRequestException e) {
            Assert.assertEquals((Object)InvalidResourceRequestException.InvalidResourceType.LESS_THAN_ZERO, (Object)e.getInvalidResourceType());
        }
        try {
            resource = Resources.createResource((int)8193, (int)1);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq, null, (YarnScheduler)mockScheduler, this.rmContext, maxResource);
            Assert.fail((String)"More than max memory should not be accepted");
        }
        catch (InvalidResourceRequestException e) {
            Assert.assertEquals((Object)InvalidResourceRequestException.InvalidResourceType.GREATER_THEN_MAX_ALLOCATION, (Object)e.getInvalidResourceType());
        }
        try {
            resource = Resources.createResource((int)1024, (int)5);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq, null, (YarnScheduler)mockScheduler, this.rmContext, maxResource);
            Assert.fail((String)"More than max vcores should not be accepted");
        }
        catch (InvalidResourceRequestException e) {
            Assert.assertEquals((Object)InvalidResourceRequestException.InvalidResourceType.GREATER_THEN_MAX_ALLOCATION, (Object)e.getInvalidResourceType());
        }
    }

    @Test
    public void testValidateResourceBlacklistRequest() throws Exception {
        TestAMAuthorization.MyContainerManager containerManager = new TestAMAuthorization.MyContainerManager();
        TestAMAuthorization.MockRMWithAMS rm = new TestAMAuthorization.MockRMWithAMS((Configuration)new YarnConfiguration(), containerManager);
        rm.start();
        MockNM nm1 = rm.registerNode("localhost:1234", 5120);
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>(2);
        acls.put(ApplicationAccessType.VIEW_APP, "*");
        RMApp app = rm.submitApp(1024, "appname", "appuser", acls);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        ApplicationAttemptId applicationAttemptId = attempt.getAppAttemptId();
        this.waitForLaunchedState(attempt);
        final Configuration yarnConf = rm.getConfig();
        final YarnRPC rpc = YarnRPC.create((Configuration)yarnConf);
        UserGroupInformation currentUser = UserGroupInformation.createRemoteUser((String)applicationAttemptId.toString());
        Credentials credentials = containerManager.getContainerCredentials();
        final InetSocketAddress rmBindAddress = rm.getApplicationMasterService().getBindAddress();
        Token<? extends TokenIdentifier> amRMToken = TestAMAuthorization.MockRMWithAMS.setupAndReturnAMRMToken(rmBindAddress, credentials.getAllTokens());
        currentUser.addToken(amRMToken);
        ApplicationMasterProtocol client = (ApplicationMasterProtocol)currentUser.doAs((PrivilegedAction)new PrivilegedAction<ApplicationMasterProtocol>(){

            @Override
            public ApplicationMasterProtocol run() {
                return (ApplicationMasterProtocol)rpc.getProxy(ApplicationMasterProtocol.class, rmBindAddress, yarnConf);
            }
        });
        RegisterApplicationMasterRequest request = (RegisterApplicationMasterRequest)Records.newRecord(RegisterApplicationMasterRequest.class);
        client.registerApplicationMaster(request);
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(Collections.singletonList("*"), null);
        AllocateRequest allocateRequest = AllocateRequest.newInstance((int)0, (float)0.0f, null, null, (ResourceBlacklistRequest)blacklistRequest);
        boolean error = false;
        try {
            client.allocate(allocateRequest);
        }
        catch (InvalidResourceBlacklistRequestException e) {
            error = true;
        }
        rm.stop();
        Assert.assertTrue((String)"Didn't not catch InvalidResourceBlacklistRequestException", (boolean)error);
    }

    private void waitForLaunchedState(RMAppAttempt attempt) throws InterruptedException {
        int waitCount = 0;
        while (attempt.getAppAttemptState() != RMAppAttemptState.LAUNCHED && waitCount++ < 20) {
            LOG.info((Object)("Waiting for AppAttempt to reach LAUNCHED state. Current state is " + attempt.getAppAttemptState()));
            Thread.sleep(1000L);
        }
        Assert.assertEquals((Object)attempt.getAppAttemptState(), (Object)RMAppAttemptState.LAUNCHED);
    }

    @Test
    public void testComparePriorities() {
        Priority low;
        Priority high = Priority.newInstance((int)1);
        Assert.assertTrue((high.compareTo(low = Priority.newInstance((int)2)) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateAbnormalContainerStatus() {
        ContainerStatus cd = SchedulerUtils.createAbnormalContainerStatus((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), (int)1), (long)1L), (String)"x");
        Assert.assertEquals((long)-100L, (long)cd.getExitStatus());
    }

    @Test
    public void testCreatePreemptedContainerStatus() {
        ContainerStatus cd = SchedulerUtils.createPreemptedContainerStatus((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), (int)1), (long)1L), (String)"x");
        Assert.assertEquals((long)-102L, (long)cd.getExitStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testNormalizeNodeLabelExpression() throws IOException {
        ResourceScheduler scheduler = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        HashSet queueAccessibleNodeLabels = Sets.newHashSet();
        QueueInfo queueInfo = (QueueInfo)Mockito.mock(QueueInfo.class);
        Mockito.when((Object)queueInfo.getQueueName()).thenReturn((Object)"queue");
        Mockito.when((Object)queueInfo.getAccessibleNodeLabels()).thenReturn((Object)queueAccessibleNodeLabels);
        Mockito.when((Object)queueInfo.getDefaultNodeLabelExpression()).thenReturn((Object)" x ");
        Mockito.when((Object)scheduler.getQueueInfo((String)Matchers.any(String.class), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)queueInfo);
        Resource maxResource = Resources.createResource((int)8192, (int)4);
        Mockito.when((Object)this.rmContext.getScheduler()).thenReturn((Object)scheduler);
        try {
            queueAccessibleNodeLabels.clear();
            queueAccessibleNodeLabels.addAll(Arrays.asList("x", "y"));
            this.rmContext.getNodeLabelManager().addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x"), (Object)NodeLabel.newInstance((String)"y")));
            Resource resource = Resources.createResource((int)0, (int)1);
            ResourceRequest resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
            Assert.assertEquals((Object)"x", (Object)resReq.getNodeLabelExpression());
            resReq.setNodeLabelExpression(" y ");
            TestSchedulerUtils.normalizeAndvalidateRequest(resReq, "queue", (YarnScheduler)scheduler, this.rmContext, maxResource);
            Assert.assertEquals((Object)"y", (Object)resReq.getNodeLabelExpression());
        }
        catch (InvalidResourceRequestException e) {
            try {
                e.printStackTrace();
                Assert.fail((String)"Should be valid when request labels is a subset of queue labels");
            }
            catch (Throwable throwable) {
                this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x", "y"));
                throw throwable;
            }
            this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x", "y"));
        }
        this.rmContext.getNodeLabelManager().removeFromClusterNodeLabels(Arrays.asList("x", "y"));
    }

    @Test
    public void testCustomResourceRequestedUnitIsSmallerThanAvailableUnit() throws InvalidResourceRequestException {
        Resource requestedResource = ResourceTypesTestHelper.newResource((long)1L, (int)1, (Map)ImmutableMap.of((Object)"custom-resource-1", (Object)"11"));
        Resource availableResource = ResourceTypesTestHelper.newResource((long)1L, (int)1, (Map)ImmutableMap.of((Object)"custom-resource-1", (Object)"0G"));
        this.exception.expect(InvalidResourceRequestException.class);
        this.exception.expectMessage(InvalidResourceRequestExceptionMessageGenerator.create().withRequestedResourceType("custom-resource-1").withRequestedResource(requestedResource).withAvailableAllocation(availableResource).withMaxAllocation(configuredMaxAllocation).withInvalidResourceType(InvalidResourceRequestException.InvalidResourceType.GREATER_THEN_MAX_ALLOCATION).build());
        SchedulerUtils.checkResourceRequestAgainstAvailableResource((Resource)requestedResource, (Resource)availableResource);
    }

    @Test
    public void testCustomResourceRequestedUnitIsSmallerThanAvailableUnit2() {
        Resource requestedResource = ResourceTypesTestHelper.newResource((long)1L, (int)1, (Map)ImmutableMap.of((Object)"custom-resource-1", (Object)"11"));
        Resource availableResource = ResourceTypesTestHelper.newResource((long)1L, (int)1, (Map)ImmutableMap.of((Object)"custom-resource-1", (Object)"1G"));
        try {
            SchedulerUtils.checkResourceRequestAgainstAvailableResource((Resource)requestedResource, (Resource)availableResource);
        }
        catch (InvalidResourceRequestException e) {
            Assert.fail((String)String.format("Resource request should be accepted. Requested: %s, available: %s", requestedResource, availableResource));
        }
    }

    @Test
    public void testCustomResourceRequestedUnitIsGreaterThanAvailableUnit() throws InvalidResourceRequestException {
        Resource requestedResource = ResourceTypesTestHelper.newResource((long)1L, (int)1, (Map)ImmutableMap.of((Object)"custom-resource-1", (Object)"1M"));
        Resource availableResource = ResourceTypesTestHelper.newResource((long)1L, (int)1, (Map)ImmutableMap.builder().put((Object)"custom-resource-1", (Object)"120k").build());
        this.exception.expect(InvalidResourceRequestException.class);
        this.exception.expectMessage(InvalidResourceRequestExceptionMessageGenerator.create().withRequestedResourceType("custom-resource-1").withRequestedResource(requestedResource).withAvailableAllocation(availableResource).withMaxAllocation(configuredMaxAllocation).withInvalidResourceType(InvalidResourceRequestException.InvalidResourceType.GREATER_THEN_MAX_ALLOCATION).build());
        SchedulerUtils.checkResourceRequestAgainstAvailableResource((Resource)requestedResource, (Resource)availableResource);
    }

    @Test
    public void testCustomResourceRequestedUnitIsGreaterThanAvailableUnit2() {
        Resource requestedResource = ResourceTypesTestHelper.newResource((long)1L, (int)1, (Map)ImmutableMap.builder().put((Object)"custom-resource-1", (Object)"11M").build());
        Resource availableResource = ResourceTypesTestHelper.newResource((long)1L, (int)1, (Map)ImmutableMap.of((Object)"custom-resource-1", (Object)"1G"));
        try {
            SchedulerUtils.checkResourceRequestAgainstAvailableResource((Resource)requestedResource, (Resource)availableResource);
        }
        catch (InvalidResourceRequestException e) {
            Assert.fail((String)String.format("Resource request should be accepted. Requested: %s, available: %s", requestedResource, availableResource));
        }
    }

    @Test
    public void testCustomResourceRequestedUnitIsSameAsAvailableUnit() {
        Resource requestedResource = ResourceTypesTestHelper.newResource((long)1L, (int)1, (Map)ImmutableMap.of((Object)"custom-resource-1", (Object)"11M"));
        Resource availableResource = ResourceTypesTestHelper.newResource((long)1L, (int)1, (Map)ImmutableMap.of((Object)"custom-resource-1", (Object)"100M"));
        try {
            SchedulerUtils.checkResourceRequestAgainstAvailableResource((Resource)requestedResource, (Resource)availableResource);
        }
        catch (InvalidResourceRequestException e) {
            Assert.fail((String)String.format("Resource request should be accepted. Requested: %s, available: %s", requestedResource, availableResource));
        }
    }

    @Test
    public void testCustomResourceRequestedUnitIsSameAsAvailableUnit2() throws InvalidResourceRequestException {
        Resource requestedResource = ResourceTypesTestHelper.newResource((long)1L, (int)1, (Map)ImmutableMap.of((Object)"custom-resource-1", (Object)"110M"));
        Resource availableResource = ResourceTypesTestHelper.newResource((long)1L, (int)1, (Map)ImmutableMap.of((Object)"custom-resource-1", (Object)"100M"));
        this.exception.expect(InvalidResourceRequestException.class);
        this.exception.expectMessage(InvalidResourceRequestExceptionMessageGenerator.create().withRequestedResourceType("custom-resource-1").withRequestedResource(requestedResource).withAvailableAllocation(availableResource).withInvalidResourceType(InvalidResourceRequestException.InvalidResourceType.GREATER_THEN_MAX_ALLOCATION).withMaxAllocation(configuredMaxAllocation).build());
        SchedulerUtils.checkResourceRequestAgainstAvailableResource((Resource)requestedResource, (Resource)availableResource);
    }

    public static void waitSchedulerApplicationAttemptStopped(AbstractYarnScheduler ys, ApplicationAttemptId attemptId) throws InterruptedException {
        SchedulerApplicationAttempt schedulerApp = ys.getApplicationAttempt(attemptId);
        if (null == schedulerApp) {
            return;
        }
        for (int tick = 0; tick < 100; ++tick) {
            if (schedulerApp.isStopped()) {
                return;
            }
            Thread.sleep(50L);
        }
        System.err.println("Failed to wait scheduler application attempt stopped.");
    }

    public static SchedulerApplication<SchedulerApplicationAttempt> verifyAppAddedAndRemovedFromScheduler(Map<ApplicationId, SchedulerApplication<SchedulerApplicationAttempt>> applications, EventHandler<SchedulerEvent> handler, String queueName) {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        AppAddedSchedulerEvent appAddedEvent = new AppAddedSchedulerEvent(appId, queueName, "user");
        handler.handle((Event)appAddedEvent);
        SchedulerApplication<SchedulerApplicationAttempt> app = applications.get(appId);
        Assert.assertNotNull(app);
        Assert.assertEquals((Object)"user", (Object)app.getUser());
        AppRemovedSchedulerEvent appRemoveEvent = new AppRemovedSchedulerEvent(appId, RMAppState.FINISHED);
        handler.handle((Event)appRemoveEvent);
        Assert.assertNull(applications.get(appId));
        return app;
    }

    private static RMContext getMockRMContext() {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        NullRMNodeLabelsManager nlm = new NullRMNodeLabelsManager();
        nlm.init(new Configuration(false));
        Mockito.when((Object)rmContext.getYarnConfiguration()).thenReturn((Object)conf);
        rmContext.getYarnConfiguration().set("yarn.node-labels.enabled", "true");
        Mockito.when((Object)rmContext.getNodeLabelManager()).thenReturn((Object)nlm);
        return rmContext;
    }

    private static void normalizeAndvalidateRequest(ResourceRequest resReq, String queueName, YarnScheduler scheduler, RMContext rmContext, Resource maxAllocation) throws InvalidResourceRequestException {
        SchedulerUtils.normalizeAndValidateRequest((ResourceRequest)resReq, (Resource)maxAllocation, (String)queueName, (YarnScheduler)scheduler, (RMContext)rmContext, null);
    }

    static {
        conf = new YarnConfiguration();
    }

    private static class InvalidResourceRequestExceptionMessageGenerator {
        private StringBuilder sb;
        private Resource requestedResource;
        private Resource availableAllocation;
        private Resource configuredMaxAllowedAllocation;
        private String resourceType;
        private InvalidResourceRequestException.InvalidResourceType invalidResourceType;

        InvalidResourceRequestExceptionMessageGenerator(StringBuilder sb) {
            this.sb = sb;
        }

        public static InvalidResourceRequestExceptionMessageGenerator create() {
            return new InvalidResourceRequestExceptionMessageGenerator(new StringBuilder());
        }

        InvalidResourceRequestExceptionMessageGenerator withRequestedResource(Resource r) {
            this.requestedResource = r;
            return this;
        }

        InvalidResourceRequestExceptionMessageGenerator withRequestedResourceType(String rt) {
            this.resourceType = rt;
            return this;
        }

        InvalidResourceRequestExceptionMessageGenerator withAvailableAllocation(Resource r) {
            this.availableAllocation = r;
            return this;
        }

        InvalidResourceRequestExceptionMessageGenerator withMaxAllocation(Resource r) {
            this.configuredMaxAllowedAllocation = r;
            return this;
        }

        InvalidResourceRequestExceptionMessageGenerator withInvalidResourceType(InvalidResourceRequestException.InvalidResourceType invalidResourceType) {
            this.invalidResourceType = invalidResourceType;
            return this;
        }

        public String build() {
            if (this.invalidResourceType == InvalidResourceRequestException.InvalidResourceType.LESS_THAN_ZERO) {
                return this.sb.append("Invalid resource request! Cannot allocate containers as requested resource is less than 0! ").append("Requested resource type=[").append(this.resourceType).append("]").append(", Requested resource=").append(this.requestedResource).toString();
            }
            if (this.invalidResourceType == InvalidResourceRequestException.InvalidResourceType.GREATER_THEN_MAX_ALLOCATION) {
                return this.sb.append("Invalid resource request! Cannot allocate containers as requested resource is greater than maximum allowed allocation. ").append("Requested resource type=[").append(this.resourceType).append("], ").append("Requested resource=").append(this.requestedResource).append(", maximum allowed allocation=").append(this.availableAllocation).append(", please note that maximum allowed allocation is calculated by scheduler based on maximum resource of registered NodeManagers, which might be less than configured maximum allocation=").append(this.configuredMaxAllowedAllocation).toString();
            }
            throw new IllegalStateException("Wrong type of InvalidResourceType is detected!");
        }
    }

    private static class CustomResourceTypesConfigurationProvider
    extends LocalConfigurationProvider {
        private CustomResourceTypesConfigurationProvider() {
        }

        public InputStream getConfigurationInputStream(Configuration bootstrapConf, String name) throws YarnException, IOException {
            if ("resource-types.xml".equals(name)) {
                return new ByteArrayInputStream("<configuration>\n <property>\n   <name>yarn.resource-types</name>\n   <value>custom-resource-1,custom-resource-2,custom-resource-3</value>\n </property>\n <property>\n   <name>yarn.resource-types.custom-resource-1.units</name>\n   <value>G</value>\n </property>\n <property>\n   <name>yarn.resource-types.custom-resource-2.units</name>\n   <value>G</value>\n </property>\n</configuration>\n".getBytes());
            }
            return super.getConfigurationInputStream(bootstrapConf, name);
        }
    }
}

