/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.Arrays;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesCapacitySched;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestRMWebServicesSchedulerActivities
extends TestRMWebServicesCapacitySched {
    private static final Log LOG = LogFactory.getLog(TestRMWebServicesSchedulerActivities.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssignMultipleContainersPerNodeHeartbeat() throws Exception {
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 24576, rm.getResourceTrackerService());
        nm.registerNode();
        try {
            RMApp app1 = rm.submitApp(10, "app1", "user1", null, "b1");
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"127.0.0.1", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"/default-rack", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)1024), (int)10)), null);
            WebResource r = this.resource();
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.add("nodeId", "127.0.0.1:1234");
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            nm.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            this.verifyNumberOfAllocations(json, 11);
            JSONArray allocations = json.getJSONArray("allocations");
            for (int i = 0; i < allocations.length(); ++i) {
                if (i == allocations.length() - 1) continue;
                this.verifyStateOfAllocations(allocations.getJSONObject(i), "finalAllocationState", "ALLOCATED");
                this.verifyQueueOrder(allocations.getJSONObject(i), "root-a-b-b2-b3-b1");
            }
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssignWithoutAvailableResource() throws Exception {
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 1024, rm.getResourceTrackerService());
        nm.registerNode();
        try {
            RMApp app1 = rm.submitApp(1024, "app1", "user1", null, "b1");
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"127.0.0.1", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"/default-rack", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)1024), (int)10)), null);
            WebResource r = this.resource();
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.add("nodeId", "127.0.0.1");
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            nm.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            this.verifyNumberOfAllocations(json, 0);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoNM() throws Exception {
        rm.start();
        try {
            WebResource r = this.resource();
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.add("nodeId", "127.0.0.1:1234");
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            this.verifyNumberOfAllocations(json, 0);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrongNodeId() throws Exception {
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 24576, rm.getResourceTrackerService());
        nm.registerNode();
        try {
            RMApp app1 = rm.submitApp(1024, "app1", "user1", null, "b1");
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"127.0.0.1", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"/default-rack", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)1024), (int)10)), null);
            WebResource r = this.resource();
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.add("nodeId", "127.0.0.0");
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            nm.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            this.verifyNumberOfAllocations(json, 0);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReserveNewContainer() throws Exception {
        rm.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 4096, rm.getResourceTrackerService());
        MockNM nm2 = new MockNM("127.0.0.2:1234", 4096, rm.getResourceTrackerService());
        nm1.registerNode();
        nm2.registerNode();
        try {
            RMApp app1 = rm.submitApp(10, "app1", "user1", null, "b1");
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            RMApp app2 = rm.submitApp(10, "app2", "user1", null, "b2");
            MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm2);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)4096), (int)10)), null);
            WebResource r = this.resource();
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.add("nodeId", "127.0.0.2");
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            nm2.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            this.verifyNumberOfAllocations(json, 1);
            this.verifyQueueOrder(json.getJSONObject("allocations"), "root-a-b-b3-b1");
            JSONObject allocations = json.getJSONObject("allocations");
            this.verifyStateOfAllocations(allocations, "finalAllocationState", "RESERVED");
            r = this.resource();
            params = new MultivaluedMapImpl();
            params.add("nodeId", "127.0.0.2");
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            nm2.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            this.verifyNumberOfAllocations(json, 1);
            this.verifyQueueOrder(json.getJSONObject("allocations"), "b1");
            allocations = json.getJSONObject("allocations");
            this.verifyStateOfAllocations(allocations, "finalAllocationState", "SKIPPED");
            CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
            ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)1L);
            cs.completedContainer(cs.getRMContainer(containerId), ContainerStatus.newInstance((ContainerId)containerId, (ContainerState)ContainerState.COMPLETE, (String)"", (int)0), RMContainerEventType.FINISHED);
            r = this.resource();
            params = new MultivaluedMapImpl();
            params.add("nodeId", "127.0.0.2");
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            nm2.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            this.verifyNumberOfAllocations(json, 1);
            this.verifyQueueOrder(json.getJSONObject("allocations"), "b1");
            allocations = json.getJSONObject("allocations");
            this.verifyStateOfAllocations(allocations, "finalAllocationState", "ALLOCATED_FROM_RESERVED");
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testActivityJSON() throws Exception {
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 24576, rm.getResourceTrackerService());
        nm.registerNode();
        try {
            RMApp app1 = rm.submitApp(10, "app1", "user1", null, "b1");
            WebResource r = this.resource();
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.add("nodeId", "127.0.0.1");
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            nm.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            this.verifyNumberOfAllocations(json, 1);
            JSONObject allocations = json.getJSONObject("allocations");
            this.verifyStateOfAllocations(allocations, "finalAllocationState", "ALLOCATED");
            this.verifyNumberOfNodes(allocations, 5);
            this.verifyQueueOrder(json.getJSONObject("allocations"), "root-b-b1");
        }
        finally {
            rm.stop();
        }
    }

    private void verifyNumberOfNodes(JSONObject allocation, int realValue) throws Exception {
        if (allocation.isNull("root")) {
            Assert.assertEquals((String)"State of allocation is wrong", (long)0L, (long)realValue);
        } else {
            Assert.assertEquals((String)"State of allocation is wrong", (long)(1 + this.getNumberOfNodes(allocation.getJSONObject("root"))), (long)realValue);
        }
    }

    private int getNumberOfNodes(JSONObject allocation) throws Exception {
        if (!allocation.isNull("children")) {
            Object object = allocation.get("children");
            if (object.getClass() == JSONObject.class) {
                return 1 + this.getNumberOfNodes((JSONObject)object);
            }
            int count = 0;
            for (int i = 0; i < ((JSONArray)object).length(); ++i) {
                count += 1 + this.getNumberOfNodes(((JSONArray)object).getJSONObject(i));
            }
            return count;
        }
        return 0;
    }

    private void verifyStateOfAllocations(JSONObject allocation, String nameToCheck, String realState) throws Exception {
        Assert.assertEquals((String)"State of allocation is wrong", (Object)allocation.get(nameToCheck), (Object)realState);
    }

    private void verifyNumberOfAllocations(JSONObject json, int realValue) throws Exception {
        if (json.isNull("allocations")) {
            Assert.assertEquals((String)"Number of allocations is wrong", (long)0L, (long)realValue);
        } else {
            Object object = json.get("allocations");
            if (object.getClass() == JSONObject.class) {
                Assert.assertEquals((String)"Number of allocations is wrong", (long)1L, (long)realValue);
            } else if (object.getClass() == JSONArray.class) {
                Assert.assertEquals((String)("Number of allocations is wrong in: " + object), (long)((JSONArray)object).length(), (long)realValue);
            }
        }
    }

    private void verifyQueueOrder(JSONObject json, String realOrder) throws Exception {
        String order = "";
        if (!json.isNull("root")) {
            JSONObject root = json.getJSONObject("root");
            order = root.getString("name") + "-" + this.getQueueOrder(root);
        }
        Assert.assertEquals((String)"Order of queue is wrong", (Object)order.substring(0, order.length() - 1), (Object)realOrder);
    }

    private String getQueueOrder(JSONObject node) throws Exception {
        if (!node.isNull("children")) {
            Object children = node.get("children");
            if (children.getClass() == JSONObject.class) {
                if (!((JSONObject)children).isNull("appPriority")) {
                    return "";
                }
                return ((JSONObject)children).getString("name") + "-" + this.getQueueOrder((JSONObject)children);
            }
            if (children.getClass() == JSONArray.class) {
                String order = "";
                for (int i = 0; i < ((JSONArray)children).length(); ++i) {
                    JSONObject child = (JSONObject)((JSONArray)children).get(i);
                    if (!child.isNull("appPriority")) {
                        return "";
                    }
                    order = order + child.getString("name") + "-" + this.getQueueOrder(child);
                }
                return order;
            }
        }
        return "";
    }

    private void verifyNumberOfAllocationAttempts(JSONObject allocation, int realValue) throws Exception {
        if (allocation.isNull("allocationAttempt")) {
            Assert.assertEquals((String)"Number of allocation attempts is wrong", (long)0L, (long)realValue);
        } else {
            Object object = allocation.get("allocationAttempt");
            if (object.getClass() == JSONObject.class) {
                Assert.assertEquals((String)"Number of allocations attempts is wrong", (long)1L, (long)realValue);
            } else if (object.getClass() == JSONArray.class) {
                Assert.assertEquals((String)"Number of allocations attempts is wrong", (long)((JSONArray)object).length(), (long)realValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppActivityJSON() throws Exception {
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 24576, rm.getResourceTrackerService());
        nm.registerNode();
        try {
            RMApp app1 = rm.submitApp(10, "app1", "user1", null, "b1");
            WebResource r = this.resource();
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.add("appId", app1.getApplicationId().toString());
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/app-activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            nm.nodeHeartbeat(true);
            Thread.sleep(5000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/app-activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            this.verifyNumberOfAllocations(json, 1);
            JSONObject allocations = json.getJSONObject("allocations");
            this.verifyStateOfAllocations(allocations, "allocationState", "ACCEPTED");
            this.verifyNumberOfAllocationAttempts(allocations, 1);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppAssignMultipleContainersPerNodeHeartbeat() throws Exception {
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 24576, rm.getResourceTrackerService());
        nm.registerNode();
        try {
            RMApp app1 = rm.submitApp(1024, "app1", "user1", null, "b1");
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"127.0.0.1", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"/default-rack", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)1024), (int)10)), null);
            WebResource r = this.resource();
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.add("appId", app1.getApplicationId().toString());
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/app-activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            nm.nodeHeartbeat(true);
            Thread.sleep(5000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/app-activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            this.verifyNumberOfAllocations(json, 10);
            JSONArray allocations = json.getJSONArray("allocations");
            for (int i = 0; i < allocations.length(); ++i) {
                this.verifyStateOfAllocations(allocations.getJSONObject(i), "allocationState", "ACCEPTED");
            }
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppAssignWithoutAvailableResource() throws Exception {
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 1024, rm.getResourceTrackerService());
        nm.registerNode();
        try {
            RMApp app1 = rm.submitApp(1024, "app1", "user1", null, "b1");
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"127.0.0.1", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"/default-rack", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)1024), (int)10)), null);
            WebResource r = this.resource();
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.add("appId", app1.getApplicationId().toString());
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/app-activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            nm.nodeHeartbeat(true);
            Thread.sleep(5000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/app-activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            this.verifyNumberOfAllocations(json, 0);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppNoNM() throws Exception {
        rm.start();
        try {
            RMApp app1 = rm.submitApp(1024, "app1", "user1", null, "b1");
            WebResource r = this.resource();
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.add("appId", app1.getApplicationId().toString());
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/app-activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/app-activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            this.verifyNumberOfAllocations(json, 0);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppReserveNewContainer() throws Exception {
        rm.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 4096, rm.getResourceTrackerService());
        MockNM nm2 = new MockNM("127.0.0.2:1234", 4096, rm.getResourceTrackerService());
        nm1.registerNode();
        nm2.registerNode();
        try {
            RMApp app1 = rm.submitApp(10, "app1", "user1", null, "b1");
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            RMApp app2 = rm.submitApp(10, "app2", "user1", null, "b2");
            MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm2);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)4096), (int)10)), null);
            WebResource r = this.resource();
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.add("appId", app1.getApplicationId().toString());
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/app-activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            nm2.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/app-activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            this.verifyNumberOfAllocations(json, 1);
            r = this.resource();
            params = new MultivaluedMapImpl();
            params.add("appId", app1.getApplicationId().toString());
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/app-activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            nm2.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/app-activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            this.verifyNumberOfAllocations(json, 2);
            CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
            ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)1L);
            cs.completedContainer(cs.getRMContainer(containerId), ContainerStatus.newInstance((ContainerId)containerId, (ContainerState)ContainerState.COMPLETE, (String)"", (int)0), RMContainerEventType.FINISHED);
            r = this.resource();
            params = new MultivaluedMapImpl();
            params.add("appId", app1.getApplicationId().toString());
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/app-activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            nm2.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/app-activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            this.verifyNumberOfAllocations(json, 3);
        }
        finally {
            rm.stop();
        }
    }
}

