/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.placement.AppNameMappingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueueMappingEntity;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserGroupMappingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacitySchedulerAutoCreatedQueueBase;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Test;

public class TestPlacementManager {
    public static final String USER = "user_";
    public static final String APP_NAME = "DistributedShell";
    public static final String APP_ID1 = "1";
    public static final String USER1 = "user_1";
    public static final String APP_ID2 = "2";
    public static final String USER2 = "user_2";
    public static final String PARENT_QUEUE = "c";
    private MockRM mockRM = null;
    private static final long CLUSTER_TIMESTAMP = System.currentTimeMillis();

    private String getQueueMapping(String parentQueue, String leafQueue) {
        return parentQueue + "." + leafQueue;
    }

    @Test
    public void testPlaceApplicationWithPlacementRuleChain() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.mockRM = new MockRM((Configuration)conf);
        CapacityScheduler cs = (CapacityScheduler)this.mockRM.getResourceScheduler();
        this.mockRM.start();
        cs.start();
        PlacementManager pm = cs.getRMContext().getQueuePlacementManager();
        ArrayList<Object> queuePlacementRules = new ArrayList<Object>();
        UserGroupMappingPlacementRule.QueueMapping userQueueMapping = new UserGroupMappingPlacementRule.QueueMapping(UserGroupMappingPlacementRule.QueueMapping.MappingType.USER, USER1, this.getQueueMapping(PARENT_QUEUE, USER1));
        UserGroupMappingPlacementRule ugRule = new UserGroupMappingPlacementRule(false, Arrays.asList(userQueueMapping), null);
        queuePlacementRules.add(ugRule);
        pm.updateRules(queuePlacementRules);
        ApplicationSubmissionContext asc = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        asc.setQueue("default");
        asc.setApplicationName(APP_NAME);
        Assert.assertNull((String)"Placement should be null", (Object)pm.placeApplication(asc, USER2));
        QueueMappingEntity queueMappingEntity = new QueueMappingEntity(APP_NAME, USER1, PARENT_QUEUE);
        AppNameMappingPlacementRule anRule = new AppNameMappingPlacementRule(false, Arrays.asList(queueMappingEntity));
        queuePlacementRules.add(anRule);
        pm.updateRules(queuePlacementRules);
        try {
            ApplicationPlacementContext pc = pm.placeApplication(asc, USER2);
            Assert.assertNotNull((Object)pc);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception not expected");
        }
    }
}

