/*
 * Decompiled with CFR 0.152.
 */
package io.hops.yarn.server.resourcemanager.quota;

import com.google.common.collect.ImmutableMap;
import io.hops.StorageConnector;
import io.hops.metadata.yarn.dal.quota.ProjectQuotaDataAccess;
import io.hops.metadata.yarn.dal.quota.ProjectsDailyCostDataAccess;
import io.hops.metadata.yarn.dal.util.YARNOperationType;
import io.hops.metadata.yarn.entity.quota.PriceMultiplicator;
import io.hops.metadata.yarn.entity.quota.ProjectDailyCost;
import io.hops.metadata.yarn.entity.quota.ProjectQuota;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import io.hops.yarn.server.resourcemanager.quota.PriceMultiplicatorService;
import io.hops.yarn.server.resourcemanager.quota.QuotaService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestQuotaService {
    private static final Log LOG = LogFactory.getLog(TestQuotaService.class);
    private StorageConnector connector = null;
    Configuration conf;

    @Before
    public void setup() throws IOException {
        this.conf = new YarnConfiguration();
        this.conf.setBoolean("yarn.resourcemanager.quota.enabled", true);
        this.conf.setBoolean("yarn.resourcemanager.quota.variable.price.enabled", true);
        YarnAPIStorageFactory.setConfiguration((Configuration)this.conf);
        RMStorageFactory.setConfiguration((Configuration)this.conf);
        DBUtility.InitializeDB();
    }

    public void CheckProject(float credits, float used) throws IOException {
        LightWeightRequestHandler bomb = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws IOException {
                connector.beginTransaction();
                connector.writeLock();
                ProjectQuotaDataAccess _pqDA = (ProjectQuotaDataAccess)RMStorageFactory.getDataAccess(ProjectQuotaDataAccess.class);
                Map _hopProjectQuotaList = _pqDA.getAll();
                connector.commit();
                return _hopProjectQuotaList;
            }
        };
        Map hopProjectQuotaList = (Map)bomb.handle();
        for (Map.Entry _ycl : hopProjectQuotaList.entrySet()) {
            Assert.assertTrue((boolean)((ProjectQuota)_ycl.getValue()).getProjectid().equalsIgnoreCase("Project07"));
            Assert.assertEquals((float)credits, (float)((ProjectQuota)_ycl.getValue()).getRemainingQuota(), (float)0.0f);
            Assert.assertEquals((float)used, (float)((ProjectQuota)_ycl.getValue()).getTotalUsedQuota(), (float)0.0f);
        }
    }

    public void CheckProjectDailyCost(float used) throws IOException {
        LightWeightRequestHandler bomb = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws IOException {
                connector.beginTransaction();
                connector.writeLock();
                ProjectsDailyCostDataAccess _pdcDA = (ProjectsDailyCostDataAccess)RMStorageFactory.getDataAccess(ProjectsDailyCostDataAccess.class);
                Map hopYarnProjectsDailyCostList = _pdcDA.getAll();
                connector.commit();
                return hopYarnProjectsDailyCostList;
            }
        };
        Map hopYarnProjectsDailyCostList = (Map)bomb.handle();
        long _miliSec = System.currentTimeMillis();
        long _day = TimeUnit.DAYS.convert(_miliSec, TimeUnit.MILLISECONDS);
        for (Map.Entry _ypdc : hopYarnProjectsDailyCostList.entrySet()) {
            Assert.assertTrue((boolean)((ProjectDailyCost)_ypdc.getValue()).getProjectName().equalsIgnoreCase("Project07"));
            Assert.assertTrue((boolean)((ProjectDailyCost)_ypdc.getValue()).getProjectUser().equalsIgnoreCase("rizvi"));
            Assert.assertEquals((long)_day, (long)((ProjectDailyCost)_ypdc.getValue()).getDay());
            Assert.assertEquals((float)used, (float)((ProjectDailyCost)_ypdc.getValue()).getCreditsUsed(), (float)0.0f);
        }
    }

    @Test(timeout=120000L)
    public void TestQuotaService() throws Exception {
        RMContainer container;
        ContainerId containerId;
        int j;
        ApplicationAttemptId appAttemptId;
        int i;
        int initialCredits = 50;
        int totalCost = 0;
        String user = "Project07__rizvi";
        ApplicationId appId = ApplicationId.fromString((String)"application_1450009406746_0001");
        final ArrayList<ProjectQuota> hopProjectQuota = new ArrayList<ProjectQuota>();
        hopProjectQuota.add(new ProjectQuota("Project07", (float)initialCredits, 0.0f));
        LightWeightRequestHandler prepareHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws IOException {
                connector.beginTransaction();
                connector.writeLock();
                ProjectQuotaDataAccess _pqDA = (ProjectQuotaDataAccess)RMStorageFactory.getDataAccess(ProjectQuotaDataAccess.class);
                _pqDA.addAll((Collection)hopProjectQuota);
                connector.commit();
                return null;
            }
        };
        prepareHandler.handle();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        ConcurrentMap rmApps = (ConcurrentMap)Mockito.mock(ConcurrentMap.class);
        RMApp rmApp = (RMApp)Mockito.mock(RMApp.class);
        PriceMultiplicatorService pms = (PriceMultiplicatorService)Mockito.mock(PriceMultiplicatorService.class);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn((Object)rmApps);
        Mockito.when((Object)rmContext.getPriceMultiplicatorService()).thenReturn((Object)pms);
        Mockito.when(rmApps.get(Mockito.any(ApplicationId.class))).thenReturn((Object)rmApp);
        Mockito.when((Object)rmApp.getUser()).thenReturn((Object)user);
        Mockito.when((Object)Float.valueOf(pms.getMultiplicator((PriceMultiplicator.MultiplicatorType)Mockito.any(PriceMultiplicator.MultiplicatorType.class)))).thenReturn((Object)new Float(1.0f));
        QuotaService qs = new QuotaService(rmContext);
        this.conf.setInt("yarn.resourcemanager.quota.scheduling.period", 1200000);
        qs.init(this.conf);
        qs.serviceStart();
        for (i = 0; i < 10; ++i) {
            appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)i);
            for (j = 0; j < i; ++j) {
                containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)j);
                container = (RMContainer)Mockito.mock(RMContainer.class);
                Mockito.when((Object)container.getContainerId()).thenReturn((Object)containerId);
                Mockito.when((Object)container.getAllocatedResource()).thenReturn((Object)TestUtils.createResource(1024L, 1, (Map<String, Integer>)ImmutableMap.builder().build()));
                Mockito.when((Object)container.getAllocatedNode()).thenReturn(null);
                Mockito.when((Object)container.getAllocatedPriority()).thenReturn((Object)Priority.UNDEFINED);
                Mockito.when((Object)container.getCreationTime()).thenReturn((Object)0L);
                qs.containerStarted(container);
            }
        }
        Thread.sleep(1000L);
        for (i = 0; i < 3; ++i) {
            appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)i);
            for (j = 0; j < i; ++j) {
                containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)j);
                container = (RMContainer)Mockito.mock(RMContainer.class);
                Mockito.when((Object)container.getContainerId()).thenReturn((Object)containerId);
                Mockito.when((Object)container.getDiagnosticsInfo()).thenReturn(null);
                Mockito.when((Object)container.getContainerExitStatus()).thenReturn((Object)0);
                Mockito.when((Object)container.getContainerState()).thenReturn((Object)ContainerState.COMPLETE);
                Mockito.when((Object)container.getFinishTime()).thenReturn((Object)1000L);
                qs.containerFinished(container);
                totalCost += 10;
            }
        }
        Thread.sleep(1000L);
        for (i = 3; i < 10; ++i) {
            appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)i);
            for (j = 0; j < i; ++j) {
                containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)j);
                totalCost += 10;
                qs.computeQuota(containerId, 10000L);
            }
        }
        Thread.sleep(1000L);
        for (i = 3; i < 6; ++i) {
            appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)i);
            for (j = 0; j < i; ++j) {
                containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)j);
                container = (RMContainer)Mockito.mock(RMContainer.class);
                Mockito.when((Object)container.getContainerId()).thenReturn((Object)containerId);
                Mockito.when((Object)container.getDiagnosticsInfo()).thenReturn(null);
                Mockito.when((Object)container.getContainerExitStatus()).thenReturn((Object)0);
                Mockito.when((Object)container.getContainerState()).thenReturn((Object)ContainerState.COMPLETE);
                Mockito.when((Object)container.getFinishTime()).thenReturn((Object)19000L);
                qs.containerFinished(container);
                totalCost += 9;
            }
        }
        Thread.sleep(1000L);
        for (i = 6; i < 10; ++i) {
            appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)i);
            for (j = 0; j < i; ++j) {
                containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)j);
                container = (RMContainer)Mockito.mock(RMContainer.class);
                Mockito.when((Object)container.getContainerId()).thenReturn((Object)containerId);
                Mockito.when((Object)container.getAllocatedResource()).thenReturn((Object)TestUtils.createResource(2048L, 1, (Map<String, Integer>)ImmutableMap.builder().build()));
                Mockito.when((Object)container.getAllocatedNode()).thenReturn(null);
                Mockito.when((Object)container.getAllocatedPriority()).thenReturn((Object)Priority.UNDEFINED);
                Mockito.when((Object)container.getCreationTime()).thenReturn((Object)0L);
                qs.containerUpdated(container, 20000L);
                totalCost += 10;
            }
        }
        Thread.sleep(1000L);
        for (i = 6; i < 10; ++i) {
            appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)i);
            for (j = 0; j < i; ++j) {
                containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)j);
                container = (RMContainer)Mockito.mock(RMContainer.class);
                Mockito.when((Object)container.getContainerId()).thenReturn((Object)containerId);
                Mockito.when((Object)container.getDiagnosticsInfo()).thenReturn(null);
                Mockito.when((Object)container.getContainerExitStatus()).thenReturn((Object)0);
                Mockito.when((Object)container.getContainerState()).thenReturn((Object)ContainerState.COMPLETE);
                Mockito.when((Object)container.getFinishTime()).thenReturn((Object)30000L);
                qs.containerFinished(container);
                totalCost += 20;
            }
        }
        Thread.sleep(1000L);
        this.CheckProject(initialCredits - totalCost, totalCost);
        this.CheckProjectDailyCost(totalCost);
    }
}

