/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.ACLsTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestApplicationPriorityACLs
extends ACLsTestBase {
    private final int defaultPriorityQueueA = 3;
    private final int defaultPriorityQueueB = 10;
    private final int maxPriorityQueueA = 5;
    private final int maxPriorityQueueB = 11;
    private final int clusterMaxPriority = 10;

    @Test
    public void testApplicationACLs() throws Exception {
        this.verifyAppSubmitWithPrioritySuccess("queueA_user", "queueA", 5);
        this.verifyAppSubmitWithPriorityFailure("queueA_user", "queueA", 6);
        this.verifyAppSubmitWithPrioritySuccess("queueA_user", "queueA", -1);
        this.verifyAppSubmitWithPrioritySuccess("queueB_user", "queueB", 11);
    }

    private void verifyAppSubmitWithPrioritySuccess(String submitter, String queueName, int priority2) throws Exception {
        Priority appPriority = null;
        if (priority2 > 0) {
            appPriority = Priority.newInstance((int)priority2);
        } else {
            priority2 = 3;
        }
        ApplicationSubmissionContext submissionContext = this.prepareForAppSubmission(submitter, queueName, appPriority);
        this.submitAppToRMWithValidAcl(submitter, submissionContext);
        this.verifyAppPriorityIsAccepted(submitter, submissionContext.getApplicationId(), priority2);
    }

    private void verifyAppSubmitWithPriorityFailure(String submitter, String queueName, int priority2) throws Exception {
        Priority appPriority = Priority.newInstance((int)priority2);
        ApplicationSubmissionContext submissionContext = this.prepareForAppSubmission(submitter, queueName, appPriority);
        this.submitAppToRMWithInValidAcl(submitter, submissionContext);
    }

    private ApplicationSubmissionContext prepareForAppSubmission(String submitter, String queueName, Priority priority2) throws Exception {
        GetNewApplicationRequest newAppRequest = GetNewApplicationRequest.newInstance();
        ApplicationClientProtocol submitterClient = this.getRMClientForUser(submitter);
        ApplicationId applicationId = submitterClient.getNewApplication(newAppRequest).getApplicationId();
        Resource resource = BuilderUtils.newResource((long)1024L, (int)1);
        ContainerLaunchContext amContainerSpec = ContainerLaunchContext.newInstance(null, null, null, null, null, null);
        ApplicationSubmissionContext appSubmissionContext = ApplicationSubmissionContext.newInstance((ApplicationId)applicationId, (String)"applicationName", (String)queueName, null, (ContainerLaunchContext)amContainerSpec, (boolean)false, (boolean)true, (int)1, (Resource)resource, (String)"applicationType");
        appSubmissionContext.setApplicationId(applicationId);
        appSubmissionContext.setQueue(queueName);
        if (null != priority2) {
            appSubmissionContext.setPriority(priority2);
        }
        return appSubmissionContext;
    }

    private void submitAppToRMWithValidAcl(String submitter, ApplicationSubmissionContext appSubmissionContext) throws YarnException, IOException, InterruptedException {
        ApplicationClientProtocol submitterClient = this.getRMClientForUser(submitter);
        SubmitApplicationRequest submitRequest = SubmitApplicationRequest.newInstance((ApplicationSubmissionContext)appSubmissionContext);
        submitterClient.submitApplication(submitRequest);
        this.resourceManager.waitForState(appSubmissionContext.getApplicationId(), RMAppState.ACCEPTED);
    }

    private void submitAppToRMWithInValidAcl(String submitter, ApplicationSubmissionContext appSubmissionContext) throws YarnException, IOException, InterruptedException {
        ApplicationClientProtocol submitterClient = this.getRMClientForUser(submitter);
        SubmitApplicationRequest submitRequest = SubmitApplicationRequest.newInstance((ApplicationSubmissionContext)appSubmissionContext);
        try {
            submitterClient.submitApplication(submitRequest);
        }
        catch (YarnException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof RemoteException));
        }
    }

    private void verifyAppPriorityIsAccepted(String submitter, ApplicationId applicationId, int priority2) throws IOException, InterruptedException {
        ApplicationClientProtocol submitterClient = this.getRMClientForUser(submitter);
        if (priority2 > 10) {
            priority2 = 10;
        }
        GetApplicationReportRequest request = GetApplicationReportRequest.newInstance((ApplicationId)applicationId);
        try {
            GetApplicationReportResponse response = submitterClient.getApplicationReport(request);
            Assert.assertEquals((Object)response.getApplicationReport().getPriority(), (Object)Priority.newInstance((int)priority2));
        }
        catch (YarnException e) {
            Assert.fail((String)"Application submission should not fail.");
        }
    }

    @Override
    protected Configuration createConfiguration() {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{"queueA", "queueB", "queueC"});
        csConf.setCapacity("root.queueA", 50.0f);
        csConf.setCapacity("root.queueB", 25.0f);
        csConf.setCapacity("root.queueC", 25.0f);
        String[] aclsForA = new String[]{"queueA_user", "queueA_group"};
        csConf.setPriorityAcls("root.queueA", Priority.newInstance((int)5), Priority.newInstance((int)3), aclsForA);
        String[] aclsForB = new String[]{"queueB_user", "queueB_group"};
        csConf.setPriorityAcls("root.queueB", Priority.newInstance((int)11), Priority.newInstance((int)10), aclsForB);
        csConf.setBoolean("yarn.acl.enable", true);
        csConf.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getName());
        return csConf;
    }
}

