/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.fairscheduler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.LocalConfigurationProvider;
import org.apache.hadoop.yarn.exceptions.YarnException;

public class CustomResourceTypesConfigurationProvider
extends LocalConfigurationProvider {
    private static final String CUSTOM_RESOURCE_PREFIX = "customResource-";
    private static CustomResourceTypes customResourceTypes = CustomResourceTypesConfigurationProvider.createInitialResourceTypes();

    private static CustomResourceTypes createInitialResourceTypes() {
        return CustomResourceTypesConfigurationProvider.createCustomResourceTypes(2);
    }

    private static CustomResourceTypes createCustomResourceTypes(int count) {
        List<String> resourceTypeNames = CustomResourceTypesConfigurationProvider.generateResourceTypeNames(count);
        List resourceUnitXmlElements = IntStream.range(0, count).boxed().map(i -> CustomResourceTypesConfigurationProvider.getResourceUnitsXml((String)resourceTypeNames.get((int)i))).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder("<configuration>\n");
        sb.append(CustomResourceTypesConfigurationProvider.getResourceTypesXml(resourceTypeNames));
        for (String resourceUnitXml : resourceUnitXmlElements) {
            sb.append(resourceUnitXml);
        }
        sb.append("</configuration>");
        return new CustomResourceTypes(sb.toString(), count);
    }

    private static List<String> generateResourceTypeNames(int count) {
        return IntStream.range(0, count).boxed().map(i -> CUSTOM_RESOURCE_PREFIX + i).collect(Collectors.toList());
    }

    private static String getResourceUnitsXml(String resource) {
        return "<property>\n<name>yarn.resource-types." + resource + ".units</name>\n<value>k</value>\n</property>\n";
    }

    private static String getResourceTypesXml(List<String> resources) {
        String resourceTypes = CustomResourceTypesConfigurationProvider.makeCommaSeparatedString(resources);
        return "<property>\n<name>yarn.resource-types</name>\n<value>" + resourceTypes + "</value>\n</property>\n";
    }

    private static String makeCommaSeparatedString(List<String> resources) {
        return resources.stream().collect(Collectors.joining(","));
    }

    public InputStream getConfigurationInputStream(Configuration bootstrapConf, String name) throws YarnException, IOException {
        if ("resource-types.xml".equals(name)) {
            return new ByteArrayInputStream(customResourceTypes.getXml().getBytes());
        }
        return super.getConfigurationInputStream(bootstrapConf, name);
    }

    public static void reset() {
        customResourceTypes = CustomResourceTypesConfigurationProvider.createInitialResourceTypes();
    }

    public static void setNumberOfResourceTypes(int count) {
        customResourceTypes = CustomResourceTypesConfigurationProvider.createCustomResourceTypes(count);
    }

    public static List<String> getCustomResourceTypes() {
        return CustomResourceTypesConfigurationProvider.generateResourceTypeNames(customResourceTypes.getCount());
    }

    private static class CustomResourceTypes {
        private int count;
        private String xml;

        CustomResourceTypes(String xml, int count) {
            this.xml = xml;
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public String getXml() {
            return this.xml;
        }
    }
}

