/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.PeriodicRLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPeriodicRLESparseResourceAllocation {
    private static final Logger LOG = LoggerFactory.getLogger(TestPeriodicRLESparseResourceAllocation.class);

    @Test
    public void testPeriodicCapacity() {
        int[] alloc = new int[]{10, 7, 5, 2, 0};
        long[] timeSteps = new long[]{0L, 5L, 10L, 15L, 19L};
        RLESparseResourceAllocation rleSparseVector = ReservationSystemTestUtil.generateRLESparseResourceAllocation(alloc, timeSteps);
        PeriodicRLESparseResourceAllocation periodicVector = new PeriodicRLESparseResourceAllocation(rleSparseVector, Long.valueOf(20L));
        LOG.info(periodicVector.toString());
        Assert.assertEquals((Object)Resource.newInstance((int)5, (int)5), (Object)periodicVector.getCapacityAtTime(10L));
        Assert.assertEquals((Object)Resource.newInstance((int)10, (int)10), (Object)periodicVector.getCapacityAtTime(20L));
        Assert.assertEquals((Object)Resource.newInstance((int)7, (int)7), (Object)periodicVector.getCapacityAtTime(27L));
        Assert.assertEquals((Object)Resource.newInstance((int)5, (int)5), (Object)periodicVector.getCapacityAtTime(50L));
    }

    @Test
    public void testMaxPeriodicCapacity() {
        int[] alloc = new int[]{2, 5, 7, 10, 3, 4, 6, 8};
        long[] timeSteps = new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L};
        RLESparseResourceAllocation rleSparseVector = ReservationSystemTestUtil.generateRLESparseResourceAllocation(alloc, timeSteps);
        PeriodicRLESparseResourceAllocation periodicVector = new PeriodicRLESparseResourceAllocation(rleSparseVector, Long.valueOf(8L));
        LOG.info(periodicVector.toString());
        Assert.assertEquals((Object)periodicVector.getMaximumPeriodicCapacity(0L, 1L), (Object)Resource.newInstance((int)10, (int)10));
        Assert.assertEquals((Object)periodicVector.getMaximumPeriodicCapacity(8L, 2L), (Object)Resource.newInstance((int)7, (int)7));
        Assert.assertEquals((Object)periodicVector.getMaximumPeriodicCapacity(16L, 3L), (Object)Resource.newInstance((int)10, (int)10));
        Assert.assertEquals((Object)periodicVector.getMaximumPeriodicCapacity(17L, 4L), (Object)Resource.newInstance((int)5, (int)5));
        Assert.assertEquals((Object)periodicVector.getMaximumPeriodicCapacity(32L, 5L), (Object)Resource.newInstance((int)4, (int)4));
    }

    @Test
    public void testMixPeriodicAndNonPeriodic() throws PlanningException {
        int[] alloc = new int[]{2, 5, 0};
        long[] timeSteps = new long[]{1L, 2L, 3L};
        RLESparseResourceAllocation tempPeriodic = ReservationSystemTestUtil.generateRLESparseResourceAllocation(alloc, timeSteps);
        PeriodicRLESparseResourceAllocation periodic = new PeriodicRLESparseResourceAllocation(tempPeriodic, Long.valueOf(10L));
        int[] alloc2 = new int[]{10, 10, 0};
        long[] timeSteps2 = new long[]{12L, 13L, 14L};
        RLESparseResourceAllocation nonPeriodic = ReservationSystemTestUtil.generateRLESparseResourceAllocation(alloc2, timeSteps2);
        RLESparseResourceAllocation merged = RLESparseResourceAllocation.merge((ResourceCalculator)nonPeriodic.getResourceCalculator(), (Resource)Resource.newInstance((int)102400, (int)100), (RLESparseResourceAllocation)periodic, (RLESparseResourceAllocation)nonPeriodic, (RLESparseResourceAllocation.RLEOperator)RLESparseResourceAllocation.RLEOperator.add, (long)2L, (long)25L);
        Assert.assertEquals((Object)Resource.newInstance((int)5, (int)5), (Object)merged.getCapacityAtTime(2L));
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)merged.getCapacityAtTime(3L));
        Assert.assertEquals((Object)Resource.newInstance((int)2, (int)2), (Object)merged.getCapacityAtTime(11L));
        Assert.assertEquals((Object)Resource.newInstance((int)15, (int)15), (Object)merged.getCapacityAtTime(12L));
        Assert.assertEquals((Object)Resource.newInstance((int)10, (int)10), (Object)merged.getCapacityAtTime(13L));
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)merged.getCapacityAtTime(14L));
        Assert.assertEquals((Object)Resource.newInstance((int)2, (int)2), (Object)merged.getCapacityAtTime(21L));
        Assert.assertEquals((Object)Resource.newInstance((int)5, (int)5), (Object)merged.getCapacityAtTime(22L));
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)merged.getCapacityAtTime(23L));
    }

    @Test
    public void testSetCapacityInInterval() {
        int[] alloc = new int[]{2, 5, 0};
        long[] timeSteps = new long[]{1L, 2L, 3L};
        RLESparseResourceAllocation rleSparseVector = ReservationSystemTestUtil.generateRLESparseResourceAllocation(alloc, timeSteps);
        PeriodicRLESparseResourceAllocation periodicVector = new PeriodicRLESparseResourceAllocation(rleSparseVector, Long.valueOf(10L));
        ReservationInterval interval = new ReservationInterval(5L, 10L);
        periodicVector.addInterval(interval, Resource.newInstance((int)8, (int)8));
        Assert.assertEquals((Object)Resource.newInstance((int)8, (int)8), (Object)periodicVector.getCapacityAtTime(5L));
        Assert.assertEquals((Object)Resource.newInstance((int)8, (int)8), (Object)periodicVector.getCapacityAtTime(9L));
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)periodicVector.getCapacityAtTime(10L));
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)periodicVector.getCapacityAtTime(0L));
    }

    public void testRemoveInterval() {
        int[] alloc = new int[]{2, 5, 3, 4, 0};
        long[] timeSteps = new long[]{1L, 3L, 5L, 7L, 9L};
        RLESparseResourceAllocation rleSparseVector = ReservationSystemTestUtil.generateRLESparseResourceAllocation(alloc, timeSteps);
        PeriodicRLESparseResourceAllocation periodicVector = new PeriodicRLESparseResourceAllocation(rleSparseVector, Long.valueOf(10L));
        ReservationInterval interval = new ReservationInterval(3L, 7L);
        Assert.assertTrue((boolean)periodicVector.removeInterval(interval, Resource.newInstance((int)3, (int)3)));
        Assert.assertEquals((Object)Resource.newInstance((int)2, (int)2), (Object)periodicVector.getCapacityAtTime(1L));
        Assert.assertEquals((Object)Resource.newInstance((int)2, (int)2), (Object)periodicVector.getCapacityAtTime(2L));
        Assert.assertEquals((Object)Resource.newInstance((int)2, (int)2), (Object)periodicVector.getCapacityAtTime(3L));
        Assert.assertEquals((Object)Resource.newInstance((int)2, (int)2), (Object)periodicVector.getCapacityAtTime(4L));
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)periodicVector.getCapacityAtTime(5L));
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)periodicVector.getCapacityAtTime(6L));
        Assert.assertEquals((Object)Resource.newInstance((int)4, (int)4), (Object)periodicVector.getCapacityAtTime(7L));
        Assert.assertFalse((boolean)periodicVector.removeInterval(new ReservationInterval(7L, 12L), Resource.newInstance((int)1, (int)1)));
        Assert.assertFalse((boolean)periodicVector.removeInterval(new ReservationInterval(2L, 4L), Resource.newInstance((int)8, (int)8)));
    }
}

