/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesCustomResourceTypesCommons;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.fairscheduler.CustomResourceTypesConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.BufferedClientResponse;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.JsonCustomResourceTypeTestcase;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.XmlCustomResourceTypeTestCase;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.GuiceServletConfig;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.NodeList;

public class TestRMWebServicesAppCustomResourceTypes
extends JerseyTestBase {
    private static MockRM rm;
    private static final int CONTAINER_MB = 1024;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.createInjectorForWebServletModule();
    }

    private void createInjectorForWebServletModule() {
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    public TestRMWebServicesAppCustomResourceTypes() {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    private WebResource getWebResourcePathForApp(RMApp app1, WebResource r) {
        return r.path("ws").path("v1").path("cluster").path("apps").path(String.valueOf(app1.getApplicationId().toString()));
    }

    @Test
    public void testRunningAppXml() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024, "testwordcount", "user1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, amNodeManager);
        am1.allocate("*", 2048, 1, new ArrayList<ContainerId>());
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        WebResource path = this.getWebResourcePathForApp(app1, r);
        ClientResponse response = (ClientResponse)path.accept(new String[]{"application/xml"}).get(ClientResponse.class);
        XmlCustomResourceTypeTestCase testCase = new XmlCustomResourceTypeTestCase(path, new BufferedClientResponse(response));
        testCase.verify(document -> {
            NodeList appArray = document.getElementsByTagName("app");
            Assert.assertEquals((String)"incorrect number of app elements", (long)1L, (long)appArray.getLength());
            TestRMWebServicesCustomResourceTypesCommons.verifyAppsXML(appArray, app1, rm);
        });
        rm.stop();
    }

    @Test
    public void testRunningAppJson() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024, "testwordcount", "user1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, amNodeManager);
        am1.allocate("*", 2048, 1, new ArrayList<ContainerId>());
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        WebResource path = this.getWebResourcePathForApp(app1, r);
        ClientResponse response = (ClientResponse)path.accept(new String[]{"application/json"}).get(ClientResponse.class);
        JsonCustomResourceTypeTestcase testCase = new JsonCustomResourceTypeTestcase(path, new BufferedClientResponse(response));
        testCase.verify(json -> {
            try {
                Assert.assertEquals((String)"incorrect number of app elements", (long)1L, (long)json.length());
                JSONObject app = json.getJSONObject("app");
                TestRMWebServicesCustomResourceTypesCommons.verifyAppInfoJson(app, app1, rm);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        });
        rm.stop();
    }

    private static class WebServletModule
    extends ServletModule {
        private WebServletModule() {
        }

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            this.bind(RMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            Configuration conf = new Configuration();
            conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
            conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
            this.initResourceTypes(conf);
            rm = new MockRM(conf);
            this.bind(ResourceManager.class).toInstance((Object)rm);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }

        private void initResourceTypes(Configuration conf) {
            conf.set("yarn.resourcemanager.configuration.provider-class", CustomResourceTypesConfigurationProvider.class.getName());
            ResourceUtils.resetResourceTypes((Configuration)conf);
        }
    }
}

