/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import net.jcip.annotations.NotThreadSafe;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.BaseSharingPolicyTest;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.NoOverCommitPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.ResourceOverCommitException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@NotThreadSafe
public class TestNoOverCommitPolicy
extends BaseSharingPolicyTest {
    static final long ONEHOUR = 3600000L;
    static final String TWOHOURPERIOD = "7200000";

    @Parameterized.Parameters(name="Duration {0}, height {1}, submissions {2}, periodic {3})")
    public static Collection<Object[]> data() {
        return Arrays.asList({3600000L, 0.25, 1, null, null}, {3600000L, 0.25, 1, TWOHOURPERIOD, null}, {3600000L, 1, 1, null, null}, {3600000L, 1, 1, TWOHOURPERIOD, null}, {3600000L, 1.1, 1, null, ResourceOverCommitException.class}, {3600000L, 1.1, 1, TWOHOURPERIOD, ResourceOverCommitException.class}, {3600000L, 0.25, 4, null, null}, {3600000L, 0.25, 4, TWOHOURPERIOD, null}, {3600000L, 0.25, 5, null, ResourceOverCommitException.class}, {3600000L, 0.25, 5, TWOHOURPERIOD, ResourceOverCommitException.class});
    }

    @Override
    public SharingPolicy getInitializedPolicy() {
        String reservationQ = ReservationSystemTestUtil.getFullReservationQueueName();
        this.conf = new CapacitySchedulerConfiguration();
        NoOverCommitPolicy policy = new NoOverCommitPolicy();
        policy.init(reservationQ, this.conf);
        return policy;
    }

    @Test
    public void testAllocation() throws IOException, PlanningException {
        this.runTest();
    }
}

