/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed;

import java.util.List;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.api.records.ContainerQueuingLimit;
import org.apache.hadoop.yarn.server.api.records.OpportunisticContainersStatus;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed.NodeQueueLoadMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed.QueueLimitCalculator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestNodeQueueLoadMonitor {
    private static final int DEFAULT_MAX_QUEUE_LENGTH = 200;

    @Test
    public void testWaitTimeSort() {
        NodeQueueLoadMonitor selector = new NodeQueueLoadMonitor(NodeQueueLoadMonitor.LoadComparator.QUEUE_WAIT_TIME);
        selector.updateNode(this.createRMNode("h1", 1, 15, 10));
        selector.updateNode(this.createRMNode("h2", 2, 5, 10));
        selector.updateNode(this.createRMNode("h3", 3, 10, 10));
        selector.computeTask.run();
        List nodeIds = selector.selectNodes();
        System.out.println("1-> " + nodeIds);
        Assert.assertEquals((Object)"h2:2", (Object)((NodeId)nodeIds.get(0)).toString());
        Assert.assertEquals((Object)"h3:3", (Object)((NodeId)nodeIds.get(1)).toString());
        Assert.assertEquals((Object)"h1:1", (Object)((NodeId)nodeIds.get(2)).toString());
        selector.updateNode(this.createRMNode("h3", 3, 2, 10));
        selector.computeTask.run();
        nodeIds = selector.selectNodes();
        System.out.println("2-> " + nodeIds);
        Assert.assertEquals((Object)"h3:3", (Object)((NodeId)nodeIds.get(0)).toString());
        Assert.assertEquals((Object)"h2:2", (Object)((NodeId)nodeIds.get(1)).toString());
        Assert.assertEquals((Object)"h1:1", (Object)((NodeId)nodeIds.get(2)).toString());
        selector.updateNode(this.createRMNode("h4", 4, -1, 10));
        selector.computeTask.run();
        nodeIds = selector.selectNodes();
        System.out.println("3-> " + nodeIds);
        Assert.assertEquals((Object)"h3:3", (Object)((NodeId)nodeIds.get(0)).toString());
        Assert.assertEquals((Object)"h2:2", (Object)((NodeId)nodeIds.get(1)).toString());
        Assert.assertEquals((Object)"h1:1", (Object)((NodeId)nodeIds.get(2)).toString());
    }

    @Test
    public void testQueueLengthSort() {
        NodeQueueLoadMonitor selector = new NodeQueueLoadMonitor(NodeQueueLoadMonitor.LoadComparator.QUEUE_LENGTH);
        selector.updateNode(this.createRMNode("h1", 1, -1, 15));
        selector.updateNode(this.createRMNode("h2", 2, -1, 5));
        selector.updateNode(this.createRMNode("h3", 3, -1, 10));
        selector.computeTask.run();
        List nodeIds = selector.selectNodes();
        System.out.println("1-> " + nodeIds);
        Assert.assertEquals((Object)"h2:2", (Object)((NodeId)nodeIds.get(0)).toString());
        Assert.assertEquals((Object)"h3:3", (Object)((NodeId)nodeIds.get(1)).toString());
        Assert.assertEquals((Object)"h1:1", (Object)((NodeId)nodeIds.get(2)).toString());
        selector.updateNode(this.createRMNode("h3", 3, -1, 2));
        selector.computeTask.run();
        nodeIds = selector.selectNodes();
        System.out.println("2-> " + nodeIds);
        Assert.assertEquals((Object)"h3:3", (Object)((NodeId)nodeIds.get(0)).toString());
        Assert.assertEquals((Object)"h2:2", (Object)((NodeId)nodeIds.get(1)).toString());
        Assert.assertEquals((Object)"h1:1", (Object)((NodeId)nodeIds.get(2)).toString());
        selector.updateNode(this.createRMNode("h4", 4, -1, 20));
        selector.computeTask.run();
        nodeIds = selector.selectNodes();
        System.out.println("3-> " + nodeIds);
        Assert.assertEquals((Object)"h3:3", (Object)((NodeId)nodeIds.get(0)).toString());
        Assert.assertEquals((Object)"h2:2", (Object)((NodeId)nodeIds.get(1)).toString());
        Assert.assertEquals((Object)"h1:1", (Object)((NodeId)nodeIds.get(2)).toString());
        Assert.assertEquals((Object)"h4:4", (Object)((NodeId)nodeIds.get(3)).toString());
        selector.updateNode(this.createRMNode("h3", 3, -1, 200));
        selector.computeTask.run();
        nodeIds = selector.selectNodes();
        System.out.println("4-> " + nodeIds);
        Assert.assertEquals((long)3L, (long)nodeIds.size());
        Assert.assertEquals((Object)"h2:2", (Object)((NodeId)nodeIds.get(0)).toString());
        Assert.assertEquals((Object)"h1:1", (Object)((NodeId)nodeIds.get(1)).toString());
        Assert.assertEquals((Object)"h4:4", (Object)((NodeId)nodeIds.get(2)).toString());
    }

    @Test
    public void testContainerQueuingLimit() {
        NodeQueueLoadMonitor selector = new NodeQueueLoadMonitor(NodeQueueLoadMonitor.LoadComparator.QUEUE_LENGTH);
        selector.updateNode(this.createRMNode("h1", 1, -1, 15));
        selector.updateNode(this.createRMNode("h2", 2, -1, 5));
        selector.updateNode(this.createRMNode("h3", 3, -1, 10));
        selector.initThresholdCalculator(0.0f, 6, 100);
        QueueLimitCalculator calculator = selector.getThresholdCalculator();
        ContainerQueuingLimit containerQueuingLimit = calculator.createContainerQueuingLimit();
        Assert.assertEquals((long)6L, (long)containerQueuingLimit.getMaxQueueLength());
        Assert.assertEquals((long)-1L, (long)containerQueuingLimit.getMaxQueueWaitTimeInMs());
        selector.computeTask.run();
        containerQueuingLimit = calculator.createContainerQueuingLimit();
        Assert.assertEquals((long)10L, (long)containerQueuingLimit.getMaxQueueLength());
        Assert.assertEquals((long)-1L, (long)containerQueuingLimit.getMaxQueueWaitTimeInMs());
        selector.updateNode(this.createRMNode("h1", 1, -1, 110));
        selector.updateNode(this.createRMNode("h2", 2, -1, 120));
        selector.updateNode(this.createRMNode("h3", 3, -1, 130));
        selector.updateNode(this.createRMNode("h4", 4, -1, 140));
        selector.updateNode(this.createRMNode("h5", 5, -1, 150));
        selector.updateNode(this.createRMNode("h6", 6, -1, 160));
        selector.computeTask.run();
        containerQueuingLimit = calculator.createContainerQueuingLimit();
        Assert.assertEquals((long)100L, (long)containerQueuingLimit.getMaxQueueLength());
        selector.updateNode(this.createRMNode("h1", 1, -1, 1));
        selector.updateNode(this.createRMNode("h2", 2, -1, 2));
        selector.updateNode(this.createRMNode("h3", 3, -1, 3));
        selector.updateNode(this.createRMNode("h4", 4, -1, 4));
        selector.updateNode(this.createRMNode("h5", 5, -1, 5));
        selector.updateNode(this.createRMNode("h6", 6, -1, 6));
        selector.computeTask.run();
        containerQueuingLimit = calculator.createContainerQueuingLimit();
        Assert.assertEquals((long)6L, (long)containerQueuingLimit.getMaxQueueLength());
    }

    private RMNode createRMNode(String host, int port, int waitTime, int queueLength) {
        return this.createRMNode(host, port, waitTime, queueLength, 200);
    }

    private RMNode createRMNode(String host, int port, int waitTime, int queueLength, int queueCapacity) {
        RMNode node1 = (RMNode)Mockito.mock(RMNode.class);
        FakeNodeId nID1 = new FakeNodeId(host, port);
        Mockito.when((Object)node1.getNodeID()).thenReturn((Object)nID1);
        OpportunisticContainersStatus status1 = (OpportunisticContainersStatus)Mockito.mock(OpportunisticContainersStatus.class);
        Mockito.when((Object)status1.getEstimatedQueueWaitTime()).thenReturn((Object)waitTime);
        Mockito.when((Object)status1.getWaitQueueLength()).thenReturn((Object)queueLength);
        Mockito.when((Object)status1.getOpportQueueCapacity()).thenReturn((Object)queueCapacity);
        Mockito.when((Object)node1.getOpportunisticContainersStatus()).thenReturn((Object)status1);
        return node1;
    }

    static class FakeNodeId
    extends NodeId {
        final String host;
        final int port;

        public FakeNodeId(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        protected void setHost(String host) {
        }

        protected void setPort(int port) {
        }

        protected void build() {
        }

        public String toString() {
            return this.host + ":" + this.port;
        }
    }
}

