/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import io.hops.security.AbstractSecurityActions;
import io.hops.security.HopsSecurityActionsFactory;
import java.time.LocalDateTime;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.JWTSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.MockJWTSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityActions;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityMaterial;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMSecurityHandlersBaseTest;
import org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppSecurityActions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestJWTSecurityHandler
extends RMSecurityHandlersBaseTest {
    private static final Log LOG = LogFactory.getLog(TestJWTSecurityHandler.class);
    private Configuration config;
    private DrainDispatcher dispatcher;
    private RMContext rmContext;

    @Before
    public void beforeTest() {
        this.config = new Configuration();
        this.config.setBoolean(YarnConfiguration.RM_JWT_ENABLED, true);
        HopsSecurityActionsFactory.getInstance().clear(this.config.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.HopsworksRMAppSecurityActions"));
        this.dispatcher = new DrainDispatcher();
        this.rmContext = new RMContextImpl((Dispatcher)this.dispatcher, null, null, null, null, null, null, null, null);
        this.dispatcher.init(this.config);
        this.dispatcher.start();
    }

    @After
    public void afterTest() {
        if (this.dispatcher != null) {
            this.dispatcher.stop();
        }
    }

    @Test
    public void testJWTGenerationEvent() throws Exception {
        this.config.set(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppSecurityActions");
        RMSecurityHandlersBaseTest.MockRMAppEventHandler eventHandler = new RMSecurityHandlersBaseTest.MockRMAppEventHandler(RMAppEventType.SECURITY_MATERIAL_GENERATED);
        this.rmContext.getDispatcher().register(RMAppEventType.class, (EventHandler)eventHandler);
        RMAppSecurityManager securityManager = new RMAppSecurityManager(this.rmContext);
        JWTSecurityHandler jwtHandler = (JWTSecurityHandler)Mockito.spy((Object)((Object)new MockJWTSecurityHandler(this.rmContext, securityManager)));
        securityManager.registerRMAppSecurityHandlerWithType((RMAppSecurityHandler)jwtHandler, JWTSecurityHandler.class);
        securityManager.init(this.config);
        securityManager.start();
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(appId, "Alice");
        RMAppSecurityMaterial securityMaterial = new RMAppSecurityMaterial();
        securityMaterial.addMaterial((RMAppSecurityManager.SecurityManagerMaterial)jwtParam);
        RMAppSecurityManagerEvent event = new RMAppSecurityManagerEvent(appId, securityMaterial, RMAppSecurityManagerEventType.GENERATE_SECURITY_MATERIAL);
        securityManager.handle(event);
        this.dispatcher.await();
        eventHandler.verifyEvent();
        securityManager.stop();
        ((JWTSecurityHandler)Mockito.verify((Object)jwtHandler)).generateMaterial((JWTSecurityHandler.JWTMaterialParameter)Mockito.eq((Object)jwtParam));
    }

    @Test
    public void testJWTRevocation() throws Exception {
        this.config.set(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppSecurityActions");
        RMAppSecurityActions actor = (RMAppSecurityActions)Mockito.spy((Object)new TestingRMAppSecurityActions());
        HopsSecurityActionsFactory.getInstance().register(this.config.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY), (AbstractSecurityActions)actor);
        RMAppSecurityManager securityManager = new RMAppSecurityManager(this.rmContext);
        JWTSecurityHandler jwtHandler = (JWTSecurityHandler)Mockito.spy((Object)((Object)new MockJWTSecurityHandler.BlockingInvalidator(this.rmContext, securityManager)));
        ((MockJWTSecurityHandler.BlockingInvalidator)jwtHandler).getSemaphore().acquire();
        securityManager.registerRMAppSecurityHandlerWithType((RMAppSecurityHandler)jwtHandler, JWTSecurityHandler.class);
        securityManager.init(this.config);
        securityManager.start();
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        JWTSecurityHandler.JWTMaterialParameter param = new JWTSecurityHandler.JWTMaterialParameter(appId, "Alice");
        RMAppSecurityMaterial securityMaterial = new RMAppSecurityMaterial();
        securityMaterial.addMaterial((RMAppSecurityManager.SecurityManagerMaterial)param);
        RMAppSecurityManagerEvent event = new RMAppSecurityManagerEvent(appId, securityMaterial, RMAppSecurityManagerEventType.REVOKE_SECURITY_MATERIAL);
        securityManager.handle(event);
        JWTSecurityHandler.JWTInvalidationEvent invalidationEvent = new JWTSecurityHandler.JWTInvalidationEvent(appId.toString());
        Assert.assertTrue((boolean)jwtHandler.getInvalidationEvents().contains(invalidationEvent));
        ((MockJWTSecurityHandler.BlockingInvalidator)jwtHandler).getSemaphore().release();
        TimeUnit.MILLISECONDS.sleep(10L);
        ((MockJWTSecurityHandler.BlockingInvalidator)jwtHandler).getSemaphore().acquire();
        ((RMAppSecurityActions)Mockito.verify((Object)actor)).invalidateJWT((String)Mockito.eq((Object)appId.toString()));
        securityManager.stop();
    }

    @Test
    public void testJWTRenewal() throws Exception {
        int sleeped;
        this.config.set(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppSecurityActions");
        this.config.set(YarnConfiguration.RM_JWT_VALIDITY_PERIOD, "5s");
        this.config.set(YarnConfiguration.RM_JWT_EXPIRATION_LEEWAY, "2s");
        RMAppSecurityActions actor = (RMAppSecurityActions)Mockito.spy((Object)new TestingRMAppSecurityActions());
        HopsSecurityActionsFactory.getInstance().register(this.config.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY), (AbstractSecurityActions)actor);
        RMAppSecurityManager securityManager = new RMAppSecurityManager(this.rmContext);
        JWTSecurityHandler jwtHandler = (JWTSecurityHandler)Mockito.spy((Object)((Object)new MockJWTSecurityHandler(this.rmContext, securityManager)));
        securityManager.registerRMAppSecurityHandlerWithType((RMAppSecurityHandler)jwtHandler, JWTSecurityHandler.class);
        securityManager.init(this.config);
        securityManager.start();
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        String user = "Dorothy";
        JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(appId, user);
        JWTSecurityHandler.JWTSecurityManagerMaterial jwt = jwtHandler.generateMaterial(jwtParam);
        jwtParam = new JWTSecurityHandler.JWTMaterialParameter(appId, user);
        jwtParam.setExpirationDate(jwt.getExpirationDate());
        jwtParam.setToken(jwt.getToken());
        securityManager.registerWithMaterialRenewers((RMAppSecurityManager.SecurityManagerMaterial)jwtParam);
        ((JWTSecurityHandler)Mockito.verify((Object)jwtHandler)).registerRenewer((JWTSecurityHandler.JWTMaterialParameter)Mockito.eq((Object)jwtParam));
        for (sleeped = 15; !((MockJWTSecurityHandler)jwtHandler).getRenewer().hasRun() && sleeped > 0; --sleeped) {
            TimeUnit.SECONDS.sleep(1L);
        }
        Assert.assertNotEquals((String)"Waited too long for JWT renewal to happen", (long)0L, (long)sleeped);
        JWTSecurityHandler.JWTMaterialParameter jwtRenewParam = new JWTSecurityHandler.JWTMaterialParameter(appId, user);
        jwtRenewParam.setToken(jwt.getToken());
        LocalDateTime now = jwtHandler.getNow();
        LocalDateTime expirationDate = now.plus((Long)jwtHandler.getValidityPeriod().getFirst(), (TemporalUnit)jwtHandler.getValidityPeriod().getSecond());
        jwtRenewParam.setExpirationDate(expirationDate);
        ((RMAppSecurityActions)Mockito.verify((Object)actor)).renewJWT((JWTSecurityHandler.JWTMaterialParameter)Mockito.eq((Object)jwtRenewParam));
        securityManager.stop();
    }
}

