/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigurableResource {
    private final Resource clusterResource = Resources.createResource((int)2048, (int)2);

    @Test
    public void testGetResourceWithPercentage() {
        ConfigurableResource configurableResource = new ConfigurableResource(new double[]{0.5, 0.5});
        Assert.assertEquals((long)configurableResource.getResource(this.clusterResource).getMemorySize(), (long)1024L);
        Assert.assertEquals((long)configurableResource.getResource(this.clusterResource).getVirtualCores(), (long)1L);
        Assert.assertNull((String)"The absolute resource should be null since object configurableResource is initialized with percentages", (Object)configurableResource.getResource());
        Assert.assertNull((String)"The absolute resource should be null since cluster resource is null", (Object)configurableResource.getResource(null));
    }

    @Test
    public void testGetResourceWithAbsolute() {
        ConfigurableResource configurableResource = new ConfigurableResource(Resources.createResource((int)3072, (int)3));
        Assert.assertEquals((long)configurableResource.getResource().getMemorySize(), (long)3072L);
        Assert.assertEquals((long)configurableResource.getResource().getVirtualCores(), (long)3L);
        Assert.assertEquals((long)configurableResource.getResource(this.clusterResource).getMemorySize(), (long)3072L);
        Assert.assertEquals((long)configurableResource.getResource(this.clusterResource).getVirtualCores(), (long)3L);
        Assert.assertEquals((long)configurableResource.getResource(null).getMemorySize(), (long)3072L);
        Assert.assertEquals((long)configurableResource.getResource(null).getVirtualCores(), (long)3L);
    }
}

