/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy;

import java.util.Iterator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FifoOrderingPolicyForPendingApps;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.MockSchedulableEntity;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.SchedulableEntity;
import org.junit.Assert;
import org.junit.Test;

public class TestFifoOrderingPolicyForPendingApps {
    @Test
    public void testFifoOrderingPolicyForPendingApps() {
        FifoOrderingPolicyForPendingApps policy = new FifoOrderingPolicyForPendingApps();
        MockSchedulableEntity r1 = new MockSchedulableEntity();
        MockSchedulableEntity r2 = new MockSchedulableEntity();
        Assert.assertEquals((long)policy.getComparator().compare(r1, r2), (long)0L);
        r1.setSerial(1L);
        r1.setRecovering(true);
        Assert.assertEquals((long)policy.getComparator().compare(r1, r2), (long)-1L);
        r1.setRecovering(false);
        r2.setSerial(2L);
        r2.setRecovering(true);
        Assert.assertEquals((long)policy.getComparator().compare(r1, r2), (long)1L);
    }

    @Test
    public void testIterators() {
        FifoOrderingPolicyForPendingApps schedOrder = new FifoOrderingPolicyForPendingApps();
        MockSchedulableEntity msp1 = new MockSchedulableEntity(1L, 1, true);
        MockSchedulableEntity msp2 = new MockSchedulableEntity(2L, 2, true);
        MockSchedulableEntity msp3 = new MockSchedulableEntity(3L, 3, true);
        MockSchedulableEntity msp4 = new MockSchedulableEntity(4L, 2, true);
        MockSchedulableEntity msp5 = new MockSchedulableEntity(5L, 5, false);
        MockSchedulableEntity msp6 = new MockSchedulableEntity(6L, 6, false);
        MockSchedulableEntity msp7 = new MockSchedulableEntity(7L, 5, false);
        schedOrder.addSchedulableEntity((SchedulableEntity)msp1);
        schedOrder.addSchedulableEntity((SchedulableEntity)msp2);
        schedOrder.addSchedulableEntity((SchedulableEntity)msp3);
        schedOrder.addSchedulableEntity((SchedulableEntity)msp4);
        schedOrder.addSchedulableEntity((SchedulableEntity)msp5);
        schedOrder.addSchedulableEntity((SchedulableEntity)msp6);
        schedOrder.addSchedulableEntity((SchedulableEntity)msp7);
        this.checkSerials(schedOrder.getAssignmentIterator(), new long[]{3L, 2L, 4L, 1L, 6L, 5L, 7L});
        this.checkSerials(schedOrder.getPreemptionIterator(), new long[]{7L, 5L, 6L, 1L, 4L, 2L, 3L});
    }

    public void checkSerials(Iterator<MockSchedulableEntity> si, long[] serials) {
        for (int i = 0; i < serials.length; ++i) {
            Assert.assertEquals((long)si.next().getSerial(), (long)serials[i]);
        }
    }
}

