/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.helper;

import com.sun.jersey.api.client.WebResource;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.BufferedClientResponse;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XmlCustomResourceTypeTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(XmlCustomResourceTypeTestCase.class);
    private WebResource path;
    private BufferedClientResponse response;
    private Document parsedResponse;

    public XmlCustomResourceTypeTestCase(WebResource path, BufferedClientResponse response) {
        this.path = path;
        this.verifyStatus(response);
        this.response = response;
    }

    private void verifyStatus(BufferedClientResponse response) {
        String responseStr = response.getEntity(String.class);
        Assert.assertEquals((String)("HTTP status should be 200, status info: " + response.getStatusInfo() + " response as string: " + responseStr), (long)200L, (long)response.getStatus());
    }

    public void verify(Consumer<Document> verifier) {
        Assert.assertEquals((Object)"application/xml; charset=utf-8", (Object)this.response.getType().toString());
        this.parsedResponse = this.parseXml(this.response);
        this.logResponse(this.parsedResponse);
        verifier.accept(this.parsedResponse);
    }

    private Document parseXml(BufferedClientResponse response) {
        try {
            String xml = response.getEntity(String.class);
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            return db.parse(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void logResponse(Document doc) {
        String responseStr = this.response.getEntity(String.class);
        LOG.info("Raw response from service URL {}: {}", (Object)this.path.toString(), (Object)responseStr);
        LOG.info("Parsed response from service URL {}: {}", (Object)this.path.toString(), (Object)XmlCustomResourceTypeTestCase.toXml(doc));
    }

    public static String toXml(Node node) {
        StringWriter writer;
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            writer = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return writer.getBuffer().toString();
    }
}

