/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ClusterNodeTracker;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestClusterNodeTracker {
    private ClusterNodeTracker<FSSchedulerNode> nodeTracker;

    @Before
    public void setup() {
        this.nodeTracker = new ClusterNodeTracker();
    }

    private void addEight4x4Nodes() {
        MockNodes.resetHostIds();
        List<RMNode> rmNodes = MockNodes.newNodes(2, 4, Resource.newInstance((int)4096, (int)4));
        for (RMNode rmNode : rmNodes) {
            this.nodeTracker.addNode((SchedulerNode)new FSSchedulerNode(rmNode, false));
        }
    }

    @Test
    public void testGetNodeCount() {
        this.addEight4x4Nodes();
        Assert.assertEquals((String)"Incorrect number of nodes in the cluster", (long)8L, (long)this.nodeTracker.nodeCount());
        Assert.assertEquals((String)"Incorrect number of nodes in each rack", (long)4L, (long)this.nodeTracker.nodeCount("rack0"));
    }

    @Test
    public void testGetNodesForResourceName() throws Exception {
        this.addEight4x4Nodes();
        Assert.assertEquals((String)"Incorrect number of nodes matching ANY", (long)8L, (long)this.nodeTracker.getNodesByResourceName("*").size());
        Assert.assertEquals((String)"Incorrect number of nodes matching rack", (long)4L, (long)this.nodeTracker.getNodesByResourceName("rack0").size());
        Assert.assertEquals((String)"Incorrect number of nodes matching node", (long)1L, (long)this.nodeTracker.getNodesByResourceName("host0").size());
    }

    @Test
    public void testMaxAllowedAllocation() {
        Configuration conf = new Configuration();
        conf.set("yarn.resource-types", "test1");
        ResourceUtils.resetResourceTypes((Configuration)conf);
        this.setup();
        Resource maximum = Resource.newInstance((long)10240L, (int)10, Collections.singletonMap("test1", 10L));
        this.nodeTracker.setConfiguredMaxAllocation(maximum);
        Resource result = this.nodeTracker.getMaxAllowedAllocation();
        Assert.assertEquals((String)"With no nodes added, the ClusterNodeTracker did not return the configured max allocation", (Object)maximum, (Object)result);
        List<RMNode> smallNodes = MockNodes.newNodes(1, 1, Resource.newInstance((long)1024L, (int)2, Collections.singletonMap("test1", 4L)));
        FSSchedulerNode smallNode = new FSSchedulerNode(smallNodes.get(0), false);
        List<RMNode> mediumNodes = MockNodes.newNodes(1, 1, Resource.newInstance((long)4096L, (int)2, Collections.singletonMap("test1", 2L)));
        FSSchedulerNode mediumNode = new FSSchedulerNode(mediumNodes.get(0), false);
        List<RMNode> largeNodes = MockNodes.newNodes(1, 1, Resource.newInstance((long)16384L, (int)4, Collections.singletonMap("test1", 1L)));
        FSSchedulerNode largeNode = new FSSchedulerNode(largeNodes.get(0), false);
        this.nodeTracker.addNode((SchedulerNode)mediumNode);
        result = this.nodeTracker.getMaxAllowedAllocation();
        Assert.assertEquals((String)"With a single node added, the ClusterNodeTracker did not return that node's resources as the maximum allocation", (Object)mediumNodes.get(0).getTotalCapability(), (Object)result);
        this.nodeTracker.addNode((SchedulerNode)smallNode);
        result = this.nodeTracker.getMaxAllowedAllocation();
        Assert.assertEquals((String)"With two nodes added, the ClusterNodeTracker did not return a the maximum allocation that was the max of their aggregate resources", (Object)Resource.newInstance((long)4096L, (int)2, Collections.singletonMap("test1", 4L)), (Object)result);
        this.nodeTracker.removeNode(smallNode.getNodeID());
        result = this.nodeTracker.getMaxAllowedAllocation();
        Assert.assertEquals((String)"After removing a node, the ClusterNodeTracker did not recalculate the adjusted maximum allocation correctly", (Object)mediumNodes.get(0).getTotalCapability(), (Object)result);
        this.nodeTracker.addNode((SchedulerNode)largeNode);
        result = this.nodeTracker.getMaxAllowedAllocation();
        Assert.assertEquals((String)"With two nodes added, the ClusterNodeTracker did not return a the maximum allocation that was the max of their aggregate resources", (Object)Resource.newInstance((long)10240L, (int)4, Collections.singletonMap("test1", 2L)), (Object)result);
        this.nodeTracker.removeNode(largeNode.getNodeID());
        result = this.nodeTracker.getMaxAllowedAllocation();
        Assert.assertEquals((String)"After removing a node, the ClusterNodeTracker did not recalculate the adjusted maximum allocation correctly", (Object)mediumNodes.get(0).getTotalCapability(), (Object)result);
        this.nodeTracker.removeNode(mediumNode.getNodeID());
        result = this.nodeTracker.getMaxAllowedAllocation();
        Assert.assertEquals((String)"After removing all nodes, the ClusterNodeTracker did not return the configured maximum allocation", (Object)maximum, (Object)result);
        this.nodeTracker.addNode((SchedulerNode)smallNode);
        this.nodeTracker.addNode((SchedulerNode)mediumNode);
        this.nodeTracker.addNode((SchedulerNode)largeNode);
        result = this.nodeTracker.getMaxAllowedAllocation();
        Assert.assertEquals((String)"With three nodes added, the ClusterNodeTracker did not return a the maximum allocation that was the max of their aggregate resources", (Object)Resource.newInstance((long)10240L, (int)4, Collections.singletonMap("test1", 4L)), (Object)result);
        this.nodeTracker.removeNode(smallNode.getNodeID());
        this.nodeTracker.removeNode(mediumNode.getNodeID());
        this.nodeTracker.removeNode(largeNode.getNodeID());
        result = this.nodeTracker.getMaxAllowedAllocation();
        Assert.assertEquals((String)"After removing all nodes, the ClusterNodeTracker did not return the configured maximum allocation", (Object)maximum, (Object)result);
    }
}

