/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.AllocationTagNamespaceType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.TargetApplicationsNamespace;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSchedulingRequestContainerAllocation {
    private static final int GB = 1024;
    private YarnConfiguration conf;
    RMNodeLabelsManager mgr;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
    }

    @Test
    public void testIntraAppAntiAffinity() throws Exception {
        int j;
        int i;
        Configuration csConf = TestUtils.getConfigurationWithMultipleQueues(new Configuration());
        csConf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        MockRM rm1 = new MockRM(csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestSchedulingRequestContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM[] nms = new MockNM[4];
        RMNode[] rmNodes = new RMNode[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            nms[i2] = rm1.registerNode("192.168.0." + i2 + ":1234", 10240);
            rmNodes[i2] = (RMNode)rm1.getRMContext().getRMNodes().get(nms[i2].getNodeId());
        }
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "c");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nms[0]);
        am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)10, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 1L, (Set<String>)ImmutableSet.of((Object)"mapper"), "mapper");
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        for (int i3 = 0; i3 < 3; ++i3) {
            for (int j2 = 0; j2 < 4; ++j2) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j2]));
            }
        }
        FiCaSchedulerApp schedulerApp = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        Assert.assertEquals((long)5L, (long)schedulerApp.getLiveContainers().size());
        am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)10, (Resource)Resource.newInstance((int)2048, (int)1)), Priority.newInstance((int)2), 1L, (Set<String>)ImmutableSet.of((Object)"reducer"), "reducer");
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j]));
            }
        }
        Assert.assertEquals((long)9L, (long)schedulerApp.getLiveContainers().size());
        am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)10, (Resource)Resource.newInstance((int)2048, (int)1)), Priority.newInstance((int)3), 1L, (Set<String>)ImmutableSet.of((Object)"reducer2"), "mapper");
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j]));
            }
        }
        Assert.assertEquals((long)9L, (long)schedulerApp.getLiveContainers().size());
        rm1.close();
    }

    @Test
    public void testIntraAppAntiAffinityWithMultipleTags() throws Exception {
        int j;
        int i;
        Configuration csConf = TestUtils.getConfigurationWithMultipleQueues(new Configuration());
        csConf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        MockRM rm1 = new MockRM(csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestSchedulingRequestContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM[] nms = new MockNM[4];
        RMNode[] rmNodes = new RMNode[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            nms[i2] = rm1.registerNode("192.168.0." + i2 + ":1234", 10240);
            rmNodes[i2] = (RMNode)rm1.getRMContext().getRMNodes().get(nms[i2].getNodeId());
        }
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "c");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nms[0]);
        am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)2, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 1L, (Set<String>)ImmutableSet.of((Object)"tag_1_1", (Object)"tag_1_2"), "tag_1_1", "tag_1_2");
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        for (int i3 = 0; i3 < 3; ++i3) {
            for (int j2 = 0; j2 < 4; ++j2) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j2]));
            }
        }
        FiCaSchedulerApp schedulerApp = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        Assert.assertEquals((long)3L, (long)schedulerApp.getLiveContainers().size());
        am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)2), 1L, (Set<String>)ImmutableSet.of((Object)"tag_2_1", (Object)"tag_2_2"), "tag_1_1", "tag_1_2");
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j]));
            }
        }
        Assert.assertEquals((long)4L, (long)schedulerApp.getLiveContainers().size());
        am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)3), 1L, (Set<String>)ImmutableSet.of((Object)"tag_3"), "tag_1_1", "tag_1_2", "tag_2_1", "tag_2_2");
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j]));
            }
        }
        Assert.assertEquals((long)5L, (long)schedulerApp.getLiveContainers().size());
        rm1.close();
    }

    @Test
    public void testInterAppAntiAffinity() throws Exception {
        Configuration csConf = TestUtils.getConfigurationWithMultipleQueues(new Configuration());
        csConf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        MockRM rm1 = new MockRM(csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestSchedulingRequestContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM[] nms = new MockNM[4];
        RMNode[] rmNodes = new RMNode[4];
        for (int i = 0; i < 4; ++i) {
            nms[i] = rm1.registerNode("192.168.0." + i + ":1234", 10240);
            rmNodes[i] = (RMNode)rm1.getRMContext().getRMNodes().get(nms[i].getNodeId());
        }
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "c");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nms[0]);
        am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)3, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 1L, (Set<String>)ImmutableSet.of((Object)"mapper"), "mapper");
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j]));
            }
        }
        System.out.println("Mappers on HOST0: " + rmNodes[0].getAllocationTagsWithCount().get("mapper"));
        System.out.println("Mappers on HOST1: " + rmNodes[1].getAllocationTagsWithCount().get("mapper"));
        System.out.println("Mappers on HOST2: " + rmNodes[2].getAllocationTagsWithCount().get("mapper"));
        FiCaSchedulerApp schedulerApp = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        Assert.assertEquals((long)4L, (long)schedulerApp.getLiveContainers().size());
        RMApp app2 = rm1.submitApp(1024, "app", "user", null, "c");
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nms[0]);
        TargetApplicationsNamespace.All allNs = new TargetApplicationsNamespace.All();
        am2.allocateAppAntiAffinity(ResourceSizing.newInstance((int)3, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 1L, allNs.toString(), (Set<String>)ImmutableSet.of((Object)"foo"), "mapper");
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j]));
            }
        }
        FiCaSchedulerApp schedulerApp2 = cs.getApplicationAttempt(am2.getApplicationAttemptId());
        Assert.assertEquals((long)4L, (long)schedulerApp2.getLiveContainers().size());
        Assert.assertTrue((boolean)schedulerApp2.getLiveContainers().stream().allMatch(rmContainer -> {
            if (!rmContainer.getContainer().getNodeId().equals((Object)rmNodes[0])) {
                return !rmContainer.getAllocationTags().contains("mapper");
            }
            return true;
        }));
        RMApp app3 = rm1.submitApp(1024, "app", "user", null, "c");
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nms[0]);
        am3.allocateAppAntiAffinity(ResourceSizing.newInstance((int)3, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 1L, allNs.toString(), (Set<String>)ImmutableSet.of((Object)"mapper"), "mapper");
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j]));
            }
        }
        FiCaSchedulerApp schedulerApp3 = cs.getApplicationAttempt(am3.getApplicationAttemptId());
        Assert.assertEquals((long)2L, (long)schedulerApp3.getLiveContainers().size());
        rm1.close();
    }

    @Test
    public void testSchedulingRequestDisabledByDefault() throws Exception {
        Configuration csConf = TestUtils.getConfigurationWithMultipleQueues(new Configuration());
        MockRM rm1 = new MockRM(csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestSchedulingRequestContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM[] nms = new MockNM[4];
        RMNode[] rmNodes = new RMNode[4];
        for (int i = 0; i < 4; ++i) {
            nms[i] = rm1.registerNode("192.168.0." + i + ":1234", 10240);
            rmNodes[i] = (RMNode)rm1.getRMContext().getRMNodes().get(nms[i].getNodeId());
        }
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "c");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nms[0]);
        boolean caughtException = false;
        try {
            am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)2, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 1L, (Set<String>)ImmutableSet.of((Object)"tag_1_1", (Object)"tag_1_2"), "tag_1_1", "tag_1_2");
        }
        catch (Exception e) {
            caughtException = true;
        }
        Assert.assertTrue((boolean)caughtException);
        rm1.close();
    }

    @Test
    public void testSchedulingRequestWithNullConstraint() throws Exception {
        Configuration csConf = TestUtils.getConfigurationWithMultipleQueues(new Configuration());
        csConf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        MockRM rm1 = new MockRM(csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestSchedulingRequestContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM[] nms = new MockNM[4];
        RMNode[] rmNodes = new RMNode[4];
        for (int i = 0; i < 4; ++i) {
            nms[i] = rm1.registerNode("192.168.0." + i + ":1234", 10240);
            rmNodes[i] = (RMNode)rm1.getRMContext().getRMNodes().get(nms[i].getNodeId());
        }
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "c");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nms[0]);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        PlacementConstraint constraint = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"t1"})}).build();
        SchedulingRequest sc = SchedulingRequest.newInstance((long)0L, (Priority)Priority.newInstance((int)1), (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED), (Set)ImmutableSet.of((Object)"t1"), (ResourceSizing)ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1)), (PlacementConstraint)constraint);
        AllocateRequest request = AllocateRequest.newBuilder().schedulingRequests((List)ImmutableList.of((Object)sc)).build();
        am1.allocate(request);
        for (int i = 0; i < 4; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[i]));
        }
        FiCaSchedulerApp schedApp = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        Assert.assertEquals((long)2L, (long)schedApp.getLiveContainers().size());
        sc = SchedulingRequest.newInstance((long)1L, (Priority)Priority.newInstance((int)1), (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED), (Set)ImmutableSet.of((Object)"t2"), (ResourceSizing)ResourceSizing.newInstance((int)2, (Resource)Resource.newInstance((int)1024, (int)1)), null);
        AllocateRequest request1 = AllocateRequest.newBuilder().schedulingRequests((List)ImmutableList.of((Object)sc)).build();
        am1.allocate(request1);
        for (int i = 0; i < 4; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[i]));
        }
        Assert.assertEquals((long)4L, (long)schedApp.getLiveContainers().size());
        rm1.close();
    }

    private void doNodeHeartbeat(MockNM ... nms) throws Exception {
        for (MockNM nm : nms) {
            nm.nodeHeartbeat(true);
        }
    }

    private List<Container> waitForAllocation(int allocNum, int timeout, MockAM am, MockNM ... nms) throws Exception {
        ArrayList<Container> result = new ArrayList<Container>();
        GenericTestUtils.waitFor(() -> {
            try {
                AllocateResponse response = am.schedule();
                List allocated = response.getAllocatedContainers();
                System.out.println("Expecting allocation: " + allocNum + ", actual allocation: " + allocated.size());
                for (Container c : allocated) {
                    System.out.println("Container " + c.getId().toString() + " is allocated on node: " + c.getNodeId().toString() + ", allocation tags: " + String.join((CharSequence)",", c.getAllocationTags()));
                }
                result.addAll(allocated);
                if (result.size() == allocNum) {
                    return true;
                }
                this.doNodeHeartbeat(nms);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }, (int)500, (int)timeout);
        return result;
    }

    private static SchedulingRequest schedulingRequest(int requestId, int containers, int cores, int mem, PlacementConstraint constraint, String ... tags) {
        return TestSchedulingRequestContainerAllocation.schedulingRequest(1, (long)requestId, containers, cores, mem, ExecutionType.GUARANTEED, constraint, tags);
    }

    private static SchedulingRequest schedulingRequest(int priority2, long allocReqId, int containers, int cores, int mem, ExecutionType execType, PlacementConstraint constraint, String ... tags) {
        return SchedulingRequest.newBuilder().priority(Priority.newInstance((int)priority2)).allocationRequestId(allocReqId).allocationTags(new HashSet<String>(Arrays.asList(tags))).executionType(ExecutionTypeRequest.newInstance((ExecutionType)execType, (boolean)true)).resourceSizing(ResourceSizing.newInstance((int)containers, (Resource)Resource.newInstance((int)mem, (int)cores))).placementConstraintExpression(constraint).build();
    }

    private int getContainerNodesNum(List<Container> containers) {
        HashSet nodes = new HashSet();
        if (containers != null) {
            containers.forEach(c -> nodes.add(c.getNodeId()));
        }
        return nodes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testInterAppCompositeConstraints() throws Exception {
        YarnConfiguration config = new YarnConfiguration();
        config.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        config.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)config);
        try {
            rm.start();
            MockNM nm1 = rm.registerNode("192.168.0.1:1234", 102400, 100);
            MockNM nm2 = rm.registerNode("192.168.0.2:1234", 102400, 100);
            MockNM nm3 = rm.registerNode("192.168.0.3:1234", 102400, 100);
            MockNM nm4 = rm.registerNode("192.168.0.4:1234", 102400, 100);
            MockNM nm5 = rm.registerNode("192.168.0.5:1234", 102400, 100);
            RMApp app1 = rm.submitApp(1024, (Set<String>)ImmutableSet.of((Object)"hbase"));
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            PlacementConstraint pc = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-master"})}).build();
            am1.addSchedulingRequest((List<SchedulingRequest>)ImmutableList.of((Object)TestSchedulingRequestContainerAllocation.schedulingRequest(1, 2, 1, 2048, pc, "hbase-master")));
            List<Container> allocated = this.waitForAllocation(2, 3000, am1, nm1, nm2);
            Assert.assertEquals((long)2L, (long)allocated.size());
            Assert.assertEquals((long)2L, (long)this.getContainerNodesNum(allocated));
            pc = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-rs"})}).build();
            am1.addSchedulingRequest((List<SchedulingRequest>)ImmutableList.of((Object)TestSchedulingRequestContainerAllocation.schedulingRequest(2, 4, 1, 1024, pc, "hbase-rs")));
            allocated = this.waitForAllocation(4, 3000, am1, nm1, nm2, nm3, nm4, nm5);
            Assert.assertEquals((long)4L, (long)allocated.size());
            Assert.assertEquals((long)4L, (long)this.getContainerNodesNum(allocated));
            RMApp app2 = rm.submitApp(1024, (Set<String>)ImmutableSet.of((Object)"web-server"));
            MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm2);
            pc = PlacementConstraints.and((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTagWithNamespace((String)new TargetApplicationsNamespace.All().toString(), (String[])new String[]{"hbase-master"})}), PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"ws-inst"})})}).build();
            am2.addSchedulingRequest((List<SchedulingRequest>)ImmutableList.of((Object)TestSchedulingRequestContainerAllocation.schedulingRequest(1, 2, 1, 2048, pc, "ws-inst")));
            allocated = this.waitForAllocation(2, 3000, am2, nm1, nm2, nm3, nm4, nm5);
            Assert.assertEquals((long)2L, (long)allocated.size());
            Assert.assertEquals((long)2L, (long)this.getContainerNodesNum(allocated));
            ConcurrentMap rmNodes = rm.getRMContext().getRMNodes();
            for (Container c : allocated) {
                RMNode rmNode = (RMNode)rmNodes.get(c.getNodeId());
                Assert.assertNotNull((Object)rmNode);
                Assert.assertTrue((String)"If ws-inst is allocated to a node, this node should have inherited the ws-inst tag ", ((Long)rmNode.getAllocationTagsWithCount().get("ws-inst") == 1L ? 1 : 0) != 0);
                Assert.assertTrue((String)"ws-inst should be co-allocated to hbase-master nodes", ((Long)rmNode.getAllocationTagsWithCount().get("hbase-master") == 1L ? 1 : 0) != 0);
            }
            RMApp app3 = rm.submitApp(1024, (Set<String>)ImmutableSet.of((Object)"ws-servants"));
            MockAM am3 = MockRM.launchAndRegisterAM(app3, rm, nm3);
            pc = PlacementConstraints.and((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTagWithNamespace((String)new TargetApplicationsNamespace.AppTag("web-server").toString(), (String[])new String[]{"ws-inst"})}), PlacementConstraints.cardinality((String)"node", (int)0, (int)2, (String[])new String[]{"ws-servant"})}).build();
            am3.addSchedulingRequest((List<SchedulingRequest>)ImmutableList.of((Object)TestSchedulingRequestContainerAllocation.schedulingRequest(1, 10, 1, 512, pc, "ws-servant")));
            allocated = this.waitForAllocation(6, 10000, am3, nm1, nm2, nm3, nm4, nm5);
            Assert.assertEquals((long)6L, (long)allocated.size());
            Assert.assertEquals((long)2L, (long)this.getContainerNodesNum(allocated));
            for (Container c : allocated) {
                RMNode rmNode = (RMNode)rmNodes.get(c.getNodeId());
                Assert.assertNotNull((Object)rmNode);
                Assert.assertTrue((String)"Node has ws-servant allocated must have 3 instances", ((Long)rmNode.getAllocationTagsWithCount().get("ws-servant") == 3L ? 1 : 0) != 0);
                Assert.assertTrue((String)"Every ws-servant container should be co-allocated with ws-inst", ((Long)rmNode.getAllocationTagsWithCount().get("ws-inst") == 1L ? 1 : 0) != 0);
            }
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testMultiAllocationTagsConstraints() throws Exception {
        YarnConfiguration config = new YarnConfiguration();
        config.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        config.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)config);
        try {
            rm.start();
            MockNM nm1 = rm.registerNode("192.168.0.1:1234", 10240, 10);
            MockNM nm2 = rm.registerNode("192.168.0.2:1234", 10240, 10);
            MockNM nm3 = rm.registerNode("192.168.0.3:1234", 10240, 10);
            MockNM nm4 = rm.registerNode("192.168.0.4:1234", 10240, 10);
            MockNM nm5 = rm.registerNode("192.168.0.5:1234", 10240, 10);
            RMApp app1 = rm.submitApp(1024, (Set<String>)ImmutableSet.of((Object)"server1"));
            this.doNodeHeartbeat(nm1);
            RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
            MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
            am1.registerAppAttempt();
            String[] server1Ports = new String[]{"port_6000", "port_7000", "port_8000"};
            PlacementConstraint pc = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTagWithNamespace((String)AllocationTagNamespaceType.ALL.toString(), (String[])server1Ports)}).build();
            am1.addSchedulingRequest((List<SchedulingRequest>)ImmutableList.of((Object)TestSchedulingRequestContainerAllocation.schedulingRequest(1, 2, 1, 1024, pc, server1Ports)));
            List<Container> allocated = this.waitForAllocation(2, 3000, am1, nm1, nm2, nm3, nm4, nm5);
            Assert.assertEquals((long)2L, (long)allocated.size());
            Assert.assertEquals((long)2L, (long)this.getContainerNodesNum(allocated));
            String[] server2Ports = new String[]{"port_6000"};
            RMApp app2 = rm.submitApp(1024, (Set<String>)ImmutableSet.of((Object)"server2"));
            this.doNodeHeartbeat(nm2);
            RMAppAttempt app2attempt1 = app2.getCurrentAppAttempt();
            MockAM am2 = rm.sendAMLaunched(app2attempt1.getAppAttemptId());
            am2.registerAppAttempt();
            pc = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTagWithNamespace((String)AllocationTagNamespaceType.ALL.toString(), (String[])server2Ports)}).build();
            am2.addSchedulingRequest((List<SchedulingRequest>)ImmutableList.of((Object)TestSchedulingRequestContainerAllocation.schedulingRequest(1, 3, 1, 1024, pc, server2Ports)));
            allocated = this.waitForAllocation(3, 3000, am2, nm1, nm2, nm3, nm4, nm5);
            Assert.assertEquals((long)3L, (long)allocated.size());
            Assert.assertEquals((long)3L, (long)this.getContainerNodesNum(allocated));
            ConcurrentMap rmNodes = rm.getRMContext().getRMNodes();
            for (Container c : allocated) {
                RMNode rmNode = (RMNode)rmNodes.get(c.getNodeId());
                Assert.assertNotNull((Object)rmNode);
                Assert.assertTrue((String)"server2 should not co-allocate to server1 as they both need to use port 6000", ((Long)rmNode.getAllocationTagsWithCount().get("port_6000") == 1L ? 1 : 0) != 0);
                Assert.assertFalse((boolean)rmNode.getAllocationTagsWithCount().containsKey("port_7000"));
                Assert.assertFalse((boolean)rmNode.getAllocationTagsWithCount().containsKey("port_8000"));
            }
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testInterAppConstraintsWithNamespaces() throws Exception {
        YarnConfiguration config = new YarnConfiguration();
        config.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        config.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)config);
        try {
            rm.start();
            MockNM nm1 = rm.registerNode("192.168.0.1:1234:", 102400, 100);
            MockNM nm2 = rm.registerNode("192.168.0.2:1234", 102400, 100);
            MockNM nm3 = rm.registerNode("192.168.0.3:1234", 102400, 100);
            MockNM nm4 = rm.registerNode("192.168.0.4:1234", 102400, 100);
            MockNM nm5 = rm.registerNode("192.168.0.5:1234", 102400, 100);
            ApplicationId app5Id = null;
            HashMap<ApplicationId, List<Container>> allocMap = new HashMap<ApplicationId, List<Container>>();
            for (int i = 0; i < 10; ++i) {
                String applicationTag = i < 5 ? "former5" : "latter5";
                RMApp app = rm.submitApp(1024, (Set<String>)ImmutableSet.of((Object)applicationTag));
                this.doNodeHeartbeat(nm1, nm2, nm3, nm4, nm5);
                RMAppAttempt attempt = app.getCurrentAppAttempt();
                MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
                am.registerAppAttempt();
                PlacementConstraint pc = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}).build();
                am.addSchedulingRequest((List<SchedulingRequest>)ImmutableList.of((Object)TestSchedulingRequestContainerAllocation.schedulingRequest(1, 3, 1, 1024, pc, "foo")));
                List<Container> allocated = this.waitForAllocation(3, 3000, am, nm1, nm2, nm3, nm4, nm5);
                if (i == 5) {
                    app5Id = am.getApplicationAttemptId().getApplicationId();
                }
                allocMap.put(am.getApplicationAttemptId().getApplicationId(), allocated);
            }
            Assert.assertNotNull(app5Id);
            Assert.assertEquals((long)3L, (long)this.getContainerNodesNum((List)allocMap.get(app5Id)));
            RMApp app1 = rm.submitApp(1024, (Set<String>)ImmutableSet.of((Object)"xyz"));
            this.doNodeHeartbeat(nm1);
            RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
            MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
            am1.registerAppAttempt();
            PlacementConstraint pc = PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTagWithNamespace((String)new TargetApplicationsNamespace.AppID(app5Id).toString(), (String[])new String[]{"foo"})}).build();
            am1.addSchedulingRequest((List<SchedulingRequest>)ImmutableList.of((Object)TestSchedulingRequestContainerAllocation.schedulingRequest(1, 3, 1, 1024, pc, "foo")));
            List<Container> allocated = this.waitForAllocation(3, 3000, am1, nm1, nm2, nm3, nm4, nm5);
            ConcurrentMap rmNodes = rm.getRMContext().getRMNodes();
            List app5Alloc = (List)allocMap.get(app5Id);
            for (Container c : allocated) {
                RMNode rmNode = (RMNode)rmNodes.get(c.getNodeId());
                Assert.assertNotNull((Object)rmNode);
                Assert.assertTrue((String)"This app is affinity with app-id/app5/foo containers", (boolean)app5Alloc.stream().anyMatch(c5 -> c5.getNodeId() == c.getNodeId()));
            }
            RMApp app2 = rm.submitApp(1024);
            this.doNodeHeartbeat(nm2);
            RMAppAttempt app2attempt1 = app2.getCurrentAppAttempt();
            MockAM am2 = rm.sendAMLaunched(app2attempt1.getAppAttemptId());
            am2.registerAppAttempt();
            pc = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTagWithNamespace((String)new TargetApplicationsNamespace.AppTag("xyz").toString(), (String[])new String[]{"foo"})}).build();
            am2.addSchedulingRequest((List<SchedulingRequest>)ImmutableList.of((Object)TestSchedulingRequestContainerAllocation.schedulingRequest(1, 2, 1, 1024, pc, "foo")));
            allocated = this.waitForAllocation(2, 3000, am2, nm1, nm2, nm3, nm4, nm5);
            Assert.assertEquals((long)2L, (long)allocated.size());
            for (Container c : app5Alloc) {
                Assert.assertNotEquals((Object)c.getNodeId(), (Object)allocated.iterator().next().getNodeId());
            }
            RMApp app3 = rm.submitApp(1024);
            this.doNodeHeartbeat(nm3);
            RMAppAttempt app3attempt1 = app3.getCurrentAppAttempt();
            MockAM am3 = rm.sendAMLaunched(app3attempt1.getAppAttemptId());
            am3.registerAppAttempt();
            pc = PlacementConstraints.cardinality((String)"node", (String)new TargetApplicationsNamespace.NotSelf().toString(), (int)1, (int)1, (String[])new String[]{"foo"}).build();
            am3.addSchedulingRequest((List<SchedulingRequest>)ImmutableList.of((Object)TestSchedulingRequestContainerAllocation.schedulingRequest(1, 1, 1, 1024, pc, "foo")));
            allocated = this.waitForAllocation(1, 3000, am3, nm1, nm2, nm3, nm4, nm5);
            Assert.assertEquals((long)1L, (long)allocated.size());
            Assert.assertTrue(((Long)((RMNode)rmNodes.get(allocated.iterator().next().getNodeId())).getAllocationTagsWithCount().get("foo") == 2L ? 1 : 0) != 0);
        }
        finally {
            rm.stop();
        }
    }
}

