/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.DecommissioningNodesWatcher;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestDecommissioningNodesWatcher {
    private MockRM rm;

    @Test
    public void testDecommissioningNodesWatcher() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodemanager-graceful-decommission-timeout-secs", "40");
        this.rm = new MockRM(conf);
        this.rm.start();
        DecommissioningNodesWatcher watcher = new DecommissioningNodesWatcher(this.rm.getRMContext());
        MockNM nm1 = this.rm.registerNode("host1:1234", 10240);
        RMNode node1 = (RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId());
        NodeId id1 = nm1.getNodeId();
        this.rm.waitForState(id1, NodeState.RUNNING);
        Assert.assertFalse((boolean)watcher.checkReadyToBeDecommissioned(id1));
        RMApp app = this.rm.submitApp(2000);
        MockAM am = MockRM.launchAndRegisterAM(app, this.rm, nm1);
        this.rm.sendNodeGracefulDecommission(nm1, 3600);
        this.rm.waitForState(id1, NodeState.DECOMMISSIONING);
        watcher.update(node1, this.createNodeStatus(id1, app, 12));
        watcher.update(node1, this.createNodeStatus(id1, app, 11));
        Assert.assertFalse((boolean)watcher.checkReadyToBeDecommissioned(id1));
        watcher.update(node1, this.createNodeStatus(id1, app, 1));
        Assert.assertEquals((Object)DecommissioningNodesWatcher.DecommissioningNodeStatus.WAIT_CONTAINER, (Object)watcher.checkDecommissioningStatus(id1));
        watcher.update(node1, this.createNodeStatus(id1, app, 0));
        Assert.assertEquals((Object)DecommissioningNodesWatcher.DecommissioningNodeStatus.WAIT_APP, (Object)watcher.checkDecommissioningStatus(id1));
        MockRM.finishAMAndVerifyAppState(app, this.rm, nm1, am);
        this.rm.waitForState(app.getApplicationId(), RMAppState.FINISHED);
        Assert.assertEquals((Object)DecommissioningNodesWatcher.DecommissioningNodeStatus.READY, (Object)watcher.checkDecommissioningStatus(id1));
    }

    @After
    public void tearDown() {
        if (this.rm != null) {
            this.rm.stop();
        }
    }

    private NodeStatus createNodeStatus(NodeId nodeId, RMApp app, int numRunningContainers) {
        return NodeStatus.newInstance((NodeId)nodeId, (int)0, this.getContainerStatuses(app, numRunningContainers), new ArrayList(), (NodeHealthStatus)NodeHealthStatus.newInstance((boolean)true, (String)"", (long)(System.currentTimeMillis() - 1000L)), null, null, null);
    }

    private List<ContainerStatus> getContainerStatuses(RMApp app, int numRunningContainers) {
        int total = 12;
        numRunningContainers = Math.min(12, numRunningContainers);
        ArrayList<ContainerStatus> output = new ArrayList<ContainerStatus>();
        for (int i = 0; i < 12; ++i) {
            ContainerState cstate = i >= numRunningContainers ? ContainerState.COMPLETE : ContainerState.RUNNING;
            output.add(ContainerStatus.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)app.getApplicationId(), (int)i), (long)1L), (ContainerState)cstate, (String)"Dummy", (int)0));
        }
        return output;
    }
}

