/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationDefinitionPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationRequestsPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.AbstractReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacityOverTimePolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryPlan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.AlignedPlannerWithGreedy;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.MultiNodeSortingManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.junit.Assert;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class ReservationSystemTestUtil {
    private static Random rand = new Random();
    public static final String reservationQ = "dedicated";

    public static ReservationId getNewReservationId() {
        return ReservationId.newInstance((long)rand.nextLong(), (long)rand.nextLong());
    }

    public static ReservationSchedulerConfiguration createConf(String reservationQ, long timeWindow, float instConstraint, float avgConstraint) {
        CapacitySchedulerConfiguration realConf = new CapacitySchedulerConfiguration();
        ReservationSchedulerConfiguration conf = (ReservationSchedulerConfiguration)Mockito.spy((Object)realConf);
        Mockito.when((Object)conf.getReservationWindow(reservationQ)).thenReturn((Object)timeWindow);
        Mockito.when((Object)Float.valueOf(conf.getInstantaneousMaxCapacity(reservationQ))).thenReturn((Object)Float.valueOf(instConstraint));
        Mockito.when((Object)Float.valueOf(conf.getAverageCapacity(reservationQ))).thenReturn((Object)Float.valueOf(avgConstraint));
        return conf;
    }

    public static void validateReservationQueue(AbstractReservationSystem reservationSystem, String planQName) {
        Plan plan = reservationSystem.getPlan(planQName);
        Assert.assertNotNull((Object)plan);
        Assert.assertTrue((boolean)(plan instanceof InMemoryPlan));
        Assert.assertEquals((Object)planQName, (Object)plan.getQueueName());
        Assert.assertEquals((long)8192L, (long)plan.getTotalCapacity().getMemorySize());
        Assert.assertTrue((boolean)(plan.getReservationAgent() instanceof AlignedPlannerWithGreedy));
        Assert.assertTrue((boolean)(plan.getSharingPolicy() instanceof CapacityOverTimePolicy));
    }

    public static void setupFSAllocationFile(String allocationFile) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(allocationFile));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"default\">");
        out.println("<weight>1</weight>");
        out.println("</queue>");
        out.println("<queue name=\"a\">");
        out.println("<weight>1</weight>");
        out.println("<queue name=\"a1\">");
        out.println("<weight>3</weight>");
        out.println("</queue>");
        out.println("<queue name=\"a2\">");
        out.println("<weight>7</weight>");
        out.println("</queue>");
        out.println("</queue>");
        out.println("<queue name=\"dedicated\">");
        out.println("<reservation></reservation>");
        out.println("<weight>8</weight>");
        out.println("</queue>");
        out.println("<defaultQueueSchedulingPolicy>drf</defaultQueueSchedulingPolicy>");
        out.println("</allocations>");
        out.close();
    }

    public static void updateFSAllocationFile(String allocationFile) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(allocationFile));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"default\">");
        out.println("<weight>5</weight>");
        out.println("</queue>");
        out.println("<queue name=\"a\">");
        out.println("<weight>5</weight>");
        out.println("<queue name=\"a1\">");
        out.println("<weight>3</weight>");
        out.println("</queue>");
        out.println("<queue name=\"a2\">");
        out.println("<weight>7</weight>");
        out.println("</queue>");
        out.println("</queue>");
        out.println("<queue name=\"dedicated\">");
        out.println("<reservation></reservation>");
        out.println("<weight>10</weight>");
        out.println("</queue>");
        out.println("<queue name=\"reservation\">");
        out.println("<reservation></reservation>");
        out.println("<weight>80</weight>");
        out.println("</queue>");
        out.println("<defaultQueueSchedulingPolicy>drf</defaultQueueSchedulingPolicy>");
        out.println("</allocations>");
        out.close();
    }

    public static FairScheduler setupFairScheduler(RMContext rmContext, Configuration conf, int numContainers) throws IOException {
        FairScheduler scheduler = new FairScheduler();
        scheduler.setRMContext(rmContext);
        Mockito.when((Object)rmContext.getScheduler()).thenReturn((Object)scheduler);
        scheduler.init(conf);
        scheduler.start();
        scheduler.reinitialize(conf, rmContext);
        Resource resource = ReservationSystemTestUtil.calculateClusterResource(numContainers);
        RMNode node1 = MockNodes.newNodeInfo(1, resource, 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        scheduler.handle((SchedulerEvent)nodeEvent1);
        return scheduler;
    }

    public static ReservationDefinition createSimpleReservationDefinition(long arrival, long deadline, long duration) {
        return ReservationSystemTestUtil.createSimpleReservationDefinition(arrival, deadline, duration, 1);
    }

    public static ReservationDefinition createSimpleReservationDefinition(long arrival, long deadline, long duration, int parallelism) {
        return ReservationSystemTestUtil.createSimpleReservationDefinition(arrival, deadline, duration, parallelism, null);
    }

    public static ReservationDefinition createSimpleReservationDefinition(long arrival, long deadline, long duration, int parallelism, String recurrenceExpression) {
        ReservationRequest r = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)parallelism, (int)parallelism, (long)duration);
        ReservationDefinitionPBImpl rDef = new ReservationDefinitionPBImpl();
        ReservationRequestsPBImpl reqs = new ReservationRequestsPBImpl();
        reqs.setReservationResources(Collections.singletonList(r));
        reqs.setInterpreter(ReservationRequestInterpreter.R_ALL);
        rDef.setReservationRequests((ReservationRequests)reqs);
        rDef.setArrival(arrival);
        rDef.setDeadline(deadline);
        if (recurrenceExpression != null) {
            rDef.setRecurrenceExpression(recurrenceExpression);
        }
        return rDef;
    }

    public static ReservationSubmissionRequest createSimpleReservationRequest(ReservationId reservationId, int numContainers, long arrival, long deadline, long duration) {
        return ReservationSystemTestUtil.createSimpleReservationRequest(reservationId, numContainers, arrival, deadline, duration, Priority.UNDEFINED);
    }

    public static ReservationSubmissionRequest createSimpleReservationRequest(ReservationId reservationId, int numContainers, long arrival, long deadline, long duration, Priority priority2) {
        ReservationRequest r = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)numContainers, (int)1, (long)duration);
        ReservationRequests reqs = ReservationRequests.newInstance(Collections.singletonList(r), (ReservationRequestInterpreter)ReservationRequestInterpreter.R_ALL);
        ReservationDefinition rDef = ReservationDefinition.newInstance((long)arrival, (long)deadline, (ReservationRequests)reqs, (String)"testClientRMService#reservation", (String)"0", (Priority)priority2);
        ReservationSubmissionRequest request = ReservationSubmissionRequest.newInstance((ReservationDefinition)rDef, (String)reservationQ, (ReservationId)reservationId);
        return request;
    }

    public static RMContext createMockRMContext() {
        RMContext context = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)context.getStateStore()).thenReturn((Object)new MemoryRMStateStore());
        return context;
    }

    public CapacityScheduler mockCapacityScheduler(int numContainers) throws IOException {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        ReservationSystemTestUtil.setupQueueConfiguration(conf);
        CapacityScheduler cs = (CapacityScheduler)Mockito.spy((Object)new CapacityScheduler());
        cs.setConf((Configuration)new YarnConfiguration());
        RMContext mockRmContext = ReservationSystemTestUtil.createRMContext((Configuration)conf);
        cs.setRMContext(mockRmContext);
        try {
            cs.serviceInit((Configuration)conf);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        ReservationSystemTestUtil.initializeRMContext(numContainers, (AbstractYarnScheduler)cs, mockRmContext);
        return cs;
    }

    public static void initializeRMContext(int numContainers, AbstractYarnScheduler scheduler, RMContext mockRMContext) {
        Mockito.when((Object)mockRMContext.getScheduler()).thenReturn((Object)scheduler);
        Resource r = ReservationSystemTestUtil.calculateClusterResource(numContainers);
        ((AbstractYarnScheduler)Mockito.doReturn((Object)r).when((Object)scheduler)).getClusterResource();
    }

    public static RMContext createRMContext(Configuration conf) {
        RMContext mockRmContext = (RMContext)Mockito.spy((Object)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager(conf), new NMTokenSecretManagerInRM(conf), new ClientToAMTokenSecretManagerInRM(), null));
        RMNodeLabelsManager nlm = (RMNodeLabelsManager)Mockito.mock(RMNodeLabelsManager.class);
        Mockito.when((Object)nlm.getQueueResource((String)Matchers.any(String.class), Matchers.anySetOf(String.class), (Resource)Matchers.any(Resource.class))).thenAnswer((Answer)new Answer<Resource>(){

            public Resource answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return (Resource)args[2];
            }
        });
        Mockito.when((Object)nlm.getResourceByLabel((String)Matchers.any(String.class), (Resource)Matchers.any(Resource.class))).thenAnswer((Answer)new Answer<Resource>(){

            public Resource answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return (Resource)args[1];
            }
        });
        mockRmContext.setNodeLabelManager(nlm);
        mockRmContext.setMultiNodeSortingManager((MultiNodeSortingManager)Mockito.mock(MultiNodeSortingManager.class));
        return mockRmContext;
    }

    public static void setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        String defQ = "root.default";
        conf.setCapacity("root.default", 10.0f);
        conf.setQueues("root", new String[]{"default", "a", reservationQ});
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        String dedicated = "root.dedicated";
        conf.setCapacity("root.dedicated", 80.0f);
        conf.setReservable("root.dedicated", true);
        String A1 = "root.a.a1";
        String A2 = "root.a.a2";
        conf.setQueues("root.a", new String[]{"a1", "a2"});
        conf.setCapacity("root.a.a1", 30.0f);
        conf.setCapacity("root.a.a2", 70.0f);
    }

    public static void setupDynamicQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{reservationQ});
        String dedicated = "root.dedicated";
        conf.setCapacity("root.dedicated", 100.0f);
        conf.setReservable("root.dedicated", true);
    }

    public static String getFullReservationQueueName() {
        return "root.dedicated";
    }

    public static String getReservationQueueName() {
        return reservationQ;
    }

    public static void updateQueueConfiguration(CapacitySchedulerConfiguration conf, String newQ) {
        String prefix = "root.";
        String defQ = "root.default";
        conf.setCapacity("root.default", 5.0f);
        conf.setQueues("root", new String[]{"default", "a", reservationQ, newQ});
        String A = "root.a";
        conf.setCapacity("root.a", 5.0f);
        String dedicated = "root.dedicated";
        conf.setCapacity("root.dedicated", 10.0f);
        conf.setReservable("root.dedicated", true);
        conf.setCapacity("root." + newQ, 80.0f);
        conf.setReservable("root." + newQ, true);
        String A1 = "root.a.a1";
        String A2 = "root.a.a2";
        conf.setQueues("root.a", new String[]{"a1", "a2"});
        conf.setCapacity("root.a.a1", 30.0f);
        conf.setCapacity("root.a.a2", 70.0f);
    }

    public static ReservationDefinition generateRandomRR(Random rand, long i) {
        rand.setSeed(i);
        long now = System.currentTimeMillis();
        long arrival = rand.nextInt(43200000);
        long deadline = arrival + (long)rand.nextInt(86400000);
        ReservationDefinitionPBImpl rr = new ReservationDefinitionPBImpl();
        rr.setArrival(now + arrival);
        rr.setDeadline(now + deadline);
        int gang = 1 + rand.nextInt(9);
        int par = (rand.nextInt(1000) + 1) * gang;
        long dur = rand.nextInt(0x6DDD00);
        ReservationRequest r = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)par, (int)gang, (long)dur);
        ReservationRequestsPBImpl reqs = new ReservationRequestsPBImpl();
        reqs.setReservationResources(Collections.singletonList(r));
        rand.nextInt(3);
        ReservationRequestInterpreter[] type = ReservationRequestInterpreter.values();
        reqs.setInterpreter(type[rand.nextInt(type.length)]);
        rr.setReservationRequests((ReservationRequests)reqs);
        return rr;
    }

    public static Map<ReservationInterval, Resource> generateAllocation(long startTime, long step, int[] alloc) {
        return ReservationSystemTestUtil.generateAllocation(startTime, step, alloc, null);
    }

    public static Map<ReservationInterval, Resource> generateAllocation(long startTime, long step, int[] alloc, String recurrenceExpression) {
        TreeMap<ReservationInterval, Resource> req = new TreeMap<ReservationInterval, Resource>();
        long period = 0L;
        if (recurrenceExpression != null) {
            period = Long.parseLong(recurrenceExpression);
        }
        int j = 0;
        while (j < 86400000) {
            for (int i = 0; i < alloc.length; ++i) {
                long rStart = startTime + (long)i * step + (long)j * period;
                long rEnd = startTime + (long)(i + 1) * step + (long)j * period;
                if (period > 0L && (rStart = rStart % period + (long)j * period) > (rEnd = rEnd % period + (long)j * period)) continue;
                req.put(new ReservationInterval(rStart, rEnd), ReservationSystemUtil.toResource((ReservationRequest)ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)alloc[i])));
            }
            if (period == 0L) break;
            j = (int)((long)j + period);
        }
        return req;
    }

    public static RLESparseResourceAllocation generateRLESparseResourceAllocation(int[] alloc, long[] timeSteps) {
        TreeMap<Long, Resource> allocationsMap = new TreeMap<Long, Resource>();
        for (int i = 0; i < alloc.length; ++i) {
            allocationsMap.put(timeSteps[i], Resource.newInstance((int)alloc[i], (int)alloc[i]));
        }
        RLESparseResourceAllocation rleVector = new RLESparseResourceAllocation(allocationsMap, (ResourceCalculator)new DefaultResourceCalculator());
        return rleVector;
    }

    public static Resource calculateClusterResource(int numContainers) {
        return Resource.newInstance((int)(numContainers * 1024), (int)numContainers);
    }

    public static Map<ReservationInterval, Resource> toAllocation(RLESparseResourceAllocation rle, long start, long end) {
        TreeMap<ReservationInterval, Resource> resAlloc = new TreeMap<ReservationInterval, Resource>();
        for (Map.Entry e : rle.getCumulative().entrySet()) {
            Long nextKey = (Long)rle.getCumulative().higherKey(e.getKey());
            if (nextKey == null) break;
            if ((Long)e.getKey() < start || (Long)e.getKey() > end || nextKey < start || nextKey > end) continue;
            resAlloc.put(new ReservationInterval(((Long)e.getKey()).longValue(), nextKey.longValue()), (Resource)e.getValue());
        }
        return resAlloc;
    }
}

