/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import io.hops.security.CertificateLocalizationService;
import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventDispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.nodelabels.NodeAttributeStore;
import org.apache.hadoop.yarn.nodelabels.NodeAttributesManager;
import org.apache.hadoop.yarn.nodelabels.NodeLabelTestBase;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UnRegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdatedCryptoForApp;
import org.apache.hadoop.yarn.server.api.records.AppCollectorData;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.FileSystemNodeAttributeStore;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NodeLabelsUtils;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStatusEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.timelineservice.collector.PerNodeTimelineCollectorsAuxService;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestResourceTrackerService
extends NodeLabelTestBase {
    private static final File TEMP_DIR = new File(System.getProperty("test.build.data", "/tmp"), "decommision");
    private final File hostFile = new File(TEMP_DIR + File.separator + "hostFile.txt");
    private final File excludeHostFile = new File(TEMP_DIR + File.separator + "excludeHostFile.txt");
    private final File excludeHostXmlFile = new File(TEMP_DIR + File.separator + "excludeHostFile.xml");
    private MockRM rm;

    @Before
    public void setup() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        RMStorageFactory.setConfiguration((Configuration)conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)conf);
        DBUtility.InitializeDB();
    }

    @Test(timeout=50000L)
    public void testGetNextHeartBeatInterval() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodemanagers.heartbeat-interval-ms", "4000");
        DBUtility.InitializeDB();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((long)4000L, (long)nodeHeartbeat.getNextHeartBeatInterval());
        NodeHeartbeatResponse nodeHeartbeat2 = nm2.nodeHeartbeat(true);
        Assert.assertEquals((long)4000L, (long)nodeHeartbeat2.getNextHeartBeatInterval());
    }

    @Test
    public void testDecommissionWithIncludeHosts() throws Exception {
        this.writeToHostsFile("localhost", "host1", "host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        MockNM nm3 = this.rm.registerNode("localhost:4433", 1024);
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        int metricCount = metrics.getNumDecommisionedNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        String ip = NetUtils.normalizeHostName((String)"localhost");
        this.writeToHostsFile("host1", ip);
        this.rm.getNodesListManager().refreshNodes(conf);
        this.checkShutdownNMCount(this.rm, ++metricCount);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        Assert.assertEquals((long)1L, (long)ClusterMetrics.getMetrics().getNumShutdownNMs());
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((String)"Node is not decommisioned.", (boolean)NodeAction.SHUTDOWN.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        Assert.assertEquals((long)metricCount, (long)ClusterMetrics.getMetrics().getNumShutdownNMs());
        this.rm.stop();
    }

    @Test
    public void testDecommissionWithExcludeHosts() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.hostFile.getAbsolutePath());
        this.writeToHostsFile("");
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        MockNM nm3 = this.rm.registerNode("localhost:4433", 1024);
        int metricCount = ClusterMetrics.getMetrics().getNumDecommisionedNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        this.rm.drainEvents();
        String ip = NetUtils.normalizeHostName((String)"localhost");
        this.writeToHostsFile("host2", ip);
        this.rm.getNodesListManager().refreshNodes(conf);
        this.checkDecommissionedNMCount(this.rm, metricCount + 2);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((String)"The decommisioned metrics are not updated", (boolean)NodeAction.SHUTDOWN.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        Assert.assertTrue((String)"The decommisioned metrics are not updated", (boolean)NodeAction.SHUTDOWN.equals((Object)nodeHeartbeat.getNodeAction()));
        this.rm.drainEvents();
        this.writeToHostsFile("");
        this.rm.getNodesListManager().refreshNodes(conf);
        nm3 = this.rm.registerNode("localhost:4433", 1024);
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        this.checkDecommissionedNMCount(this.rm, metricCount + 1);
    }

    @Test
    public void testGracefulDecommissionNoApp() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.hostFile.getAbsolutePath());
        this.writeToHostsFile("");
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        MockNM nm3 = this.rm.registerNode("host3:4433", 5120);
        int metricCount = ClusterMetrics.getMetrics().getNumDecommisionedNMs();
        NodeHeartbeatResponse nodeHeartbeat1 = nm1.nodeHeartbeat(true);
        NodeHeartbeatResponse nodeHeartbeat2 = nm2.nodeHeartbeat(true);
        NodeHeartbeatResponse nodeHeartbeat3 = nm3.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat1.getNodeAction()));
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat2.getNodeAction()));
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat3.getNodeAction()));
        this.rm.waitForState(nm2.getNodeId(), NodeState.RUNNING);
        this.rm.waitForState(nm3.getNodeId(), NodeState.RUNNING);
        this.writeToHostsFile("host2", "host3");
        this.rm.getNodesListManager().refreshNodes(conf, true);
        this.rm.waitForState(nm2.getNodeId(), NodeState.DECOMMISSIONING);
        this.rm.waitForState(nm3.getNodeId(), NodeState.DECOMMISSIONING);
        nodeHeartbeat1 = nm1.nodeHeartbeat(true);
        nodeHeartbeat2 = nm2.nodeHeartbeat(true);
        nodeHeartbeat3 = nm3.nodeHeartbeat(true);
        this.checkDecommissionedNMCount(this.rm, metricCount + 2);
        this.rm.waitForState(nm2.getNodeId(), NodeState.DECOMMISSIONED);
        this.rm.waitForState(nm3.getNodeId(), NodeState.DECOMMISSIONED);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat1.getNodeAction()));
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)nodeHeartbeat2.getNodeAction());
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)nodeHeartbeat3.getNodeAction());
    }

    @Test(timeout=75000L)
    public void testNodeHeartbeatWithUpdatedCryptoMaterialForApp() throws Exception {
        Configuration conf = new Configuration();
        conf.set(YarnConfiguration.RM_APP_CERTIFICATE_EXPIRATION_SAFETY_PERIOD, "30s");
        conf.setBoolean("ipc.server.ssl.enabled", true);
        conf.setBoolean(YarnConfiguration.RM_JWT_ENABLED, true);
        conf.set(YarnConfiguration.RM_JWT_VALIDITY_PERIOD, "20s");
        conf.set(YarnConfiguration.RM_JWT_EXPIRATION_LEEWAY, "4s");
        this.rm = new MockRM(conf){

            protected CertificateLocalizationService createCertificateLocalizationService() {
                return new CertificateLocalizationService(CertificateLocalizationService.ServiceType.RM){

                    public char[] readSupersuperPassword() throws IOException {
                        return "password".toCharArray();
                    }
                };
            }
        };
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("localhost:1234", 5120);
        NodeHeartbeatResponse response = nm1.nodeHeartbeat(true);
        this.rm.waitForState(nm1.getNodeId(), NodeState.RUNNING);
        Assert.assertNotNull((Object)response.getUpdatedCryptoForApps());
        Assert.assertTrue((boolean)response.getUpdatedCryptoForApps().isEmpty());
        RMApp app = this.rm.submitApp(2048);
        MockAM am = MockRM.launchAndRegisterAM(app, this.rm, nm1);
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        nm1.nodeHeartbeat(appAttemptId, 2L, ContainerState.RUNNING);
        this.rm.waitForState(appAttemptId, RMAppAttemptState.RUNNING);
        response = nm1.nodeHeartbeat(true);
        Assert.assertNotNull((Object)response.getUpdatedCryptoForApps());
        Assert.assertTrue((boolean)response.getUpdatedCryptoForApps().isEmpty());
        TimeUnit.SECONDS.sleep(25L);
        response = nm1.nodeHeartbeat(true);
        Assert.assertNotNull((Object)response.getUpdatedCryptoForApps());
        Assert.assertEquals((long)1L, (long)response.getUpdatedCryptoForApps().size());
        Assert.assertTrue((boolean)response.getUpdatedCryptoForApps().containsKey(app.getApplicationId()));
        UpdatedCryptoForApp updatedCryptoForApp = (UpdatedCryptoForApp)response.getUpdatedCryptoForApps().get(app.getApplicationId());
        Assert.assertTrue((boolean)updatedCryptoForApp.getKeyStore().equals(ByteBuffer.wrap(app.getKeyStore())));
        Assert.assertTrue((boolean)updatedCryptoForApp.getTrustStore().equals(ByteBuffer.wrap(app.getTrustStore())));
        Assert.assertArrayEquals((char[])app.getKeyStorePassword(), (char[])updatedCryptoForApp.getKeyStorePassword());
        Assert.assertArrayEquals((char[])app.getTrustStorePassword(), (char[])updatedCryptoForApp.getTrustStorePassword());
        Assert.assertNotNull((Object)updatedCryptoForApp.getJWT());
        Assert.assertEquals((Object)app.getJWT(), (Object)updatedCryptoForApp.getJWT());
        TimeUnit.SECONDS.sleep(25L);
        response = nm1.nodeHeartbeat(true);
        Assert.assertNotNull((Object)response.getUpdatedCryptoForApps());
        Assert.assertEquals((long)1L, (long)response.getUpdatedCryptoForApps().size());
        Assert.assertTrue((boolean)response.getUpdatedCryptoForApps().containsKey(app.getApplicationId()));
        UpdatedCryptoForApp newUpdatedCryptoForApp = (UpdatedCryptoForApp)response.getUpdatedCryptoForApps().get(app.getApplicationId());
        Assert.assertTrue((boolean)newUpdatedCryptoForApp.getKeyStore().equals(ByteBuffer.wrap(app.getKeyStore())));
        Assert.assertTrue((boolean)newUpdatedCryptoForApp.getTrustStore().equals(ByteBuffer.wrap(app.getTrustStore())));
        Assert.assertArrayEquals((char[])app.getKeyStorePassword(), (char[])newUpdatedCryptoForApp.getKeyStorePassword());
        Assert.assertArrayEquals((char[])app.getTrustStorePassword(), (char[])newUpdatedCryptoForApp.getTrustStorePassword());
        Assert.assertNotNull((Object)newUpdatedCryptoForApp.getJWT());
        Assert.assertEquals((Object)app.getJWT(), (Object)newUpdatedCryptoForApp.getJWT());
        Assert.assertFalse((boolean)newUpdatedCryptoForApp.getKeyStore().equals(updatedCryptoForApp.getKeyStore()));
        Assert.assertNotEquals((Object)newUpdatedCryptoForApp.getJWT(), (Object)updatedCryptoForApp.getJWT());
        this.rm.killApp(app.getApplicationId());
        this.rm.waitForState(app.getApplicationId(), RMAppState.KILLED);
        response = nm1.nodeHeartbeat(true);
        Assert.assertNotNull((Object)response.getUpdatedCryptoForApps());
        Assert.assertTrue((boolean)response.getUpdatedCryptoForApps().isEmpty());
        RMNode rmNode = (RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId());
        Assert.assertTrue((boolean)rmNode.getAppX509ToUpdate().isEmpty());
        this.rm.stop();
    }

    @Test
    public void testGracefulDecommissionDefaultTimeoutResolution() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.excludeHostXmlFile.getAbsolutePath());
        this.writeToHostsXmlFile(this.excludeHostXmlFile, Pair.of((Object)"", null));
        this.rm = new MockRM(conf);
        this.rm.start();
        int nodeMemory = 1024;
        MockNM nm1 = this.rm.registerNode("host1:1234", nodeMemory);
        MockNM nm2 = this.rm.registerNode("host2:5678", nodeMemory);
        MockNM nm3 = this.rm.registerNode("host3:9101", nodeMemory);
        NodeHeartbeatResponse nodeHeartbeat1 = nm1.nodeHeartbeat(true);
        NodeHeartbeatResponse nodeHeartbeat2 = nm2.nodeHeartbeat(true);
        NodeHeartbeatResponse nodeHeartbeat3 = nm3.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat1.getNodeAction()));
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat2.getNodeAction()));
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat3.getNodeAction()));
        this.rm.waitForState(nm1.getNodeId(), NodeState.RUNNING);
        this.rm.waitForState(nm2.getNodeId(), NodeState.RUNNING);
        this.rm.waitForState(nm3.getNodeId(), NodeState.RUNNING);
        Integer nm1DecommissionTimeout = 20;
        this.writeToHostsXmlFile(this.excludeHostXmlFile, Pair.of((Object)nm1.getNodeId().getHost(), (Object)nm1DecommissionTimeout), Pair.of((Object)nm2.getNodeId().getHost(), null));
        this.rm.getNodesListManager().refreshNodes(conf, true);
        this.rm.waitForState(nm1.getNodeId(), NodeState.DECOMMISSIONING);
        this.rm.waitForState(nm2.getNodeId(), NodeState.DECOMMISSIONING);
        Assert.assertEquals((Object)nm1DecommissionTimeout, (Object)this.rm.getDecommissioningTimeout(nm1.getNodeId()));
        Integer defaultDecTimeout = conf.getInt("yarn.resourcemanager.nodemanager-graceful-decommission-timeout-secs", 3600);
        Assert.assertEquals((Object)defaultDecTimeout, (Object)this.rm.getDecommissioningTimeout(nm2.getNodeId()));
        Integer newDefaultDecTimeout = defaultDecTimeout + 10;
        this.writeToHostsXmlFile(this.excludeHostXmlFile, Pair.of((Object)nm3.getNodeId().getHost(), null));
        conf.setInt("yarn.resourcemanager.nodemanager-graceful-decommission-timeout-secs", newDefaultDecTimeout.intValue());
        this.rm.getNodesListManager().refreshNodes(conf, true);
        this.rm.waitForState(nm3.getNodeId(), NodeState.DECOMMISSIONING);
        Assert.assertEquals((Object)newDefaultDecTimeout, (Object)this.rm.getDecommissioningTimeout(nm3.getNodeId()));
    }

    @Test
    public void testGracefulDecommissionWithApp() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.hostFile.getAbsolutePath());
        this.writeToHostsFile("");
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 10240);
        MockNM nm2 = this.rm.registerNode("host2:5678", 20480);
        MockNM nm3 = this.rm.registerNode("host3:4433", 10240);
        NodeId id1 = nm1.getNodeId();
        NodeId id3 = nm3.getNodeId();
        this.rm.waitForState(id1, NodeState.RUNNING);
        this.rm.waitForState(id3, NodeState.RUNNING);
        RMApp app = this.rm.submitApp(2000);
        MockAM am = MockRM.launchAndRegisterAM(app, this.rm, nm1);
        ApplicationAttemptId aaid = app.getCurrentAppAttempt().getAppAttemptId();
        nm1.nodeHeartbeat(aaid, 2L, ContainerState.RUNNING);
        nm3.nodeHeartbeat(true);
        this.writeToHostsFile("host1", "host3");
        this.rm.getNodesListManager().refreshNodes(conf, true);
        this.rm.waitForState(id1, NodeState.DECOMMISSIONING);
        this.rm.waitForState(id3, NodeState.DECOMMISSIONING);
        nm1.nodeHeartbeat(true);
        nm3.nodeHeartbeat(true);
        this.rm.waitForState(id1, NodeState.DECOMMISSIONING);
        this.rm.waitForState(id3, NodeState.DECOMMISSIONED);
        nm1.nodeHeartbeat(aaid, 2L, ContainerState.RUNNING);
        NodeHeartbeatResponse nodeHeartbeat1 = nm1.nodeHeartbeat(aaid, 2L, ContainerState.COMPLETE);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat1.getNodeAction());
        MockRM.finishAMAndVerifyAppState(app, this.rm, nm1, am);
        this.rm.waitForState(app.getApplicationId(), RMAppState.FINISHED);
        nodeHeartbeat1 = nm1.nodeHeartbeat(aaid, 2L, ContainerState.COMPLETE);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)nodeHeartbeat1.getNodeAction());
        this.rm.waitForState(id1, NodeState.DECOMMISSIONED);
    }

    @Test
    public void testAddNewIncludePathToConfiguration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        int initialMetricCount = metrics.getNumShutdownNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        this.writeToHostsFile("host1");
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm.getNodesListManager().refreshNodes(conf);
        this.checkShutdownNMCount(this.rm, ++initialMetricCount);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((String)"Node should not have been shutdown.", (Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        NodeState nodeState = ((RMNode)this.rm.getRMContext().getInactiveRMNodes().get(nm2.getNodeId())).getState();
        Assert.assertEquals((String)("Node should have been shutdown but is in state" + nodeState), (Object)NodeState.SHUTDOWN, (Object)nodeState);
    }

    @Test
    public void testAddNewExcludePathToConfiguration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        int initialMetricCount = metrics.getNumDecommisionedNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        this.writeToHostsFile("host2");
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.hostFile.getAbsolutePath());
        this.rm.getNodesListManager().refreshNodes(conf);
        this.checkDecommissionedNMCount(this.rm, ++initialMetricCount);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((String)"Node should not have been decomissioned.", (Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertEquals((String)("Node should have been decomissioned but is in state" + nodeHeartbeat.getNodeAction()), (Object)NodeAction.SHUTDOWN, (Object)nodeHeartbeat.getNodeAction());
    }

    @Test
    public void testNodeRegistrationSuccess() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        req.setResource(capability);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        req.setNMVersion(YarnVersionInfo.getVersion());
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)response.getNodeAction());
    }

    @Test
    public void testNodeRegistrationWithLabels() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.node-labels.configuration-type", "distributed");
        final NullRMNodeLabelsManager nodeLabelsMgr = new NullRMNodeLabelsManager();
        this.rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return nodeLabelsMgr;
            }
        };
        this.rm.start();
        try {
            nodeLabelsMgr.addToCluserNodeLabelsWithDefaultExclusivity(TestResourceTrackerService.toSet((Object[])new String[]{"A", "B", "C"}));
        }
        catch (IOException e) {
            Assert.fail((String)"Caught Exception while initializing");
            e.printStackTrace();
        }
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest registerReq = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        registerReq.setResource(capability);
        registerReq.setNodeId(nodeId);
        registerReq.setHttpPort(1234);
        registerReq.setNMVersion(YarnVersionInfo.getVersion());
        registerReq.setNodeLabels(TestResourceTrackerService.toSet((Object[])new NodeLabel[]{NodeLabel.newInstance((String)"A")}));
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(registerReq);
        Assert.assertEquals((String)"Action should be normal on valid Node Labels", (Object)NodeAction.NORMAL, (Object)response.getNodeAction());
        TestResourceTrackerService.assertCollectionEquals((Collection)((Collection)nodeLabelsMgr.getNodeLabels().get(nodeId)), (Collection)NodeLabelsUtils.convertToStringSet((Set)registerReq.getNodeLabels()));
        Assert.assertTrue((String)"Valid Node Labels were not accepted by RM", (boolean)response.getAreNodeLabelsAcceptedByRM());
        this.rm.stop();
    }

    @Test
    public void testNodeRegistrationWithInvalidLabels() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.node-labels.configuration-type", "distributed");
        final NullRMNodeLabelsManager nodeLabelsMgr = new NullRMNodeLabelsManager();
        this.rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return nodeLabelsMgr;
            }
        };
        this.rm.start();
        try {
            nodeLabelsMgr.addToCluserNodeLabelsWithDefaultExclusivity(TestResourceTrackerService.toSet((Object[])new String[]{"X", "Y", "Z"}));
        }
        catch (IOException e) {
            Assert.fail((String)"Caught Exception while initializing");
            e.printStackTrace();
        }
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest registerReq = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        registerReq.setResource(capability);
        registerReq.setNodeId(nodeId);
        registerReq.setHttpPort(1234);
        registerReq.setNMVersion(YarnVersionInfo.getVersion());
        registerReq.setNodeLabels(TestResourceTrackerService.toNodeLabelSet((String[])new String[]{"A", "B", "C"}));
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(registerReq);
        Assert.assertEquals((String)"On Invalid Node Labels action is expected to be normal", (Object)NodeAction.NORMAL, (Object)response.getNodeAction());
        Assert.assertNull(nodeLabelsMgr.getNodeLabels().get(nodeId));
        Assert.assertNotNull((Object)response.getDiagnosticsMessage());
        Assert.assertFalse((String)"Node Labels should not accepted by RM If Invalid", (boolean)response.getAreNodeLabelsAcceptedByRM());
        if (this.rm != null) {
            this.rm.stop();
        }
    }

    @Test
    public void testNodeRegistrationWithInvalidLabelsSyntax() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.node-labels.configuration-type", "distributed");
        final NullRMNodeLabelsManager nodeLabelsMgr = new NullRMNodeLabelsManager();
        this.rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return nodeLabelsMgr;
            }
        };
        this.rm.start();
        try {
            nodeLabelsMgr.addToCluserNodeLabelsWithDefaultExclusivity(TestResourceTrackerService.toSet((Object[])new String[]{"X", "Y", "Z"}));
        }
        catch (IOException e) {
            Assert.fail((String)"Caught Exception while initializing");
            e.printStackTrace();
        }
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        req.setResource(capability);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        req.setNMVersion(YarnVersionInfo.getVersion());
        req.setNodeLabels(TestResourceTrackerService.toNodeLabelSet((String[])new String[]{"#Y"}));
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((String)"On Invalid Node Labels action is expected to be normal", (Object)NodeAction.NORMAL, (Object)response.getNodeAction());
        Assert.assertNull(nodeLabelsMgr.getNodeLabels().get(nodeId));
        Assert.assertNotNull((Object)response.getDiagnosticsMessage());
        Assert.assertFalse((String)"Node Labels should not accepted by RM If Invalid", (boolean)response.getAreNodeLabelsAcceptedByRM());
        if (this.rm != null) {
            this.rm.stop();
        }
    }

    @Test
    public void testNodeRegistrationWithCentralLabelConfig() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.node-labels.configuration-type", "centralized");
        final NullRMNodeLabelsManager nodeLabelsMgr = new NullRMNodeLabelsManager();
        this.rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return nodeLabelsMgr;
            }
        };
        this.rm.start();
        try {
            nodeLabelsMgr.addToCluserNodeLabelsWithDefaultExclusivity(TestResourceTrackerService.toSet((Object[])new String[]{"A", "B", "C"}));
        }
        catch (IOException e) {
            Assert.fail((String)"Caught Exception while initializing");
            e.printStackTrace();
        }
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        req.setResource(capability);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        req.setNMVersion(YarnVersionInfo.getVersion());
        req.setNodeLabels(TestResourceTrackerService.toNodeLabelSet((String[])new String[]{"A"}));
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)response.getNodeAction());
        Assert.assertNull(nodeLabelsMgr.getNodeLabels().get(nodeId));
        Assert.assertFalse((String)"Node Labels should not accepted by RM If its configured with Central configuration", (boolean)response.getAreNodeLabelsAcceptedByRM());
        if (this.rm != null) {
            this.rm.stop();
        }
    }

    private NodeStatus getNodeStatusObject(NodeId nodeId) {
        NodeStatus status = (NodeStatus)Records.newRecord(NodeStatus.class);
        status.setNodeId(nodeId);
        status.setResponseId(0);
        status.setContainersStatuses(Collections.emptyList());
        status.setKeepAliveApplications(Collections.emptyList());
        return status;
    }

    @Test
    public void testNodeHeartBeatWithLabels() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.node-labels.configuration-type", "distributed");
        final NullRMNodeLabelsManager nodeLabelsMgr = new NullRMNodeLabelsManager();
        this.rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return nodeLabelsMgr;
            }
        };
        this.rm.start();
        try {
            nodeLabelsMgr.addToCluserNodeLabelsWithDefaultExclusivity(TestResourceTrackerService.toSet((Object[])new String[]{"A", "B", "C"}));
        }
        catch (IOException e) {
            Assert.fail((String)"Caught Exception while initializing");
            e.printStackTrace();
        }
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest registerReq = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        registerReq.setResource(capability);
        registerReq.setNodeId(nodeId);
        registerReq.setHttpPort(1234);
        registerReq.setNMVersion(YarnVersionInfo.getVersion());
        registerReq.setNodeLabels(TestResourceTrackerService.toNodeLabelSet((String[])new String[]{"A"}));
        RegisterNodeManagerResponse registerResponse = resourceTrackerService.registerNodeManager(registerReq);
        NodeHeartbeatRequest heartbeatReq = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        heartbeatReq.setNodeLabels(TestResourceTrackerService.toNodeLabelSet((String[])new String[]{"B"}));
        NodeStatus nodeStatusObject = this.getNodeStatusObject(nodeId);
        heartbeatReq.setNodeStatus(nodeStatusObject);
        heartbeatReq.setLastKnownNMTokenMasterKey(registerResponse.getNMTokenMasterKey());
        heartbeatReq.setLastKnownContainerTokenMasterKey(registerResponse.getContainerTokenMasterKey());
        NodeHeartbeatResponse nodeHeartbeatResponse = resourceTrackerService.nodeHeartbeat(heartbeatReq);
        Assert.assertEquals((String)"InValid Node Labels were not accepted by RM", (Object)NodeAction.NORMAL, (Object)nodeHeartbeatResponse.getNodeAction());
        TestResourceTrackerService.assertCollectionEquals((Collection)((Collection)nodeLabelsMgr.getNodeLabels().get(nodeId)), (Collection)NodeLabelsUtils.convertToStringSet((Set)heartbeatReq.getNodeLabels()));
        Assert.assertTrue((String)"Valid Node Labels were not accepted by RM", (boolean)nodeHeartbeatResponse.getAreNodeLabelsAcceptedByRM());
        Set oldLabels = (Set)nodeLabelsMgr.getNodeLabels().get(nodeId);
        int responseId = nodeStatusObject.getResponseId();
        heartbeatReq = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        heartbeatReq.setNodeLabels(null);
        nodeStatusObject = this.getNodeStatusObject(nodeId);
        nodeStatusObject.setResponseId(responseId + 1);
        heartbeatReq.setNodeStatus(nodeStatusObject);
        heartbeatReq.setLastKnownNMTokenMasterKey(registerResponse.getNMTokenMasterKey());
        heartbeatReq.setLastKnownContainerTokenMasterKey(registerResponse.getContainerTokenMasterKey());
        nodeHeartbeatResponse = resourceTrackerService.nodeHeartbeat(heartbeatReq);
        Assert.assertEquals((String)"InValid Node Labels were not accepted by RM", (Object)NodeAction.NORMAL, (Object)nodeHeartbeatResponse.getNodeAction());
        TestResourceTrackerService.assertCollectionEquals((Collection)((Collection)nodeLabelsMgr.getNodeLabels().get(nodeId)), (Collection)oldLabels);
        Assert.assertFalse((String)"Node Labels should not accepted by RM", (boolean)nodeHeartbeatResponse.getAreNodeLabelsAcceptedByRM());
        this.rm.stop();
    }

    @Test
    public void testNodeHeartbeatWithNodeAttributes() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.setClass("yarn.node-attribute.fs-store.impl.class", FileSystemNodeAttributeStore.class, NodeAttributeStore.class);
        File tempDir = File.createTempFile("nattr", ".tmp");
        tempDir.delete();
        tempDir.mkdirs();
        tempDir.deleteOnExit();
        conf.set("yarn.node-attribute.fs-store.root-dir", tempDir.getAbsolutePath());
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest registerReq = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        registerReq.setResource(capability);
        registerReq.setNodeId(nodeId);
        registerReq.setHttpPort(1234);
        registerReq.setNMVersion(YarnVersionInfo.getVersion());
        RegisterNodeManagerResponse registerResponse = resourceTrackerService.registerNodeManager(registerReq);
        HashSet<NodeAttribute> nodeAttributes = new HashSet<NodeAttribute>();
        nodeAttributes.add(NodeAttribute.newInstance((String)"nm.yarn.io", (String)"host", (NodeAttributeType)NodeAttributeType.STRING, (String)"host2"));
        NodeHeartbeatRequest heartbeatReq = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        NodeStatus nodeStatusObject = this.getNodeStatusObject(nodeId);
        int responseId = nodeStatusObject.getResponseId();
        heartbeatReq.setNodeStatus(nodeStatusObject);
        heartbeatReq.setLastKnownNMTokenMasterKey(registerResponse.getNMTokenMasterKey());
        heartbeatReq.setLastKnownContainerTokenMasterKey(registerResponse.getContainerTokenMasterKey());
        heartbeatReq.setNodeAttributes(nodeAttributes);
        resourceTrackerService.nodeHeartbeat(heartbeatReq);
        NodeAttributesManager attributeManager = this.rm.getRMContext().getNodeAttributesManager();
        Map attrs = attributeManager.getAttributesForNode(nodeId.getHost());
        Assert.assertEquals((long)1L, (long)attrs.size());
        NodeAttribute na = (NodeAttribute)attrs.keySet().iterator().next();
        Assert.assertEquals((Object)"host", (Object)na.getAttributeKey().getAttributeName());
        Assert.assertEquals((Object)"host2", (Object)na.getAttributeValue());
        Assert.assertEquals((Object)NodeAttributeType.STRING, (Object)na.getAttributeType());
        nodeAttributes.clear();
        nodeAttributes.add(NodeAttribute.newInstance((String)"nm.yarn.io", (String)"host", (NodeAttributeType)NodeAttributeType.STRING, (String)"host3"));
        nodeStatusObject = this.getNodeStatusObject(nodeId);
        nodeStatusObject.setResponseId(++responseId);
        heartbeatReq.setNodeStatus(nodeStatusObject);
        heartbeatReq.setNodeAttributes(nodeAttributes);
        resourceTrackerService.nodeHeartbeat(heartbeatReq);
        attrs = attributeManager.getAttributesForNode(nodeId.getHost());
        Assert.assertEquals((long)1L, (long)attrs.size());
        na = (NodeAttribute)attrs.keySet().iterator().next();
        Assert.assertEquals((Object)"host", (Object)na.getAttributeKey().getAttributeName());
        Assert.assertEquals((Object)"host3", (Object)na.getAttributeValue());
        Assert.assertEquals((Object)NodeAttributeType.STRING, (Object)na.getAttributeType());
    }

    @Test
    public void testNodeHeartBeatWithInvalidLabels() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.node-labels.configuration-type", "distributed");
        final NullRMNodeLabelsManager nodeLabelsMgr = new NullRMNodeLabelsManager();
        this.rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return nodeLabelsMgr;
            }
        };
        this.rm.start();
        try {
            nodeLabelsMgr.addToCluserNodeLabelsWithDefaultExclusivity(TestResourceTrackerService.toSet((Object[])new String[]{"A", "B", "C"}));
        }
        catch (IOException e) {
            Assert.fail((String)"Caught Exception while initializing");
            e.printStackTrace();
        }
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest registerReq = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        registerReq.setResource(capability);
        registerReq.setNodeId(nodeId);
        registerReq.setHttpPort(1234);
        registerReq.setNMVersion(YarnVersionInfo.getVersion());
        registerReq.setNodeLabels(TestResourceTrackerService.toNodeLabelSet((String[])new String[]{"A"}));
        RegisterNodeManagerResponse registerResponse = resourceTrackerService.registerNodeManager(registerReq);
        NodeHeartbeatRequest heartbeatReq = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        heartbeatReq.setNodeLabels(TestResourceTrackerService.toNodeLabelSet((String[])new String[]{"B", "#C"}));
        heartbeatReq.setNodeStatus(this.getNodeStatusObject(nodeId));
        heartbeatReq.setLastKnownNMTokenMasterKey(registerResponse.getNMTokenMasterKey());
        heartbeatReq.setLastKnownContainerTokenMasterKey(registerResponse.getContainerTokenMasterKey());
        NodeHeartbeatResponse nodeHeartbeatResponse = resourceTrackerService.nodeHeartbeat(heartbeatReq);
        Assert.assertEquals((String)"Response should be NORMAL when RM heartbeat labels are rejected", (Object)NodeAction.NORMAL, (Object)nodeHeartbeatResponse.getNodeAction());
        Assert.assertFalse((boolean)nodeHeartbeatResponse.getAreNodeLabelsAcceptedByRM());
        Assert.assertNotNull((Object)nodeHeartbeatResponse.getDiagnosticsMessage());
        this.rm.stop();
    }

    @Test
    public void testNodeHeartbeatWithCentralLabelConfig() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.node-labels.configuration-type", "centralized");
        final NullRMNodeLabelsManager nodeLabelsMgr = new NullRMNodeLabelsManager();
        this.rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return nodeLabelsMgr;
            }
        };
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        req.setResource(capability);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        req.setNMVersion(YarnVersionInfo.getVersion());
        req.setNodeLabels(TestResourceTrackerService.toNodeLabelSet((String[])new String[]{"A", "B", "C"}));
        RegisterNodeManagerResponse registerResponse = resourceTrackerService.registerNodeManager(req);
        NodeHeartbeatRequest heartbeatReq = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        heartbeatReq.setNodeLabels(TestResourceTrackerService.toNodeLabelSet((String[])new String[]{"B"}));
        heartbeatReq.setNodeStatus(this.getNodeStatusObject(nodeId));
        heartbeatReq.setLastKnownNMTokenMasterKey(registerResponse.getNMTokenMasterKey());
        heartbeatReq.setLastKnownContainerTokenMasterKey(registerResponse.getContainerTokenMasterKey());
        NodeHeartbeatResponse nodeHeartbeatResponse = resourceTrackerService.nodeHeartbeat(heartbeatReq);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeatResponse.getNodeAction());
        Assert.assertNull(nodeLabelsMgr.getNodeLabels().get(nodeId));
        Assert.assertFalse((String)"Invalid Node Labels should not accepted by RM", (boolean)nodeHeartbeatResponse.getAreNodeLabelsAcceptedByRM());
        if (this.rm != null) {
            this.rm.stop();
        }
    }

    @Test
    public void testNodeRegistrationVersionLessThanRM() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.resourcemanager.nodemanager.minimum.version", "EqualToRM");
        this.rm = new MockRM(conf);
        this.rm.start();
        String nmVersion = "1.9.9";
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        req.setResource(capability);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        req.setNMVersion(nmVersion);
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response.getNodeAction());
        Assert.assertTrue((String)("Diagnostic message did not contain: 'Disallowed NodeManager Version " + nmVersion + ", is less than the minimum version'"), (boolean)response.getDiagnosticsMessage().contains("Disallowed NodeManager Version " + nmVersion + ", is less than the minimum version "));
    }

    @Test
    public void testNodeRegistrationFailure() throws Exception {
        this.writeToHostsFile("host1");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response.getNodeAction());
        Assert.assertEquals((Object)"Disallowed NodeManager from  host2, Sending SHUTDOWN signal to the NodeManager.", (Object)response.getDiagnosticsMessage());
    }

    @Test
    public void testSetRMIdentifierInRegistration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm = new MockNM("host1:1234", 5120, this.rm.getResourceTrackerService());
        RegisterNodeManagerResponse response = nm.registerNode();
        Assert.assertEquals((long)ResourceManager.getClusterTimeStamp(), (long)response.getRMIdentifier());
    }

    @Test
    public void testNodeRegistrationWithMinimumAllocations() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.minimum-allocation-mb", "2048");
        conf.set("yarn.scheduler.minimum-allocation-vcores", "4");
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = BuilderUtils.newNodeId((String)"host", (int)1234);
        req.setNodeId(nodeId);
        Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        req.setResource(capability);
        RegisterNodeManagerResponse response1 = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response1.getNodeAction());
        capability.setMemorySize(2048L);
        capability.setVirtualCores(1);
        req.setResource(capability);
        RegisterNodeManagerResponse response2 = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response2.getNodeAction());
        capability.setMemorySize(1024L);
        capability.setVirtualCores(4);
        req.setResource(capability);
        RegisterNodeManagerResponse response3 = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response3.getNodeAction());
        capability.setMemorySize(2048L);
        capability.setVirtualCores(4);
        req.setResource(capability);
        RegisterNodeManagerResponse response4 = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)response4.getNodeAction());
    }

    @Test
    public void testReboot() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:1234", 2048);
        int initialMetricCount = ClusterMetrics.getMetrics().getNumRebootedNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(new HashMap<ApplicationId, List<ContainerStatus>>(), true, -100);
        Assert.assertTrue((boolean)NodeAction.RESYNC.equals((Object)nodeHeartbeat.getNodeAction()));
        Assert.assertEquals((Object)"Too far behind rm response id:0 nm response id:-100", (Object)nodeHeartbeat.getDiagnosticsMessage());
        this.checkRebootedNMCount(this.rm, ++initialMetricCount);
    }

    @Test
    public void testNodeHeartbeatForAppCollectorsMap() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setFloat("yarn.timeline-service.version", 2.0f);
        conf.set("yarn.nodemanager.aux-services", "timeline_collector");
        conf.set("yarn.nodemanager.aux-services.timeline_collector.class", PerNodeTimelineCollectorsAuxService.class.getName());
        conf.setClass("yarn.timeline-service.writer.class", FileSystemTimelineWriterImpl.class, TimelineWriter.class);
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:1234", 2048);
        NodeHeartbeatResponse nodeHeartbeat1 = nm1.nodeHeartbeat(true);
        NodeHeartbeatResponse nodeHeartbeat2 = nm2.nodeHeartbeat(true);
        RMNodeImpl node1 = (RMNodeImpl)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId());
        RMNodeImpl node2 = (RMNodeImpl)this.rm.getRMContext().getRMNodes().get(nm2.getNodeId());
        RMAppImpl app1 = (RMAppImpl)this.rm.submitApp(1024);
        String collectorAddr1 = "1.2.3.4:5";
        app1.setCollectorData(AppCollectorData.newInstance((ApplicationId)app1.getApplicationId(), (String)collectorAddr1));
        String collectorAddr2 = "5.4.3.2:1";
        RMAppImpl app2 = (RMAppImpl)this.rm.submitApp(1024);
        app2.setCollectorData(AppCollectorData.newInstance((ApplicationId)app2.getApplicationId(), (String)collectorAddr2));
        String collectorAddr3 = "5.4.3.2:2";
        app2.setCollectorData(AppCollectorData.newInstance((ApplicationId)app2.getApplicationId(), (String)collectorAddr3, (long)0L, (long)1L));
        String collectorAddr4 = "5.4.3.2:3";
        app2.setCollectorData(AppCollectorData.newInstance((ApplicationId)app2.getApplicationId(), (String)collectorAddr4, (long)1L, (long)0L));
        ContainerId runningContainerId1 = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)app1.getApplicationId(), (int)0), (long)0L);
        ContainerStatus status1 = ContainerStatus.newInstance((ContainerId)runningContainerId1, (ContainerState)ContainerState.RUNNING, (String)"", (int)0);
        ArrayList<ContainerStatus> statusList = new ArrayList<ContainerStatus>();
        statusList.add(status1);
        NodeHealthStatus nodeHealth = NodeHealthStatus.newInstance((boolean)true, (String)"", (long)System.currentTimeMillis());
        NodeStatus nodeStatus = NodeStatus.newInstance((NodeId)nm1.getNodeId(), (int)0, statusList, null, (NodeHealthStatus)nodeHealth, null, null, null);
        node1.handle((RMNodeEvent)new RMNodeStatusEvent(nm1.getNodeId(), nodeStatus));
        Assert.assertEquals((long)1L, (long)node1.getRunningApps().size());
        Assert.assertEquals((Object)app1.getApplicationId(), node1.getRunningApps().get(0));
        ContainerId runningContainerId2 = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)app2.getApplicationId(), (int)0), (long)0L);
        ContainerStatus status2 = ContainerStatus.newInstance((ContainerId)runningContainerId2, (ContainerState)ContainerState.RUNNING, (String)"", (int)0);
        statusList = new ArrayList();
        statusList.add(status2);
        nodeStatus = NodeStatus.newInstance((NodeId)nm1.getNodeId(), (int)0, statusList, null, (NodeHealthStatus)nodeHealth, null, null, null);
        node2.handle((RMNodeEvent)new RMNodeStatusEvent(nm2.getNodeId(), nodeStatus));
        Assert.assertEquals((long)1L, (long)node2.getRunningApps().size());
        Assert.assertEquals((Object)app2.getApplicationId(), node2.getRunningApps().get(0));
        nodeHeartbeat1 = nm1.nodeHeartbeat(true);
        Map map1 = nodeHeartbeat1.getAppCollectors();
        Assert.assertEquals((long)1L, (long)map1.size());
        Assert.assertEquals((Object)collectorAddr1, (Object)((AppCollectorData)map1.get(app1.getApplicationId())).getCollectorAddr());
        nodeHeartbeat2 = nm2.nodeHeartbeat(true);
        Map map2 = nodeHeartbeat2.getAppCollectors();
        Assert.assertEquals((long)1L, (long)map2.size());
        Assert.assertEquals((Object)collectorAddr4, (Object)((AppCollectorData)map2.get(app2.getApplicationId())).getCollectorAddr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRebootedNMCount(MockRM rm2, int count) throws InterruptedException {
        int waitCount = 0;
        while (ClusterMetrics.getMetrics().getNumRebootedNMs() != count && waitCount++ < 20) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                ((Object)((Object)this)).wait(100L);
            }
        }
        Assert.assertEquals((String)"The rebooted metrics are not updated", (long)count, (long)ClusterMetrics.getMetrics().getNumRebootedNMs());
    }

    @Test
    public void testUnhealthyNodeStatus() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.hostFile.getAbsolutePath());
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        Assert.assertEquals((long)0L, (long)ClusterMetrics.getMetrics().getUnhealthyNMs());
        nm1.nodeHeartbeat(true);
        nm1.nodeHeartbeat(false);
        this.checkUnhealthyNMCount(this.rm, nm1, true, 1);
        nm1.nodeHeartbeat(true);
        this.checkUnhealthyNMCount(this.rm, nm1, false, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUnhealthyNMCount(MockRM rm, MockNM nm1, boolean health, int count) throws Exception {
        int waitCount = 0;
        while (((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())).getState() != NodeState.UNHEALTHY == health && waitCount++ < 20) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                ((Object)((Object)this)).wait(100L);
            }
        }
        Assert.assertFalse((((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())).getState() != NodeState.UNHEALTHY == health ? 1 : 0) != 0);
        Assert.assertEquals((String)"Unhealthy metrics not incremented", (long)count, (long)ClusterMetrics.getMetrics().getUnhealthyNMs());
    }

    @Test
    public void testHandleContainerStatusInvalidCompletions() throws Exception {
        this.rm = new MockRM((Configuration)new YarnConfiguration());
        this.rm.start();
        EventHandler handler = (EventHandler)Mockito.spy((Object)this.rm.getRMContext().getDispatcher().getEventHandler());
        RMApp app = this.rm.submitApp(1024, true);
        NMContainerStatus report = NMContainerStatus.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)app.getApplicationId(), (int)2), (long)1L), (int)0, (ContainerState)ContainerState.COMPLETE, (Resource)Resource.newInstance((int)1024, (int)1), (String)"Dummy Completed", (int)0, (Priority)Priority.newInstance((int)10), (long)1234L);
        this.rm.getResourceTrackerService().handleNMContainerStatus(report, null);
        ((EventHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).handle((Event)Matchers.any());
        RMAppAttemptImpl currentAttempt = (RMAppAttemptImpl)app.getCurrentAppAttempt();
        currentAttempt.setMasterContainer(null);
        report = NMContainerStatus.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)currentAttempt.getAppAttemptId(), (long)0L), (int)0, (ContainerState)ContainerState.COMPLETE, (Resource)Resource.newInstance((int)1024, (int)1), (String)"Dummy Completed", (int)0, (Priority)Priority.newInstance((int)10), (long)1234L);
        this.rm.getResourceTrackerService().handleNMContainerStatus(report, null);
        ((EventHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).handle((Event)Matchers.any());
        app = this.rm.submitApp(1024);
        report = NMContainerStatus.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)app.getApplicationId(), (int)2), (long)1L), (int)0, (ContainerState)ContainerState.COMPLETE, (Resource)Resource.newInstance((int)1024, (int)1), (String)"Dummy Completed", (int)0, (Priority)Priority.newInstance((int)10), (long)1234L);
        try {
            this.rm.getResourceTrackerService().handleNMContainerStatus(report, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((EventHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).handle((Event)Matchers.any());
        currentAttempt = (RMAppAttemptImpl)app.getCurrentAppAttempt();
        currentAttempt.setMasterContainer(null);
        report = NMContainerStatus.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)currentAttempt.getAppAttemptId(), (long)0L), (int)0, (ContainerState)ContainerState.COMPLETE, (Resource)Resource.newInstance((int)1024, (int)1), (String)"Dummy Completed", (int)0, (Priority)Priority.newInstance((int)10), (long)1234L);
        try {
            this.rm.getResourceTrackerService().handleNMContainerStatus(report, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((EventHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).handle((Event)Matchers.any());
    }

    @Test
    public void testReconnectNode() throws Exception {
        this.rm = new MockRM(){

            @Override
            protected EventHandler<SchedulerEvent> createSchedulerEventDispatcher() {
                return new EventDispatcher<SchedulerEvent>((EventHandler)this.scheduler, this.scheduler.getClass().getName()){

                    public void handle(SchedulerEvent event) {
                        scheduler.handle((Event)event);
                    }
                };
            }
        };
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 5120);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(false);
        this.rm.drainEvents();
        this.checkUnhealthyNMCount(this.rm, nm2, true, 1);
        int expectedNMs = ClusterMetrics.getMetrics().getNumActiveNMs();
        QueueMetrics metrics = this.rm.getResourceScheduler().getRootQueueMetrics();
        Assert.assertEquals((long)5120L, (long)metrics.getAvailableMB());
        nm1 = this.rm.registerNode("host1:1234", 5120);
        NodeHeartbeatResponse response = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)response.getNodeAction()));
        this.rm.drainEvents();
        Assert.assertEquals((long)expectedNMs, (long)ClusterMetrics.getMetrics().getNumActiveNMs());
        this.checkUnhealthyNMCount(this.rm, nm2, true, 1);
        nm2 = this.rm.registerNode("host2:5678", 5120);
        response = nm2.nodeHeartbeat(false);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)response.getNodeAction()));
        this.rm.drainEvents();
        Assert.assertEquals((long)expectedNMs, (long)ClusterMetrics.getMetrics().getNumActiveNMs());
        this.checkUnhealthyNMCount(this.rm, nm2, true, 1);
        nm2 = this.rm.registerNode("host2:5678", 5120);
        response = nm2.nodeHeartbeat(true);
        response = nm2.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertEquals((long)10240L, (long)metrics.getAvailableMB());
        nm1 = this.rm.registerNode("host2:5678", 10240);
        response = nm1.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)response.getNodeAction()));
        Assert.assertEquals((long)15360L, (long)metrics.getAvailableMB());
        HashMap<ApplicationId, UpdatedCryptoForApp> runningApps = new HashMap<ApplicationId, UpdatedCryptoForApp>(1);
        runningApps.put(ApplicationId.newInstance((long)1L, (int)0), UpdatedCryptoForApp.newInstance((int)0, (long)0L));
        nm1 = this.rm.registerNode("host2:5678", 15360, 2, runningApps);
        response = nm1.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)response.getNodeAction()));
        Assert.assertEquals((long)20480L, (long)metrics.getAvailableMB());
        nm1 = new MockNM("host1:1234", 5120, this.rm.getResourceTrackerService());
        nm1.setHttpPort(3);
        nm1.registerNode();
        response = nm1.nodeHeartbeat(true);
        response = nm1.nodeHeartbeat(true);
        this.rm.drainEvents();
        RMNode rmNode = (RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId());
        Assert.assertEquals((long)3L, (long)rmNode.getHttpPort());
        Assert.assertEquals((long)5120L, (long)rmNode.getTotalCapability().getMemorySize());
        Assert.assertEquals((long)20480L, (long)metrics.getAvailableMB());
    }

    @Test
    public void testNMUnregistration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        int shutdownNMsCount = ClusterMetrics.getMetrics().getNumShutdownNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        UnRegisterNodeManagerRequest request = (UnRegisterNodeManagerRequest)Records.newRecord(UnRegisterNodeManagerRequest.class);
        request.setNodeId(nm1.getNodeId());
        resourceTrackerService.unRegisterNodeManager(request);
        this.checkShutdownNMCount(this.rm, ++shutdownNMsCount);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.RESYNC.equals((Object)nodeHeartbeat.getNodeAction()));
    }

    @Test
    public void testUnhealthyNMUnregistration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        Assert.assertEquals((long)0L, (long)ClusterMetrics.getMetrics().getUnhealthyNMs());
        nm1.nodeHeartbeat(true);
        int shutdownNMsCount = ClusterMetrics.getMetrics().getNumShutdownNMs();
        nm1.nodeHeartbeat(false);
        this.checkUnhealthyNMCount(this.rm, nm1, true, 1);
        UnRegisterNodeManagerRequest request = (UnRegisterNodeManagerRequest)Records.newRecord(UnRegisterNodeManagerRequest.class);
        request.setNodeId(nm1.getNodeId());
        resourceTrackerService.unRegisterNodeManager(request);
        this.checkShutdownNMCount(this.rm, ++shutdownNMsCount);
    }

    @Test
    public void testInvalidNMUnregistration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        int decommisionedNMsCount = ClusterMetrics.getMetrics().getNumDecommisionedNMs();
        UnRegisterNodeManagerRequest request = (UnRegisterNodeManagerRequest)Records.newRecord(UnRegisterNodeManagerRequest.class);
        request.setNodeId(BuilderUtils.newNodeId((String)"host", (int)1234));
        resourceTrackerService.unRegisterNodeManager(request);
        this.checkShutdownNMCount(this.rm, 0);
        this.checkDecommissionedNMCount(this.rm, 0);
        MockNM nm1 = new MockNM("host1:1234", 5120, resourceTrackerService);
        RegisterNodeManagerResponse response = nm1.registerNode();
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)response.getNodeAction());
        int shutdownNMsCount = ClusterMetrics.getMetrics().getNumShutdownNMs();
        this.writeToHostsFile("host2");
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm.getNodesListManager().refreshNodes(conf);
        NodeHeartbeatResponse heartbeatResponse = nm1.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)heartbeatResponse.getNodeAction());
        this.checkDecommissionedNMCount(this.rm, decommisionedNMsCount);
        request.setNodeId(nm1.getNodeId());
        resourceTrackerService.unRegisterNodeManager(request);
        this.checkShutdownNMCount(this.rm, ++shutdownNMsCount);
        this.checkDecommissionedNMCount(this.rm, decommisionedNMsCount);
        MockNM nm2 = new MockNM("host2:1234", 5120, resourceTrackerService);
        RegisterNodeManagerResponse response2 = nm2.registerNode();
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)response2.getNodeAction());
        this.writeToHostsFile("host1");
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm.getNodesListManager().refreshNodes(conf);
        request.setNodeId(nm2.getNodeId());
        resourceTrackerService.unRegisterNodeManager(request);
        this.checkShutdownNMCount(this.rm, ++shutdownNMsCount);
        this.checkDecommissionedNMCount(this.rm, decommisionedNMsCount);
        this.rm.stop();
    }

    @Test(timeout=30000L)
    public void testInitDecommMetric() throws Exception {
        this.testInitDecommMetricHelper(true);
        this.testInitDecommMetricHelper(false);
    }

    public void testInitDecommMetricHelper(boolean hasIncludeList) throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        this.writeToHostsFile(this.excludeHostFile, "host1");
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.excludeHostFile.getAbsolutePath());
        if (hasIncludeList) {
            this.writeToHostsFile(this.hostFile, "host1", "host2");
            conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        }
        this.rm.getNodesListManager().refreshNodes(conf);
        this.rm.drainEvents();
        this.rm.stop();
        MockRM rm1 = new MockRM(conf);
        rm1.start();
        nm1 = rm1.registerNode("host1:1234", 5120);
        nm2 = rm1.registerNode("host2:5678", 10240);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        rm1.drainEvents();
        Assert.assertEquals((String)"Number of Decommissioned nodes should be 1", (long)1L, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
        Assert.assertEquals((String)"The inactiveRMNodes should contain an entry for thedecommissioned node", (long)1L, (long)rm1.getRMContext().getInactiveRMNodes().size());
        this.writeToHostsFile(this.excludeHostFile, "");
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.excludeHostFile.getAbsolutePath());
        rm1.getNodesListManager().refreshNodes(conf);
        nm1 = rm1.registerNode("host1:1234", 5120);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        rm1.drainEvents();
        Assert.assertEquals((String)"The decommissioned nodes metric should have decremented to 0", (long)0L, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
        Assert.assertEquals((String)"The active nodes metric should be 2", (long)2L, (long)ClusterMetrics.getMetrics().getNumActiveNMs());
        Assert.assertEquals((String)"The inactive RMNodes entry should have been removed", (long)0L, (long)rm1.getRMContext().getInactiveRMNodes().size());
        rm1.drainEvents();
        rm1.stop();
    }

    @Test(timeout=30000L)
    public void testInitDecommMetricNoRegistration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        this.writeToHostsFile(this.excludeHostFile, "host3", "host2");
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.excludeHostFile.getAbsolutePath());
        this.writeToHostsFile(this.hostFile, "host1", "host2");
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm.getNodesListManager().refreshNodes(conf);
        this.rm.drainEvents();
        Assert.assertEquals((String)"The decommissioned nodes metric should be 1 ", (long)1L, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
        this.rm.stop();
        MockRM rm1 = new MockRM(conf);
        rm1.start();
        rm1.getNodesListManager().refreshNodes(conf);
        rm1.drainEvents();
        Assert.assertEquals((String)"The decommissioned nodes metric should be 2 ", (long)2L, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
        rm1.stop();
    }

    @Test
    public void testIncorrectRecommission() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        this.writeToHostsFile(this.excludeHostFile, "host3", "host2");
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.excludeHostFile.getAbsolutePath());
        this.writeToHostsFile(this.hostFile, "host1", "host2");
        this.writeToHostsFile(this.excludeHostFile, "host1");
        this.rm.getNodesListManager().refreshNodesGracefully(conf, null);
        this.rm.drainEvents();
        nm1.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertTrue((String)("Node " + nm1.getNodeId().getHost() + " should be Decommissioned"), (((RMNode)this.rm.getRMContext().getInactiveRMNodes().get(nm1.getNodeId())).getState() == NodeState.DECOMMISSIONED ? 1 : 0) != 0);
        this.writeToHostsFile(this.excludeHostFile, "");
        this.rm.getNodesListManager().refreshNodesGracefully(conf, null);
        this.rm.drainEvents();
        Assert.assertTrue((String)("Node " + nm1.getNodeId().getHost() + " should be Decommissioned"), (((RMNode)this.rm.getRMContext().getInactiveRMNodes().get(nm1.getNodeId())).getState() == NodeState.DECOMMISSIONED ? 1 : 0) != 0);
        this.rm.stop();
    }

    @Test
    public void testNodeRemovalNormally() throws Exception {
        this.testNodeRemovalUtil(false);
        this.testNodeRemovalUtilLost(false);
        this.testNodeRemovalUtilRebooted(false);
        this.testNodeRemovalUtilUnhealthy(false);
    }

    @Test
    public void testNodeRemovalGracefully() throws Exception {
        this.testNodeRemovalUtil(true);
        this.testNodeRemovalUtilLost(true);
        this.testNodeRemovalUtilRebooted(true);
        this.testNodeRemovalUtilUnhealthy(true);
    }

    public void refreshNodesOption(boolean doGraceful, Configuration conf) throws Exception {
        if (doGraceful) {
            this.rm.getNodesListManager().refreshNodesGracefully(conf, null);
        } else {
            this.rm.getNodesListManager().refreshNodes(conf);
        }
    }

    public void testNodeRemovalUtil(boolean doGraceful) throws Exception {
        Configuration conf = new Configuration();
        int timeoutValue = 500;
        conf.set("yarn.resourcemanager.nodes.include-path", "");
        conf.set("yarn.resourcemanager.nodes.exclude-path", "");
        conf.setInt("yarn.resourcemanager.node-removal-untracked.timeout-ms", timeoutValue);
        CountDownLatch latch = new CountDownLatch(1);
        this.rm = new MockRM(conf);
        this.rm.init(conf);
        this.rm.start();
        RMContext rmContext = this.rm.getRMContext();
        this.refreshNodesOption(doGraceful, conf);
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        MockNM nm3 = this.rm.registerNode("localhost:4433", 1024);
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        this.rm.drainEvents();
        Assert.assertEquals((String)"All 3 nodes should be active", (long)metrics.getNumActiveNMs(), (long)3L);
        String ip = NetUtils.normalizeHostName((String)"localhost");
        this.writeToHostsFile("host1", ip);
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.refreshNodesOption(doGraceful, conf);
        if (doGraceful) {
            this.rm.waitForState(nm2.getNodeId(), NodeState.DECOMMISSIONING);
        }
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertTrue((String)"Node should not be in active node list", (!rmContext.getRMNodes().containsKey(nm2.getNodeId()) ? 1 : 0) != 0);
        RMNode rmNode = (RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId());
        Assert.assertEquals((String)"Node should be in inactive node list", (Object)rmNode.getState(), (Object)(doGraceful ? NodeState.DECOMMISSIONED : NodeState.SHUTDOWN));
        Assert.assertEquals((String)"Active nodes should be 2", (long)metrics.getNumActiveNMs(), (long)2L);
        Assert.assertEquals((String)"Shutdown nodes should be expected", (long)metrics.getNumShutdownNMs(), (long)(doGraceful ? 0L : 1L));
        int nodeRemovalTimeout = conf.getInt("yarn.resourcemanager.node-removal-untracked.timeout-ms", 60000);
        int nodeRemovalInterval = rmContext.getNodesListManager().getNodeRemovalCheckInterval();
        long maxThreadSleeptime = nodeRemovalInterval + nodeRemovalTimeout;
        latch.await(maxThreadSleeptime, TimeUnit.MILLISECONDS);
        rmNode = (RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId());
        Assert.assertEquals((String)"Node should have been forgotten!", (Object)rmNode, null);
        Assert.assertEquals((String)"Shutdown nodes should be 0 now", (long)metrics.getNumShutdownNMs(), (long)0L);
        this.writeToHostsFile("host1", ip, "host2");
        this.refreshNodesOption(doGraceful, conf);
        nm2 = this.rm.registerNode("host2:5678", 10240);
        this.rm.drainEvents();
        this.writeToHostsFile("host1", ip);
        this.refreshNodesOption(doGraceful, conf);
        this.rm.waitForState(nm2.getNodeId(), doGraceful ? NodeState.DECOMMISSIONING : NodeState.SHUTDOWN);
        nm2.nodeHeartbeat(true);
        this.rm.drainEvents();
        rmNode = (RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId());
        Assert.assertEquals((String)"Node should be shutdown", (Object)rmNode.getState(), (Object)(doGraceful ? NodeState.DECOMMISSIONED : NodeState.SHUTDOWN));
        Assert.assertEquals((String)"Active nodes should be 2", (long)metrics.getNumActiveNMs(), (long)2L);
        Assert.assertEquals((String)"Shutdown nodes should be expected", (long)metrics.getNumShutdownNMs(), (long)(doGraceful ? 0L : 1L));
        latch.await(maxThreadSleeptime - 2000L, TimeUnit.MILLISECONDS);
        this.writeToHostsFile("host1", ip, "host2");
        this.refreshNodesOption(doGraceful, conf);
        nm2 = this.rm.registerNode("host2:5678", 10240);
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        Assert.assertEquals((String)"Shutdown nodes should be 0 now", (long)metrics.getNumShutdownNMs(), (long)0L);
        Assert.assertEquals((String)"All 3 nodes should be active", (long)metrics.getNumActiveNMs(), (long)3L);
        this.writeToHostsFile("host1", "host2", ip);
        this.writeToHostsFile(this.excludeHostFile, "host2");
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.excludeHostFile.getAbsolutePath());
        this.refreshNodesOption(doGraceful, conf);
        this.rm.drainEvents();
        rmNode = doGraceful ? (RMNode)rmContext.getRMNodes().get(nm2.getNodeId()) : (RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId());
        Assert.assertTrue((String)"Node should be DECOMMISSIONED or DECOMMISSIONING", (rmNode.getState() == NodeState.DECOMMISSIONED || rmNode.getState() == NodeState.DECOMMISSIONING ? 1 : 0) != 0);
        if (rmNode.getState() == NodeState.DECOMMISSIONED) {
            Assert.assertEquals((String)"Decommissioned/ing nodes should be 1 now", (long)metrics.getNumDecommisionedNMs(), (long)1L);
        }
        latch.await(maxThreadSleeptime, TimeUnit.MILLISECONDS);
        rmNode = doGraceful ? (RMNode)rmContext.getRMNodes().get(nm2.getNodeId()) : (RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId());
        Assert.assertTrue((String)"Node should be DECOMMISSIONED or DECOMMISSIONING", (rmNode.getState() == NodeState.DECOMMISSIONED || rmNode.getState() == NodeState.DECOMMISSIONING ? 1 : 0) != 0);
        if (rmNode.getState() == NodeState.DECOMMISSIONED) {
            Assert.assertEquals((String)"Decommissioned/ing nodes should be 1 now", (long)metrics.getNumDecommisionedNMs(), (long)1L);
        }
        this.testNodeRemovalUtilDecomToUntracked(rmContext, conf, nm1, nm2, nm3, maxThreadSleeptime, doGraceful);
        this.rm.stop();
    }

    private void testNodeRemovalUtilDecomToUntracked(RMContext rmContext, Configuration conf, MockNM nm1, MockNM nm2, MockNM nm3, long maxThreadSleeptime, boolean doGraceful) throws Exception {
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        String ip = NetUtils.normalizeHostName((String)"localhost");
        CountDownLatch latch = new CountDownLatch(1);
        this.writeToHostsFile("host1", ip, "host2");
        this.writeToHostsFile(this.excludeHostFile, "host2");
        this.refreshNodesOption(doGraceful, conf);
        nm1.nodeHeartbeat(true);
        nm3.nodeHeartbeat(true);
        latch.await(maxThreadSleeptime, TimeUnit.MILLISECONDS);
        RMNode rmNode = doGraceful ? (RMNode)rmContext.getRMNodes().get(nm2.getNodeId()) : (RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId());
        Assert.assertNotEquals((String)"Timer for this node was not canceled!", (Object)rmNode, null);
        Assert.assertTrue((String)"Node should be DECOMMISSIONED or DECOMMISSIONING", (rmNode.getState() == NodeState.DECOMMISSIONED || rmNode.getState() == NodeState.DECOMMISSIONING ? 1 : 0) != 0);
        this.writeToHostsFile("host1", ip);
        this.writeToHostsFile(this.excludeHostFile, "");
        this.refreshNodesOption(doGraceful, conf);
        nm2.nodeHeartbeat(true);
        latch.await(maxThreadSleeptime, TimeUnit.MILLISECONDS);
        rmNode = doGraceful ? (RMNode)rmContext.getRMNodes().get(nm2.getNodeId()) : (RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId());
        Assert.assertEquals((String)"Node should have been forgotten!", (Object)rmNode, null);
        Assert.assertEquals((String)"Shutdown nodes should be 0 now", (long)metrics.getNumDecommisionedNMs(), (long)0L);
        Assert.assertEquals((String)"Shutdown nodes should be 0 now", (long)metrics.getNumShutdownNMs(), (long)0L);
        Assert.assertEquals((String)"Active nodes should be 2", (long)metrics.getNumActiveNMs(), (long)2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNodeRemovalUtilLost(boolean doGraceful) throws Exception {
        ClusterMetrics clusterMetrics;
        Configuration conf = new Configuration();
        conf.setLong("yarn.nm.liveness-monitor.expiry-interval-ms", 2000L);
        int timeoutValue = 500;
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.excludeHostFile.getAbsolutePath());
        this.writeToHostsFile(this.hostFile, "host1", "localhost", "host2");
        this.writeToHostsFile(this.excludeHostFile, "");
        conf.setInt("yarn.resourcemanager.node-removal-untracked.timeout-ms", timeoutValue);
        this.rm = new MockRM(conf);
        this.rm.init(conf);
        this.rm.start();
        RMContext rmContext = this.rm.getRMContext();
        this.refreshNodesOption(doGraceful, conf);
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        MockNM nm3 = this.rm.registerNode("localhost:4433", 1024);
        ClusterMetrics metrics = clusterMetrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        this.rm.drainEvents();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        this.rm.drainEvents();
        Assert.assertEquals((String)"All 3 nodes should be active", (long)metrics.getNumActiveNMs(), (long)3L);
        int waitCount = 0;
        while (waitCount++ < 20) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                ((Object)((Object)this)).wait(200L);
            }
            nm3.nodeHeartbeat(true);
            nm1.nodeHeartbeat(true);
        }
        Assert.assertNotEquals((String)"host2 should be a lost NM!", rmContext.getInactiveRMNodes().get(nm2.getNodeId()), null);
        Assert.assertEquals((String)"host2 should be a lost NM!", (Object)((RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId())).getState(), (Object)NodeState.LOST);
        Assert.assertEquals((String)"There should be 1 Lost NM!", (long)clusterMetrics.getNumLostNMs(), (long)1L);
        Assert.assertEquals((String)"There should be 2 Active NM!", (long)clusterMetrics.getNumActiveNMs(), (long)2L);
        int nodeRemovalTimeout = conf.getInt("yarn.resourcemanager.node-removal-untracked.timeout-ms", 60000);
        int nodeRemovalInterval = rmContext.getNodesListManager().getNodeRemovalCheckInterval();
        long maxThreadSleeptime = nodeRemovalInterval + nodeRemovalTimeout;
        this.writeToHostsFile(this.hostFile, "host1", "localhost");
        this.writeToHostsFile(this.excludeHostFile, "");
        this.refreshNodesOption(doGraceful, conf);
        nm1.nodeHeartbeat(true);
        nm3.nodeHeartbeat(true);
        this.rm.drainEvents();
        waitCount = 0;
        while (rmContext.getInactiveRMNodes().get(nm2.getNodeId()) != null && waitCount++ < 2) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                ((Object)((Object)this)).wait(maxThreadSleeptime);
                nm1.nodeHeartbeat(true);
                nm2.nodeHeartbeat(true);
            }
        }
        Assert.assertEquals((String)"host2 should have been forgotten!", rmContext.getInactiveRMNodes().get(nm2.getNodeId()), null);
        Assert.assertEquals((String)"There should be no Lost NMs!", (long)clusterMetrics.getNumLostNMs(), (long)0L);
        Assert.assertEquals((String)"There should be 2 Active NM!", (long)clusterMetrics.getNumActiveNMs(), (long)2L);
        this.rm.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNodeRemovalUtilRebooted(boolean doGraceful) throws Exception {
        ClusterMetrics clusterMetrics;
        Configuration conf = new Configuration();
        int timeoutValue = 500;
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.excludeHostFile.getAbsolutePath());
        this.writeToHostsFile(this.hostFile, "host1", "localhost", "host2");
        this.writeToHostsFile(this.excludeHostFile, "");
        conf.setInt("yarn.resourcemanager.node-removal-untracked.timeout-ms", timeoutValue);
        this.rm = new MockRM(conf);
        this.rm.init(conf);
        this.rm.start();
        RMContext rmContext = this.rm.getRMContext();
        this.refreshNodesOption(doGraceful, conf);
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        MockNM nm3 = this.rm.registerNode("localhost:4433", 1024);
        ClusterMetrics metrics = clusterMetrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        NodeHeartbeatResponse nodeHeartbeat = nm2.nodeHeartbeat(new HashMap<ApplicationId, List<ContainerStatus>>(), true, -100);
        this.rm.drainEvents();
        this.rm.drainEvents();
        Assert.assertNotEquals((String)"host2 should be a rebooted NM!", rmContext.getInactiveRMNodes().get(nm2.getNodeId()), null);
        Assert.assertEquals((String)"host2 should be a rebooted NM!", (Object)((RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId())).getState(), (Object)NodeState.REBOOTED);
        Assert.assertEquals((String)"There should be 1 Rebooted NM!", (long)clusterMetrics.getNumRebootedNMs(), (long)1L);
        Assert.assertEquals((String)"There should be 2 Active NM!", (long)clusterMetrics.getNumActiveNMs(), (long)2L);
        int nodeRemovalTimeout = conf.getInt("yarn.resourcemanager.node-removal-untracked.timeout-ms", 60000);
        int nodeRemovalInterval = rmContext.getNodesListManager().getNodeRemovalCheckInterval();
        long maxThreadSleeptime = nodeRemovalInterval + nodeRemovalTimeout;
        this.writeToHostsFile(this.hostFile, "host1", "localhost");
        this.writeToHostsFile(this.excludeHostFile, "");
        this.refreshNodesOption(doGraceful, conf);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        nm3.nodeHeartbeat(true);
        this.rm.drainEvents();
        int waitCount = 0;
        while (rmContext.getInactiveRMNodes().get(nm2.getNodeId()) != null && waitCount++ < 2) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                ((Object)((Object)this)).wait(maxThreadSleeptime);
            }
        }
        Assert.assertEquals((String)"host2 should have been forgotten!", rmContext.getInactiveRMNodes().get(nm2.getNodeId()), null);
        Assert.assertEquals((String)"There should be no Rebooted NMs!", (long)clusterMetrics.getNumRebootedNMs(), (long)0L);
        Assert.assertEquals((String)"There should be 2 Active NM!", (long)clusterMetrics.getNumActiveNMs(), (long)2L);
        this.rm.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNodeRemovalUtilUnhealthy(boolean doGraceful) throws Exception {
        ClusterMetrics clusterMetrics;
        Configuration conf = new Configuration();
        int timeoutValue = 500;
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.excludeHostFile.getAbsolutePath());
        this.writeToHostsFile(this.hostFile, "host1", "localhost", "host2");
        this.writeToHostsFile(this.excludeHostFile, "");
        conf.setInt("yarn.resourcemanager.node-removal-untracked.timeout-ms", timeoutValue);
        this.rm = new MockRM(conf);
        this.rm.init(conf);
        this.rm.start();
        RMContext rmContext = this.rm.getRMContext();
        this.refreshNodesOption(doGraceful, conf);
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        MockNM nm3 = this.rm.registerNode("localhost:4433", 1024);
        ClusterMetrics metrics = clusterMetrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        this.rm.drainEvents();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        this.rm.drainEvents();
        Assert.assertEquals((String)"All 3 nodes should be active", (long)metrics.getNumActiveNMs(), (long)3L);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(false);
        nm3.nodeHeartbeat(true);
        this.checkUnhealthyNMCount(this.rm, nm2, true, 1);
        this.writeToHostsFile(this.hostFile, "host1", "localhost");
        this.writeToHostsFile(this.excludeHostFile, "");
        this.refreshNodesOption(doGraceful, conf);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(false);
        nm3.nodeHeartbeat(true);
        this.rm.drainEvents();
        if (!doGraceful) {
            Assert.assertNotEquals((String)"host2 should be a shutdown NM!", rmContext.getInactiveRMNodes().get(nm2.getNodeId()), null);
            Assert.assertEquals((String)"host2 should be a shutdown NM!", (Object)((RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId())).getState(), (Object)NodeState.SHUTDOWN);
        }
        Assert.assertEquals((String)"There should be 2 Active NM!", (long)clusterMetrics.getNumActiveNMs(), (long)2L);
        if (!doGraceful) {
            Assert.assertEquals((String)"There should be 1 Shutdown NM!", (long)clusterMetrics.getNumShutdownNMs(), (long)1L);
        }
        Assert.assertEquals((String)"There should be 0 Unhealthy NM!", (long)clusterMetrics.getUnhealthyNMs(), (long)0L);
        int nodeRemovalTimeout = conf.getInt("yarn.resourcemanager.node-removal-untracked.timeout-ms", 60000);
        int nodeRemovalInterval = rmContext.getNodesListManager().getNodeRemovalCheckInterval();
        long maxThreadSleeptime = nodeRemovalInterval + nodeRemovalTimeout;
        int waitCount = 0;
        while (rmContext.getInactiveRMNodes().get(nm2.getNodeId()) != null && waitCount++ < 2) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                ((Object)((Object)this)).wait(maxThreadSleeptime);
            }
        }
        Assert.assertEquals((String)"host2 should have been forgotten!", rmContext.getInactiveRMNodes().get(nm2.getNodeId()), null);
        Assert.assertEquals((String)"There should be no Shutdown NMs!", (long)clusterMetrics.getNumRebootedNMs(), (long)0L);
        Assert.assertEquals((String)"There should be 2 Active NM!", (long)clusterMetrics.getNumActiveNMs(), (long)2L);
        this.rm.stop();
    }

    private void ensureFileExists(File file) throws IOException {
        if (!file.exists()) {
            TEMP_DIR.mkdirs();
            file.createNewFile();
        }
    }

    private void writeToHostsFile(String ... hosts) throws IOException {
        this.writeToHostsFile(this.hostFile, hosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToHostsFile(File file, String ... hosts) throws IOException {
        this.ensureFileExists(file);
        FileOutputStream fStream = null;
        try {
            fStream = new FileOutputStream(file);
            for (int i = 0; i < hosts.length; ++i) {
                fStream.write(hosts[i].getBytes());
                fStream.write("\n".getBytes());
            }
        }
        finally {
            if (fStream != null) {
                IOUtils.closeStream((Closeable)fStream);
                fStream = null;
            }
        }
    }

    private void writeToHostsXmlFile(File file, Pair<String, Integer> ... hostsAndTimeouts) throws Exception {
        this.ensureFileExists(file);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        Document doc = dbFactory.newDocumentBuilder().newDocument();
        Element hosts = doc.createElement("hosts");
        doc.appendChild(hosts);
        for (Pair<String, Integer> hostsAndTimeout : hostsAndTimeouts) {
            Element host = doc.createElement("host");
            hosts.appendChild(host);
            Element name = doc.createElement("name");
            host.appendChild(name);
            name.appendChild(doc.createTextNode((String)hostsAndTimeout.getLeft()));
            if (hostsAndTimeout.getRight() == null) continue;
            Element timeout = doc.createElement("timeout");
            host.appendChild(timeout);
            timeout.appendChild(doc.createTextNode(((Integer)hostsAndTimeout.getRight()).toString()));
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new DOMSource(doc), new StreamResult(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDecommissionedNMCount(MockRM rm, int count) throws InterruptedException {
        int waitCount = 0;
        while (ClusterMetrics.getMetrics().getNumDecommisionedNMs() != count && waitCount++ < 20) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                ((Object)((Object)this)).wait(100L);
            }
        }
        Assert.assertEquals((long)count, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
        Assert.assertEquals((String)"The decommisioned metrics are not updated", (long)count, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkShutdownNMCount(MockRM rm, int count) throws InterruptedException {
        int waitCount = 0;
        while (ClusterMetrics.getMetrics().getNumShutdownNMs() != count && waitCount++ < 20) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                ((Object)((Object)this)).wait(100L);
            }
        }
        Assert.assertEquals((String)"The shutdown metrics are not updated", (long)count, (long)ClusterMetrics.getMetrics().getNumShutdownNMs());
    }

    @After
    public void tearDown() {
        MetricsSystem ms;
        if (this.hostFile != null && this.hostFile.exists()) {
            this.hostFile.delete();
        }
        ClusterMetrics.destroy();
        if (this.rm != null) {
            this.rm.stop();
        }
        if ((ms = DefaultMetricsSystem.instance()).getSource("ClusterMetrics") != null) {
            DefaultMetricsSystem.shutdown();
        }
    }

    @Test
    public void testHandleOpportunisticContainerStatus() throws Exception {
        final DrainDispatcher dispatcher = new DrainDispatcher();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        conf.setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", true);
        this.rm = new MockRM((Configuration)conf){

            @Override
            protected Dispatcher createDispatcher() {
                return dispatcher;
            }
        };
        this.rm.start();
        RMApp app = this.rm.submitApp(1024, true);
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        SchedulerApplicationAttempt applicationAttempt = null;
        while (applicationAttempt == null) {
            applicationAttempt = ((AbstractYarnScheduler)this.rm.getRMContext().getScheduler()).getApplicationAttempt(appAttemptId);
            Thread.sleep(100L);
        }
        Resource currentConsumption = applicationAttempt.getCurrentConsumption();
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)currentConsumption);
        Resource allocResources = applicationAttempt.getQueue().getMetrics().getAllocatedResources();
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)allocResources);
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        req.setResource(capability);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        req.setNMVersion(YarnVersionInfo.getVersion());
        ContainerId c1 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        ContainerId c2 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)2L);
        ContainerId c3 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)3L);
        NMContainerStatus queuedOpp = NMContainerStatus.newInstance((ContainerId)c1, (int)1, (ContainerState)ContainerState.RUNNING, (Resource)Resource.newInstance((int)1024, (int)1), (String)"Dummy Queued OC", (int)-1000, (Priority)Priority.newInstance((int)5), (long)1234L, (String)"", (ExecutionType)ExecutionType.OPPORTUNISTIC, (long)-1L);
        NMContainerStatus runningOpp = NMContainerStatus.newInstance((ContainerId)c2, (int)1, (ContainerState)ContainerState.RUNNING, (Resource)Resource.newInstance((int)2048, (int)1), (String)"Dummy Running OC", (int)-1000, (Priority)Priority.newInstance((int)6), (long)1234L, (String)"", (ExecutionType)ExecutionType.OPPORTUNISTIC, (long)-1L);
        NMContainerStatus runningGuar = NMContainerStatus.newInstance((ContainerId)c3, (int)1, (ContainerState)ContainerState.RUNNING, (Resource)Resource.newInstance((int)2048, (int)1), (String)"Dummy Running GC", (int)-1000, (Priority)Priority.newInstance((int)6), (long)1234L, (String)"", (ExecutionType)ExecutionType.GUARANTEED, (long)-1L);
        req.setContainerStatuses(Arrays.asList(queuedOpp, runningOpp, runningGuar));
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(req);
        dispatcher.await();
        Thread.sleep(2000L);
        dispatcher.await();
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)response.getNodeAction());
        Collection liveContainers = applicationAttempt.getLiveContainers();
        Assert.assertEquals((long)3L, (long)liveContainers.size());
        for (RMContainer rc : liveContainers) {
            Assert.assertEquals((Object)(rc.getContainerId().equals((Object)c3) ? ExecutionType.GUARANTEED : ExecutionType.OPPORTUNISTIC), (Object)rc.getExecutionType());
        }
        currentConsumption = applicationAttempt.getCurrentConsumption();
        Assert.assertEquals((Object)Resource.newInstance((int)2048, (int)1), (Object)currentConsumption);
        allocResources = applicationAttempt.getQueue().getMetrics().getAllocatedResources();
        Assert.assertEquals((Object)Resource.newInstance((int)2048, (int)1), (Object)allocResources);
        SchedulerNode schedulerNode = this.rm.getRMContext().getScheduler().getSchedulerNode(nodeId);
        Assert.assertNotNull((Object)schedulerNode);
        Resource nodeResources = schedulerNode.getAllocatedResource();
        Assert.assertEquals((Object)Resource.newInstance((int)2048, (int)1), (Object)nodeResources);
    }

    @Test(timeout=60000L)
    public void testNodeHeartBeatResponseForUnknownContainerCleanUp() throws Exception {
        NodeHeartbeatResponse nodeHeartbeat;
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.init(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        this.rm.drainEvents();
        nm1.nodeHeartbeat(true);
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)1L, (int)1);
        ApplicationAttemptId applicationAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)applicationId, (int)1);
        ContainerId cid1 = BuilderUtils.newContainerId((ApplicationAttemptId)applicationAttemptId, (long)2L);
        ContainerId cid2 = BuilderUtils.newContainerId((ApplicationAttemptId)applicationAttemptId, (long)3L);
        ArrayList<ContainerStatus> containerStats = new ArrayList<ContainerStatus>();
        containerStats.add(ContainerStatus.newInstance((ContainerId)cid1, (ContainerState)ContainerState.COMPLETE, (String)"", (int)-1));
        containerStats.add(ContainerStatus.newInstance((ContainerId)cid2, (ContainerState)ContainerState.COMPLETE, (String)"", (int)-1));
        HashMap<ApplicationId, List<ContainerStatus>> conts = new HashMap<ApplicationId, List<ContainerStatus>>();
        conts.put(applicationAttemptId.getApplicationId(), containerStats);
        RMApp app1 = (RMApp)Mockito.mock(RMApp.class);
        Mockito.when((Object)app1.getApplicationId()).thenReturn((Object)applicationId);
        this.rm.getRMContext().getRMApps().put(applicationId, app1);
        nm1.nodeHeartbeat(conts, true);
        this.rm.drainEvents();
        int containersToBeRemovedFromNM = 0;
        do {
            nodeHeartbeat = nm1.nodeHeartbeat(true);
            this.rm.drainEvents();
        } while ((containersToBeRemovedFromNM += nodeHeartbeat.getContainersToBeRemovedFromNM().size()) != 2);
    }

    @Test
    public void testResponseIdOverflow() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        RMNode node = (RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId());
        node.getLastNodeHeartBeatResponse().setResponseId(Integer.MAX_VALUE);
        nm1.setResponseId(Integer.MAX_VALUE);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        Assert.assertEquals((long)0L, (long)nodeHeartbeat.getResponseId());
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        Assert.assertEquals((long)1L, (long)nodeHeartbeat.getResponseId());
    }
}

