/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ParameterizedSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSchedulingWithAllocationRequestId
extends ParameterizedSchedulerTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestSchedulingWithAllocationRequestId.class);
    private static final int GB = 1024;

    public TestSchedulingWithAllocationRequestId(ParameterizedSchedulerTestBase.SchedulerType type) throws IOException {
        super(type);
    }

    @Override
    public YarnConfiguration getConf() {
        YarnConfiguration conf = super.getConf();
        if (this.getSchedulerType().equals((Object)ParameterizedSchedulerTestBase.SchedulerType.FAIR)) {
            conf.setBoolean("yarn.scheduler.fair.assignmultiple", true);
        }
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testMultipleAllocationRequestIds() throws Exception {
        YarnConfiguration conf = this.getConf();
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            MockNM nm1 = rm.registerNode("127.0.0.1:1234", 4096);
            MockNM nm2 = rm.registerNode("127.0.0.2:5678", 4096);
            RMApp app1 = rm.submitApp(2048);
            nm1.nodeHeartbeat(true);
            RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
            MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
            am1.registerAppAttempt();
            am1.allocate(am1.createReq(new String[]{"127.0.0.1"}, 2048, 1, 1, 10L), null);
            am1.allocate(am1.createReq(new String[]{"127.0.0.2"}, 2048, 1, 2, 20L), null);
            AllocateResponse allocResponse = this.waitForAllocResponse(rm, am1, nm1, 1);
            List allocated = allocResponse.getAllocatedContainers();
            Assert.assertEquals((long)1L, (long)allocated.size());
            this.checkAllocatedContainer((Container)allocated.get(0), 2048, nm1.getNodeId(), 10L);
            allocResponse = this.waitForAllocResponse(rm, am1, nm2, 2);
            allocated = allocResponse.getAllocatedContainers();
            Assert.assertEquals((long)2L, (long)allocated.size());
            for (Container container : allocated) {
                this.checkAllocatedContainer(container, 2048, nm2.getNodeId(), 20L);
            }
        }
        finally {
            if (rm != null) {
                rm.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testMultipleAllocationRequestDiffPriority() throws Exception {
        YarnConfiguration conf = this.getConf();
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            MockNM nm1 = rm.registerNode("127.0.0.1:1234", 4096);
            MockNM nm2 = rm.registerNode("127.0.0.2:5678", 4096);
            RMApp app1 = rm.submitApp(2048);
            nm1.nodeHeartbeat(true);
            RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
            MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
            am1.registerAppAttempt();
            am1.allocate(am1.createReq(new String[]{"127.0.0.1"}, 2048, 2, 1, 10L), null);
            am1.allocate(am1.createReq(new String[]{"127.0.0.2"}, 2048, 1, 2, 20L), null);
            AllocateResponse allocResponse = this.waitForAllocResponse(rm, am1, nm2, 2);
            List allocated = allocResponse.getAllocatedContainers();
            Assert.assertEquals((long)2L, (long)allocated.size());
            for (Container container : allocated) {
                this.checkAllocatedContainer(container, 2048, nm2.getNodeId(), 20L);
            }
            allocResponse = this.waitForAllocResponse(rm, am1, nm1, 1);
            allocated = allocResponse.getAllocatedContainers();
            Assert.assertEquals((long)1L, (long)allocated.size());
            this.checkAllocatedContainer((Container)allocated.get(0), 2048, nm1.getNodeId(), 10L);
        }
        finally {
            if (rm != null) {
                rm.stop();
            }
        }
    }

    private void checkAllocatedContainer(Container allocated, int memory, NodeId nodeId, long allocationRequestId) {
        Assert.assertEquals((long)memory, (long)allocated.getResource().getMemorySize());
        Assert.assertEquals((Object)nodeId, (Object)allocated.getNodeId());
        Assert.assertEquals((long)allocationRequestId, (long)allocated.getAllocationRequestId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testMultipleAppsWithAllocationReqId() throws Exception {
        YarnConfiguration conf = this.getConf();
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            String host0 = "host_0";
            String host1 = "host_1";
            MockNM nm1 = new MockNM(host0 + ":1234", 8192, rm.getResourceTrackerService());
            nm1.registerNode();
            MockNM nm2 = new MockNM(host1 + ":2351", 8192, rm.getResourceTrackerService());
            nm2.registerNode();
            RMApp app1 = rm.submitApp(1024, "user_0", "a1");
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            int numContainers = 1;
            am1.allocate(am1.createReq(new String[]{host0, host1}, 1024, 1, numContainers, 5L), null);
            AllocateResponse allocResponse = this.waitForAllocResponse(rm, am1, nm1, 1);
            List allocated = allocResponse.getAllocatedContainers();
            Assert.assertEquals((long)1L, (long)allocated.size());
            this.checkAllocatedContainer((Container)allocated.get(0), 1024, nm1.getNodeId(), 5L);
            RMApp app2 = rm.submitApp(1024, "user_1", "a2");
            MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm2);
            am2.allocate(am1.createReq(new String[]{host0, host1}, 2048, 1, numContainers, 5L), null);
            allocResponse = this.waitForAllocResponse(rm, am2, nm2, 1);
            allocated = allocResponse.getAllocatedContainers();
            Assert.assertEquals((long)1L, (long)allocated.size());
            this.checkAllocatedContainer((Container)allocated.get(0), 2048, nm2.getNodeId(), 5L);
            am2.allocate(am1.createReq(new String[]{host0, host1}, 3072, 1, numContainers, 10L), null);
            allocResponse = this.waitForAllocResponse(rm, am2, nm1, 1);
            allocated = allocResponse.getAllocatedContainers();
            Assert.assertEquals((long)1L, (long)allocated.size());
            this.checkAllocatedContainer((Container)allocated.get(0), 3072, nm1.getNodeId(), 10L);
            am1.allocate(am1.createReq(new String[]{host0, host1}, 4096, 1, numContainers, 10L), null);
            allocResponse = this.waitForAllocResponse(rm, am1, nm2, 1);
            allocated = allocResponse.getAllocatedContainers();
            Assert.assertEquals((long)1L, (long)allocated.size());
            this.checkAllocatedContainer((Container)allocated.get(0), 4096, nm2.getNodeId(), 10L);
        }
        finally {
            if (rm != null) {
                rm.stop();
            }
        }
    }

    private AllocateResponse waitForAllocResponse(MockRM rm, MockAM am, MockNM nm, int size) throws Exception {
        AllocateResponse allocResponse = am.doHeartbeat();
        while (allocResponse.getAllocatedContainers().size() < size) {
            LOG.info("Waiting for containers to be created for app...");
            nm.nodeHeartbeat(true);
            ((AbstractYarnScheduler)rm.getResourceScheduler()).update();
            Thread.sleep(100L);
            allocResponse = am.doHeartbeat();
        }
        return allocResponse;
    }
}

