/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;

public class FSSchedulerConfigurationStore
extends YarnConfigurationStore {
    public static final Log LOG = LogFactory.getLog(FSSchedulerConfigurationStore.class);
    @VisibleForTesting
    protected static final Version CURRENT_VERSION_INFO = Version.newInstance((int)0, (int)1);
    private static final String TMP = ".tmp";
    private int maxVersion;
    private Path schedulerConfDir;
    private FileSystem fileSystem;
    private YarnConfigurationStore.LogMutation pendingMutation;
    private PathFilter configFilePathFilter;
    private volatile Configuration schedConf;
    private volatile Configuration oldConf;
    private Path tempConfigPath;

    @Override
    public void initialize(Configuration conf, Configuration vSchedConf, RMContext rmContext) throws Exception {
        this.configFilePathFilter = new PathFilter(){

            public boolean accept(Path path) {
                if (path == null) {
                    return false;
                }
                String pathName = path.getName();
                return pathName.startsWith("capacity-scheduler.xml") && !pathName.endsWith(FSSchedulerConfigurationStore.TMP);
            }
        };
        String schedulerConfPathStr = conf.get("yarn.scheduler.configuration.fs.path");
        if (schedulerConfPathStr == null || schedulerConfPathStr.isEmpty()) {
            throw new IOException("yarn.scheduler.configuration.fs.path must be set");
        }
        this.schedulerConfDir = new Path(schedulerConfPathStr);
        this.fileSystem = this.schedulerConfDir.getFileSystem(conf);
        this.maxVersion = conf.getInt("yarn.scheduler.configuration.max.version", 100);
        LOG.info((Object)("schedulerConfDir=" + schedulerConfPathStr));
        LOG.info((Object)("capacity scheduler file max version = " + this.maxVersion));
        if (!this.fileSystem.exists(this.schedulerConfDir) && !this.fileSystem.mkdirs(this.schedulerConfDir)) {
            throw new IOException("mkdir " + schedulerConfPathStr + " failed");
        }
        if (this.getConfigFileInputStream() == null) {
            this.writeConfigurationToFileSystem(vSchedConf);
        }
        this.schedConf = this.getConfigurationFromFileSystem();
    }

    @Override
    public void logMutation(YarnConfigurationStore.LogMutation logMutation) throws IOException {
        this.pendingMutation = logMutation;
        LOG.info((Object)new GsonBuilder().serializeNulls().create().toJson((Object)logMutation));
        this.oldConf = new Configuration(this.schedConf);
        Map<String, String> mutations = this.pendingMutation.getUpdates();
        for (Map.Entry<String, String> kv : mutations.entrySet()) {
            if (kv.getValue() == null) {
                this.schedConf.unset(kv.getKey());
                continue;
            }
            this.schedConf.set(kv.getKey(), kv.getValue());
        }
        this.tempConfigPath = this.writeTmpConfig(this.schedConf);
    }

    @Override
    public void confirmMutation(boolean isValid) throws Exception {
        if (this.pendingMutation == null || this.tempConfigPath == null) {
            LOG.warn((Object)"pendingMutation or tempConfigPath is null, do nothing");
            return;
        }
        if (isValid) {
            this.finalizeFileSystemFile();
        } else {
            this.schedConf = this.oldConf;
            this.removeTmpConfigFile();
        }
        this.tempConfigPath = null;
    }

    private void finalizeFileSystemFile() throws IOException {
        Path finalConfigPath = this.getFinalConfigPath(this.tempConfigPath);
        this.fileSystem.rename(this.tempConfigPath, finalConfigPath);
        LOG.info((Object)("finalize temp configuration file successfully, finalConfigPath=" + finalConfigPath));
    }

    private Path getFinalConfigPath(Path tempPath) {
        String tempConfigPathStr = tempPath.getName();
        if (!tempConfigPathStr.endsWith(TMP)) {
            LOG.warn((Object)(tempPath + " does not end with '" + TMP + "' return null"));
            return null;
        }
        String finalConfigPathStr = tempConfigPathStr.substring(0, tempConfigPathStr.length() - TMP.length());
        return new Path(tempPath.getParent(), finalConfigPathStr);
    }

    private void removeTmpConfigFile() throws IOException {
        this.fileSystem.delete(this.tempConfigPath, true);
        LOG.info((Object)("delete temp configuration file: " + this.tempConfigPath));
    }

    private Configuration getConfigurationFromFileSystem() throws IOException {
        long start = Time.monotonicNow();
        Configuration conf = new Configuration(false);
        InputStream configInputStream = this.getConfigFileInputStream();
        if (configInputStream == null) {
            throw new IOException("no capacity scheduler file in " + this.schedulerConfDir);
        }
        conf.addResource(configInputStream);
        Configuration result = new Configuration(false);
        for (Map.Entry entry : conf) {
            result.set((String)entry.getKey(), (String)entry.getValue());
        }
        LOG.info((Object)("upload conf from fileSystem took " + (Time.monotonicNow() - start) + " ms"));
        this.schedConf = result;
        return result;
    }

    private InputStream getConfigFileInputStream() throws IOException {
        Path lastestConfigPath = this.getLatestConfigPath();
        if (lastestConfigPath == null) {
            return null;
        }
        return this.fileSystem.open(lastestConfigPath);
    }

    private Path getLatestConfigPath() throws IOException {
        Object[] fileStatuses = this.fileSystem.listStatus(this.schedulerConfDir, this.configFilePathFilter);
        if (fileStatuses == null || fileStatuses.length == 0) {
            return null;
        }
        Arrays.sort(fileStatuses);
        return fileStatuses[fileStatuses.length - 1].getPath();
    }

    @VisibleForTesting
    private Path writeTmpConfig(Configuration vSchedConf) throws IOException {
        long start = Time.monotonicNow();
        String tempSchedulerConfigFile = "capacity-scheduler.xml." + System.currentTimeMillis() + TMP;
        Path tempSchedulerConfigPath = new Path(this.schedulerConfDir, tempSchedulerConfigFile);
        try (FSDataOutputStream outputStream = this.fileSystem.create(tempSchedulerConfigPath);){
            this.cleanConfigurationFile();
            vSchedConf.writeXml((OutputStream)outputStream);
            LOG.info((Object)("write temp capacity configuration successfully, schedulerConfigFile=" + tempSchedulerConfigPath));
        }
        catch (IOException e) {
            LOG.info((Object)("write temp capacity configuration fail, schedulerConfigFile=" + tempSchedulerConfigPath), (Throwable)e);
            throw e;
        }
        LOG.info((Object)("write temp configuration to fileSystem took " + (Time.monotonicNow() - start) + " ms"));
        return tempSchedulerConfigPath;
    }

    @VisibleForTesting
    void writeConfigurationToFileSystem(Configuration vSchedConf) throws IOException {
        this.tempConfigPath = this.writeTmpConfig(vSchedConf);
        this.finalizeFileSystemFile();
    }

    private void cleanConfigurationFile() throws IOException {
        Object[] fileStatuses = this.fileSystem.listStatus(this.schedulerConfDir, this.configFilePathFilter);
        if (fileStatuses == null || fileStatuses.length <= this.maxVersion) {
            return;
        }
        Arrays.sort(fileStatuses);
        int configFileNum = fileStatuses.length;
        if (fileStatuses.length > this.maxVersion) {
            for (int i = 0; i < configFileNum - this.maxVersion; ++i) {
                this.fileSystem.delete(fileStatuses[i].getPath(), false);
                LOG.info((Object)("delete config file " + fileStatuses[i].getPath()));
            }
        }
    }

    @Override
    public Configuration retrieve() throws IOException {
        return this.getConfigurationFromFileSystem();
    }

    @Override
    public List<YarnConfigurationStore.LogMutation> getConfirmedConfHistory(long fromId) {
        return null;
    }

    @Override
    protected Version getConfStoreVersion() throws Exception {
        return null;
    }

    @Override
    protected void storeVersion() throws Exception {
    }

    @Override
    protected Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    @Override
    public void close() throws IOException {
        if (this.fileSystem != null) {
            this.fileSystem.close();
        }
    }
}

