/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import io.hops.security.HopsUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.DateUtils;
import org.apache.hadoop.util.ExponentialBackOff;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppSecurityMaterialRenewedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityActions;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppSecurityActions;
import org.apache.hadoop.yarn.server.resourcemanager.security.X509SecurityHandler;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.junit.Assert;

public class MockX509SecurityHandler
extends X509SecurityHandler {
    private static final Logger LOG = LogManager.getLogger(MockX509SecurityHandler.class);
    private final boolean loadTrustStore;
    private final String systemTMP;
    private boolean renewalException = false;
    private long oldCertificateExpiration;

    public MockX509SecurityHandler(RMContext rmContext, RMAppSecurityManager rmAppSecurityManager, boolean loadTrustStore) {
        super(rmContext, rmAppSecurityManager);
        this.loadTrustStore = loadTrustStore;
        this.systemTMP = System.getProperty("java.io.tmpdir");
    }

    public KeyStore loadSystemTrustStore(Configuration conf) throws GeneralSecurityException, IOException {
        if (this.loadTrustStore) {
            return super.loadSystemTrustStore(conf);
        }
        KeyStore emptyTrustStore = KeyStore.getInstance("JKS");
        emptyTrustStore.load(null, null);
        return emptyTrustStore;
    }

    public X509SecurityHandler.X509SecurityManagerMaterial generateMaterial(X509SecurityHandler.X509MaterialParameter materialParameter) throws Exception {
        ApplicationId appId = materialParameter.getApplicationId();
        String appUser = materialParameter.getAppUser();
        Integer cryptoMaterialVersion = materialParameter.getCryptoMaterialVersion();
        KeyPair keyPair = this.generateKeyPair();
        PKCS10CertificationRequest csr = this.generateCSR(appId, appUser, keyPair, cryptoMaterialVersion);
        Assert.assertEquals((Object)appUser, (Object)HopsUtil.extractCNFromSubject((String)csr.getSubject().toString()));
        Assert.assertEquals((Object)appId.toString(), (Object)HopsUtil.extractOFromSubject((String)csr.getSubject().toString()));
        Assert.assertEquals((Object)String.valueOf(cryptoMaterialVersion), (Object)HopsUtil.extractOUFromSubject((String)csr.getSubject().toString()));
        X509SecurityHandler.CertificateBundle certificateBundle = this.sendCSRAndGetSigned(csr);
        certificateBundle.getCertificate().checkValidity();
        long expiration = certificateBundle.getCertificate().getNotAfter().getTime();
        long epochNow = DateUtils.localDateTime2UnixEpoch((LocalDateTime)DateUtils.getNow());
        Assert.assertTrue((expiration >= epochNow ? 1 : 0) != 0);
        Assert.assertNotNull((Object)certificateBundle.getIssuer());
        RMAppSecurityActions actor = this.getRmAppSecurityActions();
        if (actor instanceof TestingRMAppSecurityActions) {
            X509Certificate caCert = ((TestingRMAppSecurityActions)actor).getCaCert();
            certificateBundle.getCertificate().verify(caCert.getPublicKey(), "BC");
        }
        certificateBundle.getCertificate().verify(certificateBundle.getIssuer().getPublicKey(), "BC");
        X509SecurityHandler.KeyStoresWrapper appKeystores = this.createApplicationStores(certificateBundle, keyPair.getPrivate(), appUser, appId);
        X509Certificate extractedCert = (X509Certificate)appKeystores.getKeystore().getCertificate(appUser);
        byte[] rawKeystore = appKeystores.getRawKeyStore(X509SecurityHandler.TYPE.KEYSTORE);
        Assert.assertNotNull((Object)rawKeystore);
        Assert.assertNotEquals((long)0L, (long)rawKeystore.length);
        File keystoreFile = Paths.get(this.systemTMP, appUser + "-" + appId.toString() + "_kstore.jks").toFile();
        Assert.assertFalse((boolean)keystoreFile.exists());
        char[] keyStorePassword = appKeystores.getKeyStorePassword();
        Assert.assertNotNull((Object)keyStorePassword);
        Assert.assertNotEquals((long)0L, (long)keyStorePassword.length);
        byte[] rawTrustStore = appKeystores.getRawKeyStore(X509SecurityHandler.TYPE.TRUSTSTORE);
        File trustStoreFile = Paths.get(this.systemTMP, appUser + "-" + appId.toString() + "_tstore.jks").toFile();
        Assert.assertFalse((boolean)trustStoreFile.exists());
        char[] trustStorePassword = appKeystores.getTrustStorePassword();
        Assert.assertNotNull((Object)trustStorePassword);
        Assert.assertNotEquals((long)0L, (long)trustStorePassword.length);
        this.verifyContentOfAppTrustStore(rawTrustStore, trustStorePassword, appUser, appId);
        if (actor instanceof TestingRMAppSecurityActions) {
            X509Certificate caCert = ((TestingRMAppSecurityActions)actor).getCaCert();
            extractedCert.verify(caCert.getPublicKey(), "BC");
        }
        Assert.assertEquals((Object)appUser, (Object)HopsUtil.extractCNFromSubject((String)extractedCert.getSubjectX500Principal().getName()));
        Assert.assertEquals((Object)appId.toString(), (Object)HopsUtil.extractOFromSubject((String)extractedCert.getSubjectX500Principal().getName()));
        Assert.assertEquals((Object)String.valueOf(cryptoMaterialVersion), (Object)HopsUtil.extractOUFromSubject((String)extractedCert.getSubjectX500Principal().getName()));
        return new X509SecurityHandler.X509SecurityManagerMaterial(appId, rawKeystore, appKeystores.getKeyStorePassword(), rawTrustStore, appKeystores.getTrustStorePassword(), Long.valueOf(expiration));
    }

    public boolean isHopsTLSEnabled() {
        return true;
    }

    public boolean revokeMaterial(X509SecurityHandler.X509MaterialParameter materialParameter, Boolean blocking) {
        ApplicationId appId = materialParameter.getApplicationId();
        String appUser = materialParameter.getAppUser();
        Integer cryptoMaterialVersion = materialParameter.getCryptoMaterialVersion();
        try {
            if (!materialParameter.isFromRenewal()) {
                this.deregisterFromCertificateRenewer(appId);
            }
            this.putToQueue(appId, appUser, cryptoMaterialVersion);
            this.waitForQueueToDrain();
            return true;
        }
        catch (InterruptedException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            Assert.fail((String)"Exception should not be thrown here");
            return false;
        }
    }

    protected Runnable createCertificateRenewerTask(ApplicationId appId, String appUser, Integer currentCryptoVersion) {
        return new MockX509Renewer(appId, appUser, currentCryptoVersion, 1L);
    }

    public void setOldCertificateExpiration(long oldCertificateExpiration) {
        this.oldCertificateExpiration = oldCertificateExpiration;
    }

    public boolean getRenewalException() {
        return this.renewalException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyContentOfAppTrustStore(byte[] appTrustStore, char[] password, String appUser, ApplicationId appId) throws GeneralSecurityException, IOException {
        File trustStoreFile = Paths.get(this.systemTMP, appUser + "-" + appId.toString() + "_tstore.jks").toFile();
        boolean certificateMissing = false;
        try {
            KeyStore systemTrustStore = this.loadSystemTrustStore(this.getConfig());
            FileUtils.writeByteArrayToFile((File)trustStoreFile, (byte[])appTrustStore, (boolean)false);
            KeyStore ts = KeyStore.getInstance("JKS");
            try (FileInputStream fis = new FileInputStream(trustStoreFile);){
                ts.load(fis, password);
            }
            Enumeration<String> sysAliases = systemTrustStore.aliases();
            while (sysAliases.hasMoreElements()) {
                String alias = sysAliases.nextElement();
                X509Certificate appCert = (X509Certificate)ts.getCertificate(alias);
                if (appCert == null) {
                    certificateMissing = true;
                } else {
                    X509Certificate sysCert = (X509Certificate)systemTrustStore.getCertificate(alias);
                    if (Arrays.equals(sysCert.getSignature(), appCert.getSignature())) continue;
                    certificateMissing = true;
                }
                break;
            }
        }
        finally {
            FileUtils.deleteQuietly((File)trustStoreFile);
            Assert.assertFalse((boolean)certificateMissing);
        }
    }

    public static class MockFailingX509SecurityHandler
    extends X509SecurityHandler {
        private final Integer succeedAfterRetries;
        private int numberOfRenewalFailures = 0;
        private boolean renewalFailed = false;

        public MockFailingX509SecurityHandler(RMContext rmContext, RMAppSecurityManager rmAppSecurityManager, Integer succeedAfterRetries) {
            super(rmContext, rmAppSecurityManager);
            this.succeedAfterRetries = succeedAfterRetries;
        }

        public int getNumberOfRenewalFailures() {
            return this.numberOfRenewalFailures;
        }

        public boolean hasRenewalFailed() {
            return this.renewalFailed;
        }

        public boolean isHopsTLSEnabled() {
            return true;
        }

        protected Runnable createCertificateRenewerTask(ApplicationId appId, String appUser, Integer currentCryptoVersion) {
            return new MockFailingX509Renewer(appId, appUser, currentCryptoVersion, this.succeedAfterRetries);
        }

        public X509SecurityHandler.X509SecurityManagerMaterial generateMaterial(X509SecurityHandler.X509MaterialParameter materialParameter) throws Exception {
            throw new IOException("Exception is intended here");
        }

        public class MockFailingX509Renewer
        extends X509SecurityHandler.X509Renewer {
            private final Integer succeedAfterRetries;

            public MockFailingX509Renewer(ApplicationId appId, String appUser, Integer currentCryptoVersion, Integer succeedAfterRetries) {
                super((X509SecurityHandler)MockFailingX509SecurityHandler.this, appId, appUser, currentCryptoVersion);
                this.succeedAfterRetries = succeedAfterRetries;
            }

            public void run() {
                try {
                    if (((ExponentialBackOff)this.backOff).getNumberOfRetries() < this.succeedAfterRetries) {
                        throw new Exception("Ooops something went wrong");
                    }
                    MockFailingX509SecurityHandler.this.getRenewalTasks().remove(this.appId);
                    LOG.info((Object)("Renewed certificate for applicaiton " + this.appId));
                }
                catch (Exception ex) {
                    MockFailingX509SecurityHandler.this.getRenewalTasks().remove(this.appId);
                    this.backOffTime = this.backOff.getBackOffInMillis();
                    if (this.backOffTime != -1L) {
                        MockFailingX509SecurityHandler.this.numberOfRenewalFailures++;
                        LOG.warn((Object)("Failed to renew certificates for application " + this.appId + ". Retrying in " + this.backOffTime));
                        ScheduledFuture<?> task = MockFailingX509SecurityHandler.this.getRenewerScheduler().schedule((Runnable)((Object)this), this.backOffTime, TimeUnit.MILLISECONDS);
                        MockFailingX509SecurityHandler.this.getRenewalTasks().put(this.appId, task);
                    }
                    LOG.error((Object)("Failed to renew certificate for application " + this.appId + " Failed more than 4 times, giving up"));
                    MockFailingX509SecurityHandler.this.renewalFailed = true;
                }
            }
        }
    }

    public class MockX509Renewer
    extends X509SecurityHandler.X509Renewer {
        private final long oldCertificateExpiration;

        public MockX509Renewer(ApplicationId appId, String appUser, Integer currentCryptoVersion, long oldCertificateExpiration) {
            super((X509SecurityHandler)MockX509SecurityHandler.this, appId, appUser, currentCryptoVersion);
            this.oldCertificateExpiration = oldCertificateExpiration;
        }

        public void run() {
            LOG.info((Object)("Renewing certificate for application: " + this.appId));
            try {
                X509SecurityHandler.CertificateBundle certificateBundle;
                long newCertificateExpiration;
                KeyPair keyPair = MockX509SecurityHandler.this.generateKeyPair();
                int oldCryptoVersion = this.currentCryptoVersion;
                this.currentCryptoVersion = this.currentCryptoVersion + 1;
                PKCS10CertificationRequest csr = MockX509SecurityHandler.this.generateCSR(this.appId, this.appUser, keyPair, this.currentCryptoVersion);
                int newCryptoVersion = Integer.parseInt(HopsUtil.extractOUFromSubject((String)csr.getSubject().toString()));
                if (++oldCryptoVersion != newCryptoVersion) {
                    LOG.error((Object)("Crypto version of new certificate is wrong: " + newCryptoVersion));
                    MockX509SecurityHandler.this.renewalException = true;
                }
                if ((newCertificateExpiration = (certificateBundle = MockX509SecurityHandler.this.sendCSRAndGetSigned(csr)).getCertificate().getNotAfter().getTime()) <= this.oldCertificateExpiration) {
                    LOG.error((Object)"New certificate expiration is older than old certificate");
                    MockX509SecurityHandler.this.renewalException = true;
                }
                X509SecurityHandler.KeyStoresWrapper appKeystores = MockX509SecurityHandler.this.createApplicationStores(certificateBundle, keyPair.getPrivate(), this.appUser, this.appId);
                byte[] rawKeystore = appKeystores.getRawKeyStore(X509SecurityHandler.TYPE.KEYSTORE);
                byte[] rawTrustStore = appKeystores.getRawKeyStore(X509SecurityHandler.TYPE.TRUSTSTORE);
                MockX509SecurityHandler.this.getRenewalTasks().remove(this.appId);
                X509SecurityHandler.X509SecurityManagerMaterial x509Material = new X509SecurityHandler.X509SecurityManagerMaterial(this.appId, rawKeystore, appKeystores.getKeyStorePassword(), rawTrustStore, appKeystores.getTrustStorePassword(), Long.valueOf(newCertificateExpiration));
                MockX509SecurityHandler.this.getRmContext().getDispatcher().getEventHandler().handle((Event)new RMAppSecurityMaterialRenewedEvent(this.appId, (RMAppSecurityManager.SecurityManagerMaterial)x509Material));
                LOG.debug((Object)("Renewed certificate for application " + this.appId));
            }
            catch (Exception ex) {
                LOG.error((Object)"Exception while renewing certificate. THis should not have happened here :(", (Throwable)ex);
                MockX509SecurityHandler.this.renewalException = true;
            }
        }
    }
}

