/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationClientProtocolPB;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.records.DecommissionType;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.nodelabels.NodeAttributesManager;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.AttributeMappingOperationType;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeToAttributes;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodesToAttributesMappingRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshClusterMaxPriorityRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResourcesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.AddToClusterNodeLabelsRequestPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.NodeAttributeTestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.resource.DynamicResourceConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRMAdminService {
    private Configuration configuration;
    private MockRM rm = null;
    private FileSystem fs;
    private Path workingPath;
    private Path tmpDir;

    @Before
    public void setup() throws IOException {
        QueueMetrics.clearQueueMetrics();
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        this.configuration = new YarnConfiguration();
        this.configuration.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getCanonicalName());
        this.fs = FileSystem.get((Configuration)this.configuration);
        this.workingPath = new Path(new File("target", this.getClass().getSimpleName() + "-remoteDir").getAbsolutePath());
        this.configuration.set("yarn.resourcemanager.configuration.file-system-based-store", this.workingPath.toString());
        this.tmpDir = new Path(new File("target", this.getClass().getSimpleName() + "-tmpDir").getAbsolutePath());
        this.fs.delete(this.workingPath, true);
        this.fs.delete(this.tmpDir, true);
        this.fs.mkdirs(this.workingPath);
        this.fs.mkdirs(this.tmpDir);
        MockUnixGroupsMapping.resetGroups();
    }

    @After
    public void tearDown() throws IOException {
        if (this.rm != null) {
            this.rm.stop();
        }
        this.fs.delete(this.workingPath, true);
        this.fs.delete(this.tmpDir, true);
    }

    @Test
    public void testAdminRefreshQueuesWithLocalConfigurationProvider() throws IOException, YarnException {
        this.rm = new MockRM(this.configuration);
        this.rm.init(this.configuration);
        this.rm.start();
        CapacityScheduler cs = (CapacityScheduler)this.rm.getRMContext().getScheduler();
        int maxAppsBefore = cs.getConfiguration().getMaximumSystemApplications();
        try {
            this.rm.adminService.refreshQueues(RefreshQueuesRequest.newInstance());
            Assert.assertEquals((long)maxAppsBefore, (long)cs.getConfiguration().getMaximumSystemApplications());
        }
        catch (Exception ex) {
            Assert.fail((String)"Using localConfigurationProvider. Should not get any exception.");
        }
    }

    @Test
    public void testAdminRefreshQueuesWithFileSystemBasedConfigurationProvider() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        CapacityScheduler cs = (CapacityScheduler)this.rm.getRMContext().getScheduler();
        int maxAppsBefore = cs.getConfiguration().getMaximumSystemApplications();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.set("yarn.scheduler.capacity.maximum-applications", "5000");
        this.uploadConfiguration((Configuration)csConf, "capacity-scheduler.xml");
        this.rm.adminService.refreshQueues(RefreshQueuesRequest.newInstance());
        int maxAppsAfter = cs.getConfiguration().getMaximumSystemApplications();
        Assert.assertEquals((long)maxAppsAfter, (long)5000L);
        Assert.assertTrue((maxAppsAfter != maxAppsBefore ? 1 : 0) != 0);
    }

    @Test
    public void testAdminRefreshQueuesWithMutableSchedulerConfiguration() {
        this.configuration.set("yarn.scheduler.configuration.store.class", "memory");
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        try {
            this.rm.adminService.refreshQueues(RefreshQueuesRequest.newInstance());
            Assert.fail((String)"Expected exception while calling refreshQueues when scheduler configuration is mutable.");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)ex.getMessage().endsWith("Scheduler configuration is mutable. refreshQueues is not allowed in this scenario."));
        }
    }

    @Test
    public void testAdminRefreshNodesWithoutConfiguration() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        try {
            this.rm.adminService.refreshNodesResources(RefreshNodesResourcesRequest.newInstance());
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions even when no configurations are done for node resources refresh");
        }
    }

    @Test
    public void testRefreshNodesResourceWithFileSystemBasedConfigurationProvider() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
            this.rm.registerNode("h1:1234", 5120);
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        NodeId nid = NodeId.fromString((String)"h1:1234");
        RMNode ni = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        Resource resource = ni.getTotalCapability();
        Assert.assertEquals((Object)"<memory:5120, vCores:5>", (Object)resource.toString());
        DynamicResourceConfiguration drConf = new DynamicResourceConfiguration();
        drConf.set("yarn.resource.dynamic.nodes", "h1:1234");
        drConf.set("yarn.resource.dynamic.h1:1234.vcores", "4");
        drConf.set("yarn.resource.dynamic.h1:1234.memory", "4096");
        this.uploadConfiguration((Configuration)drConf, "dynamic-resources.xml");
        this.rm.adminService.refreshNodesResources(RefreshNodesResourcesRequest.newInstance());
        this.rm.drainEvents();
        RMNode niAfter = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        Resource resourceAfter = niAfter.getTotalCapability();
        Assert.assertEquals((Object)"<memory:4096, vCores:4>", (Object)resourceAfter.toString());
    }

    @Test
    public void testRefreshNodesResourceWithResourceReturnInRegistration() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        MockNM nm = null;
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
            nm = this.rm.registerNode("h1:1234", 2048, 2);
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        NodeId nid = NodeId.fromString((String)"h1:1234");
        RMNode ni = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        Resource resource = ni.getTotalCapability();
        Assert.assertEquals((Object)"<memory:2048, vCores:2>", (Object)resource.toString());
        DynamicResourceConfiguration drConf = new DynamicResourceConfiguration();
        drConf.set("yarn.resource.dynamic.nodes", "h1:1234");
        drConf.set("yarn.resource.dynamic.h1:1234.vcores", "4");
        drConf.set("yarn.resource.dynamic.h1:1234.memory", "4096");
        this.uploadConfiguration((Configuration)drConf, "dynamic-resources.xml");
        this.rm.adminService.refreshNodesResources(RefreshNodesResourcesRequest.newInstance());
        try {
            nm.registerNode();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        RMNode niAfter = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        Resource resourceAfter = niAfter.getTotalCapability();
        Assert.assertEquals((Object)"<memory:4096, vCores:4>", (Object)resourceAfter.toString());
        Assert.assertEquals((long)4096L, (long)nm.getMemory());
        Assert.assertEquals((long)4L, (long)nm.getvCores());
    }

    @Test
    public void testRefreshNodesResourceWithResourceReturnInHeartbeat() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        MockNM nm = null;
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
            nm = this.rm.registerNode("h1:1234", 2048, 2);
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        NodeId nid = NodeId.fromString((String)"h1:1234");
        RMNode ni = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        Resource resource = ni.getTotalCapability();
        Assert.assertEquals((Object)"<memory:2048, vCores:2>", (Object)resource.toString());
        DynamicResourceConfiguration drConf = new DynamicResourceConfiguration();
        drConf.set("yarn.resource.dynamic.nodes", "h1:1234");
        drConf.set("yarn.resource.dynamic.h1:1234.vcores", "4");
        drConf.set("yarn.resource.dynamic.h1:1234.memory", "4096");
        this.uploadConfiguration((Configuration)drConf, "dynamic-resources.xml");
        this.rm.adminService.refreshNodesResources(RefreshNodesResourcesRequest.newInstance());
        try {
            nm.nodeHeartbeat(true);
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        RMNode niAfter = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        Resource resourceAfter = niAfter.getTotalCapability();
        Assert.assertEquals((Object)"<memory:4096, vCores:4>", (Object)resourceAfter.toString());
        Assert.assertEquals((long)4096L, (long)nm.getMemory());
        Assert.assertEquals((long)4L, (long)nm.getvCores());
    }

    @Test
    public void testResourcePersistentForNMRegistrationWithNewResource() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
            this.rm.registerNode("h1:1234", 5120);
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        NodeId nid = NodeId.fromString((String)"h1:1234");
        RMNode ni = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        Resource resource = ni.getTotalCapability();
        Assert.assertEquals((Object)"<memory:5120, vCores:5>", (Object)resource.toString());
        DynamicResourceConfiguration drConf = new DynamicResourceConfiguration();
        drConf.set("yarn.resource.dynamic.nodes", "h1:1234");
        drConf.set("yarn.resource.dynamic.h1:1234.vcores", "4");
        drConf.set("yarn.resource.dynamic.h1:1234.memory", "4096");
        this.uploadConfiguration((Configuration)drConf, "dynamic-resources.xml");
        this.rm.adminService.refreshNodesResources(RefreshNodesResourcesRequest.newInstance());
        try {
            this.rm.registerNode("h1:1234", 8192, 8);
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        RMNode niAfter = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        Resource resourceAfter = niAfter.getTotalCapability();
        Assert.assertEquals((Object)"<memory:4096, vCores:4>", (Object)resourceAfter.toString());
        this.deleteOnRemoteFileSystem("dynamic-resources.xml");
        DynamicResourceConfiguration emptyDRConf = new DynamicResourceConfiguration();
        this.uploadConfiguration((Configuration)emptyDRConf, "dynamic-resources.xml");
        this.rm.adminService.refreshNodesResources(RefreshNodesResourcesRequest.newInstance());
        try {
            this.rm.registerNode("h1:1234", 8192, 8);
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        niAfter = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        resourceAfter = niAfter.getTotalCapability();
        Assert.assertEquals((Object)"<memory:8192, vCores:8>", (Object)resourceAfter.toString());
    }

    @Test
    public void testAdminAclsWithLocalConfigurationProvider() {
        this.rm = new MockRM(this.configuration);
        this.rm.init(this.configuration);
        this.rm.start();
        try {
            this.rm.adminService.refreshAdminAcls(RefreshAdminAclsRequest.newInstance());
        }
        catch (Exception ex) {
            Assert.fail((String)"Using localConfigurationProvider. Should not get any exception.");
        }
    }

    @Test
    public void testAdminAclsWithFileSystemBasedConfigurationProvider() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        String aclStringBefore = this.rm.adminService.getAccessControlList().getAclString().trim();
        YarnConfiguration yarnConf = new YarnConfiguration();
        yarnConf.set("yarn.admin.acl", "world:anyone:rwcda");
        this.uploadConfiguration((Configuration)yarnConf, "yarn-site.xml");
        this.rm.adminService.refreshAdminAcls(RefreshAdminAclsRequest.newInstance());
        String aclStringAfter = this.rm.adminService.getAccessControlList().getAclString().trim();
        Assert.assertTrue((!aclStringAfter.equals(aclStringBefore) ? 1 : 0) != 0);
        Assert.assertEquals((Object)aclStringAfter, (Object)("world:anyone:rwcda," + UserGroupInformation.getCurrentUser().getShortUserName()));
    }

    @Test
    public void testServiceAclsRefreshWithLocalConfigurationProvider() {
        this.configuration.setBoolean("hadoop.security.authorization", true);
        ResourceManager resourceManager = null;
        try {
            resourceManager = new ResourceManager();
            resourceManager.init(this.configuration);
            resourceManager.start();
            resourceManager.adminService.refreshServiceAcls(RefreshServiceAclsRequest.newInstance());
        }
        catch (Exception ex) {
            Assert.fail((String)"Using localConfigurationProvider. Should not get any exception.");
        }
        finally {
            if (resourceManager != null) {
                resourceManager.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServiceAclsRefreshWithFileSystemBasedConfigurationProvider() throws IOException, YarnException {
        this.configuration.setBoolean("hadoop.security.authorization", true);
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        ResourceManager resourceManager = null;
        try {
            this.uploadDefaultConfiguration();
            Configuration conf = new Configuration();
            conf.setBoolean("hadoop.security.authorization", true);
            this.uploadConfiguration(conf, "core-site.xml");
            try {
                resourceManager = new ResourceManager();
                resourceManager.init(this.configuration);
                resourceManager.start();
            }
            catch (Exception ex) {
                Assert.fail((String)"Should not get any exceptions");
            }
            String aclsString = "alice,bob users,wheel";
            Configuration newConf = new Configuration();
            newConf.set("security.applicationclient.protocol.acl", aclsString);
            this.uploadConfiguration(newConf, "hadoop-policy.xml");
            resourceManager.adminService.refreshServiceAcls(RefreshServiceAclsRequest.newInstance());
            ServiceAuthorizationManager adminServiceServiceManager = resourceManager.adminService.getServer().getServiceAuthorizationManager();
            this.verifyServiceACLsRefresh(adminServiceServiceManager, ApplicationClientProtocolPB.class, aclsString);
            ServiceAuthorizationManager clientRMServiceServiceManager = resourceManager.getRMContext().getClientRMService().getServer().getServiceAuthorizationManager();
            this.verifyServiceACLsRefresh(clientRMServiceServiceManager, ApplicationClientProtocolPB.class, aclsString);
            ServiceAuthorizationManager appMasterService = resourceManager.getRMContext().getApplicationMasterService().getServer().getServiceAuthorizationManager();
            this.verifyServiceACLsRefresh(appMasterService, ApplicationClientProtocolPB.class, aclsString);
            ServiceAuthorizationManager RTService = resourceManager.getRMContext().getResourceTrackerService().getServer().getServiceAuthorizationManager();
            this.verifyServiceACLsRefresh(RTService, ApplicationClientProtocolPB.class, aclsString);
        }
        finally {
            if (resourceManager != null) {
                resourceManager.stop();
            }
        }
    }

    private void verifyServiceACLsRefresh(ServiceAuthorizationManager manager, Class<?> protocol, String aclString) {
        for (Class protocolClass : manager.getProtocolsWithAcls()) {
            AccessControlList accessList = manager.getProtocolsAcls(protocolClass);
            if (protocolClass == protocol) {
                Assert.assertEquals((Object)accessList.getAclString(), (Object)aclString);
                continue;
            }
            Assert.assertEquals((Object)accessList.getAclString(), (Object)"*");
        }
    }

    @Test
    public void testRefreshSuperUserGroupsWithLocalConfigurationProvider() {
        this.rm = new MockRM(this.configuration);
        this.rm.init(this.configuration);
        this.rm.start();
        try {
            this.rm.adminService.refreshSuperUserGroupsConfiguration(RefreshSuperUserGroupsConfigurationRequest.newInstance());
        }
        catch (Exception ex) {
            Assert.fail((String)"Using localConfigurationProvider. Should not get any exception.");
        }
    }

    @Test
    public void testRefreshSuperUserGroupsWithFileSystemBasedConfigurationProvider() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        Configuration coreConf = new Configuration(false);
        coreConf.set("hadoop.proxyuser.test.groups", "test_groups");
        coreConf.set("hadoop.proxyuser.test.hosts", "test_hosts");
        this.uploadConfiguration(coreConf, "core-site.xml");
        this.rm.adminService.refreshSuperUserGroupsConfiguration(RefreshSuperUserGroupsConfigurationRequest.newInstance());
        Assert.assertTrue((((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyGroups().get("hadoop.proxyuser.test.groups")).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyGroups().get("hadoop.proxyuser.test.groups")).contains("test_groups"));
        Assert.assertTrue((((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyHosts().get("hadoop.proxyuser.test.hosts")).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyHosts().get("hadoop.proxyuser.test.hosts")).contains("test_hosts"));
        Configuration yarnConf = new Configuration(false);
        yarnConf.set("yarn.resourcemanager.proxyuser.test.groups", "test_groups_1");
        yarnConf.set("yarn.resourcemanager.proxyuser.test.hosts", "test_hosts_1");
        this.uploadConfiguration(yarnConf, "yarn-site.xml");
        this.rm.adminService.refreshSuperUserGroupsConfiguration(RefreshSuperUserGroupsConfigurationRequest.newInstance());
        Assert.assertTrue((((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyGroups().get("hadoop.proxyuser.test.groups")).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyGroups().get("hadoop.proxyuser.test.groups")).contains("test_groups_1"));
        Assert.assertTrue((((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyHosts().get("hadoop.proxyuser.test.hosts")).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyHosts().get("hadoop.proxyuser.test.hosts")).contains("test_hosts_1"));
    }

    @Test
    public void testRefreshUserToGroupsMappingsWithLocalConfigurationProvider() {
        this.rm = new MockRM(this.configuration);
        this.rm.init(this.configuration);
        this.rm.start();
        try {
            this.rm.adminService.refreshUserToGroupsMappings(RefreshUserToGroupsMappingsRequest.newInstance());
        }
        catch (Exception ex) {
            Assert.fail((String)"Using localConfigurationProvider. Should not get any exception.");
        }
    }

    @Test
    public void testRefreshUserToGroupsMappingsWithFileSystemBasedConfigurationProvider() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        String[] defaultTestUserGroups = new String[]{"dummy_group1", "dummy_group2"};
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"dummyUser", (String[])defaultTestUserGroups);
        String user = ugi.getUserName();
        ArrayList<String> groupWithInit = new ArrayList<String>(2);
        for (int i = 0; i < ugi.getGroupNames().length; ++i) {
            groupWithInit.add(ugi.getGroupNames()[i]);
        }
        this.uploadDefaultConfiguration();
        Configuration conf = new Configuration();
        conf.setClass("hadoop.security.group.mapping", MockUnixGroupsMapping.class, GroupMappingServiceProvider.class);
        this.uploadConfiguration(conf, "core-site.xml");
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        Groups.getUserToGroupsMappingServiceWithLoadedConfiguration((Configuration)conf).refresh();
        ArrayList groupBefore = new ArrayList(Groups.getUserToGroupsMappingService((Configuration)this.configuration).getGroups(user));
        Assert.assertTrue((groupBefore.contains("test_group_A") && groupBefore.contains("test_group_B") && groupBefore.contains("test_group_C") && groupBefore.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((groupWithInit.size() != groupBefore.size() ? 1 : 0) != 0);
        Assert.assertFalse((groupWithInit.contains("test_group_A") || groupWithInit.contains("test_group_B") || groupWithInit.contains("test_group_C") ? 1 : 0) != 0);
        MockUnixGroupsMapping.updateGroups();
        this.rm.adminService.refreshUserToGroupsMappings(RefreshUserToGroupsMappingsRequest.newInstance());
        List groupAfter = Groups.getUserToGroupsMappingService((Configuration)this.configuration).getGroups(user);
        Assert.assertTrue((groupAfter.contains("test_group_D") && groupAfter.contains("test_group_E") && groupAfter.contains("test_group_F") && groupAfter.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testRefreshNodesWithLocalConfigurationProvider() {
        this.rm = new MockRM(this.configuration);
        this.rm.init(this.configuration);
        this.rm.start();
        try {
            this.rm.adminService.refreshNodes(RefreshNodesRequest.newInstance((DecommissionType)DecommissionType.NORMAL));
        }
        catch (Exception ex) {
            Assert.fail((String)"Using localConfigurationProvider. Should not get any exception.");
        }
    }

    @Test
    public void testRefreshNodesWithFileSystemBasedConfigurationProvider() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        File excludeHostsFile = new File(this.tmpDir.toString(), "excludeHosts");
        if (excludeHostsFile.exists()) {
            excludeHostsFile.delete();
        }
        if (!excludeHostsFile.createNewFile()) {
            Assert.fail((String)"Can not create excludeHosts");
        }
        PrintWriter fileWriter = new PrintWriter(excludeHostsFile);
        fileWriter.write("0.0.0.0:123");
        fileWriter.close();
        this.uploadToRemoteFileSystem(new Path(excludeHostsFile.getAbsolutePath()));
        YarnConfiguration yarnConf = new YarnConfiguration();
        yarnConf.set("yarn.resourcemanager.nodes.exclude-path", this.workingPath + "/excludeHosts");
        this.uploadConfiguration((Configuration)yarnConf, "yarn-site.xml");
        this.rm.adminService.refreshNodes(RefreshNodesRequest.newInstance((DecommissionType)DecommissionType.NORMAL));
        Set excludeHosts = this.rm.getNodesListManager().getHostsReader().getExcludedHosts();
        Assert.assertTrue((excludeHosts.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)excludeHosts.contains("0.0.0.0:123"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRMHAWithFileSystemBasedConfiguration() throws IOException, YarnException {
        HAServiceProtocol.StateChangeRequestInfo requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        this.updateConfigurationForRMHA();
        Configuration conf1 = new Configuration(this.configuration);
        conf1.set("yarn.resourcemanager.ha.id", "rm1");
        Configuration conf2 = new Configuration(this.configuration);
        conf2.set("yarn.resourcemanager.ha.id", "rm2");
        this.uploadDefaultConfiguration();
        MockRM rm1 = null;
        MockRM rm2 = null;
        try {
            rm1 = new MockRM(conf1);
            rm1.init(conf1);
            rm1.start();
            Assert.assertTrue((rm1.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.STANDBY ? 1 : 0) != 0);
            rm2 = new MockRM(conf2);
            rm2.init(conf1);
            rm2.start();
            Assert.assertTrue((rm2.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.STANDBY ? 1 : 0) != 0);
            rm1.adminService.transitionToActive(requestInfo);
            Assert.assertTrue((rm1.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.ACTIVE ? 1 : 0) != 0);
            CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
            csConf.set("yarn.scheduler.capacity.maximum-applications", "5000");
            this.uploadConfiguration((Configuration)csConf, "capacity-scheduler.xml");
            rm1.adminService.refreshQueues(RefreshQueuesRequest.newInstance());
            int maxApps = ((CapacityScheduler)rm1.getRMContext().getScheduler()).getConfiguration().getMaximumSystemApplications();
            Assert.assertEquals((long)maxApps, (long)5000L);
            int maxAppsBeforeFailOver = ((CapacityScheduler)rm2.getRMContext().getScheduler()).getConfiguration().getMaximumSystemApplications();
            Assert.assertEquals((long)maxAppsBeforeFailOver, (long)10000L);
            rm1.adminService.transitionToStandby(requestInfo);
            rm2.adminService.transitionToActive(requestInfo);
            Assert.assertTrue((rm1.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.STANDBY ? 1 : 0) != 0);
            Assert.assertTrue((rm2.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.ACTIVE ? 1 : 0) != 0);
            int maxAppsAfter = ((CapacityScheduler)rm2.getRMContext().getScheduler()).getConfiguration().getMaximumSystemApplications();
            Assert.assertEquals((long)maxAppsAfter, (long)5000L);
        }
        finally {
            if (rm1 != null) {
                rm1.stop();
            }
            if (rm2 != null) {
                rm2.stop();
            }
        }
    }

    @Ignore
    @Test
    public void testHAConfWithoutLeaderElection() {
        Configuration conf = new Configuration(this.configuration);
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        int base = 100;
        for (String confKey : YarnConfiguration.getServiceAddressConfKeys((Configuration)this.configuration)) {
            conf.set(HAUtil.addSuffix((String)confKey, (String)"rm1"), "0.0.0.0:" + (base + 20));
            conf.set(HAUtil.addSuffix((String)confKey, (String)"rm2"), "0.0.0.0:" + (base + 40));
            base *= 2;
        }
        conf.set("yarn.resourcemanager.ha.id", "rm1");
        this.checkBadConfiguration(conf);
    }

    @Test
    public void testHAConfWithSingleRMID() {
        Configuration conf = new Configuration(this.configuration);
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1");
        int base = 100;
        for (String confKey : YarnConfiguration.getServiceAddressConfKeys((Configuration)this.configuration)) {
            conf.set(HAUtil.addSuffix((String)confKey, (String)"rm1"), "0.0.0.0:" + (base + 20));
            base *= 2;
        }
        conf.set("yarn.resourcemanager.ha.id", "rm1");
        this.checkBadConfiguration(conf);
    }

    @Test
    public void testHAConfWithoutServiceInfo() {
        Configuration conf = new Configuration(this.configuration);
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        conf.set("yarn.resourcemanager.ha.id", "rm1");
        this.checkBadConfiguration(conf);
    }

    @Test
    public void testRMStartsWithoutConfigurationFilesProvided() {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRMInitialsWithFileSystemBasedConfigurationProvider() throws Exception {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        File excludeHostsFile = new File(this.tmpDir.toString(), "excludeHosts");
        if (excludeHostsFile.exists()) {
            excludeHostsFile.delete();
        }
        if (!excludeHostsFile.createNewFile()) {
            Assert.fail((String)"Can not create excludeHosts");
        }
        PrintWriter fileWriter = new PrintWriter(excludeHostsFile);
        fileWriter.write("0.0.0.0:123");
        fileWriter.close();
        this.uploadToRemoteFileSystem(new Path(excludeHostsFile.getAbsolutePath()));
        YarnConfiguration yarnConf = new YarnConfiguration();
        yarnConf.set("yarn.admin.acl", "world:anyone:rwcda");
        yarnConf.set("yarn.resourcemanager.nodes.exclude-path", this.workingPath + "/excludeHosts");
        this.uploadConfiguration((Configuration)yarnConf, "yarn-site.xml");
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.set("yarn.scheduler.capacity.maximum-applications", "5000");
        this.uploadConfiguration((Configuration)csConf, "capacity-scheduler.xml");
        String aclsString = "alice,bob users,wheel";
        Configuration newConf = new Configuration();
        newConf.set("security.applicationclient.protocol.acl", aclsString);
        this.uploadConfiguration(newConf, "hadoop-policy.xml");
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.security.authorization", true);
        conf.set("hadoop.proxyuser.test.groups", "test_groups");
        conf.set("hadoop.proxyuser.test.hosts", "test_hosts");
        conf.setClass("hadoop.security.group.mapping", MockUnixGroupsMapping.class, GroupMappingServiceProvider.class);
        this.uploadConfiguration(conf, "core-site.xml");
        MockUnixGroupsMapping.updateGroups();
        ResourceManager resourceManager = null;
        try {
            try {
                resourceManager = new ResourceManager();
                resourceManager.init(this.configuration);
                resourceManager.start();
            }
            catch (Exception ex) {
                Assert.fail((String)"Should not get any exceptions");
            }
            Set excludeHosts = resourceManager.getRMContext().getNodesListManager().getHostsReader().getExcludedHosts();
            Assert.assertTrue((excludeHosts.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)excludeHosts.contains("0.0.0.0:123"));
            String aclStringAfter = resourceManager.adminService.getAccessControlList().getAclString().trim();
            Assert.assertEquals((Object)aclStringAfter, (Object)("world:anyone:rwcda," + UserGroupInformation.getCurrentUser().getShortUserName()));
            CapacityScheduler cs = (CapacityScheduler)resourceManager.getRMContext().getScheduler();
            int maxAppsAfter = cs.getConfiguration().getMaximumSystemApplications();
            Assert.assertEquals((long)maxAppsAfter, (long)5000L);
            ServiceAuthorizationManager adminServiceServiceManager = resourceManager.adminService.getServer().getServiceAuthorizationManager();
            this.verifyServiceACLsRefresh(adminServiceServiceManager, ApplicationClientProtocolPB.class, aclsString);
            ServiceAuthorizationManager clientRMServiceServiceManager = resourceManager.getRMContext().getClientRMService().getServer().getServiceAuthorizationManager();
            this.verifyServiceACLsRefresh(clientRMServiceServiceManager, ApplicationClientProtocolPB.class, aclsString);
            ServiceAuthorizationManager appMasterService = resourceManager.getRMContext().getApplicationMasterService().getServer().getServiceAuthorizationManager();
            this.verifyServiceACLsRefresh(appMasterService, ApplicationClientProtocolPB.class, aclsString);
            ServiceAuthorizationManager RTService = resourceManager.getRMContext().getResourceTrackerService().getServer().getServiceAuthorizationManager();
            this.verifyServiceACLsRefresh(RTService, ApplicationClientProtocolPB.class, aclsString);
            ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.configuration);
            Assert.assertTrue((((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyGroups().get("hadoop.proxyuser.test.groups")).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyGroups().get("hadoop.proxyuser.test.groups")).contains("test_groups"));
            Assert.assertTrue((((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyHosts().get("hadoop.proxyuser.test.hosts")).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyHosts().get("hadoop.proxyuser.test.hosts")).contains("test_hosts"));
            Groups.getUserToGroupsMappingServiceWithLoadedConfiguration((Configuration)conf).refresh();
            List groupAfter = Groups.getUserToGroupsMappingService((Configuration)this.configuration).getGroups(UserGroupInformation.getCurrentUser().getUserName());
            Assert.assertTrue((groupAfter.contains("test_group_D") && groupAfter.contains("test_group_E") && groupAfter.contains("test_group_F") && groupAfter.size() == 3 ? 1 : 0) != 0);
        }
        finally {
            if (resourceManager != null) {
                resourceManager.stop();
            }
        }
    }

    @Test
    public void testRefreshAclWithDaemonUser() throws Exception {
        String daemonUser = UserGroupInformation.getCurrentUser().getShortUserName();
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        YarnConfiguration yarnConf = new YarnConfiguration();
        yarnConf.set("yarn.admin.acl", daemonUser + "xyz");
        this.uploadConfiguration((Configuration)yarnConf, "yarn-site.xml");
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        Assert.assertEquals((Object)(daemonUser + "xyz," + daemonUser), (Object)this.rm.adminService.getAccessControlList().getAclString().trim());
        yarnConf = new YarnConfiguration();
        yarnConf.set("yarn.admin.acl", daemonUser + "abc");
        this.uploadConfiguration((Configuration)yarnConf, "yarn-site.xml");
        try {
            this.rm.adminService.refreshAdminAcls(RefreshAdminAclsRequest.newInstance());
        }
        catch (YarnException e) {
            if (e.getCause() != null && e.getCause() instanceof AccessControlException) {
                Assert.fail((String)"Refresh should not have failed due to incorrect ACL");
            }
            throw e;
        }
        Assert.assertEquals((Object)(daemonUser + "abc," + daemonUser), (Object)this.rm.adminService.getAccessControlList().getAclString().trim());
    }

    @Test
    public void testModifyLabelsOnNodesWithDistributedConfigurationDisabled() throws IOException, YarnException {
        MockRM rm = new MockRM();
        ((RMContextImpl)rm.getRMContext()).setHAServiceState(HAServiceProtocol.HAServiceState.ACTIVE);
        RMNodeLabelsManager labelMgr = rm.rmContext.getNodeLabelManager();
        labelMgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        rm.adminService.replaceLabelsOnNode(ReplaceLabelsOnNodeRequest.newInstance((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host", (int)0), (Object)ImmutableSet.of((Object)"x"))));
        rm.close();
    }

    @Test(expected=YarnException.class)
    public void testModifyLabelsOnNodesWithCentralizedConfigurationDisabled() throws IOException, YarnException {
        MockRM rm = new MockRM();
        rm.adminService.isCentralizedNodeLabelConfiguration = false;
        ((RMContextImpl)rm.getRMContext()).setHAServiceState(HAServiceProtocol.HAServiceState.ACTIVE);
        RMNodeLabelsManager labelMgr = rm.rmContext.getNodeLabelManager();
        labelMgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        rm.adminService.replaceLabelsOnNode(ReplaceLabelsOnNodeRequest.newInstance((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host", (int)0), (Object)ImmutableSet.of((Object)"x"))));
        rm.close();
    }

    @Test
    public void testModifyLabelsOnUnknownNodes() throws IOException, YarnException {
        this.rm = new MockRM();
        ((RMContextImpl)this.rm.getRMContext()).setHAServiceState(HAServiceProtocol.HAServiceState.ACTIVE);
        this.setActiveAndInactiveNodes(this.rm);
        RMNodeLabelsManager labelMgr = this.rm.rmContext.getNodeLabelManager();
        labelMgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        ReplaceLabelsOnNodeRequest request1 = ReplaceLabelsOnNodeRequest.newInstance((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host1", (int)1111), (Object)ImmutableSet.of((Object)"x")));
        request1.setFailOnUnknownNodes(true);
        try {
            this.rm.adminService.replaceLabelsOnNode(request1);
        }
        catch (Exception ex) {
            Assert.fail((String)"should not fail on known node");
        }
        ReplaceLabelsOnNodeRequest request2 = ReplaceLabelsOnNodeRequest.newInstance((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host1", (int)0), (Object)ImmutableSet.of((Object)"x")));
        request2.setFailOnUnknownNodes(true);
        try {
            this.rm.adminService.replaceLabelsOnNode(request2);
        }
        catch (Exception ex) {
            Assert.fail((String)"should not fail on known node");
        }
        ReplaceLabelsOnNodeRequest request3 = ReplaceLabelsOnNodeRequest.newInstance((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host5", (int)0), (Object)ImmutableSet.of((Object)"x")));
        request3.setFailOnUnknownNodes(true);
        try {
            this.rm.adminService.replaceLabelsOnNode(request3);
            Assert.fail((String)"Should fail on unknown node");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ReplaceLabelsOnNodeRequest request4 = ReplaceLabelsOnNodeRequest.newInstance((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host2", (int)1111), (Object)ImmutableSet.of((Object)"x")));
        request4.setFailOnUnknownNodes(true);
        try {
            this.rm.adminService.replaceLabelsOnNode(request4);
            Assert.fail((String)"Should fail on node with wrong port");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ReplaceLabelsOnNodeRequest request5 = ReplaceLabelsOnNodeRequest.newInstance((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host5", (int)0), (Object)ImmutableSet.of((Object)"x")));
        request5.setFailOnUnknownNodes(false);
        try {
            this.rm.adminService.replaceLabelsOnNode(request5);
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not fail on unknown node when fail-on-unkown-nodes is set false");
        }
        ReplaceLabelsOnNodeRequest request6 = ReplaceLabelsOnNodeRequest.newInstance((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host4", (int)0), (Object)ImmutableSet.of((Object)"x")));
        request6.setFailOnUnknownNodes(true);
        try {
            this.rm.adminService.replaceLabelsOnNode(request6);
        }
        catch (Exception ex) {
            Assert.fail((String)"should not fail on inactive node");
        }
        this.rm.close();
    }

    @Test
    public void testRemoveClusterNodeLabelsWithCentralizedConfigurationDisabled() throws IOException, YarnException {
        MockRM rm = new MockRM();
        ((RMContextImpl)rm.getRMContext()).setHAServiceState(HAServiceProtocol.HAServiceState.ACTIVE);
        RMNodeLabelsManager labelMgr = rm.rmContext.getNodeLabelManager();
        rm.adminService.isCentralizedNodeLabelConfiguration = false;
        labelMgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        rm.adminService.removeFromClusterNodeLabels(RemoveFromClusterNodeLabelsRequest.newInstance((Set)ImmutableSet.of((Object)"x")));
        Set clusterNodeLabels = labelMgr.getClusterNodeLabelNames();
        Assert.assertEquals((long)1L, (long)clusterNodeLabels.size());
        rm.close();
    }

    @Test(timeout=30000L)
    public void testAdminRefreshClusterMaxPriority() throws Exception, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        YarnConfiguration yarnConf = new YarnConfiguration();
        yarnConf.set("yarn.cluster.max-application-priority", "5");
        this.uploadConfiguration((Configuration)yarnConf, "yarn-site.xml");
        this.rm = new MockRM(this.configuration);
        this.rm.init(this.configuration);
        this.rm.start();
        CapacityScheduler cs = (CapacityScheduler)this.rm.getRMContext().getScheduler();
        Assert.assertEquals((long)5L, (long)cs.getMaxClusterLevelAppPriority().getPriority());
        yarnConf = new YarnConfiguration();
        yarnConf.set("yarn.cluster.max-application-priority", "10");
        this.uploadConfiguration((Configuration)yarnConf, "yarn-site.xml");
        try {
            this.rm.adminService.refreshClusterMaxPriority(RefreshClusterMaxPriorityRequest.newInstance());
            Assert.assertEquals((long)10L, (long)cs.getMaxClusterLevelAppPriority().getPriority());
        }
        catch (Exception ex) {
            Assert.fail((String)"Could not refresh cluster max priority.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeConfigurationXML(Configuration conf, String confXMLName) throws IOException {
        try (FilterOutputStream output = null;){
            File confFile = new File(this.tmpDir.toString(), confXMLName);
            if (confFile.exists()) {
                confFile.delete();
            }
            if (!confFile.createNewFile()) {
                Assert.fail((String)("Can not create " + confXMLName));
            }
            output = new DataOutputStream(new FileOutputStream(confFile));
            conf.writeXml((OutputStream)output);
            String string = confFile.getAbsolutePath();
            return string;
        }
    }

    private void uploadToRemoteFileSystem(Path filePath) throws IOException {
        this.fs.copyFromLocalFile(filePath, this.workingPath);
    }

    private void uploadConfiguration(Configuration conf, String confFileName) throws IOException {
        String csConfFile = this.writeConfigurationXML(conf, confFileName);
        this.uploadToRemoteFileSystem(new Path(csConfFile));
    }

    private void deleteOnRemoteFileSystem(String fileName) throws IOException {
        this.fs.delete(new Path(this.workingPath, fileName));
    }

    private void uploadDefaultConfiguration() throws IOException {
        Configuration conf = new Configuration();
        this.uploadConfiguration(conf, "core-site.xml");
        YarnConfiguration yarnConf = new YarnConfiguration();
        yarnConf.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadConfiguration((Configuration)yarnConf, "yarn-site.xml");
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.uploadConfiguration((Configuration)csConf, "capacity-scheduler.xml");
        Configuration hadoopPolicyConf = new Configuration(false);
        hadoopPolicyConf.addResource("hadoop-policy.xml");
        this.uploadConfiguration(hadoopPolicyConf, "hadoop-policy.xml");
    }

    @Test
    public void testSecureRMBecomeActive() throws IOException, YarnException {
        HAServiceProtocol.StateChangeRequestInfo requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        this.updateConfigurationForRMHA();
        this.configuration.setBoolean("hadoop.security.authorization", true);
        this.configuration.set("yarn.resourcemanager.ha.id", "rm1");
        this.uploadDefaultConfiguration();
        try (ResourceManager resourceManager = new ResourceManager();){
            resourceManager.init(this.configuration);
            resourceManager.start();
            Assert.assertTrue((resourceManager.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.STANDBY ? 1 : 0) != 0);
            resourceManager.adminService.transitionToActive(requestInfo);
        }
    }

    private void updateConfigurationForRMHA() {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.configuration.setBoolean("yarn.resourcemanager.ha.enabled", true);
        this.configuration.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        this.configuration.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        int base = 1500;
        for (String confKey : YarnConfiguration.getServiceAddressConfKeys((Configuration)this.configuration)) {
            this.configuration.set(HAUtil.addSuffix((String)confKey, (String)"rm1"), "0.0.0.0:" + (base + 20));
            this.configuration.set(HAUtil.addSuffix((String)confKey, (String)"rm2"), "0.0.0.1:" + (base + 40));
            base *= 2;
        }
    }

    private void checkBadConfiguration(Configuration conf) {
        MockRM rm1 = null;
        conf.set("yarn.resourcemanager.ha.id", "rm1");
        try {
            rm1 = new MockRM(conf);
            rm1.init(conf);
            Assert.fail((String)"The RM allowed an invalid configuration");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The RM initialization threw an unexpected exception", (boolean)e.getMessage().startsWith("Invalid configuration! "));
        }
    }

    @Test(timeout=30000L)
    public void testAdminAddToClusterNodeLabelsWithDeprecatedAPIs() throws Exception, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        this.rm = new MockRM(this.configuration){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        this.rm.init(this.configuration);
        this.rm.start();
        try {
            ArrayList<String> list = new ArrayList<String>();
            list.add("a");
            list.add("b");
            YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto proto = YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto.newBuilder().addAllDeprecatedNodeLabels(list).build();
            AddToClusterNodeLabelsRequestPBImpl protoImpl = new AddToClusterNodeLabelsRequestPBImpl(proto);
            this.rm.adminService.addToClusterNodeLabels((AddToClusterNodeLabelsRequest)protoImpl);
        }
        catch (Exception ex) {
            Assert.fail((String)("Could not update node labels." + ex));
        }
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = this.rm.getClientRMService().getBindAddress();
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        GetClusterNodeLabelsResponse response = client.getClusterNodeLabels(GetClusterNodeLabelsRequest.newInstance());
        NodeLabel labelX = NodeLabel.newInstance((String)"a");
        NodeLabel labelY = NodeLabel.newInstance((String)"b");
        Assert.assertTrue((boolean)response.getNodeLabelList().containsAll(Arrays.asList(labelX, labelY)));
    }

    @Test(timeout=30000L)
    public void testMapAttributesToNodes() throws Exception, YarnException {
        YarnConfiguration newConf = NodeAttributeTestUtils.getRandomDirConf(null);
        this.rm = new MockRM((Configuration)newConf);
        NodeAttributesManager spiedAttributesManager = (NodeAttributesManager)Mockito.spy((Object)this.rm.getRMContext().getNodeAttributesManager());
        this.rm.getRMContext().setNodeAttributesManager(spiedAttributesManager);
        ((RMContextImpl)this.rm.getRMContext()).setHAServiceState(HAServiceProtocol.HAServiceState.ACTIVE);
        this.setActiveAndInactiveNodes(this.rm);
        NodesToAttributesMappingRequest request = NodesToAttributesMappingRequest.newInstance((AttributeMappingOperationType)AttributeMappingOperationType.ADD, (List)ImmutableList.of((Object)NodeToAttributes.newInstance((String)"host1", (List)ImmutableList.of((Object)NodeAttribute.newInstance((String)"rm.yarn.io", (String)"x", (NodeAttributeType)NodeAttributeType.STRING, (String)"dfasdf")))), (boolean)true);
        try {
            this.rm.adminService.mapAttributesToNodes(request);
        }
        catch (Exception ex) {
            Assert.fail((String)("should not fail on known node in active state" + ex.getMessage()));
        }
        ((NodeAttributesManager)Mockito.verify((Object)spiedAttributesManager, (VerificationMode)Mockito.times((int)1))).addNodeAttributes(Mockito.anyMap());
        request = NodesToAttributesMappingRequest.newInstance((AttributeMappingOperationType)AttributeMappingOperationType.REMOVE, (List)ImmutableList.of((Object)NodeToAttributes.newInstance((String)"host4", (List)ImmutableList.of((Object)NodeAttribute.newInstance((String)"rm.yarn.io", (String)"x", (NodeAttributeType)NodeAttributeType.STRING, (String)"dfasdf")))), (boolean)true);
        try {
            this.rm.adminService.mapAttributesToNodes(request);
        }
        catch (Exception ex) {
            Assert.fail((String)("should not fail on known node in inactive state" + ex.getMessage()));
        }
        ((NodeAttributesManager)Mockito.verify((Object)spiedAttributesManager, (VerificationMode)Mockito.times((int)1))).removeNodeAttributes(Mockito.anyMap());
        request = NodesToAttributesMappingRequest.newInstance((AttributeMappingOperationType)AttributeMappingOperationType.ADD, (List)ImmutableList.of((Object)NodeToAttributes.newInstance((String)"host5", (List)ImmutableList.of((Object)NodeAttribute.newInstance((String)"rm.yarn.io", (String)"x", (NodeAttributeType)NodeAttributeType.STRING, (String)"dfasdf")))), (boolean)true);
        try {
            this.rm.adminService.mapAttributesToNodes(request);
            Assert.fail((String)"host5 is not a valid node, It should have failed");
        }
        catch (YarnException ex) {
            Assert.assertEquals((String)"Exception Message is not as desired", (Object)" Following nodes does not exist : [host5]", (Object)ex.getCause().getMessage());
        }
        request = NodesToAttributesMappingRequest.newInstance((AttributeMappingOperationType)AttributeMappingOperationType.ADD, (List)ImmutableList.of((Object)NodeToAttributes.newInstance((String)"host4:8889", (List)ImmutableList.of((Object)NodeAttribute.newInstance((String)"rm.yarn.io", (String)"x", (NodeAttributeType)NodeAttributeType.STRING, (String)"dfasdf"))), (Object)NodeToAttributes.newInstance((String)"host2:8889", (List)ImmutableList.of((Object)NodeAttribute.newInstance((String)"rm.yarn.io", (String)"x", (NodeAttributeType)NodeAttributeType.STRING, (String)"dfasdf")))), (boolean)true);
        try {
            this.rm.adminService.mapAttributesToNodes(request);
            Assert.fail((String)"host with the port should fail as only hostnames are validated");
        }
        catch (YarnException ex) {
            Assert.assertEquals((String)"Exception Message is not as desired", (Object)" Following nodes does not exist : [host4:8889, host2:8889]", (Object)ex.getCause().getMessage());
        }
        request = NodesToAttributesMappingRequest.newInstance((AttributeMappingOperationType)AttributeMappingOperationType.REPLACE, (List)ImmutableList.of((Object)NodeToAttributes.newInstance((String)"host5", (List)ImmutableList.of((Object)NodeAttribute.newInstance((String)"rm.yarn.io", (String)"x", (NodeAttributeType)NodeAttributeType.STRING, (String)"dfasdf")))), (boolean)false);
        try {
            this.rm.adminService.mapAttributesToNodes(request);
        }
        catch (Exception ex) {
            Assert.fail((String)("This operation should not fail as failOnUnknownNodes is false : " + ex.getMessage()));
        }
        ((NodeAttributesManager)Mockito.verify((Object)spiedAttributesManager, (VerificationMode)Mockito.times((int)1))).replaceNodeAttributes((String)Mockito.eq((Object)"rm.yarn.io"), Mockito.anyMap());
        request = NodesToAttributesMappingRequest.newInstance((AttributeMappingOperationType)AttributeMappingOperationType.ADD, (List)ImmutableList.of((Object)NodeToAttributes.newInstance((String)"host5", (List)ImmutableList.of((Object)NodeAttribute.newInstance((String)"nm.yarn.io", (String)"x", (NodeAttributeType)NodeAttributeType.STRING, (String)"dfasdf")))), (boolean)false);
        try {
            this.rm.adminService.mapAttributesToNodes(request);
            Assert.fail((String)"This operation should fail as prefix should be \"nm.yarn.io\".");
        }
        catch (YarnException ex) {
            Assert.assertEquals((String)"Exception Message is not as desired", (Object)"Invalid Attribute Mapping for the node host5. Prefix should be rm.yarn.io", (Object)ex.getCause().getMessage());
        }
        this.rm.close();
    }

    private void setActiveAndInactiveNodes(ResourceManager resourceManager) {
        ConcurrentMap rmNodes = resourceManager.getRMContext().getRMNodes();
        rmNodes.put(NodeId.newInstance((String)"host1", (int)1111), new RMNodeImpl(null, resourceManager.getRMContext(), "host1", 0, 0, null, null, null));
        rmNodes.put(NodeId.newInstance((String)"host2", (int)2222), new RMNodeImpl(null, resourceManager.getRMContext(), "host2", 0, 0, null, null, null));
        rmNodes.put(NodeId.newInstance((String)"host3", (int)3333), new RMNodeImpl(null, resourceManager.getRMContext(), "host3", 0, 0, null, null, null));
        ConcurrentMap rmInactiveNodes = resourceManager.getRMContext().getInactiveRMNodes();
        rmInactiveNodes.put(NodeId.newInstance((String)"host4", (int)4444), new RMNodeImpl(null, resourceManager.getRMContext(), "host4", 0, 0, null, null, null));
    }

    static {
        YarnConfiguration.addDefaultResource((String)"capacity-scheduler.xml");
        YarnConfiguration.addDefaultResource((String)"dynamic-resources.xml");
    }

    private static class MockUnixGroupsMapping
    implements GroupMappingServiceProvider {
        private static List<String> group = new ArrayList<String>();

        private MockUnixGroupsMapping() {
        }

        public List<String> getGroups(String user) throws IOException {
            return group;
        }

        public void cacheGroupsRefresh() throws IOException {
        }

        public void cacheGroupsAdd(List<String> groups) throws IOException {
        }

        public static void updateGroups() {
            group.clear();
            group.add("test_group_D");
            group.add("test_group_E");
            group.add("test_group_F");
        }

        public static void resetGroups() {
            group.clear();
            group.add("test_group_A");
            group.add("test_group_B");
            group.add("test_group_C");
        }
    }
}

