/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import org.apache.hadoop.yarn.server.router.webapp.NodesBlock;
import org.apache.hadoop.yarn.server.router.webapp.RouterView;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

class NodesPage
extends RouterView {
    NodesPage() {
    }

    @Override
    protected void preHead(Hamlet.HTML<HtmlPage.__> html) {
        this.commonPreHead(html);
        String type = this.$("node.state");
        String title = "Nodes of the cluster";
        if (type != null && !type.isEmpty()) {
            title = title + " (" + type + ")";
        }
        this.setTitle(title);
        this.set("ui.dataTables.id", "nodes");
        this.set(JQueryUI.initID((String)"ui.dataTables", (String)"nodes"), this.nodesTableInit());
        this.setTableStyles(html, "nodes", new String[]{".healthStatus {width:10em}", ".healthReport {width:10em}"});
    }

    @Override
    protected Class<? extends SubView> content() {
        return NodesBlock.class;
    }

    private String nodesTableInit() {
        StringBuilder b = JQueryUI.tableInit().append(", aoColumnDefs: [");
        b.append("{'bSearchable': false, 'aTargets': [ 7 ]}");
        b.append(", {'sType': 'title-numeric', 'bSearchable': false, 'aTargets': [ 2, 3, 4, 5, 6 ] }");
        b.append(", {'sType': 'title-numeric', 'aTargets': [ 5 ]}");
        b.append("]}");
        return b.toString();
    }
}

