/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;

@InterfaceAudience.Private
@Metrics(about="Metrics for Router Federation Interceptor", context="fedr")
public final class RouterMetrics {
    private static final MetricsInfo RECORD_INFO = Interns.info((String)"RouterMetrics", (String)"Router Federation Interceptor");
    private static AtomicBoolean isInitialized = new AtomicBoolean(false);
    @Metric(value={"# of applications failed to be submitted"})
    private MutableGaugeInt numAppsFailedSubmitted;
    @Metric(value={"# of applications failed to be created"})
    private MutableGaugeInt numAppsFailedCreated;
    @Metric(value={"# of applications failed to be killed"})
    private MutableGaugeInt numAppsFailedKilled;
    @Metric(value={"# of application reports failed to be retrieved"})
    private MutableGaugeInt numAppsFailedRetrieved;
    @Metric(value={"# of multiple applications reports failed to be retrieved"})
    private MutableGaugeInt numMultipleAppsFailedRetrieved;
    @Metric(value={"Total number of successful Submitted apps and latency(ms)"})
    private MutableRate totalSucceededAppsSubmitted;
    @Metric(value={"Total number of successful Killed apps and latency(ms)"})
    private MutableRate totalSucceededAppsKilled;
    @Metric(value={"Total number of successful Created apps and latency(ms)"})
    private MutableRate totalSucceededAppsCreated;
    @Metric(value={"Total number of successful Retrieved app reports and latency(ms)"})
    private MutableRate totalSucceededAppsRetrieved;
    @Metric(value={"Total number of successful Retrieved multiple apps reports and latency(ms)"})
    private MutableRate totalSucceededMultipleAppsRetrieved;
    private MutableQuantiles submitApplicationLatency;
    private MutableQuantiles getNewApplicationLatency;
    private MutableQuantiles killApplicationLatency;
    private MutableQuantiles getApplicationReportLatency;
    private MutableQuantiles getApplicationsReportLatency;
    private static volatile RouterMetrics INSTANCE = null;
    private static MetricsRegistry registry;

    private RouterMetrics() {
        registry = new MetricsRegistry(RECORD_INFO);
        registry.tag(RECORD_INFO, "Router");
        this.getNewApplicationLatency = registry.newQuantiles("getNewApplicationLatency", "latency of get new application", "ops", "latency", 10);
        this.submitApplicationLatency = registry.newQuantiles("submitApplicationLatency", "latency of submit application", "ops", "latency", 10);
        this.killApplicationLatency = registry.newQuantiles("killApplicationLatency", "latency of kill application", "ops", "latency", 10);
        this.getApplicationReportLatency = registry.newQuantiles("getApplicationReportLatency", "latency of get application report", "ops", "latency", 10);
        this.getApplicationsReportLatency = registry.newQuantiles("getApplicationsReportLatency", "latency of get applications report", "ops", "latency", 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RouterMetrics getMetrics() {
        if (isInitialized.get()) return INSTANCE;
        Class<RouterMetrics> clazz = RouterMetrics.class;
        synchronized (RouterMetrics.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = (RouterMetrics)DefaultMetricsSystem.instance().register("RouterMetrics", "Metrics for the Yarn Router", (Object)new RouterMetrics());
            isInitialized.set(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @VisibleForTesting
    static synchronized void destroy() {
        isInitialized.set(false);
        INSTANCE = null;
    }

    @VisibleForTesting
    public long getNumSucceededAppsCreated() {
        return this.totalSucceededAppsCreated.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededAppsSubmitted() {
        return this.totalSucceededAppsSubmitted.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededAppsKilled() {
        return this.totalSucceededAppsKilled.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededAppsRetrieved() {
        return this.totalSucceededAppsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumSucceededMultipleAppsRetrieved() {
        return this.totalSucceededMultipleAppsRetrieved.lastStat().numSamples();
    }

    @VisibleForTesting
    public double getLatencySucceededAppsCreated() {
        return this.totalSucceededAppsCreated.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededAppsSubmitted() {
        return this.totalSucceededAppsSubmitted.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededAppsKilled() {
        return this.totalSucceededAppsKilled.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededGetAppReport() {
        return this.totalSucceededAppsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public double getLatencySucceededMultipleGetAppReport() {
        return this.totalSucceededMultipleAppsRetrieved.lastStat().mean();
    }

    @VisibleForTesting
    public int getAppsFailedCreated() {
        return this.numAppsFailedCreated.value();
    }

    @VisibleForTesting
    public int getAppsFailedSubmitted() {
        return this.numAppsFailedSubmitted.value();
    }

    @VisibleForTesting
    public int getAppsFailedKilled() {
        return this.numAppsFailedKilled.value();
    }

    @VisibleForTesting
    public int getAppsFailedRetrieved() {
        return this.numAppsFailedRetrieved.value();
    }

    @VisibleForTesting
    public int getMultipleAppsFailedRetrieved() {
        return this.numMultipleAppsFailedRetrieved.value();
    }

    public void succeededAppsCreated(long duration) {
        this.totalSucceededAppsCreated.add(duration);
        this.getNewApplicationLatency.add(duration);
    }

    public void succeededAppsSubmitted(long duration) {
        this.totalSucceededAppsSubmitted.add(duration);
        this.submitApplicationLatency.add(duration);
    }

    public void succeededAppsKilled(long duration) {
        this.totalSucceededAppsKilled.add(duration);
        this.killApplicationLatency.add(duration);
    }

    public void succeededAppsRetrieved(long duration) {
        this.totalSucceededAppsRetrieved.add(duration);
        this.getApplicationReportLatency.add(duration);
    }

    public void succeededMultipleAppsRetrieved(long duration) {
        this.totalSucceededMultipleAppsRetrieved.add(duration);
        this.getApplicationsReportLatency.add(duration);
    }

    public void incrAppsFailedCreated() {
        this.numAppsFailedCreated.incr();
    }

    public void incrAppsFailedSubmitted() {
        this.numAppsFailedSubmitted.incr();
    }

    public void incrAppsFailedKilled() {
        this.numAppsFailedKilled.incr();
    }

    public void incrAppsFailedRetrieved() {
        this.numAppsFailedRetrieved.incr();
    }

    public void incrMultipleAppsFailedRetrieved() {
        this.numMultipleAppsFailedRetrieved.incr();
    }
}

