/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.client.SCMAdmin;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.api.SCMAdminProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.RunSharedCacheCleanerTaskRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RunSharedCacheCleanerTaskResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RunSharedCacheCleanerTaskResponsePBImpl;
import org.apache.hadoop.yarn.server.sharedcachemanager.CleanerService;
import org.apache.hadoop.yarn.server.sharedcachemanager.SCMAdminProtocolService;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.InMemorySCMStore;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.SCMStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSCMAdminProtocolService {
    static SCMAdminProtocolService service;
    static SCMAdminProtocol SCMAdminProxy;
    static SCMAdminProtocol mockAdmin;
    static SCMAdmin adminCLI;
    static SCMStore store;
    static CleanerService cleaner;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @Before
    public void startUp() {
        Configuration conf = new Configuration();
        conf.set("yarn.sharedcache.store.class", InMemorySCMStore.class.getName());
        cleaner = (CleanerService)Mockito.mock(CleanerService.class);
        service = (SCMAdminProtocolService)Mockito.spy((Object)new SCMAdminProtocolService(cleaner));
        service.init(conf);
        service.start();
        YarnRPC rpc = YarnRPC.create((Configuration)new Configuration());
        InetSocketAddress scmAddress = conf.getSocketAddr("yarn.sharedcache.admin.address", "0.0.0.0:8047", 8047);
        SCMAdminProxy = (SCMAdminProtocol)rpc.getProxy(SCMAdminProtocol.class, scmAddress, conf);
        mockAdmin = (SCMAdminProtocol)Mockito.mock(SCMAdminProtocol.class);
        adminCLI = new SCMAdmin(new Configuration()){

            protected SCMAdminProtocol createSCMAdminProtocol() throws IOException {
                return mockAdmin;
            }
        };
    }

    @After
    public void cleanUpTest() {
        if (service != null) {
            service.stop();
        }
        if (SCMAdminProxy != null) {
            RPC.stopProxy((Object)SCMAdminProxy);
        }
    }

    @Test
    public void testRunCleanerTask() throws Exception {
        ((CleanerService)Mockito.doNothing().when((Object)cleaner)).runCleanerTask();
        RunSharedCacheCleanerTaskRequest request = (RunSharedCacheCleanerTaskRequest)this.recordFactory.newRecordInstance(RunSharedCacheCleanerTaskRequest.class);
        RunSharedCacheCleanerTaskResponse response = SCMAdminProxy.runCleanerTask(request);
        Assert.assertTrue((String)"cleaner task request isn't accepted", (boolean)response.getAccepted());
        ((SCMAdminProtocolService)Mockito.verify((Object)service, (VerificationMode)Mockito.times((int)1))).runCleanerTask((RunSharedCacheCleanerTaskRequest)Matchers.any(RunSharedCacheCleanerTaskRequest.class));
    }

    @Test
    public void testRunCleanerTaskCLI() throws Exception {
        String[] args = new String[]{"-runCleanerTask"};
        RunSharedCacheCleanerTaskResponsePBImpl rp = new RunSharedCacheCleanerTaskResponsePBImpl();
        rp.setAccepted(true);
        Mockito.when((Object)mockAdmin.runCleanerTask((RunSharedCacheCleanerTaskRequest)Matchers.isA(RunSharedCacheCleanerTaskRequest.class))).thenReturn((Object)rp);
        Assert.assertEquals((long)0L, (long)adminCLI.run(args));
        rp.setAccepted(false);
        Mockito.when((Object)mockAdmin.runCleanerTask((RunSharedCacheCleanerTaskRequest)Matchers.isA(RunSharedCacheCleanerTaskRequest.class))).thenReturn((Object)rp);
        Assert.assertEquals((long)1L, (long)adminCLI.run(args));
        ((SCMAdminProtocol)Mockito.verify((Object)mockAdmin, (VerificationMode)Mockito.times((int)2))).runCleanerTask((RunSharedCacheCleanerTaskRequest)Matchers.any(RunSharedCacheCleanerTaskRequest.class));
    }
}

