/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRMNMSecretKeys {
    @Before
    public void setup() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        RMStorageFactory.setConfiguration((Configuration)conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)conf);
        DBUtility.InitializeDB();
    }

    @Test(timeout=1000000L)
    public void testNMUpdation() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        this.validateRMNMKeyExchange(conf);
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.validateRMNMKeyExchange(conf);
    }

    private void validateRMNMKeyExchange(YarnConfiguration conf) throws Exception {
        ResourceManager rm = new ResourceManager(){

            protected void doSecureLogin() throws IOException {
            }

            protected Dispatcher createDispatcher() {
                return new DrainDispatcher();
            }

            protected void startWepApp() {
            }
        };
        rm.init((Configuration)conf);
        rm.start();
        String containerToken = "Container Token : ";
        String nmToken = "NM Token : ";
        MockNM nm = new MockNM("host:1234", 3072, rm.getResourceTrackerService());
        RegisterNodeManagerResponse registrationResponse = nm.registerNode();
        MasterKey containerTokenMasterKey = registrationResponse.getContainerTokenMasterKey();
        Assert.assertNotNull((String)(containerToken + "Registration should cause a key-update!"), (Object)containerTokenMasterKey);
        MasterKey nmTokenMasterKey = registrationResponse.getNMTokenMasterKey();
        Assert.assertNotNull((String)(nmToken + "Registration should cause a key-update!"), (Object)nmTokenMasterKey);
        ((DrainDispatcher)rm.getRMContext().getDispatcher()).await();
        NodeHeartbeatResponse response = nm.nodeHeartbeat(true);
        Assert.assertNull((String)(containerToken + "First heartbeat after registration shouldn't get any key updates!"), (Object)response.getContainerTokenMasterKey());
        Assert.assertNull((String)(nmToken + "First heartbeat after registration shouldn't get any key updates!"), (Object)response.getNMTokenMasterKey());
        ((DrainDispatcher)rm.getRMContext().getDispatcher()).await();
        response = nm.nodeHeartbeat(true);
        Assert.assertNull((String)(containerToken + "Even second heartbeat after registration shouldn't get any key updates!"), (Object)response.getContainerTokenMasterKey());
        Assert.assertNull((String)(nmToken + "Even second heartbeat after registration shouldn't get any key updates!"), (Object)response.getContainerTokenMasterKey());
        ((DrainDispatcher)rm.getRMContext().getDispatcher()).await();
        rm.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        rm.getRMContext().getNMTokenSecretManager().rollMasterKey();
        response = nm.nodeHeartbeat(true);
        Assert.assertNotNull((String)(containerToken + "Heartbeats after roll-over and before activation should not err out."), (Object)response.getContainerTokenMasterKey());
        Assert.assertNotNull((String)(nmToken + "Heartbeats after roll-over and before activation should not err out."), (Object)response.getNMTokenMasterKey());
        Assert.assertEquals((String)(containerToken + "Roll-over should have incremented the key-id only by one!"), (long)(containerTokenMasterKey.getKeyId() + 1), (long)response.getContainerTokenMasterKey().getKeyId());
        Assert.assertEquals((String)(nmToken + "Roll-over should have incremented the key-id only by one!"), (long)(nmTokenMasterKey.getKeyId() + 1), (long)response.getNMTokenMasterKey().getKeyId());
        ((DrainDispatcher)rm.getRMContext().getDispatcher()).await();
        response = nm.nodeHeartbeat(true);
        Assert.assertNull((String)(containerToken + "Second heartbeat after roll-over shouldn't get any key updates!"), (Object)response.getContainerTokenMasterKey());
        Assert.assertNull((String)(nmToken + "Second heartbeat after roll-over shouldn't get any key updates!"), (Object)response.getNMTokenMasterKey());
        ((DrainDispatcher)rm.getRMContext().getDispatcher()).await();
        rm.getRMContext().getContainerTokenSecretManager().activateNextMasterKey();
        rm.getRMContext().getNMTokenSecretManager().activateNextMasterKey();
        response = nm.nodeHeartbeat(true);
        Assert.assertNull((String)(containerToken + "Activation shouldn't cause any key updates!"), (Object)response.getContainerTokenMasterKey());
        Assert.assertNull((String)(nmToken + "Activation shouldn't cause any key updates!"), (Object)response.getNMTokenMasterKey());
        ((DrainDispatcher)rm.getRMContext().getDispatcher()).await();
        response = nm.nodeHeartbeat(true);
        Assert.assertNull((String)(containerToken + "Even second heartbeat after activation shouldn't get any key updates!"), (Object)response.getContainerTokenMasterKey());
        Assert.assertNull((String)(nmToken + "Even second heartbeat after activation shouldn't get any key updates!"), (Object)response.getNMTokenMasterKey());
        ((DrainDispatcher)rm.getRMContext().getDispatcher()).await();
        rm.stop();
    }
}

