/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcServerException;
import org.apache.hadoop.net.HopsSSLSocketFactory;
import org.apache.hadoop.security.ssl.HopsSSLTestUtils;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.util.Records;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestYarnSSLServer
extends HopsSSLTestUtils {
    private final Log LOG = LogFactory.getLog(TestYarnSSLServer.class);
    private MiniYARNCluster cluster;
    private ApplicationClientProtocol acClient;
    private ApplicationClientProtocol acClient1;
    private static String classpathDir;

    public TestYarnSSLServer(HopsSSLTestUtils.CERT_ERR error_mode) {
        this.error_mode = error_mode;
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        classpathDir = KeyStoreTestUtil.getClasspathDir(TestYarnSSLServer.class);
    }

    @Before
    public void setUp() throws Exception {
        this.LOG.debug((Object)("Error mode: " + this.error_mode.name()));
        this.conf = new YarnConfiguration();
        this.conf.set("hops.rm.certificate.actor.class", "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppCertificateActions");
        this.filesToPurge = this.prepareCryptoMaterial(this.conf, classpathDir);
        this.setCryptoConfig(this.conf, classpathDir);
        this.conf.setBoolean("yarn.minicluster.fixed.ports", true);
        this.conf.setBoolean("yarn.minicluster.use-rpc", true);
        this.cluster = new MiniYARNCluster(TestYarnSSLServer.class.getName(), 1, 3, 1, 1, false, true);
        this.cluster.init(this.conf);
        this.cluster.start();
        this.LOG.info((Object)"Started cluster");
        this.acClient = (ApplicationClientProtocol)ClientRMProxy.createRMProxy((Configuration)this.conf, ApplicationClientProtocol.class, (boolean)true);
    }

    @After
    public void tearDown() throws Exception {
        if (this.invoker != null) {
            this.invoker.join();
            this.invoker = null;
        }
        if (this.cluster != null) {
            this.LOG.info((Object)"Stopping MiniYARN cluster");
            this.cluster.stop();
        }
        if (this.acClient != null) {
            RPC.stopProxy((Object)this.acClient);
        }
        if (this.acClient1 != null) {
            RPC.stopProxy((Object)this.acClient1);
        }
    }

    @Test
    public void testSubmitApplication() throws Exception {
        GetNewApplicationRequest newAppReq = GetNewApplicationRequest.newInstance();
        GetNewApplicationResponse newAppRes = this.acClient.getNewApplication(newAppReq);
        ApplicationSubmissionContext appCtx = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        appCtx.setApplicationId(newAppRes.getApplicationId());
        appCtx.setApplicationName("RandomApplication");
        appCtx.setApplicationType("SomeType");
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        LocalResource lr = LocalResource.newInstance((URL)URL.newInstance((String)"hdfs://", (String)"localhost", (int)8020, (String)"aFile"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)100L, (long)100L);
        localResources.put("aFile", lr);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("env0", "someValue");
        ArrayList<String> amCommnads = new ArrayList<String>();
        amCommnads.add("someRandom --command");
        ContainerLaunchContext amCtx = ContainerLaunchContext.newInstance(localResources, env, amCommnads, null, null, null);
        appCtx.setAMContainerSpec(amCtx);
        appCtx.setResource(Resource.newInstance((int)2048, (int)2));
        appCtx.setQueue("default");
        ApplicationClientProtocol client = (ApplicationClientProtocol)ClientRMProxy.createRMProxy((Configuration)this.conf, ApplicationClientProtocol.class, (boolean)true);
        Thread invoker = new Thread(new Invoker(client));
        invoker.setName("AnotherClient");
        invoker.start();
        SubmitApplicationRequest appReq = SubmitApplicationRequest.newInstance((ApplicationSubmissionContext)appCtx);
        this.LOG.debug((Object)"Submitting the application");
        this.acClient.submitApplication(appReq);
        this.LOG.debug((Object)"Submitted the application");
        this.LOG.debug((Object)"Getting new application");
        newAppRes = this.acClient.getNewApplication(newAppReq);
        Assert.assertNotNull((Object)newAppRes);
        this.LOG.debug((Object)"I have gotten the new application");
        List appsReport = this.acClient.getApplications(GetApplicationsRequest.newInstance()).getApplicationList();
        boolean found = false;
        for (ApplicationReport appRep : appsReport) {
            if (!appRep.getApplicationId().equals((Object)appCtx.getApplicationId())) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
        TimeUnit.SECONDS.sleep(10L);
    }

    @Test(timeout=3000L)
    public void testRpcCall() throws Exception {
        EnumSet<NodeState> filter = EnumSet.of(NodeState.RUNNING);
        GetClusterNodesRequest req = GetClusterNodesRequest.newInstance();
        req.setNodeStates(filter);
        this.LOG.debug((Object)"Sending request");
        GetClusterNodesResponse res = this.acClient.getClusterNodes(req);
        this.LOG.debug((Object)"Got response from server");
        Assert.assertNotNull((String)"Response should not be null", (Object)res);
        List reports = res.getNodeReports();
        this.LOG.debug((Object)"Printing cluster nodes report");
        for (NodeReport report : reports) {
            this.LOG.debug((Object)("NodeId: " + report.getNodeId().toString()));
        }
    }

    @Test
    public void testRpcCallWithNonValidCert() throws Exception {
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue(), this.err_clientKeyStore.toString());
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_PASSWORD_KEY.getValue(), this.passwd);
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.KEY_PASSWORD_KEY.getValue(), this.passwd);
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue(), this.err_clientTrustStore.toString());
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_PASSWORD_KEY.getValue(), this.passwd);
        this.invoker = new Thread(new Invoker(this.acClient));
        this.invoker.start();
        this.LOG.debug((Object)"Creating the second client");
        this.acClient1 = (ApplicationClientProtocol)ClientRMProxy.createRMProxy((Configuration)this.conf, ApplicationClientProtocol.class, (boolean)true);
        GetNewApplicationRequest req1 = GetNewApplicationRequest.newInstance();
        if (this.error_mode.equals((Object)HopsSSLTestUtils.CERT_ERR.NO_CA)) {
            this.rule.expect(SSLException.class);
        } else if (this.error_mode.equals((Object)HopsSSLTestUtils.CERT_ERR.ERR_CN)) {
            this.rule.expect(RpcServerException.class);
        }
        GetNewApplicationResponse res1 = this.acClient1.getNewApplication(req1);
    }

    private class Invoker
    implements Runnable {
        private final ApplicationClientProtocol client;

        public Invoker(ApplicationClientProtocol client) {
            this.client = client;
        }

        @Override
        public void run() {
            EnumSet<NodeState> filter = EnumSet.of(NodeState.RUNNING);
            GetClusterNodesRequest req = GetClusterNodesRequest.newInstance();
            req.setNodeStates(filter);
            TestYarnSSLServer.this.LOG.debug((Object)"Sending cluster nodes request from first client");
            try {
                TimeUnit.SECONDS.sleep(1L);
                GetClusterNodesResponse res = this.client.getClusterNodes(req);
                Assert.assertNotNull((String)"Response from the first client should not be null", (Object)res);
                TestYarnSSLServer.this.LOG.debug((Object)("NodeReports: " + res.getNodeReports().size()));
                for (NodeReport nodeReport : res.getNodeReports()) {
                    TestYarnSSLServer.this.LOG.debug((Object)("Node: " + nodeReport.getNodeId() + " Capability: " + nodeReport.getCapability()));
                }
            }
            catch (Exception ex) {
                TestYarnSSLServer.this.LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }
}

