/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jwt.JWTClaimsSet;
import java.net.MalformedURLException;
import java.security.GeneralSecurityException;
import java.sql.Date;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Random;
import org.apache.hadoop.yarn.server.resourcemanager.security.HopsworksRMAppSecurityActions;
import org.apache.hadoop.yarn.server.resourcemanager.security.MockJWTIssuer;

public class MockHopsworksRMAppSecurityActions
extends HopsworksRMAppSecurityActions {
    private final byte[] secret;
    private final MockJWTIssuer jwtIssuer;

    public MockHopsworksRMAppSecurityActions() throws MalformedURLException, GeneralSecurityException {
        Random rand = new Random();
        this.secret = new byte[32];
        rand.nextBytes(this.secret);
        this.jwtIssuer = new MockJWTIssuer(this.secret);
    }

    protected void loadMasterJWT() throws GeneralSecurityException {
        LocalDateTime masterExpiration = LocalDateTime.now().plus(10L, ChronoUnit.MINUTES);
        JWTClaimsSet claims = new JWTClaimsSet();
        claims.setExpirationTime(Date.from(masterExpiration.atZone(ZoneId.systemDefault()).toInstant()));
        try {
            String masterToken = this.jwtIssuer.generate(claims);
            this.setMasterToken(masterToken);
            this.setMasterTokenExpiration(masterExpiration);
        }
        catch (JOSEException ex) {
            throw new GeneralSecurityException(ex.getMessage(), ex);
        }
    }

    protected void loadRenewalJWTs() throws GeneralSecurityException {
        this.setRenewalTokens(new String[0]);
    }
}

