/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import io.hops.security.HopsFileBasedKeyStoresFactory;
import io.hops.security.SuperuserKeystoresLoader;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.CRLFetcherFactory;
import org.apache.hadoop.security.ssl.CRLValidatorFactory;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestYarnStartupWithCRL {
    private static final String BASE_DIR = Paths.get(System.getProperty("test.build.dir", Paths.get("target", "test-dir").toString()), TestYarnStartupWithCRL.class.getSimpleName()).toString();
    private static final File BASE_DIR_FILE = new File(BASE_DIR);
    private final String keyAlgorithm = "RSA";
    private final String signatureAlgorithm = "SHA256withRSA";
    private final String password = "password";
    private static String confDir = null;
    private Configuration conf;
    private MiniYARNCluster cluster;

    @BeforeClass
    public static void beforeClass() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        BASE_DIR_FILE.mkdirs();
        confDir = KeyStoreTestUtil.getClasspathDir(TestYarnStartupWithCRL.class);
    }

    @Before
    public void setup() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setBoolean("yarn.minicluster.fixed.ports", true);
        this.conf.setBoolean("yarn.minicluster.use-rpc", true);
        CRLValidatorFactory.getInstance().clearCache();
        CRLFetcherFactory.getInstance().clearFetcherCache();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.stop();
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        File sslServerConf;
        if (BASE_DIR_FILE.exists()) {
            FileUtils.deleteDirectory((File)BASE_DIR_FILE);
        }
        if ((sslServerConf = Paths.get(confDir, TestYarnStartupWithCRL.class.getSimpleName() + ".ssl-server.xml").toFile()).exists()) {
            sslServerConf.delete();
        }
    }

    @Test
    public void testYarnStartup() throws Exception {
        String hostname = NetUtils.getLocalCanonicalHostname();
        Path inputCRLPath = Paths.get(BASE_DIR, "input.crl.pem");
        Path fetchedCRLPath = Paths.get(BASE_DIR, "fetched.crl.pem");
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(this.conf);
        Path keyStore = Paths.get(BASE_DIR, loader.getSuperKeystoreFilename(ugi.getUserName()));
        Path trustStore = Paths.get(BASE_DIR, loader.getSuperTruststoreFilename(ugi.getUserName()));
        Path passwdFile = Paths.get(BASE_DIR, loader.getSuperMaterialPasswdFilename(ugi.getUserName()));
        FileUtils.writeStringToFile((File)passwdFile.toFile(), (String)"password");
        String superUser = UserGroupInformation.getCurrentUser().getUserName();
        KeyPair keyPair = KeyStoreTestUtil.generateKeyPair((String)"RSA");
        X509Certificate cert = KeyStoreTestUtil.generateCertificate((String)("CN=" + hostname + ",L=" + superUser), (KeyPair)keyPair, (int)10, (String)"SHA256withRSA");
        KeyStoreTestUtil.createKeyStore((String)keyStore.toString(), (String)"password", (String)"server", (Key)keyPair.getPrivate(), (Certificate)cert);
        KeyStoreTestUtil.createTrustStore((String)trustStore.toString(), (String)"password", (String)"server", (Certificate)cert);
        X509CRL crl = KeyStoreTestUtil.generateCRL((X509Certificate)cert, (PrivateKey)keyPair.getPrivate(), (String)"SHA256withRSA", null, null);
        FileWriter fw = new FileWriter(inputCRLPath.toFile(), false);
        PemWriter pw = new PemWriter((Writer)fw);
        pw.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)crl));
        pw.flush();
        fw.flush();
        pw.close();
        fw.close();
        this.conf.set("hadoop.rpc.socket.factory.class.default", "org.apache.hadoop.net.HopsSSLSocketFactory");
        this.conf.setBoolean("ipc.server.ssl.enabled", true);
        this.conf.set("hadoop.ssl.hostname.verifier", "ALLOW_ALL");
        this.conf.set("hadoop.proxyuser." + superUser, "*");
        this.conf.set(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppSecurityActions");
        this.conf.set("hadoop.ssl.keystores.factory.class", HopsFileBasedKeyStoresFactory.class.getCanonicalName());
        this.conf.set("hops.tls.superuser-material-directory", BASE_DIR);
        this.conf.setBoolean("hops.crl.validation.enabled", true);
        this.conf.set("hops.crl.fetcher.class", "org.apache.hadoop.security.ssl.RemoteCRLFetcher");
        this.conf.set("hops.crl.fetcher.interval", "1s");
        this.conf.set("hops.crl.input.uri", "file://" + inputCRLPath.toString());
        this.conf.set("hops.crl.output.file", fetchedCRLPath.toString());
        this.cluster = new MiniYARNCluster(TestYarnStartupWithCRL.class.getSimpleName(), 1, 1, 1);
        this.cluster.init(this.conf);
        this.cluster.start();
        this.cluster.waitForNodeManagersToConnect(2000L);
        Assert.assertTrue((boolean)this.cluster.getResourceManager().areActiveServicesRunning());
        Assert.assertEquals((long)1L, (long)this.cluster.getResourceManager().getResourceScheduler().getNumClusterNodes());
    }
}

