/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class LogInfo {
    public static final String ENTITY_FILE_NAME_DELIMITERS = "_.";
    private String attemptDirName;
    private String filename;
    private String user;
    private long offset = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(LogInfo.class);

    public String getAttemptDirName() {
        return this.attemptDirName;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long newOffset) {
        this.offset = newOffset;
    }

    public LogInfo(String attemptDirName, String file, String owner) {
        this.attemptDirName = attemptDirName;
        this.filename = file;
        this.user = owner;
    }

    public Path getPath(Path rootPath) {
        Path attemptPath = new Path(rootPath, this.attemptDirName);
        return new Path(attemptPath, this.filename);
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean matchesGroupId(TimelineEntityGroupId groupId) {
        return this.matchesGroupId(groupId.toString());
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    boolean matchesGroupId(String groupId) {
        int pos = this.filename.indexOf(groupId);
        if (pos < 0) {
            return false;
        }
        return this.filename.length() == pos + groupId.length() || ENTITY_FILE_NAME_DELIMITERS.contains(String.valueOf(this.filename.charAt(pos + groupId.length())));
    }

    public long parseForStore(TimelineDataManager tdm, Path appDirPath, boolean appCompleted, JsonFactory jsonFactory, ObjectMapper objMapper, FileSystem fs) throws IOException {
        LOG.debug("Parsing for log dir {} on attempt {}", (Object)appDirPath, (Object)this.attemptDirName);
        Path logPath = this.getPath(appDirPath);
        FileStatus status = fs.getFileStatus(logPath);
        long numParsed = 0L;
        if (status != null) {
            long startTime = Time.monotonicNow();
            try {
                LOG.debug("Parsing {} at offset {}", (Object)logPath, (Object)this.offset);
                long count = this.parsePath(tdm, logPath, appCompleted, jsonFactory, objMapper, fs);
                LOG.info("Parsed {} entities from {} in {} msec", new Object[]{count, logPath, Time.monotonicNow() - startTime});
                numParsed += count;
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof JsonParseException && (status.getLen() > 0L || this.offset > 0L)) {
                    LOG.info("Log {} appears to be corrupted. Skip. ", (Object)logPath);
                }
            }
        } else {
            LOG.warn("{} no longer exists. Skip for scanning. ", (Object)logPath);
        }
        return numParsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long parsePath(TimelineDataManager tdm, Path logPath, boolean appCompleted, JsonFactory jsonFactory, ObjectMapper objMapper, FileSystem fs) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.user);
        FSDataInputStream in = fs.open(logPath);
        JsonParser parser = null;
        try {
            in.seek(this.offset);
            try {
                parser = jsonFactory.createJsonParser((InputStream)in);
                parser.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
            }
            catch (IOException e) {
                if (appCompleted) {
                    throw e;
                }
                LOG.debug("Exception in parse path: {}", (Object)e.getMessage());
                long l = 0L;
                IOUtils.closeStream((Closeable)parser);
                IOUtils.closeStream((Closeable)in);
                return l;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(parser);
            IOUtils.closeStream((Closeable)in);
            throw throwable;
        }
        long l = this.doParse(tdm, parser, objMapper, ugi, appCompleted);
        IOUtils.closeStream((Closeable)parser);
        IOUtils.closeStream((Closeable)in);
        return l;
    }

    protected abstract long doParse(TimelineDataManager var1, JsonParser var2, ObjectMapper var3, UserGroupInformation var4, boolean var5) throws IOException;
}

