/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableStat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timeline.EntityCacheItem;
import org.apache.hadoop.yarn.server.timeline.EntityGroupFSTimelineStore;
import org.apache.hadoop.yarn.server.timeline.EntityGroupPlugInForTest;
import org.apache.hadoop.yarn.server.timeline.LogInfo;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.PluginStoreTestUtils;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineStoreTestUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestEntityGroupFSTimelineStore
extends TimelineStoreTestUtils {
    private static final String SAMPLE_APP_PREFIX_CACHE_TEST = "1234_000";
    private static final int CACHE_TEST_CACHE_SIZE = 5;
    private static final String TEST_SUMMARY_LOG_FILE_NAME = "summarylog-test";
    private static final String TEST_DOMAIN_LOG_FILE_NAME = "domainlog-test";
    private static final Path TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", System.getProperty("java.io.tmpdir")), TestEntityGroupFSTimelineStore.class.getSimpleName());
    private static Configuration config = new YarnConfiguration();
    private static MiniDFSCluster hdfsCluster;
    private static FileSystem fs;
    private static FileContext fc;
    private static FileContextTestHelper fileContextTestHelper;
    private static List<ApplicationId> sampleAppIds;
    private static ApplicationId mainTestAppId;
    private static Path mainTestAppDirPath;
    private static Path testDoneDirPath;
    private static String mainEntityLogFileName;
    private EntityGroupFSTimelineStore store;
    private TimelineEntity entityNew;
    @Rule
    public TestName currTestName = new TestName();

    @BeforeClass
    public static void setupClass() throws Exception {
        config.setBoolean("yarn.timeline-service.ttl-enable", false);
        config.set("yarn.timeline-service.entity-group-fs-store.summary-entity-types", "YARN_APPLICATION,YARN_APPLICATION_ATTEMPT,YARN_CONTAINER");
        config.setInt("yarn.timeline-service.entity-group-fs-store.app-cache-size", 5);
        config.set("hdfs.minidfs.basedir", TEST_ROOT_DIR.toString());
        HdfsConfiguration hdfsConfig = new HdfsConfiguration();
        hdfsCluster = new MiniDFSCluster.Builder((Configuration)hdfsConfig).numDataNodes(1).build();
        fs = hdfsCluster.getFileSystem();
        fc = FileContext.getFileContext((URI)hdfsCluster.getURI(0), (Configuration)config);
        sampleAppIds = new ArrayList<ApplicationId>(6);
        for (int i = 0; i < 6; ++i) {
            ApplicationId appId = ApplicationId.fromString((String)("application_1234_000" + i));
            sampleAppIds.add(appId);
        }
        mainTestAppId = sampleAppIds.get(0);
        mainTestAppDirPath = TestEntityGroupFSTimelineStore.getTestRootPath(mainTestAppId.toString());
        mainEntityLogFileName = "entitylog-" + EntityGroupPlugInForTest.getStandardTimelineGroupId(mainTestAppId);
        testDoneDirPath = TestEntityGroupFSTimelineStore.getTestRootPath("done");
        config.set("yarn.timeline-service.entity-group-fs-store.done-dir", testDoneDirPath.toString());
    }

    @Before
    public void setup() throws Exception {
        for (ApplicationId appId : sampleAppIds) {
            Path attemotDirPath = new Path(TestEntityGroupFSTimelineStore.getTestRootPath(appId.toString()), TestEntityGroupFSTimelineStore.getAttemptDirName(appId));
            this.createTestFiles(appId, attemotDirPath);
        }
        this.store = new EntityGroupFSTimelineStore();
        if (this.currTestName.getMethodName().contains("Plugin")) {
            config.set("yarn.timeline-service.entity-group-fs-store.group-id-plugin-classes", EntityGroupPlugInForTest.class.getName());
        }
        this.store.init(config);
        this.store.setFs(fs);
        this.store.start();
    }

    @After
    public void tearDown() throws Exception {
        this.store.stop();
        for (ApplicationId appId : sampleAppIds) {
            fs.delete(TestEntityGroupFSTimelineStore.getTestRootPath(appId.toString()), true);
        }
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        hdfsCluster.shutdown();
        FileContext fileContext = FileContext.getLocalFSFileContext();
        fileContext.delete(new Path(config.get("yarn.timeline-service.leveldb-timeline-store.path")), true);
    }

    @Test
    public void testAppLogsScanLogs() throws Exception {
        String fileName;
        EntityGroupFSTimelineStore entityGroupFSTimelineStore = this.store;
        entityGroupFSTimelineStore.getClass();
        EntityGroupFSTimelineStore.AppLogs appLogs = new EntityGroupFSTimelineStore.AppLogs(entityGroupFSTimelineStore, mainTestAppId, mainTestAppDirPath, EntityGroupFSTimelineStore.AppState.COMPLETED);
        appLogs.scanForLogs();
        List summaryLogs = appLogs.getSummaryLogs();
        List detailLogs = appLogs.getDetailLogs();
        Assert.assertEquals((long)2L, (long)summaryLogs.size());
        Assert.assertEquals((long)1L, (long)detailLogs.size());
        for (LogInfo log : summaryLogs) {
            fileName = log.getFilename();
            Assert.assertTrue((fileName.equals(TEST_SUMMARY_LOG_FILE_NAME) || fileName.equals(TEST_DOMAIN_LOG_FILE_NAME) ? 1 : 0) != 0);
        }
        for (LogInfo log : detailLogs) {
            fileName = log.getFilename();
            Assert.assertEquals((Object)fileName, (Object)mainEntityLogFileName);
        }
    }

    @Test
    public void testMoveToDone() throws Exception {
        EntityGroupFSTimelineStore entityGroupFSTimelineStore = this.store;
        entityGroupFSTimelineStore.getClass();
        EntityGroupFSTimelineStore.AppLogs appLogs = new EntityGroupFSTimelineStore.AppLogs(entityGroupFSTimelineStore, mainTestAppId, mainTestAppDirPath, EntityGroupFSTimelineStore.AppState.COMPLETED);
        Path pathBefore = appLogs.getAppDirPath();
        appLogs.moveToDone();
        Path pathAfter = appLogs.getAppDirPath();
        Assert.assertNotEquals((Object)pathBefore, (Object)pathAfter);
        Assert.assertTrue((boolean)pathAfter.toString().contains(testDoneDirPath.toString()));
    }

    @Test
    public void testParseSummaryLogs() throws Exception {
        TimelineDataManager tdm = PluginStoreTestUtils.getTdmWithMemStore(config);
        MutableCounterLong scanned = this.store.metrics.getEntitiesReadToSummary();
        long beforeScan = scanned.value();
        EntityGroupFSTimelineStore entityGroupFSTimelineStore = this.store;
        entityGroupFSTimelineStore.getClass();
        EntityGroupFSTimelineStore.AppLogs appLogs = new EntityGroupFSTimelineStore.AppLogs(entityGroupFSTimelineStore, mainTestAppId, mainTestAppDirPath, EntityGroupFSTimelineStore.AppState.COMPLETED);
        appLogs.scanForLogs();
        appLogs.parseSummaryLogs(tdm);
        PluginStoreTestUtils.verifyTestEntities(tdm);
        Assert.assertEquals((long)(beforeScan + 2L), (long)scanned.value());
    }

    @Test
    public void testCleanLogs() throws Exception {
        String appDirName = mainTestAppId.toString();
        String attemptDirName = "appattempt" + appDirName + "_1";
        Path irrelevantFilePath = new Path(testDoneDirPath, "irrelevant.log");
        FSDataOutputStream stream = fs.create(irrelevantFilePath);
        stream.close();
        Path irrelevantDirPath = new Path(testDoneDirPath, "irrelevant");
        fs.mkdirs(irrelevantDirPath);
        Path doneAppHomeDir = new Path(new Path(testDoneDirPath, "0000"), "001");
        Path appDirClean = new Path(doneAppHomeDir, appDirName);
        Path attemptDirClean = new Path(appDirClean, attemptDirName);
        fs.mkdirs(attemptDirClean);
        Path filePath = new Path(attemptDirClean, "test.log");
        stream = fs.create(filePath);
        stream.close();
        Path appDirHoldByFile = new Path(doneAppHomeDir, appDirName + "1");
        Path attemptDirHoldByFile = new Path(appDirHoldByFile, attemptDirName);
        fs.mkdirs(attemptDirHoldByFile);
        Path filePathHold = new Path(attemptDirHoldByFile, "test1.log");
        stream = fs.create(filePathHold);
        stream.close();
        Path appDirHoldByDir = new Path(doneAppHomeDir, appDirName + "2");
        Path attemptDirHoldByDir = new Path(appDirHoldByDir, attemptDirName);
        fs.mkdirs(attemptDirHoldByDir);
        Path dirPathHold = new Path(attemptDirHoldByDir, "hold");
        fs.mkdirs(dirPathHold);
        Path appDirEmpty = new Path(doneAppHomeDir, appDirName + "3");
        Path attemptDirEmpty = new Path(appDirEmpty, attemptDirName);
        fs.mkdirs(attemptDirEmpty);
        Path dirPathEmpty = new Path(attemptDirEmpty, "empty");
        fs.mkdirs(dirPathEmpty);
        MutableCounterLong dirsCleaned = this.store.metrics.getLogsDirsCleaned();
        long before = dirsCleaned.value();
        this.store.cleanLogs(testDoneDirPath, fs, 10000L);
        Assert.assertTrue((boolean)fs.exists(irrelevantDirPath));
        Assert.assertTrue((boolean)fs.exists(irrelevantFilePath));
        Assert.assertTrue((boolean)fs.exists(filePath));
        Assert.assertTrue((boolean)fs.exists(filePathHold));
        Assert.assertTrue((boolean)fs.exists(dirPathHold));
        Assert.assertTrue((boolean)fs.exists(dirPathEmpty));
        Thread.sleep(2000L);
        stream = fs.append(filePathHold);
        stream.writeBytes("append");
        stream.close();
        fs.mkdirs(new Path(dirPathHold, "holdByMe"));
        this.store.cleanLogs(testDoneDirPath, fs, 1000L);
        Assert.assertTrue((boolean)fs.exists(irrelevantDirPath));
        Assert.assertTrue((boolean)fs.exists(irrelevantFilePath));
        Assert.assertTrue((boolean)fs.exists(filePathHold));
        Assert.assertTrue((boolean)fs.exists(dirPathHold));
        Assert.assertTrue((boolean)fs.exists(doneAppHomeDir));
        Assert.assertFalse((boolean)fs.exists(appDirClean));
        Assert.assertFalse((boolean)fs.exists(appDirEmpty));
        Assert.assertEquals((long)(before + 2L), (long)dirsCleaned.value());
    }

    @Test
    public void testPluginRead() throws Exception {
        Assert.assertEquals((Object)EntityGroupPlugInForTest.class.getName(), (Object)this.store.getConfig().get("yarn.timeline-service.entity-group-fs-store.group-id-plugin-classes"));
        EntityGroupFSTimelineStore entityGroupFSTimelineStore = this.store;
        entityGroupFSTimelineStore.getClass();
        EntityGroupFSTimelineStore.AppLogs appLogs = new EntityGroupFSTimelineStore.AppLogs(entityGroupFSTimelineStore, mainTestAppId, mainTestAppDirPath, EntityGroupFSTimelineStore.AppState.COMPLETED);
        EntityCacheItem cacheItem = new EntityCacheItem(EntityGroupPlugInForTest.getStandardTimelineGroupId(mainTestAppId), config);
        cacheItem.setAppLogs(appLogs);
        this.store.setCachedLogs(EntityGroupPlugInForTest.getStandardTimelineGroupId(mainTestAppId), cacheItem);
        MutableCounterLong detailLogEntityRead = this.store.metrics.getGetEntityToDetailOps();
        MutableStat cacheRefresh = this.store.metrics.getCacheRefresh();
        long numEntityReadBefore = detailLogEntityRead.value();
        long cacheRefreshBefore = cacheRefresh.lastStat().numSamples();
        TimelineDataManager tdm = PluginStoreTestUtils.getTdmWithStore(config, (TimelineStore)this.store);
        TimelineEntity entity3 = tdm.getEntity("type_3", mainTestAppId.toString(), EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        Assert.assertNotNull((Object)entity3);
        Assert.assertEquals((Object)this.entityNew.getStartTime(), (Object)entity3.getStartTime());
        NameValuePair primaryFilter = new NameValuePair("appid", (Object)mainTestAppId.toString());
        TimelineEntities entities = tdm.getEntities("type_3", primaryFilter, null, null, null, null, null, null, EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        Assert.assertEquals((long)1L, (long)entities.getEntities().size());
        for (TimelineEntity entity : entities.getEntities()) {
            Assert.assertEquals((Object)this.entityNew.getStartTime(), (Object)entity.getStartTime());
        }
        Assert.assertEquals((long)(numEntityReadBefore + 2L), (long)detailLogEntityRead.value());
        Assert.assertEquals((long)(cacheRefreshBefore + 1L), (long)cacheRefresh.lastStat().numSamples());
    }

    @Test
    public void testSummaryRead() throws Exception {
        EntityGroupFSTimelineStore entityGroupFSTimelineStore = this.store;
        entityGroupFSTimelineStore.getClass();
        EntityGroupFSTimelineStore.AppLogs appLogs = new EntityGroupFSTimelineStore.AppLogs(entityGroupFSTimelineStore, mainTestAppId, mainTestAppDirPath, EntityGroupFSTimelineStore.AppState.COMPLETED);
        MutableCounterLong summaryLogEntityRead = this.store.metrics.getGetEntityToSummaryOps();
        long numEntityReadBefore = summaryLogEntityRead.value();
        TimelineDataManager tdm = PluginStoreTestUtils.getTdmWithStore(config, (TimelineStore)this.store);
        appLogs.scanForLogs();
        appLogs.parseSummaryLogs(tdm);
        PluginStoreTestUtils.verifyTestEntities(tdm);
        TimelineEntities entities = tdm.getEntities("type_1", null, null, null, null, null, null, null, EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        Assert.assertEquals((long)entities.getEntities().size(), (long)1L);
        for (TimelineEntity entity : entities.getEntities()) {
            Assert.assertEquals((Object)123L, (Object)entity.getStartTime());
        }
        Assert.assertEquals((long)(numEntityReadBefore + 5L), (long)summaryLogEntityRead.value());
    }

    private void createTestFiles(ApplicationId appId, Path attemptDirPath) throws IOException {
        TimelineEntities entities = PluginStoreTestUtils.generateTestEntities();
        PluginStoreTestUtils.writeEntities(entities, new Path(attemptDirPath, TEST_SUMMARY_LOG_FILE_NAME), fs);
        HashMap<String, Set<Object>> primaryFilters = new HashMap<String, Set<Object>>();
        HashSet<String> appSet = new HashSet<String>();
        appSet.add(appId.toString());
        primaryFilters.put("appid", appSet);
        this.entityNew = PluginStoreTestUtils.createEntity(appId.toString(), "type_3", 789L, null, null, primaryFilters, null, "domain_id_1");
        TimelineEntities entityList = new TimelineEntities();
        entityList.addEntity(this.entityNew);
        PluginStoreTestUtils.writeEntities(entityList, new Path(attemptDirPath, mainEntityLogFileName), fs);
        FSDataOutputStream out = fs.create(new Path(attemptDirPath, TEST_DOMAIN_LOG_FILE_NAME));
        out.close();
    }

    private static Path getTestRootPath(String pathString) {
        return fileContextTestHelper.getTestRootPath(fc, pathString);
    }

    private static String getAttemptDirName(ApplicationId appId) {
        return "appattempt" + appId.toString() + "_1";
    }

    static {
        fileContextTestHelper = new FileContextTestHelper("/tmp/TestEntityGroupFSTimelineStore");
    }
}

