/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.EntityTypeReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.TimelineEntityReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.TimelineEntityReaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseTimelineReaderImpl
extends AbstractService
implements TimelineReader {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseTimelineReaderImpl.class);
    private Configuration hbaseConf = null;
    private Connection conn;
    private Configuration monitorHBaseConf = null;
    private Connection monitorConn;
    private ScheduledExecutorService monitorExecutorService;
    private TimelineReaderContext monitorContext;
    private long monitorInterval;
    private AtomicBoolean hbaseDown = new AtomicBoolean();
    protected static final TimelineEntityFilters MONITOR_FILTERS = new TimelineEntityFilters.Builder().entityLimit(Long.valueOf(1L)).build();
    protected static final TimelineDataToRetrieve DATA_TO_RETRIEVE = new TimelineDataToRetrieve(null, null, null, null, null, null);

    public HBaseTimelineReaderImpl() {
        super(HBaseTimelineReaderImpl.class.getName());
    }

    public void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        String clusterId = conf.get("yarn.resourcemanager.cluster-id", "yarn_cluster");
        this.monitorContext = new TimelineReaderContext(clusterId, null, null, null, null, TimelineEntityType.YARN_FLOW_ACTIVITY.toString(), null, null);
        this.monitorInterval = conf.getLong("yarn.timeline-service.reader.storage-monitor.interval-ms", 60000L);
        this.monitorHBaseConf = HBaseTimelineStorageUtils.getTimelineServiceHBaseConf(conf);
        this.monitorHBaseConf.setInt("hbase.client.retries.number", 3);
        this.monitorHBaseConf.setLong("hbase.client.pause", 1000L);
        this.monitorHBaseConf.setLong("hbase.rpc.timeout", this.monitorInterval);
        this.monitorHBaseConf.setLong("hbase.client.scanner.timeout.period", this.monitorInterval);
        this.monitorHBaseConf.setInt("zookeeper.recovery.retry", 1);
        this.monitorConn = ConnectionFactory.createConnection((Configuration)this.monitorHBaseConf);
        this.monitorExecutorService = Executors.newScheduledThreadPool(1);
        this.hbaseConf = HBaseTimelineStorageUtils.getTimelineServiceHBaseConf(conf);
        this.conn = ConnectionFactory.createConnection((Configuration)this.hbaseConf);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        LOG.info("Scheduling HBase liveness monitor at interval {}", (Object)this.monitorInterval);
        this.monitorExecutorService.scheduleAtFixedRate(new HBaseMonitor(), 0L, this.monitorInterval, TimeUnit.MILLISECONDS);
    }

    protected void serviceStop() throws Exception {
        if (this.conn != null) {
            LOG.info("closing the hbase Connection");
            this.conn.close();
        }
        if (this.monitorExecutorService != null) {
            this.monitorExecutorService.shutdownNow();
            if (!this.monitorExecutorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                LOG.warn("failed to stop the monitir task in time. will still proceed to close the monitor.");
            }
        }
        this.monitorConn.close();
        super.serviceStop();
    }

    private void checkHBaseDown() throws IOException {
        if (this.hbaseDown.get()) {
            throw new IOException("HBase is down");
        }
    }

    public boolean isHBaseDown() {
        return this.hbaseDown.get();
    }

    public TimelineEntity getEntity(TimelineReaderContext context, TimelineDataToRetrieve dataToRetrieve) throws IOException {
        this.checkHBaseDown();
        TimelineEntityReader reader = TimelineEntityReaderFactory.createSingleEntityReader(context, dataToRetrieve);
        return reader.readEntity(this.hbaseConf, this.conn);
    }

    public Set<TimelineEntity> getEntities(TimelineReaderContext context, TimelineEntityFilters filters, TimelineDataToRetrieve dataToRetrieve) throws IOException {
        this.checkHBaseDown();
        TimelineEntityReader reader = TimelineEntityReaderFactory.createMultipleEntitiesReader(context, filters, dataToRetrieve);
        return reader.readEntities(this.hbaseConf, this.conn);
    }

    public Set<String> getEntityTypes(TimelineReaderContext context) throws IOException {
        this.checkHBaseDown();
        EntityTypeReader reader = new EntityTypeReader(context);
        return reader.readEntityTypes(this.hbaseConf, this.conn);
    }

    private class HBaseMonitor
    implements Runnable {
        private HBaseMonitor() {
        }

        @Override
        public void run() {
            try {
                LOG.info("Running HBase liveness monitor");
                TimelineEntityReader reader = TimelineEntityReaderFactory.createMultipleEntitiesReader(HBaseTimelineReaderImpl.this.monitorContext, MONITOR_FILTERS, DATA_TO_RETRIEVE);
                reader.readEntities(HBaseTimelineReaderImpl.this.monitorHBaseConf, HBaseTimelineReaderImpl.this.monitorConn);
                if (HBaseTimelineReaderImpl.this.hbaseDown.getAndSet(false) && LOG.isDebugEnabled()) {
                    LOG.debug("HBase request succeeded, assuming HBase up");
                }
            }
            catch (Exception e) {
                LOG.warn("Got failure attempting to read from timeline storage, assuming HBase down", (Throwable)e);
                HBaseTimelineReaderImpl.this.hbaseDown.getAndSet(true);
            }
        }
    }
}

