/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowActivityEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowRunEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.security.AdminACLsManager;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineUIDConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineReaderManager
extends AbstractService {
    private TimelineReader reader;
    private AdminACLsManager adminACLsManager;

    public TimelineReaderManager(TimelineReader timelineReader) {
        super(TimelineReaderManager.class.getName());
        this.reader = timelineReader;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.adminACLsManager = new AdminACLsManager(conf);
    }

    private static String getClusterID(String clusterId, Configuration conf) {
        if (clusterId == null || clusterId.isEmpty()) {
            return conf.get("yarn.resourcemanager.cluster-id", "yarn_cluster");
        }
        return clusterId;
    }

    private static TimelineEntityType getTimelineEntityType(String entityType) {
        if (entityType == null) {
            return null;
        }
        try {
            return TimelineEntityType.valueOf((String)entityType);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static void fillUID(TimelineEntityType entityType, TimelineEntity entity, TimelineReaderContext context) {
        if (entityType != null) {
            switch (entityType) {
                case YARN_FLOW_ACTIVITY: {
                    FlowActivityEntity activityEntity = (FlowActivityEntity)entity;
                    context.setUserId(activityEntity.getUser());
                    context.setFlowName(activityEntity.getFlowName());
                    entity.setUID("UID", TimelineUIDConverter.FLOW_UID.encodeUID(context));
                    return;
                }
                case YARN_FLOW_RUN: {
                    FlowRunEntity runEntity = (FlowRunEntity)entity;
                    context.setFlowRunId(runEntity.getRunId());
                    entity.setUID("UID", TimelineUIDConverter.FLOWRUN_UID.encodeUID(context));
                    return;
                }
                case YARN_APPLICATION: {
                    context.setAppId(entity.getId());
                    entity.setUID("UID", TimelineUIDConverter.APPLICATION_UID.encodeUID(context));
                    return;
                }
            }
        }
        context.setEntityType(entity.getType());
        context.setEntityIdPrefix(entity.getIdPrefix());
        context.setEntityId(entity.getId());
        if (context.getDoAsUser() != null) {
            entity.setUID("UID", TimelineUIDConverter.SUB_APPLICATION_ENTITY_UID.encodeUID(context));
        } else {
            entity.setUID("UID", TimelineUIDConverter.GENERIC_ENTITY_UID.encodeUID(context));
        }
    }

    public Set<TimelineEntity> getEntities(TimelineReaderContext context, TimelineEntityFilters filters, TimelineDataToRetrieve dataToRetrieve) throws IOException {
        context.setClusterId(TimelineReaderManager.getClusterID(context.getClusterId(), this.getConfig()));
        Set<TimelineEntity> entities = this.reader.getEntities(new TimelineReaderContext(context), filters, dataToRetrieve);
        if (entities != null) {
            TimelineEntityType type = TimelineReaderManager.getTimelineEntityType(context.getEntityType());
            for (TimelineEntity entity : entities) {
                TimelineReaderManager.fillUID(type, entity, context);
            }
        }
        return entities;
    }

    public TimelineEntity getEntity(TimelineReaderContext context, TimelineDataToRetrieve dataToRetrieve) throws IOException {
        context.setClusterId(TimelineReaderManager.getClusterID(context.getClusterId(), this.getConfig()));
        TimelineEntity entity = this.reader.getEntity(new TimelineReaderContext(context), dataToRetrieve);
        if (entity != null) {
            TimelineEntityType type = TimelineReaderManager.getTimelineEntityType(context.getEntityType());
            TimelineReaderManager.fillUID(type, entity, context);
        }
        return entity;
    }

    public Set<String> getEntityTypes(TimelineReaderContext context) throws IOException {
        context.setClusterId(TimelineReaderManager.getClusterID(context.getClusterId(), this.getConfig()));
        return this.reader.getEntityTypes(new TimelineReaderContext(context));
    }

    public boolean checkAccess(UserGroupInformation callerUGI) {
        if (!this.adminACLsManager.areACLsEnabled()) {
            return true;
        }
        return callerUGI != null && this.adminACLsManager.isAdmin(callerUGI);
    }
}

