/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.server.timelineservice.reader.security.TimelineReaderWhitelistAuthorizationFilter;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestTimelineReaderWhitelistAuthorizationFilter {
    private static final String GROUP1_NAME = "group1";
    private static final String GROUP2_NAME = "group2";
    private static final String GROUP3_NAME = "group3";
    private static final String[] GROUP_NAMES = new String[]{"group1", "group2", "group3"};

    @Test
    public void checkFilterAllowedUser() throws ServletException, IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("yarn.timeline-service.read.authentication.enabled", "true");
        map.put("yarn.timeline-service.read.allowed.users", "user1,user2");
        TimelineReaderWhitelistAuthorizationFilter f = new TimelineReaderWhitelistAuthorizationFilter();
        DummyFilterConfig fc = new DummyFilterConfig(map);
        f.init((FilterConfig)fc);
        HttpServletRequest mockHsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockHsr.getUserPrincipal()).thenReturn((Object)new Principal(){

            @Override
            public String getName() {
                return "user1";
            }
        });
        HttpServletResponse r = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        f.doFilter((ServletRequest)mockHsr, (ServletResponse)r, null);
    }

    @Test
    public void checkFilterNotAllowedUser() throws ServletException, IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("yarn.timeline-service.read.authentication.enabled", "true");
        map.put("yarn.timeline-service.read.allowed.users", "user1,user2");
        TimelineReaderWhitelistAuthorizationFilter f = new TimelineReaderWhitelistAuthorizationFilter();
        DummyFilterConfig fc = new DummyFilterConfig(map);
        f.init((FilterConfig)fc);
        HttpServletRequest mockHsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        final String userName = "testuser1";
        Mockito.when((Object)mockHsr.getUserPrincipal()).thenReturn((Object)new Principal(){

            @Override
            public String getName() {
                return userName;
            }
        });
        HttpServletResponse r = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        f.doFilter((ServletRequest)mockHsr, (ServletResponse)r, null);
        String msg = "User " + userName + " is not allowed to read TimelineService V2 data.";
        ((HttpServletResponse)Mockito.verify((Object)r)).sendError(Matchers.eq((int)403), (String)Matchers.eq((Object)msg));
    }

    @Test
    public void checkFilterAllowedUserGroup() throws ServletException, IOException, InterruptedException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("yarn.timeline-service.read.authentication.enabled", "true");
        map.put("yarn.timeline-service.read.allowed.users", "user2 group1,group2");
        final TimelineReaderWhitelistAuthorizationFilter f = new TimelineReaderWhitelistAuthorizationFilter();
        DummyFilterConfig fc = new DummyFilterConfig(map);
        f.init((FilterConfig)fc);
        final HttpServletRequest mockHsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockHsr.getUserPrincipal()).thenReturn((Object)new Principal(){

            @Override
            public String getName() {
                return "user1";
            }
        });
        final HttpServletResponse r = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"user1", (String[])GROUP_NAMES);
        user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                f.doFilter((ServletRequest)mockHsr, (ServletResponse)r, null);
                return null;
            }
        });
    }

    @Test
    public void checkFilterNotAlloweGroup() throws ServletException, IOException, InterruptedException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("yarn.timeline-service.read.authentication.enabled", "true");
        map.put("yarn.timeline-service.read.allowed.users", " group5,group6");
        final TimelineReaderWhitelistAuthorizationFilter f = new TimelineReaderWhitelistAuthorizationFilter();
        DummyFilterConfig fc = new DummyFilterConfig(map);
        f.init((FilterConfig)fc);
        final HttpServletRequest mockHsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        final String userName = "user200";
        Mockito.when((Object)mockHsr.getUserPrincipal()).thenReturn((Object)new Principal(){

            @Override
            public String getName() {
                return userName;
            }
        });
        final HttpServletResponse r = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)userName, (String[])GROUP_NAMES);
        user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                f.doFilter((ServletRequest)mockHsr, (ServletResponse)r, null);
                return null;
            }
        });
        String msg = "User " + userName + " is not allowed to read TimelineService V2 data.";
        ((HttpServletResponse)Mockito.verify((Object)r)).sendError(Matchers.eq((int)403), (String)Matchers.eq((Object)msg));
    }

    @Test
    public void checkFilterAllowAdmins() throws ServletException, IOException, InterruptedException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("yarn.timeline-service.read.authentication.enabled", "true");
        map.put("yarn.timeline-service.read.allowed.users", "user3 group5,group6");
        map.put("yarn.admin.acl", " group1,group2");
        final TimelineReaderWhitelistAuthorizationFilter f = new TimelineReaderWhitelistAuthorizationFilter();
        DummyFilterConfig fc = new DummyFilterConfig(map);
        f.init((FilterConfig)fc);
        final HttpServletRequest mockHsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockHsr.getUserPrincipal()).thenReturn((Object)new Principal(){

            @Override
            public String getName() {
                return "user90";
            }
        });
        final HttpServletResponse r = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"user90", (String[])GROUP_NAMES);
        user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                f.doFilter((ServletRequest)mockHsr, (ServletResponse)r, null);
                return null;
            }
        });
    }

    @Test
    public void checkFilterAllowAdminsWhenNoUsersSet() throws ServletException, IOException, InterruptedException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("yarn.timeline-service.read.authentication.enabled", "true");
        map.put("yarn.admin.acl", " group1,group2");
        final TimelineReaderWhitelistAuthorizationFilter f = new TimelineReaderWhitelistAuthorizationFilter();
        DummyFilterConfig fc = new DummyFilterConfig(map);
        f.init((FilterConfig)fc);
        final HttpServletRequest mockHsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockHsr.getUserPrincipal()).thenReturn((Object)new Principal(){

            @Override
            public String getName() {
                return "user90";
            }
        });
        final HttpServletResponse r = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"user90", (String[])GROUP_NAMES);
        user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                f.doFilter((ServletRequest)mockHsr, (ServletResponse)r, null);
                return null;
            }
        });
    }

    @Test
    public void checkFilterAllowNoOneWhenAdminAclsEmptyAndUserAclsEmpty() throws ServletException, IOException, InterruptedException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("yarn.timeline-service.read.authentication.enabled", "true");
        final TimelineReaderWhitelistAuthorizationFilter f = new TimelineReaderWhitelistAuthorizationFilter();
        DummyFilterConfig fc = new DummyFilterConfig(map);
        f.init((FilterConfig)fc);
        final HttpServletRequest mockHsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        final String userName = "user88";
        Mockito.when((Object)mockHsr.getUserPrincipal()).thenReturn((Object)new Principal(){

            @Override
            public String getName() {
                return userName;
            }
        });
        final HttpServletResponse r = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)userName, (String[])GROUP_NAMES);
        user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                f.doFilter((ServletRequest)mockHsr, (ServletResponse)r, null);
                return null;
            }
        });
        String msg = "User " + userName + " is not allowed to read TimelineService V2 data.";
        ((HttpServletResponse)Mockito.verify((Object)r)).sendError(Matchers.eq((int)403), (String)Matchers.eq((Object)msg));
    }

    @Test
    public void checkFilterReadAuthDisabledNoAclSettings() throws ServletException, IOException, InterruptedException {
        HashMap<String, String> map = new HashMap<String, String>();
        final TimelineReaderWhitelistAuthorizationFilter f = new TimelineReaderWhitelistAuthorizationFilter();
        DummyFilterConfig fc = new DummyFilterConfig(map);
        f.init((FilterConfig)fc);
        final HttpServletRequest mockHsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockHsr.getUserPrincipal()).thenReturn((Object)new Principal(){

            @Override
            public String getName() {
                return "user437";
            }
        });
        final HttpServletResponse r = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"user437", (String[])GROUP_NAMES);
        user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                f.doFilter((ServletRequest)mockHsr, (ServletResponse)r, null);
                return null;
            }
        });
    }

    @Test
    public void checkFilterReadAuthDisabledButAclSettingsPopulated() throws ServletException, IOException, InterruptedException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("yarn.admin.acl", "user1,user2 group9,group21");
        map.put("yarn.timeline-service.read.allowed.users", "user27,user36 group5,group6");
        final TimelineReaderWhitelistAuthorizationFilter f = new TimelineReaderWhitelistAuthorizationFilter();
        DummyFilterConfig fc = new DummyFilterConfig(map);
        f.init((FilterConfig)fc);
        final HttpServletRequest mockHsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockHsr.getUserPrincipal()).thenReturn((Object)new Principal(){

            @Override
            public String getName() {
                return "user37";
            }
        });
        final HttpServletResponse r = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"user37", (String[])GROUP_NAMES);
        user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                f.doFilter((ServletRequest)mockHsr, (ServletResponse)r, null);
                return null;
            }
        });
        Mockito.when((Object)mockHsr.getUserPrincipal()).thenReturn((Object)new Principal(){

            @Override
            public String getName() {
                return "user27";
            }
        });
        final HttpServletResponse r2 = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        UserGroupInformation user2 = UserGroupInformation.createUserForTesting((String)"user27", (String[])GROUP_NAMES);
        user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                f.doFilter((ServletRequest)mockHsr, (ServletResponse)r2, null);
                return null;
            }
        });
        Mockito.when((Object)mockHsr.getUserPrincipal()).thenReturn((Object)new Principal(){

            @Override
            public String getName() {
                return "user2";
            }
        });
        final HttpServletResponse r3 = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        UserGroupInformation user3 = UserGroupInformation.createUserForTesting((String)"user2", (String[])GROUP_NAMES);
        user3.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                f.doFilter((ServletRequest)mockHsr, (ServletResponse)r3, null);
                return null;
            }
        });
    }

    private static class DummyFilterConfig
    implements FilterConfig {
        private final Map<String, String> map;

        DummyFilterConfig(Map<String, String> map) {
            this.map = map;
        }

        public String getFilterName() {
            return "dummy";
        }

        public String getInitParameter(String arg0) {
            return this.map.get(arg0);
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(this.map.keySet());
        }

        public ServletContext getServletContext() {
            return null;
        }
    }
}

