/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.JobCallable;
import org.apache.hive.hcatalog.templeton.Main;
import org.apache.hive.hcatalog.templeton.TooManyRequestsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRequestExecutor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JobRequestExecutor.class);
    private static AppConfig appConf = Main.getAppConfigInstance();
    private ThreadPoolExecutor jobExecutePool = null;
    private JobRequestType requestType;
    private String concurrentRequestsConfigName;
    private String jobTimeoutConfigName;
    private int requestExecutionTimeoutInSec = 0;
    private int threadKeepAliveTimeInHours = 1;
    private int maxTaskCancelRetryCount = 10;
    private int maxTaskCancelRetryWaitTimeInMs = 1000;
    private boolean enableCancelTask = true;

    public JobRequestExecutor(JobRequestType requestType, String concurrentRequestsConfigName, String jobTimeoutConfigName, boolean enableCancelTask) {
        int threads;
        this.concurrentRequestsConfigName = concurrentRequestsConfigName;
        this.jobTimeoutConfigName = jobTimeoutConfigName;
        this.requestType = requestType;
        this.enableCancelTask = enableCancelTask;
        int n = threads = !StringUtils.isEmpty((CharSequence)concurrentRequestsConfigName) ? appConf.getInt(concurrentRequestsConfigName, 0) : 0;
        if (threads > 0) {
            this.jobExecutePool = new ThreadPoolExecutor(threads, threads, this.threadKeepAliveTimeInHours, TimeUnit.HOURS, new SynchronousQueue<Runnable>());
            this.jobExecutePool.allowCoreThreadTimeOut(true);
            if (!StringUtils.isEmpty((CharSequence)jobTimeoutConfigName)) {
                this.requestExecutionTimeoutInSec = appConf.getInt(jobTimeoutConfigName, 0);
            }
            LOG.info("Configured " + threads + " threads for job request type " + (Object)((Object)this.requestType) + " with time out " + this.requestExecutionTimeoutInSec + " s.");
        } else {
            LOG.info("No thread pool configured for job request type " + (Object)((Object)this.requestType));
        }
    }

    public JobRequestExecutor(JobRequestType requestType, String concurrentRequestsConfigName, String jobTimeoutConfigName) {
        this(requestType, concurrentRequestsConfigName, jobTimeoutConfigName, true);
    }

    public boolean isThreadPoolEnabled() {
        return this.jobExecutePool != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T execute(JobCallable<T> jobExecuteCallable) throws InterruptedException, TimeoutException, TooManyRequestsException, ExecutionException {
        assert (jobExecuteCallable != null);
        assert (this.jobExecutePool != null);
        String type = this.requestType.toString().toLowerCase();
        String retryMessageForConcurrentRequests = "Please wait for some time before retrying the operation. Please refer to the config " + this.concurrentRequestsConfigName + " to configure concurrent requests.";
        LOG.debug("Starting new " + type + " job request with time out " + this.requestExecutionTimeoutInSec + "seconds.");
        Future<T> future = null;
        try {
            future = this.jobExecutePool.submit(jobExecuteCallable);
        }
        catch (RejectedExecutionException rejectedException) {
            String tooManyRequestsExceptionMessage = "Unable to service the " + type + " job request as templeton service is busy with too many " + type + " job requests. " + retryMessageForConcurrentRequests;
            LOG.warn(tooManyRequestsExceptionMessage);
            throw new TooManyRequestsException(tooManyRequestsExceptionMessage);
        }
        T result = null;
        try {
            result = this.requestExecutionTimeoutInSec > 0 ? future.get(this.requestExecutionTimeoutInSec, TimeUnit.SECONDS) : future.get();
        }
        catch (TimeoutException e) {
            T t = this.tryGetJobResultOrSetJobStateFailed(jobExecuteCallable);
            result = t;
            if (t == null) {
                String message = (Object)((Object)this.requestType) + " job request got timed out. Please wait for some time before retrying the operation. Please refer to the config " + this.jobTimeoutConfigName + " to configure job request time out.";
                LOG.warn(message);
                throw new TimeoutException(message);
            }
        }
        catch (InterruptedException e) {
            T t = this.tryGetJobResultOrSetJobStateFailed(jobExecuteCallable);
            result = t;
            if (t == null) {
                String message = (Object)((Object)this.requestType) + " job request got interrupted. Please wait for some time before retrying the operation.";
                LOG.warn(message);
                throw new InterruptedException(message);
            }
        }
        catch (CancellationException e) {
            T t = this.tryGetJobResultOrSetJobStateFailed(jobExecuteCallable);
            result = t;
            if (t == null) {
                String message = (Object)((Object)this.requestType) + " job request got cancelled and thread got interrupted. Please wait for some time before retrying the operation.";
                LOG.warn(message);
                throw new InterruptedException(message);
            }
        }
        finally {
            if (this.enableCancelTask) {
                this.cancelExecutePoolThread(future);
            }
        }
        LOG.debug("Completed " + type + " job request.");
        return result;
    }

    private void cancelExecutePoolThread(Future<T> future) {
        int retryCount = 0;
        while (retryCount < this.maxTaskCancelRetryCount && !future.isDone()) {
            LOG.info("Task is still executing the job request. Cancelling it with retry count: " + retryCount);
            if (future.cancel(true)) {
                LOG.info("Cancel job request issued successfully.");
                return;
            }
            ++retryCount;
            try {
                Thread.sleep(this.maxTaskCancelRetryWaitTimeInMs);
            }
            catch (InterruptedException interruptedException) {}
        }
        LOG.warn("Failed to cancel the job. isCancelled: " + future.isCancelled() + " Retry count: " + retryCount);
    }

    private T tryGetJobResultOrSetJobStateFailed(JobCallable<T> jobExecuteCallable) {
        if (!jobExecuteCallable.setJobStateFailed()) {
            LOG.info("Job is already COMPLETED. Returning the result.");
            return jobExecuteCallable.returnResult;
        }
        LOG.info("Job status set to FAILED. Job clean up to be done by execute thread after job request is executed.");
        return null;
    }

    public static enum JobRequestType {
        Submit,
        Status,
        List;

    }
}

