/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.accumulo.core.client.mapred.AccumuloInputFormat;
import org.apache.hadoop.hive.accumulo.HiveAccumuloHelper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHiveAccumuloHelper {
    private static final Logger log = Logger.getLogger(TestHiveAccumuloHelper.class);
    private HiveAccumuloHelper helper;

    @Before
    public void setup() {
        this.helper = new HiveAccumuloHelper();
    }

    @Test
    public void testTokenMerge() throws Exception {
        Text service = new Text("service");
        Token token = (Token)Mockito.mock(Token.class);
        JobConf jobConf = new JobConf();
        Mockito.when((Object)token.getService()).thenReturn((Object)service);
        try {
            this.helper.mergeTokenIntoJobConf(jobConf, token);
        }
        catch (IOException e) {
            log.info((Object)"Ignoring exception, likely coming from Hadoop 1", (Throwable)e);
            return;
        }
        Collection tokens = jobConf.getCredentials().getAllTokens();
        Assert.assertEquals((long)1L, (long)tokens.size());
        Assert.assertEquals((Object)service, (Object)((Token)tokens.iterator().next()).getService());
    }

    @Test
    public void testTokenToConfFromUser() throws Exception {
        UserGroupInformation ugi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        JobConf jobConf = new JobConf();
        ArrayList<Token> tokens = new ArrayList<Token>();
        Text service = new Text("service");
        Token token = (Token)Mockito.mock(Token.class);
        tokens.add(token);
        Mockito.when((Object)ugi.getTokens()).thenReturn(tokens);
        Mockito.when((Object)token.getKind()).thenReturn((Object)HiveAccumuloHelper.ACCUMULO_SERVICE);
        Mockito.when((Object)token.getService()).thenReturn((Object)service);
        try {
            this.helper.addTokenFromUserToJobConf(ugi, jobConf);
        }
        catch (IOException e) {
            log.info((Object)"Ignoring exception, likely coming from Hadoop 1", (Throwable)e);
            return;
        }
        Collection credTokens = jobConf.getCredentials().getAllTokens();
        Assert.assertEquals((long)1L, (long)credTokens.size());
        Assert.assertEquals((Object)service, (Object)((Token)credTokens.iterator().next()).getService());
    }

    @Test(expected=IllegalStateException.class)
    public void testISEIsPropagated() throws Exception {
        HiveAccumuloHelper helper = (HiveAccumuloHelper)Mockito.mock(HiveAccumuloHelper.class);
        JobConf jobConf = (JobConf)Mockito.mock(JobConf.class);
        Class<AccumuloInputFormat> inputOrOutputFormatClass = AccumuloInputFormat.class;
        String zookeepers = "localhost:2181";
        String instanceName = "accumulo_instance";
        boolean useSasl = false;
        ((HiveAccumuloHelper)Mockito.doCallRealMethod().when((Object)helper)).setZooKeeperInstance(jobConf, inputOrOutputFormatClass, "localhost:2181", "accumulo_instance", false);
        ((HiveAccumuloHelper)Mockito.doThrow((Throwable)new IllegalStateException()).when((Object)helper)).setZooKeeperInstanceWithReflection(jobConf, inputOrOutputFormatClass, "localhost:2181", "accumulo_instance", false);
        helper.setZooKeeperInstance(jobConf, inputOrOutputFormatClass, "localhost:2181", "accumulo_instance", false);
    }

    @Test(expected=IllegalStateException.class)
    public void testISEIsPropagatedWithReflection() throws Exception {
        HiveAccumuloHelper helper = (HiveAccumuloHelper)Mockito.mock(HiveAccumuloHelper.class);
        JobConf jobConf = (JobConf)Mockito.mock(JobConf.class);
        Class<AccumuloInputFormat> inputOrOutputFormatClass = AccumuloInputFormat.class;
        String zookeepers = "localhost:2181";
        String instanceName = "accumulo_instance";
        boolean useSasl = false;
        ((HiveAccumuloHelper)Mockito.doCallRealMethod().when((Object)helper)).setZooKeeperInstance(jobConf, inputOrOutputFormatClass, "localhost:2181", "accumulo_instance", false);
        ((HiveAccumuloHelper)Mockito.doThrow((Throwable)new InvocationTargetException(new IllegalStateException())).when((Object)helper)).setZooKeeperInstanceWithReflection(jobConf, inputOrOutputFormatClass, "localhost:2181", "accumulo_instance", false);
        helper.setZooKeeperInstance(jobConf, inputOrOutputFormatClass, "localhost:2181", "accumulo_instance", false);
    }
}

