/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.predicate;

import com.google.common.collect.Lists;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.AccumuloIndexScanner;
import org.apache.hadoop.hive.accumulo.TestAccumuloDefaultIndexScanner;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloRowIdColumnMapping;
import org.apache.hadoop.hive.accumulo.predicate.AccumuloPredicateHandler;
import org.apache.hadoop.hive.accumulo.predicate.AccumuloRangeGenerator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.UDFToString;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPlus;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAccumuloRangeGenerator {
    private AccumuloPredicateHandler handler;
    private HiveAccumuloRowIdColumnMapping rowIdMapping;
    private Configuration conf;

    @Before
    public void setup() {
        this.handler = AccumuloPredicateHandler.getInstance();
        this.rowIdMapping = new HiveAccumuloRowIdColumnMapping(":rowID", ColumnEncoding.STRING, "row", TypeInfoFactory.stringTypeInfo.toString());
        this.conf = new Configuration(true);
    }

    @Test
    public void testRangeConjunction() throws Exception {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"f");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), (List)children);
        Assert.assertNotNull((Object)node);
        ExprNodeColumnDesc column2 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant2 = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"m");
        ArrayList children2 = Lists.newArrayList();
        children2.add(column2);
        children2.add(constant2);
        ExprNodeGenericFuncDesc node2 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), (List)children2);
        Assert.assertNotNull((Object)node2);
        ArrayList bothFilters = Lists.newArrayList();
        bothFilters.add(node);
        bothFilters.add(node2);
        ExprNodeGenericFuncDesc both = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPAnd(), (List)bothFilters);
        List<Range> expectedRanges = Arrays.asList(new Range(new Key((CharSequence)"f"), true, new Key((CharSequence)"m\u0000"), false));
        AccumuloRangeGenerator rangeGenerator = new AccumuloRangeGenerator(this.conf, this.handler, this.rowIdMapping, "rid");
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher((NodeProcessor)rangeGenerator, Collections.emptyMap(), null);
        DefaultGraphWalker ogw = new DefaultGraphWalker((Dispatcher)disp);
        ArrayList<ExprNodeGenericFuncDesc> topNodes = new ArrayList<ExprNodeGenericFuncDesc>();
        topNodes.add(both);
        HashMap nodeOutput = new HashMap();
        try {
            ogw.startWalking(topNodes, nodeOutput);
        }
        catch (SemanticException ex) {
            throw new RuntimeException(ex);
        }
        Object result = nodeOutput.get(both);
        Assert.assertNotNull(result);
        Assert.assertTrue((String)"Result from graph walk was not a List", (boolean)(result instanceof List));
        List actualRanges = (List)result;
        Assert.assertEquals(expectedRanges, (Object)actualRanges);
    }

    @Test
    public void testRangeDisjunction() throws Exception {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"f");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), (List)children);
        Assert.assertNotNull((Object)node);
        ExprNodeColumnDesc column2 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant2 = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"m");
        ArrayList children2 = Lists.newArrayList();
        children2.add(column2);
        children2.add(constant2);
        ExprNodeGenericFuncDesc node2 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), (List)children2);
        Assert.assertNotNull((Object)node2);
        ArrayList bothFilters = Lists.newArrayList();
        bothFilters.add(node);
        bothFilters.add(node2);
        ExprNodeGenericFuncDesc both = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPOr(), (List)bothFilters);
        List<Range> expectedRanges = Arrays.asList(new Range());
        AccumuloRangeGenerator rangeGenerator = new AccumuloRangeGenerator(this.conf, this.handler, this.rowIdMapping, "rid");
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher((NodeProcessor)rangeGenerator, Collections.emptyMap(), null);
        DefaultGraphWalker ogw = new DefaultGraphWalker((Dispatcher)disp);
        ArrayList<ExprNodeGenericFuncDesc> topNodes = new ArrayList<ExprNodeGenericFuncDesc>();
        topNodes.add(both);
        HashMap nodeOutput = new HashMap();
        try {
            ogw.startWalking(topNodes, nodeOutput);
        }
        catch (SemanticException ex) {
            throw new RuntimeException(ex);
        }
        Object result = nodeOutput.get(both);
        Assert.assertNotNull(result);
        Assert.assertTrue((String)"Result from graph walk was not a List", (boolean)(result instanceof List));
        List actualRanges = (List)result;
        Assert.assertEquals(expectedRanges, (Object)actualRanges);
    }

    @Test
    public void testRangeConjunctionWithDisjunction() throws Exception {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"h");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), (List)children);
        Assert.assertNotNull((Object)node);
        ExprNodeColumnDesc column2 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant2 = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"d");
        ArrayList children2 = Lists.newArrayList();
        children2.add(column2);
        children2.add(constant2);
        ExprNodeGenericFuncDesc node2 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), (List)children2);
        Assert.assertNotNull((Object)node2);
        ExprNodeColumnDesc column3 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant3 = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"q");
        ArrayList children3 = Lists.newArrayList();
        children3.add(column3);
        children3.add(constant3);
        ExprNodeGenericFuncDesc node3 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), (List)children3);
        Assert.assertNotNull((Object)node3);
        ArrayList orFilters = Lists.newArrayList();
        orFilters.add(node2);
        orFilters.add(node3);
        ExprNodeGenericFuncDesc orNode = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPOr(), (List)orFilters);
        ArrayList andFilters = Lists.newArrayList();
        andFilters.add(node);
        andFilters.add(orNode);
        ExprNodeGenericFuncDesc both = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPAnd(), (List)andFilters);
        List<Range> expectedRanges = Arrays.asList(new Range(new Key((CharSequence)"q"), true, null, false));
        AccumuloRangeGenerator rangeGenerator = new AccumuloRangeGenerator(this.conf, this.handler, this.rowIdMapping, "rid");
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher((NodeProcessor)rangeGenerator, Collections.emptyMap(), null);
        DefaultGraphWalker ogw = new DefaultGraphWalker((Dispatcher)disp);
        ArrayList<ExprNodeGenericFuncDesc> topNodes = new ArrayList<ExprNodeGenericFuncDesc>();
        topNodes.add(both);
        HashMap nodeOutput = new HashMap();
        try {
            ogw.startWalking(topNodes, nodeOutput);
        }
        catch (SemanticException ex) {
            throw new RuntimeException(ex);
        }
        Object result = nodeOutput.get(both);
        Assert.assertNotNull(result);
        Assert.assertTrue((String)"Result from graph walk was not a List", (boolean)(result instanceof List));
        List actualRanges = (List)result;
        Assert.assertEquals(expectedRanges, (Object)actualRanges);
    }

    @Test
    public void testPartialRangeConjunction() throws Exception {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"f");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), (List)children);
        Assert.assertNotNull((Object)node);
        ExprNodeColumnDesc column2 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "anythingElse", null, false);
        ExprNodeConstantDesc constant2 = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"foo");
        ArrayList children2 = Lists.newArrayList();
        children2.add(column2);
        children2.add(constant2);
        ExprNodeGenericFuncDesc node2 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), (List)children2);
        Assert.assertNotNull((Object)node2);
        ArrayList bothFilters = Lists.newArrayList();
        bothFilters.add(node);
        bothFilters.add(node2);
        ExprNodeGenericFuncDesc both = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPAnd(), (List)bothFilters);
        List<Range> expectedRanges = Arrays.asList(new Range(new Key((CharSequence)"f"), true, null, false));
        AccumuloRangeGenerator rangeGenerator = new AccumuloRangeGenerator(this.conf, this.handler, this.rowIdMapping, "rid");
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher((NodeProcessor)rangeGenerator, Collections.emptyMap(), null);
        DefaultGraphWalker ogw = new DefaultGraphWalker((Dispatcher)disp);
        ArrayList<ExprNodeGenericFuncDesc> topNodes = new ArrayList<ExprNodeGenericFuncDesc>();
        topNodes.add(both);
        HashMap nodeOutput = new HashMap();
        try {
            ogw.startWalking(topNodes, nodeOutput);
        }
        catch (SemanticException ex) {
            throw new RuntimeException(ex);
        }
        Object result = nodeOutput.get(both);
        Assert.assertNotNull(result);
        Assert.assertTrue((String)"Result from graph walk was not a List", (boolean)(result instanceof List));
        List actualRanges = (List)result;
        Assert.assertEquals(expectedRanges, (Object)actualRanges);
    }

    @Test
    public void testDateRangeConjunction() throws Exception {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.dateTypeInfo, (Object)Date.valueOf("2014-01-01"));
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), (List)children);
        Assert.assertNotNull((Object)node);
        ExprNodeColumnDesc column2 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant2 = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.dateTypeInfo, (Object)Date.valueOf("2014-07-01"));
        ArrayList children2 = Lists.newArrayList();
        children2.add(column2);
        children2.add(constant2);
        ExprNodeGenericFuncDesc node2 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPLessThan(), (List)children2);
        Assert.assertNotNull((Object)node2);
        ArrayList bothFilters = Lists.newArrayList();
        bothFilters.add(node);
        bothFilters.add(node2);
        ExprNodeGenericFuncDesc both = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPAnd(), (List)bothFilters);
        List<Range> expectedRanges = Arrays.asList(new Range(new Key((CharSequence)"2014-01-01"), true, new Key((CharSequence)"2014-07-01"), false));
        AccumuloRangeGenerator rangeGenerator = new AccumuloRangeGenerator(this.conf, this.handler, this.rowIdMapping, "rid");
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher((NodeProcessor)rangeGenerator, Collections.emptyMap(), null);
        DefaultGraphWalker ogw = new DefaultGraphWalker((Dispatcher)disp);
        ArrayList<ExprNodeGenericFuncDesc> topNodes = new ArrayList<ExprNodeGenericFuncDesc>();
        topNodes.add(both);
        HashMap nodeOutput = new HashMap();
        try {
            ogw.startWalking(topNodes, nodeOutput);
        }
        catch (SemanticException ex) {
            throw new RuntimeException(ex);
        }
        Object result = nodeOutput.get(both);
        Assert.assertNotNull(result);
        Assert.assertTrue((String)"Result from graph walk was not a List", (boolean)(result instanceof List));
        List actualRanges = (List)result;
        Assert.assertEquals(expectedRanges, (Object)actualRanges);
    }

    @Test
    public void testCastExpression() throws Exception {
        ExprNodeConstantDesc fourty = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)40);
        ExprNodeConstantDesc fifty = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)50);
        GenericUDFOPPlus plus = new GenericUDFOPPlus();
        ExprNodeGenericFuncDesc addition = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)plus, Arrays.asList(fourty, fifty));
        UDFToString stringCast = new UDFToString();
        GenericUDFBridge stringCastBridge = new GenericUDFBridge("cast", false, stringCast.getClass().getName());
        ExprNodeGenericFuncDesc cast = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)stringCastBridge, "cast", Collections.singletonList(addition));
        ExprNodeColumnDesc key = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "key", null, false);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), Arrays.asList(key, cast));
        AccumuloRangeGenerator rangeGenerator = new AccumuloRangeGenerator(this.conf, this.handler, this.rowIdMapping, "key");
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher((NodeProcessor)rangeGenerator, Collections.emptyMap(), null);
        DefaultGraphWalker ogw = new DefaultGraphWalker((Dispatcher)disp);
        ArrayList<ExprNodeGenericFuncDesc> topNodes = new ArrayList<ExprNodeGenericFuncDesc>();
        topNodes.add(node);
        HashMap nodeOutput = new HashMap();
        try {
            ogw.startWalking(topNodes, nodeOutput);
        }
        catch (SemanticException ex) {
            throw new RuntimeException(ex);
        }
        Object result = nodeOutput.get(node);
        Assert.assertNull(result);
    }

    @Test
    public void testRangeOverNonRowIdField() throws Exception {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "foo", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"f");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), (List)children);
        Assert.assertNotNull((Object)node);
        ExprNodeColumnDesc column2 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "foo", null, false);
        ExprNodeConstantDesc constant2 = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"m");
        ArrayList children2 = Lists.newArrayList();
        children2.add(column2);
        children2.add(constant2);
        ExprNodeGenericFuncDesc node2 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), (List)children2);
        Assert.assertNotNull((Object)node2);
        ArrayList bothFilters = Lists.newArrayList();
        bothFilters.add(node);
        bothFilters.add(node2);
        ExprNodeGenericFuncDesc both = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPAnd(), (List)bothFilters);
        AccumuloRangeGenerator rangeGenerator = new AccumuloRangeGenerator(this.conf, this.handler, this.rowIdMapping, "rid");
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher((NodeProcessor)rangeGenerator, Collections.emptyMap(), null);
        DefaultGraphWalker ogw = new DefaultGraphWalker((Dispatcher)disp);
        ArrayList<ExprNodeGenericFuncDesc> topNodes = new ArrayList<ExprNodeGenericFuncDesc>();
        topNodes.add(both);
        HashMap nodeOutput = new HashMap();
        try {
            ogw.startWalking(topNodes, nodeOutput);
        }
        catch (SemanticException ex) {
            throw new RuntimeException(ex);
        }
        Object result = nodeOutput.get(both);
        Assert.assertNull(result);
    }

    @Test
    public void testRangeOverStringIndexedField() throws Exception {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "age", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"10");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), (List)children);
        Assert.assertNotNull((Object)node);
        ExprNodeColumnDesc column2 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "age", null, false);
        ExprNodeConstantDesc constant2 = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"50");
        ArrayList children2 = Lists.newArrayList();
        children2.add(column2);
        children2.add(constant2);
        ExprNodeGenericFuncDesc node2 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), (List)children2);
        Assert.assertNotNull((Object)node2);
        ArrayList bothFilters = Lists.newArrayList();
        bothFilters.add(node);
        bothFilters.add(node2);
        ExprNodeGenericFuncDesc both = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPAnd(), (List)bothFilters);
        AccumuloRangeGenerator rangeGenerator = new AccumuloRangeGenerator(this.conf, this.handler, this.rowIdMapping, "rid");
        rangeGenerator.setIndexScanner((AccumuloIndexScanner)TestAccumuloDefaultIndexScanner.buildMockHandler(10));
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher((NodeProcessor)rangeGenerator, Collections.emptyMap(), null);
        DefaultGraphWalker ogw = new DefaultGraphWalker((Dispatcher)disp);
        ArrayList<ExprNodeGenericFuncDesc> topNodes = new ArrayList<ExprNodeGenericFuncDesc>();
        topNodes.add(both);
        HashMap nodeOutput = new HashMap();
        try {
            ogw.startWalking(topNodes, nodeOutput);
        }
        catch (SemanticException ex) {
            throw new RuntimeException(ex);
        }
        Object result = nodeOutput.get(both);
        if (result instanceof List) {
            List results = (List)result;
            Assert.assertEquals((long)3L, (long)results.size());
            Assert.assertTrue((String)"does not contain row1", (boolean)results.contains(new Range((CharSequence)"row1")));
            Assert.assertTrue((String)"does not contain row2", (boolean)results.contains(new Range((CharSequence)"row2")));
            Assert.assertTrue((String)"does not contain row3", (boolean)results.contains(new Range((CharSequence)"row3")));
        } else {
            Assert.fail((String)"Results not a list");
        }
    }

    @Test
    public void testRangeOverIntegerIndexedField() throws Exception {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.intTypeInfo, "cars", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)2);
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), (List)children);
        Assert.assertNotNull((Object)node);
        ExprNodeColumnDesc column2 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.intTypeInfo, "cars", null, false);
        ExprNodeConstantDesc constant2 = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)9);
        ArrayList children2 = Lists.newArrayList();
        children2.add(column2);
        children2.add(constant2);
        ExprNodeGenericFuncDesc node2 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), (List)children2);
        Assert.assertNotNull((Object)node2);
        ArrayList bothFilters = Lists.newArrayList();
        bothFilters.add(node);
        bothFilters.add(node2);
        ExprNodeGenericFuncDesc both = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPAnd(), (List)bothFilters);
        AccumuloRangeGenerator rangeGenerator = new AccumuloRangeGenerator(this.conf, this.handler, this.rowIdMapping, "rid");
        rangeGenerator.setIndexScanner((AccumuloIndexScanner)TestAccumuloDefaultIndexScanner.buildMockHandler(10));
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher((NodeProcessor)rangeGenerator, Collections.emptyMap(), null);
        DefaultGraphWalker ogw = new DefaultGraphWalker((Dispatcher)disp);
        ArrayList<ExprNodeGenericFuncDesc> topNodes = new ArrayList<ExprNodeGenericFuncDesc>();
        topNodes.add(both);
        HashMap nodeOutput = new HashMap();
        try {
            ogw.startWalking(topNodes, nodeOutput);
        }
        catch (SemanticException ex) {
            throw new RuntimeException(ex);
        }
        Object result = nodeOutput.get(both);
        if (result instanceof List) {
            List results = (List)result;
            Assert.assertEquals((long)3L, (long)results.size());
            Assert.assertTrue((String)"does not contain row1", (boolean)results.contains(new Range((CharSequence)"row1")));
            Assert.assertTrue((String)"does not contain row2", (boolean)results.contains(new Range((CharSequence)"row2")));
            Assert.assertTrue((String)"does not contain row3", (boolean)results.contains(new Range((CharSequence)"row3")));
        } else {
            Assert.fail((String)"Results not a list");
        }
    }

    @Test
    public void testRangeOverBooleanIndexedField() throws Exception {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, "mgr", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (Object)true);
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPEqual(), (List)children);
        Assert.assertNotNull((Object)node);
        AccumuloRangeGenerator rangeGenerator = new AccumuloRangeGenerator(this.conf, this.handler, this.rowIdMapping, "rid");
        rangeGenerator.setIndexScanner((AccumuloIndexScanner)TestAccumuloDefaultIndexScanner.buildMockHandler(10));
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher((NodeProcessor)rangeGenerator, Collections.emptyMap(), null);
        DefaultGraphWalker ogw = new DefaultGraphWalker((Dispatcher)disp);
        ArrayList<ExprNodeGenericFuncDesc> topNodes = new ArrayList<ExprNodeGenericFuncDesc>();
        topNodes.add(node);
        HashMap nodeOutput = new HashMap();
        try {
            ogw.startWalking(topNodes, nodeOutput);
        }
        catch (SemanticException ex) {
            throw new RuntimeException(ex);
        }
        Object result = nodeOutput.get(node);
        if (result instanceof List) {
            List results = (List)result;
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertTrue((String)"does not contain row1", (boolean)results.contains(new Range((CharSequence)"row1")));
            Assert.assertTrue((String)"does not contain row3", (boolean)results.contains(new Range((CharSequence)"row3")));
        } else {
            Assert.fail((String)"Results not a list");
        }
    }
}

