/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.hadoop.hive.accumulo.AccumuloConnectionParameters;
import org.apache.hadoop.hive.accumulo.HiveAccumuloHelper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHiveAccumuloHelper {
    private static final Logger log = Logger.getLogger(TestHiveAccumuloHelper.class);
    private HiveAccumuloHelper helper;

    @Before
    public void setup() {
        this.helper = new HiveAccumuloHelper();
    }

    @Test
    public void testTokenMerge() throws Exception {
        Text service = new Text("service");
        Token token = (Token)Mockito.mock(Token.class);
        JobConf jobConf = new JobConf();
        Mockito.when((Object)token.getService()).thenReturn((Object)service);
        try {
            this.helper.mergeTokenIntoJobConf(jobConf, token);
        }
        catch (IOException e) {
            log.info((Object)"Ignoring exception, likely coming from Hadoop 1", (Throwable)e);
            return;
        }
        Collection tokens = jobConf.getCredentials().getAllTokens();
        Assert.assertEquals((long)1L, (long)tokens.size());
        Assert.assertEquals((Object)service, (Object)((Token)tokens.iterator().next()).getService());
    }

    @Test
    public void testTokenToConfFromUser() throws Exception {
        UserGroupInformation ugi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        JobConf jobConf = new JobConf();
        ArrayList<Token> tokens = new ArrayList<Token>();
        Text service = new Text("service");
        Token token = (Token)Mockito.mock(Token.class);
        tokens.add(token);
        Mockito.when((Object)ugi.getTokens()).thenReturn(tokens);
        Mockito.when((Object)token.getKind()).thenReturn((Object)HiveAccumuloHelper.ACCUMULO_SERVICE);
        Mockito.when((Object)token.getService()).thenReturn((Object)service);
        try {
            this.helper.addTokenFromUserToJobConf(ugi, jobConf);
        }
        catch (IOException e) {
            log.info((Object)"Ignoring exception, likely coming from Hadoop 1", (Throwable)e);
            return;
        }
        Collection credTokens = jobConf.getCredentials().getAllTokens();
        Assert.assertEquals((long)1L, (long)credTokens.size());
        Assert.assertEquals((Object)service, (Object)((Token)credTokens.iterator().next()).getService());
    }

    @Test
    public void testInputFormatWithKerberosToken() throws Exception {
        JobConf jobConf = new JobConf();
        HiveAccumuloHelper helper = (HiveAccumuloHelper)Mockito.mock(HiveAccumuloHelper.class);
        AuthenticationToken authToken = (AuthenticationToken)Mockito.mock(AuthenticationToken.class);
        Token hadoopToken = (Token)Mockito.mock(Token.class);
        AccumuloConnectionParameters cnxnParams = (AccumuloConnectionParameters)Mockito.mock(AccumuloConnectionParameters.class);
        Connector connector = (Connector)Mockito.mock(Connector.class);
        String user = "bob";
        String instanceName = "accumulo";
        String zookeepers = "host1:2181,host2:2181,host3:2181";
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"bob", (String[])new String[0]);
        ((HiveAccumuloHelper)Mockito.doCallRealMethod().when((Object)helper)).updateOutputFormatConfWithAccumuloToken(jobConf, ugi, cnxnParams);
        ((HiveAccumuloHelper)Mockito.doCallRealMethod().when((Object)helper)).updateInputFormatConfWithAccumuloToken(jobConf, ugi, cnxnParams);
        ((HiveAccumuloHelper)Mockito.doCallRealMethod().when((Object)helper)).updateConfWithAccumuloToken(jobConf, ugi, cnxnParams, true);
        Mockito.when((Object)cnxnParams.getConnector()).thenReturn((Object)connector);
        Mockito.when((Object)helper.getDelegationToken(connector)).thenReturn((Object)authToken);
        Mockito.when((Object)helper.getHadoopToken(authToken)).thenReturn((Object)hadoopToken);
        Mockito.when((Object)cnxnParams.useSasl()).thenReturn((Object)true);
        Mockito.when((Object)cnxnParams.getAccumuloUserName()).thenReturn((Object)"bob");
        Mockito.when((Object)cnxnParams.getAccumuloInstanceName()).thenReturn((Object)"accumulo");
        Mockito.when((Object)cnxnParams.getZooKeepers()).thenReturn((Object)"host1:2181,host2:2181,host3:2181");
        Mockito.when((Object)helper.hasKerberosCredentials(ugi)).thenReturn((Object)true);
        helper.updateInputFormatConfWithAccumuloToken(jobConf, ugi, cnxnParams);
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).setInputFormatConnectorInfo(jobConf, "bob", authToken);
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).mergeTokenIntoJobConf(jobConf, hadoopToken);
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).addTokenFromUserToJobConf(ugi, jobConf);
        Collection tokens = ugi.getTokens();
        Assert.assertEquals((long)1L, (long)tokens.size());
        Assert.assertEquals((Object)hadoopToken, tokens.iterator().next());
    }

    @Test
    public void testInputFormatWithoutKerberosToken() throws Exception {
        JobConf jobConf = new JobConf();
        HiveAccumuloHelper helper = (HiveAccumuloHelper)Mockito.mock(HiveAccumuloHelper.class);
        AuthenticationToken authToken = (AuthenticationToken)Mockito.mock(AuthenticationToken.class);
        Token hadoopToken = (Token)Mockito.mock(Token.class);
        AccumuloConnectionParameters cnxnParams = (AccumuloConnectionParameters)Mockito.mock(AccumuloConnectionParameters.class);
        Connector connector = (Connector)Mockito.mock(Connector.class);
        String user = "bob";
        String instanceName = "accumulo";
        String zookeepers = "host1:2181,host2:2181,host3:2181";
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"bob", (String[])new String[0]);
        ((HiveAccumuloHelper)Mockito.doCallRealMethod().when((Object)helper)).updateOutputFormatConfWithAccumuloToken(jobConf, ugi, cnxnParams);
        ((HiveAccumuloHelper)Mockito.doCallRealMethod().when((Object)helper)).updateInputFormatConfWithAccumuloToken(jobConf, ugi, cnxnParams);
        ((HiveAccumuloHelper)Mockito.doCallRealMethod().when((Object)helper)).updateConfWithAccumuloToken(jobConf, ugi, cnxnParams, true);
        Mockito.when((Object)cnxnParams.getConnector()).thenReturn((Object)connector);
        Mockito.when((Object)helper.getDelegationToken(connector)).thenReturn((Object)authToken);
        Mockito.when((Object)helper.getHadoopToken(authToken)).thenReturn((Object)hadoopToken);
        Mockito.when((Object)cnxnParams.useSasl()).thenReturn((Object)true);
        Mockito.when((Object)cnxnParams.getAccumuloUserName()).thenReturn((Object)"bob");
        Mockito.when((Object)cnxnParams.getAccumuloInstanceName()).thenReturn((Object)"accumulo");
        Mockito.when((Object)cnxnParams.getZooKeepers()).thenReturn((Object)"host1:2181,host2:2181,host3:2181");
        Mockito.when((Object)helper.hasKerberosCredentials(ugi)).thenReturn((Object)false);
        helper.updateInputFormatConfWithAccumuloToken(jobConf, ugi, cnxnParams);
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).addTokenFromUserToJobConf(ugi, jobConf);
    }

    @Test
    public void testOutputFormatSaslConfigurationWithoutKerberosToken() throws Exception {
        JobConf jobConf = new JobConf();
        HiveAccumuloHelper helper = (HiveAccumuloHelper)Mockito.mock(HiveAccumuloHelper.class);
        AuthenticationToken authToken = (AuthenticationToken)Mockito.mock(AuthenticationToken.class);
        Token hadoopToken = (Token)Mockito.mock(Token.class);
        AccumuloConnectionParameters cnxnParams = (AccumuloConnectionParameters)Mockito.mock(AccumuloConnectionParameters.class);
        Connector connector = (Connector)Mockito.mock(Connector.class);
        String user = "bob";
        String instanceName = "accumulo";
        String zookeepers = "host1:2181,host2:2181,host3:2181";
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"bob", (String[])new String[0]);
        ((HiveAccumuloHelper)Mockito.doCallRealMethod().when((Object)helper)).updateOutputFormatConfWithAccumuloToken(jobConf, ugi, cnxnParams);
        ((HiveAccumuloHelper)Mockito.doCallRealMethod().when((Object)helper)).updateConfWithAccumuloToken(jobConf, ugi, cnxnParams, false);
        Mockito.when((Object)cnxnParams.getConnector()).thenReturn((Object)connector);
        Mockito.when((Object)helper.getDelegationToken(connector)).thenReturn((Object)authToken);
        Mockito.when((Object)helper.getHadoopToken(authToken)).thenReturn((Object)hadoopToken);
        Mockito.when((Object)cnxnParams.useSasl()).thenReturn((Object)true);
        Mockito.when((Object)cnxnParams.getAccumuloUserName()).thenReturn((Object)"bob");
        Mockito.when((Object)cnxnParams.getAccumuloInstanceName()).thenReturn((Object)"accumulo");
        Mockito.when((Object)cnxnParams.getZooKeepers()).thenReturn((Object)"host1:2181,host2:2181,host3:2181");
        Mockito.when((Object)helper.hasKerberosCredentials(ugi)).thenReturn((Object)false);
        helper.updateOutputFormatConfWithAccumuloToken(jobConf, ugi, cnxnParams);
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).addTokenFromUserToJobConf(ugi, jobConf);
    }

    @Test
    public void testOutputFormatSaslConfigurationWithKerberosToken() throws Exception {
        JobConf jobConf = new JobConf();
        HiveAccumuloHelper helper = (HiveAccumuloHelper)Mockito.mock(HiveAccumuloHelper.class);
        AuthenticationToken authToken = (AuthenticationToken)Mockito.mock(AuthenticationToken.class);
        Token hadoopToken = (Token)Mockito.mock(Token.class);
        AccumuloConnectionParameters cnxnParams = (AccumuloConnectionParameters)Mockito.mock(AccumuloConnectionParameters.class);
        Connector connector = (Connector)Mockito.mock(Connector.class);
        String user = "bob";
        String instanceName = "accumulo";
        String zookeepers = "host1:2181,host2:2181,host3:2181";
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"bob", (String[])new String[0]);
        ((HiveAccumuloHelper)Mockito.doCallRealMethod().when((Object)helper)).updateOutputFormatConfWithAccumuloToken(jobConf, ugi, cnxnParams);
        ((HiveAccumuloHelper)Mockito.doCallRealMethod().when((Object)helper)).updateConfWithAccumuloToken(jobConf, ugi, cnxnParams, false);
        Mockito.when((Object)cnxnParams.getConnector()).thenReturn((Object)connector);
        Mockito.when((Object)helper.getDelegationToken(connector)).thenReturn((Object)authToken);
        Mockito.when((Object)helper.getHadoopToken(authToken)).thenReturn((Object)hadoopToken);
        Mockito.when((Object)cnxnParams.useSasl()).thenReturn((Object)true);
        Mockito.when((Object)cnxnParams.getAccumuloUserName()).thenReturn((Object)"bob");
        Mockito.when((Object)cnxnParams.getAccumuloInstanceName()).thenReturn((Object)"accumulo");
        Mockito.when((Object)cnxnParams.getZooKeepers()).thenReturn((Object)"host1:2181,host2:2181,host3:2181");
        Mockito.when((Object)helper.hasKerberosCredentials(ugi)).thenReturn((Object)true);
        helper.updateOutputFormatConfWithAccumuloToken(jobConf, ugi, cnxnParams);
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).setOutputFormatConnectorInfo(jobConf, "bob", authToken);
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).mergeTokenIntoJobConf(jobConf, hadoopToken);
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).addTokenFromUserToJobConf(ugi, jobConf);
        Collection tokens = ugi.getTokens();
        Assert.assertEquals((long)1L, (long)tokens.size());
        Assert.assertEquals((Object)hadoopToken, tokens.iterator().next());
    }
}

