/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.predicate;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.user.WholeRowIterator;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.ColumnMappingFactory;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloColumnMapping;
import org.apache.hadoop.hive.accumulo.predicate.compare.CompareOp;
import org.apache.hadoop.hive.accumulo.predicate.compare.PrimitiveComparison;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimitiveComparisonFilter
extends WholeRowIterator {
    private static final Logger LOG = LoggerFactory.getLogger(PrimitiveComparisonFilter.class);
    public static final String FILTER_PREFIX = "accumulo.filter.compare.iterator.";
    public static final String P_COMPARE_CLASS = "accumulo.filter.iterator.p.compare.class";
    public static final String COMPARE_OPT_CLASS = "accumulo.filter.iterator.compare.opt.class";
    public static final String CONST_VAL = "accumulo.filter.iterator.const.val";
    public static final String COLUMN = "accumulo.filter.iterator.qual";
    private Text cfHolder;
    private Text cqHolder;
    private Text columnMappingFamily;
    private Text columnMappingQualifier;
    private HiveAccumuloColumnMapping columnMapping;
    private CompareOp compOpt;

    protected boolean filter(Text currentRow, List<Key> keys, List<Value> values) {
        boolean allow;
        try {
            while (keys.get(0).getColumnFamily().getBytes().length == 0) {
                SortedMap items = PrimitiveComparisonFilter.decodeRow((Key)keys.get(0), (Value)values.get(0));
                keys = Lists.newArrayList(items.keySet());
                values = Lists.newArrayList(items.values());
            }
            allow = this.accept(keys, values);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return allow;
    }

    private boolean accept(Collection<Key> keys, Collection<Value> values) {
        Iterator<Key> kIter = keys.iterator();
        Iterator<Value> vIter = values.iterator();
        while (kIter.hasNext()) {
            Key k = kIter.next();
            Value v = vIter.next();
            if (!this.matchQualAndFam(k)) continue;
            return this.compOpt.accept(v.get());
        }
        return false;
    }

    private boolean matchQualAndFam(Key k) {
        k.getColumnFamily(this.cfHolder);
        k.getColumnQualifier(this.cqHolder);
        return this.cfHolder.equals((Object)this.columnMappingFamily) && this.cqHolder.equals((Object)this.columnMappingQualifier);
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        String serializedColumnMapping = options.get(COLUMN);
        Map.Entry<String, String> pair = ColumnMappingFactory.parseMapping(serializedColumnMapping);
        this.columnMapping = new HiveAccumuloColumnMapping(pair.getKey(), pair.getValue(), ColumnEncoding.STRING, "column", "string");
        this.columnMappingFamily = new Text(this.columnMapping.getColumnFamily());
        this.columnMappingQualifier = new Text(this.columnMapping.getColumnQualifier());
        this.cfHolder = new Text();
        this.cqHolder = new Text();
        try {
            Class pClass = JavaUtils.loadClass((String)options.get(P_COMPARE_CLASS));
            Class cClazz = JavaUtils.loadClass((String)options.get(COMPARE_OPT_CLASS));
            PrimitiveComparison pCompare = pClass.asSubclass(PrimitiveComparison.class).newInstance();
            this.compOpt = cClazz.asSubclass(CompareOp.class).newInstance();
            byte[] constant = this.getConstant(options);
            pCompare.init(constant);
            this.compOpt.setPrimitiveCompare(pCompare);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
    }

    protected byte[] getConstant(Map<String, String> options) {
        String b64Const = options.get(CONST_VAL);
        return Base64.decodeBase64((byte[])b64Const.getBytes());
    }
}

