/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.predicate.compare;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.hadoop.hive.accumulo.predicate.compare.DoubleCompare;
import org.apache.hadoop.hive.accumulo.predicate.compare.Equal;
import org.apache.hadoop.hive.accumulo.predicate.compare.GreaterThan;
import org.apache.hadoop.hive.accumulo.predicate.compare.GreaterThanOrEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.LessThan;
import org.apache.hadoop.hive.accumulo.predicate.compare.LessThanOrEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.Like;
import org.apache.hadoop.hive.accumulo.predicate.compare.NotEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.PrimitiveComparison;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDoubleCompare {
    private DoubleCompare doubleCompare;

    @Before
    public void setup() {
        this.doubleCompare = new DoubleCompare();
        byte[] db = new byte[8];
        ByteBuffer.wrap(db).putDouble(10.5);
        this.doubleCompare.init(db);
    }

    public byte[] getBytes(double val) {
        byte[] dBytes = new byte[8];
        ByteBuffer.wrap(dBytes).putDouble(val);
        BigDecimal bd = this.doubleCompare.serialize(dBytes);
        Assert.assertEquals((double)bd.doubleValue(), (double)val, (double)0.0);
        return dBytes;
    }

    @Test
    public void equal() {
        Equal equalObj = new Equal((PrimitiveComparison)this.doubleCompare);
        byte[] val = this.getBytes(10.5);
        Assert.assertTrue((boolean)equalObj.accept(val));
    }

    @Test
    public void notEqual() {
        NotEqual notEqualObj = new NotEqual((PrimitiveComparison)this.doubleCompare);
        byte[] val = this.getBytes(11.0);
        Assert.assertTrue((boolean)notEqualObj.accept(val));
        val = this.getBytes(10.5);
        Assert.assertFalse((boolean)notEqualObj.accept(val));
    }

    @Test
    public void greaterThan() {
        GreaterThan greaterThanObj = new GreaterThan((PrimitiveComparison)this.doubleCompare);
        byte[] val = this.getBytes(11.0);
        Assert.assertTrue((boolean)greaterThanObj.accept(val));
        val = this.getBytes(4.5);
        Assert.assertFalse((boolean)greaterThanObj.accept(val));
        val = this.getBytes(10.5);
        Assert.assertFalse((boolean)greaterThanObj.accept(val));
    }

    @Test
    public void greaterThanOrEqual() {
        GreaterThanOrEqual greaterThanOrEqualObj = new GreaterThanOrEqual((PrimitiveComparison)this.doubleCompare);
        byte[] val = this.getBytes(11.0);
        Assert.assertTrue((boolean)greaterThanOrEqualObj.accept(val));
        val = this.getBytes(4.0);
        Assert.assertFalse((boolean)greaterThanOrEqualObj.accept(val));
        val = this.getBytes(10.5);
        Assert.assertTrue((boolean)greaterThanOrEqualObj.accept(val));
    }

    @Test
    public void lessThan() {
        LessThan lessThanObj = new LessThan((PrimitiveComparison)this.doubleCompare);
        byte[] val = this.getBytes(11.0);
        Assert.assertFalse((boolean)lessThanObj.accept(val));
        val = this.getBytes(4.0);
        Assert.assertTrue((boolean)lessThanObj.accept(val));
        val = this.getBytes(10.5);
        Assert.assertFalse((boolean)lessThanObj.accept(val));
    }

    @Test
    public void lessThanOrEqual() {
        LessThanOrEqual lessThanOrEqualObj = new LessThanOrEqual((PrimitiveComparison)this.doubleCompare);
        byte[] val = this.getBytes(11.0);
        Assert.assertFalse((boolean)lessThanOrEqualObj.accept(val));
        val = this.getBytes(4.0);
        Assert.assertTrue((boolean)lessThanOrEqualObj.accept(val));
        val = this.getBytes(10.5);
        Assert.assertTrue((boolean)lessThanOrEqualObj.accept(val));
    }

    @Test
    public void like() {
        try {
            Like likeObj = new Like((PrimitiveComparison)this.doubleCompare);
            Assert.assertTrue((boolean)likeObj.accept(new byte[0]));
            Assert.fail((String)"should not accept");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Like not supported for " + this.doubleCompare.getClass().getName()));
        }
    }

    @Test
    public void invalidSerialization() {
        try {
            byte[] badVal = new byte[4];
            ByteBuffer.wrap(badVal).putInt(1);
            this.doubleCompare.serialize(badVal);
            Assert.fail((String)"Should fail");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(" occurred trying to build double value"));
        }
    }
}

