/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.predicate;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.accumulo.core.data.Range;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.AccumuloIndexLexicoder;
import org.apache.hadoop.hive.accumulo.AccumuloIndexScanner;
import org.apache.hadoop.hive.accumulo.AccumuloIndexScannerException;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloRowIdColumnMapping;
import org.apache.hadoop.hive.accumulo.predicate.AccumuloPredicateHandler;
import org.apache.hadoop.hive.accumulo.predicate.NoSuchCompareOpException;
import org.apache.hadoop.hive.accumulo.predicate.compare.CompareOp;
import org.apache.hadoop.hive.accumulo.predicate.compare.Equal;
import org.apache.hadoop.hive.accumulo.predicate.compare.GreaterThan;
import org.apache.hadoop.hive.accumulo.predicate.compare.GreaterThanOrEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.LessThan;
import org.apache.hadoop.hive.accumulo.predicate.compare.LessThanOrEqual;
import org.apache.hadoop.hive.accumulo.serde.AccumuloIndexParameters;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloRangeGenerator
implements NodeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AccumuloRangeGenerator.class);
    private final AccumuloPredicateHandler predicateHandler;
    private final HiveAccumuloRowIdColumnMapping rowIdMapping;
    private final String hiveRowIdColumnName;
    private AccumuloIndexScanner indexScanner;

    public AccumuloRangeGenerator(Configuration conf, AccumuloPredicateHandler predicateHandler, HiveAccumuloRowIdColumnMapping rowIdMapping, String hiveRowIdColumnName) {
        this.predicateHandler = predicateHandler;
        this.rowIdMapping = rowIdMapping;
        this.hiveRowIdColumnName = hiveRowIdColumnName;
        try {
            this.indexScanner = new AccumuloIndexParameters(conf).createScanner();
        }
        catch (AccumuloIndexScannerException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            this.indexScanner = null;
        }
    }

    public AccumuloIndexScanner getIndexScanner() {
        return this.indexScanner;
    }

    public void setIndexScanner(AccumuloIndexScanner indexScanner) {
        this.indexScanner = indexScanner;
    }

    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        if (!(nd instanceof ExprNodeGenericFuncDesc)) {
            return nd;
        }
        ExprNodeGenericFuncDesc func = (ExprNodeGenericFuncDesc)nd;
        if (FunctionRegistry.isOpAnd((ExprNodeDesc)func)) {
            return this.processAndOpNode(nd, nodeOutputs);
        }
        if (FunctionRegistry.isOpOr((ExprNodeDesc)func)) {
            return this.processOrOpNode(nd, nodeOutputs);
        }
        if (FunctionRegistry.isOpNot((ExprNodeDesc)func)) {
            throw new IllegalArgumentException("Negations not yet implemented");
        }
        return this.processExpression(func, nodeOutputs);
    }

    protected Object processAndOpNode(Node nd, Object[] nodeOutputs) {
        ArrayList<Range> andRanges = null;
        for (Object nodeOutput : nodeOutputs) {
            ArrayList<Range> newRanges;
            if (null == nodeOutput) continue;
            if (null == andRanges) {
                andRanges = new ArrayList<Range>();
            }
            if (nodeOutput instanceof Range) {
                Range childRange = (Range)nodeOutput;
                if (andRanges.isEmpty()) {
                    andRanges.add(childRange);
                    continue;
                }
                newRanges = new ArrayList<Range>();
                for (Range andRange : andRanges) {
                    Range intersectedRange = andRange.clip(childRange, true);
                    if (null == intersectedRange) continue;
                    newRanges.add(intersectedRange);
                }
                andRanges = newRanges;
                continue;
            }
            if (nodeOutput instanceof List) {
                List childRanges = (List)nodeOutput;
                if (andRanges.isEmpty()) {
                    andRanges.addAll(childRanges);
                    continue;
                }
                newRanges = new ArrayList();
                for (Range andRange : andRanges) {
                    for (Range childRange : childRanges) {
                        Range intersectedRange = andRange.clip(childRange, true);
                        if (null == intersectedRange) continue;
                        newRanges.add(intersectedRange);
                    }
                }
                andRanges = newRanges;
                continue;
            }
            LOG.error("Expected Range from {} but got {}", (Object)nd, nodeOutput);
            throw new IllegalArgumentException("Expected Range but got " + nodeOutput.getClass().getName());
        }
        return andRanges;
    }

    protected Object processOrOpNode(Node nd, Object[] nodeOutputs) {
        ArrayList<Range> orRanges = new ArrayList<Range>(nodeOutputs.length);
        for (Object nodeOutput : nodeOutputs) {
            if (nodeOutput instanceof Range) {
                orRanges.add((Range)nodeOutput);
                continue;
            }
            if (nodeOutput instanceof List) {
                List childRanges = (List)nodeOutput;
                orRanges.addAll(childRanges);
                continue;
            }
            LOG.error("Expected Range from {} but got {}", (Object)nd, nodeOutput);
            throw new IllegalArgumentException("Expected Range but got " + nodeOutput.getClass().getName());
        }
        if (orRanges.size() > 1) {
            return Range.mergeOverlapping(orRanges);
        }
        if (1 == orRanges.size()) {
            return orRanges.get(0);
        }
        return orRanges;
    }

    protected Object processExpression(ExprNodeGenericFuncDesc func, Object[] nodeOutputs) throws SemanticException {
        GenericUDF genericUdf = func.getGenericUDF();
        ExprNodeConstantDesc constantDesc = null;
        ExprNodeColumnDesc columnDesc = null;
        ExprNodeDesc leftHandNode = null;
        for (Object nodeOutput : nodeOutputs) {
            if (nodeOutput instanceof ExprNodeConstantDesc) {
                if (null == leftHandNode) {
                    leftHandNode = (ExprNodeDesc)nodeOutput;
                }
                constantDesc = (ExprNodeConstantDesc)nodeOutput;
                continue;
            }
            if (!(nodeOutput instanceof ExprNodeColumnDesc)) continue;
            if (null == leftHandNode) {
                leftHandNode = (ExprNodeDesc)nodeOutput;
            }
            columnDesc = (ExprNodeColumnDesc)nodeOutput;
        }
        if (null == constantDesc || null == columnDesc) {
            return null;
        }
        ConstantObjectInspector objInspector = constantDesc.getWritableObjectInspector();
        if (!this.hiveRowIdColumnName.equals(columnDesc.getColumn())) {
            if (this.indexScanner != null && this.indexScanner.isIndexed(columnDesc.getColumn())) {
                return this.getIndexedRowIds(genericUdf, leftHandNode, columnDesc.getColumn(), objInspector);
            }
            return null;
        }
        Text constText = this.getConstantText(objInspector);
        return this.getRange(genericUdf, leftHandNode, constText);
    }

    private Range getRange(GenericUDF genericUdf, ExprNodeDesc leftHandNode, Text constText) {
        Class<? extends CompareOp> opClz;
        try {
            opClz = this.predicateHandler.getCompareOpClass(genericUdf.getUdfName());
        }
        catch (NoSuchCompareOpException e) {
            throw new IllegalArgumentException("Unhandled UDF class: " + genericUdf.getUdfName());
        }
        if (leftHandNode instanceof ExprNodeConstantDesc) {
            return this.getConstantOpColumnRange(opClz, constText);
        }
        if (leftHandNode instanceof ExprNodeColumnDesc) {
            return this.getColumnOpConstantRange(opClz, constText);
        }
        throw new IllegalStateException("Expected column or constant on LHS of expression");
    }

    private Text getConstantText(ConstantObjectInspector objInspector) throws SemanticException {
        Text constText;
        switch (this.rowIdMapping.getEncoding()) {
            case STRING: {
                constText = this.getUtf8Value(objInspector);
                break;
            }
            case BINARY: {
                try {
                    constText = this.getBinaryValue(objInspector);
                    break;
                }
                catch (IOException e) {
                    throw new SemanticException((Throwable)e);
                }
            }
            default: {
                throw new SemanticException("Unable to parse unknown encoding: " + (Object)((Object)this.rowIdMapping.getEncoding()));
            }
        }
        return constText;
    }

    protected Range getConstantOpColumnRange(Class<? extends CompareOp> opClz, Text constText) {
        if (opClz.equals(Equal.class)) {
            return new Range(constText);
        }
        if (opClz.equals(GreaterThanOrEqual.class)) {
            return new Range(null, constText);
        }
        if (opClz.equals(GreaterThan.class)) {
            return new Range(null, false, constText, false);
        }
        if (opClz.equals(LessThanOrEqual.class)) {
            return new Range(constText, true, null, false);
        }
        if (opClz.equals(LessThan.class)) {
            return new Range(constText, false, null, false);
        }
        throw new IllegalArgumentException("Could not process " + opClz);
    }

    protected Range getColumnOpConstantRange(Class<? extends CompareOp> opClz, Text constText) {
        if (opClz.equals(Equal.class)) {
            return new Range(constText);
        }
        if (opClz.equals(GreaterThanOrEqual.class)) {
            return new Range(constText, null);
        }
        if (opClz.equals(GreaterThan.class)) {
            return new Range(constText, false, null, false);
        }
        if (opClz.equals(LessThanOrEqual.class)) {
            return new Range(null, false, constText, true);
        }
        if (opClz.equals(LessThan.class)) {
            return new Range(null, false, constText, false);
        }
        throw new IllegalArgumentException("Could not process " + opClz);
    }

    protected Object getIndexedRowIds(GenericUDF genericUdf, ExprNodeDesc leftHandNode, String columnName, ConstantObjectInspector objInspector) throws SemanticException {
        Text constText = this.getConstantText(objInspector);
        byte[] value = constText.toString().getBytes(StandardCharsets.UTF_8);
        byte[] encoded = AccumuloIndexLexicoder.encodeValue(value, leftHandNode.getTypeString(), true);
        Range range = this.getRange(genericUdf, leftHandNode, new Text(encoded));
        if (this.indexScanner != null) {
            return this.indexScanner.getIndexRowRanges(columnName, range);
        }
        return null;
    }

    protected Text getUtf8Value(ConstantObjectInspector objInspector) {
        return new Text(objInspector.getWritableConstantValue().toString());
    }

    protected Text getBinaryValue(ConstantObjectInspector objInspector) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (!(objInspector instanceof PrimitiveObjectInspector)) {
            return this.getUtf8Value(objInspector);
        }
        LazyUtils.writePrimitive((OutputStream)out, (Object)objInspector.getWritableConstantValue(), (PrimitiveObjectInspector)((PrimitiveObjectInspector)objInspector));
        out.close();
        return new Text(out.toByteArray());
    }
}

