/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.Commands;
import org.junit.Assert;
import org.junit.Test;

public class TestCommands {
    @Test
    public void testLinesEndingWithComments() {
        BeeLine beeline = new BeeLine();
        Commands commands = new Commands(beeline);
        int[] escape = new int[]{-1};
        Assert.assertEquals((Object)"show tables;", (Object)commands.removeComments("show tables;", escape));
        Assert.assertEquals((Object)"show tables;", (Object)commands.removeComments("show tables; --comments", escape));
        Assert.assertEquals((Object)"show tables;", (Object)commands.removeComments("show tables; -------comments", escape));
        Assert.assertEquals((Object)"show tables;", (Object)commands.removeComments("show tables; -------comments;one;two;three;;;;", escape));
        Assert.assertEquals((Object)"show", (Object)commands.removeComments("show-- tables; -------comments", escape));
        Assert.assertEquals((Object)"show", (Object)commands.removeComments("show --tables; -------comments", escape));
        Assert.assertEquals((Object)"s", (Object)commands.removeComments("s--how --tables; -------comments", escape));
        Assert.assertEquals((Object)"", (Object)commands.removeComments("-- show tables; -------comments", escape));
        Assert.assertEquals((Object)"\"show tables\"", (Object)commands.removeComments("\"show tables\" --comments", escape));
        Assert.assertEquals((Object)"\"show --comments tables\"", (Object)commands.removeComments("\"show --comments tables\" --comments", escape));
        Assert.assertEquals((Object)"\"'show --comments' tables\"", (Object)commands.removeComments("\"'show --comments' tables\" --comments", escape));
        Assert.assertEquals((Object)"'show --comments tables'", (Object)commands.removeComments("'show --comments tables' --comments", escape));
        Assert.assertEquals((Object)"'\"show --comments tables\"'", (Object)commands.removeComments("'\"show --comments tables\"' --comments", escape));
    }
}

