/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline.hs2connection;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hive.beeline.hs2connection.BeelineHS2ConnectionFileParseException;
import org.apache.hive.beeline.hs2connection.HS2ConnectionFileUtils;
import org.apache.hive.beeline.hs2connection.UserHS2ConnectionFileParser;
import org.apache.hive.common.util.HiveTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestUserHS2ConnectionFileParser {
    private final String LOCATION_1 = System.getProperty("java.io.tmpdir") + "loc1" + File.separator + "beeline-hs2-connection.xml";
    private final String LOCATION_2 = System.getProperty("java.io.tmpdir") + "loc2" + File.separator + "beeline-hs2-connection.xml";
    private final String LOCATION_3 = System.getProperty("java.io.tmpdir") + "loc3" + File.separator + "beeline-hs2-connection.xml";
    List<String> testLocations = new ArrayList<String>();

    @After
    public void cleanUp() {
        try {
            this.deleteFile(this.LOCATION_1);
            this.deleteFile(this.LOCATION_2);
            this.deleteFile(this.LOCATION_3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.testLocations.clear();
    }

    @Test
    public void testParseNoAuthentication() throws BeelineHS2ConnectionFileParseException {
        String url = this.getParsedUrlFromConfigFile("test-hs2-connection-config-noauth.xml");
        String expectedUrl = "jdbc:hive2://localhost:10000/default;user=hive";
        Assert.assertTrue((String)("Expected " + expectedUrl + " got " + url), (boolean)expectedUrl.equals(url));
    }

    @Test
    public void testParseZookeeper() throws BeelineHS2ConnectionFileParseException {
        String url = this.getParsedUrlFromConfigFile("test-hs2-connection-zookeeper-config.xml");
        String expectedUrl = "jdbc:hive2://zk-node-1:10000,zk-node-2:10001,zk-node-3:10004/default;serviceDiscoveryMode=zookeeper;zooKeeperNamespace=hiveserver2";
        Assert.assertTrue((String)("Expected " + expectedUrl + " got " + url), (boolean)expectedUrl.equals(url));
    }

    @Test
    public void testParseWithKerberosNoSSL() throws BeelineHS2ConnectionFileParseException {
        String url = this.getParsedUrlFromConfigFile("test-hs2-conn-conf-kerberos-nossl.xml");
        String expectedUrl = "jdbc:hive2://localhost:10000/default;principal=hive/dummy-hostname@domain.com;ssl=false";
        Assert.assertTrue((String)("Expected " + expectedUrl + " got " + url), (boolean)expectedUrl.equals(url));
    }

    @Test
    public void testParseWithKerberosSSL() throws BeelineHS2ConnectionFileParseException {
        String url = this.getParsedUrlFromConfigFile("test-hs2-conn-conf-kerberos-ssl.xml");
        String expectedUrl = "jdbc:hive2://localhost:10000/default;principal=hive/dummy-hostname@domain.com;ssl=true;sslTrustStore=test/truststore;trustStorePassword=testTruststorePassword";
        Assert.assertTrue((String)("Expected " + expectedUrl + " got " + url), (boolean)expectedUrl.equals(url));
    }

    @Test
    public void testParseWithSSLAndHttpMode() throws BeelineHS2ConnectionFileParseException {
        String url = this.getParsedUrlFromConfigFile("test-hs2-conn-conf-kerberos-http.xml");
        String expectedUrl = "jdbc:hive2://localhost:10000/default;httpPath=testHTTPPath;principal=hive/dummy-hostname@domain.com;ssl=true;sslTrustStore=test/truststore;transportMode=http;trustStorePassword=testTruststorePassword";
        Assert.assertTrue((String)("Expected " + expectedUrl + " got " + url), (boolean)expectedUrl.equals(url));
    }

    @Test
    public void testUrlWithHiveConfValues() throws Exception {
        String url = this.getParsedUrlFromConfigFile("test-hs2-connection-conf-list.xml");
        String expectedUrl = "jdbc:hive2://localhost:10000/default;user=hive?hive.cli.print.current.db=false#testVarName1=value1";
        Assert.assertTrue((String)("Expected " + expectedUrl + " got " + url), (boolean)expectedUrl.equals(url));
    }

    @Test
    public void testUrlWithMultipleHiveConfValues() throws Exception {
        String url = this.getParsedUrlFromConfigFile("test-hs2-connection-multi-conf-list.xml");
        String expectedUrl = "jdbc:hive2://localhost:10000/default;user=hive?hive.cli.print.current.db=true;hive.cli.print.header=true#testVarName1=value1;testVarName2=value2";
        Assert.assertTrue((String)("Expected " + expectedUrl + " got " + url), (boolean)expectedUrl.equals(url));
    }

    @Test
    public void testNoLocationFoundCase() throws Exception {
        this.testLocations.add(this.LOCATION_1);
        this.testLocations.add(this.LOCATION_2);
        this.testLocations.add(this.LOCATION_3);
        UserHS2ConnectionFileParser testHS2ConfigManager = new UserHS2ConnectionFileParser(this.testLocations);
        Assert.assertTrue((boolean)testHS2ConfigManager.getConnectionProperties().isEmpty());
    }

    @Test
    public void testGetLocation1() throws Exception {
        this.createNewFile(this.LOCATION_1);
        this.testLocations.add(this.LOCATION_1);
        this.testLocations.add(this.LOCATION_2);
        this.testLocations.add(this.LOCATION_3);
        UserHS2ConnectionFileParser testHS2ConfigManager = new UserHS2ConnectionFileParser(this.testLocations);
        Assert.assertTrue((String)("File location " + this.LOCATION_1 + " was not returned"), (boolean)this.LOCATION_1.equals(testHS2ConfigManager.getFileLocation()));
    }

    @Test
    public void testGetLocation3() throws Exception {
        this.createNewFile(this.LOCATION_3);
        this.testLocations.add(this.LOCATION_1);
        this.testLocations.add(this.LOCATION_2);
        this.testLocations.add(this.LOCATION_3);
        UserHS2ConnectionFileParser testHS2ConfigManager = new UserHS2ConnectionFileParser(this.testLocations);
        Assert.assertTrue((String)("File location " + this.LOCATION_3 + " was not returned"), (boolean)this.LOCATION_3.equals(testHS2ConfigManager.getFileLocation()));
    }

    @Test
    public void testGetLocationOrder() throws Exception {
        this.createNewFile(this.LOCATION_2);
        this.createNewFile(this.LOCATION_3);
        this.testLocations.add(this.LOCATION_1);
        this.testLocations.add(this.LOCATION_2);
        this.testLocations.add(this.LOCATION_3);
        UserHS2ConnectionFileParser testHS2ConfigManager = new UserHS2ConnectionFileParser(this.testLocations);
        Assert.assertTrue((String)("File location " + this.LOCATION_2 + " was not returned"), (boolean)this.LOCATION_2.equals(testHS2ConfigManager.getFileLocation()));
    }

    private String getParsedUrlFromConfigFile(String filename) throws BeelineHS2ConnectionFileParseException {
        String path = HiveTestUtils.getFileFromClasspath((String)filename);
        this.testLocations.add(path);
        UserHS2ConnectionFileParser testHS2ConfigManager = new UserHS2ConnectionFileParser(this.testLocations);
        String url = HS2ConnectionFileUtils.getUrl((Properties)testHS2ConfigManager.getConnectionProperties());
        return url;
    }

    private void createNewFile(String path) throws Exception {
        File file = new File(path);
        if (file.exists()) {
            return;
        }
        String dir = path.substring(0, path.indexOf("beeline-hs2-connection.xml"));
        if (!new File(dir).exists() && !new File(dir).mkdirs()) {
            throw new Exception("Could not create directory " + dir);
        }
        if (!file.createNewFile()) {
            throw new Exception("Could not create new file at " + path);
        }
    }

    private void deleteFile(String path) throws Exception {
        File file = new File(path);
        if (file.exists() && !file.delete()) {
            throw new Exception("Could not delete file at " + path);
        }
    }
}

