/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.tools.HiveSchemaHelper;
import org.apache.hive.beeline.HiveSchemaTool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"javax.management.*"})
@PrepareForTest(value={HiveSchemaHelper.class, HiveSchemaTool.CommandBuilder.class})
public class TestHiveSchemaTool {
    String scriptFile = System.getProperty("java.io.tmpdir") + File.separator + "someScript.sql";
    @Mock
    private HiveConf hiveConf;
    private HiveSchemaTool.CommandBuilder builder;
    private String pasword = "reallySimplePassword";

    @Before
    public void setup() throws IOException {
        PowerMockito.mockStatic(HiveSchemaHelper.class, (Class[])new Class[0]);
        Mockito.when((Object)HiveSchemaHelper.getValidConfVar((MetastoreConf.ConfVars)((MetastoreConf.ConfVars)Matchers.eq((Object)MetastoreConf.ConfVars.CONNECT_URL_KEY)), (Configuration)((Configuration)Matchers.same((Object)this.hiveConf)))).thenReturn((Object)"someURL");
        Mockito.when((Object)HiveSchemaHelper.getValidConfVar((MetastoreConf.ConfVars)((MetastoreConf.ConfVars)Matchers.eq((Object)MetastoreConf.ConfVars.CONNECTION_DRIVER)), (Configuration)((Configuration)Matchers.same((Object)this.hiveConf)))).thenReturn((Object)"someDriver");
        File file = new File(this.scriptFile);
        if (!file.exists()) {
            file.createNewFile();
        }
        this.builder = new HiveSchemaTool.CommandBuilder(this.hiveConf, null, null, "testUser", this.pasword, this.scriptFile);
    }

    @After
    public void globalAssert() throws IOException {
        PowerMockito.verifyStatic();
        HiveSchemaHelper.getValidConfVar((MetastoreConf.ConfVars)((MetastoreConf.ConfVars)Matchers.eq((Object)MetastoreConf.ConfVars.CONNECT_URL_KEY)), (Configuration)((Configuration)Matchers.same((Object)this.hiveConf)));
        HiveSchemaHelper.getValidConfVar((MetastoreConf.ConfVars)((MetastoreConf.ConfVars)Matchers.eq((Object)MetastoreConf.ConfVars.CONNECTION_DRIVER)), (Configuration)((Configuration)Matchers.same((Object)this.hiveConf)));
        new File(this.scriptFile).delete();
    }

    @Test
    public void shouldReturnStrippedPassword() throws IOException {
        Assert.assertFalse((boolean)this.builder.buildToLog().contains(this.pasword));
    }

    @Test
    public void shouldReturnActualPassword() throws IOException {
        String[] strings = this.builder.buildToRun();
        Assert.assertTrue((boolean)Arrays.asList(strings).contains(this.pasword));
    }
}

