/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidWriteIds {
    public static final ValidWriteIds NO_WRITE_IDS = new ValidWriteIds(-1L, -1L, false, null);
    public static final String MM_PREFIX = "mm";
    private static final String CURRENT_SUFFIX = ".current";
    private static final Logger LOG = LoggerFactory.getLogger(ValidWriteIds.class);
    private static final String VALID_WRITEIDS_PREFIX = "hive.valid.write.ids.";
    private final long lowWatermark;
    private final long highWatermark;
    private final boolean areIdsValid;
    private final HashSet<Long> ids;
    private String source = null;

    public ValidWriteIds(long lowWatermark, long highWatermark, boolean areIdsValid, HashSet<Long> ids) {
        this.lowWatermark = lowWatermark;
        this.highWatermark = highWatermark;
        this.areIdsValid = areIdsValid;
        this.ids = ids;
    }

    public static ValidWriteIds createFromConf(Configuration conf, String dbName, String tblName) {
        return ValidWriteIds.createFromConf(conf, dbName + "." + tblName);
    }

    public static ValidWriteIds createFromConf(Configuration conf, String fullTblName) {
        String key = ValidWriteIds.createConfKey(fullTblName);
        String idStr = conf.get(key, null);
        String current = conf.get(key + CURRENT_SUFFIX, null);
        if (idStr == null || idStr.isEmpty()) {
            return null;
        }
        return new ValidWriteIds(idStr, current);
    }

    private static String createConfKey(String dbName, String tblName) {
        return ValidWriteIds.createConfKey(dbName + "." + tblName);
    }

    private static String createConfKey(String fullName) {
        return VALID_WRITEIDS_PREFIX + fullName;
    }

    private ValidWriteIds(String src, String current) {
        String[] values = src.split(":");
        this.highWatermark = Long.parseLong(values[0]);
        this.lowWatermark = Long.parseLong(values[1]);
        if (values.length > 2) {
            this.areIdsValid = Long.parseLong(values[2]) > 0L;
            this.ids = new HashSet();
            for (int i = 3; i < values.length; ++i) {
                this.ids.add(Long.parseLong(values[i]));
            }
            if (current != null) {
                long currentId = Long.parseLong(current);
                if (this.areIdsValid) {
                    this.ids.add(currentId);
                } else {
                    this.ids.remove(currentId);
                }
            }
        } else if (current != null) {
            long currentId = Long.parseLong(current);
            this.areIdsValid = true;
            this.ids = new HashSet();
            this.ids.add(currentId);
        } else {
            this.areIdsValid = false;
            this.ids = null;
        }
    }

    public static void addCurrentToConf(Configuration conf, String dbName, String tblName, long mmWriteId) {
        String key = ValidWriteIds.createConfKey(dbName, tblName) + CURRENT_SUFFIX;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting " + key + " => " + mmWriteId);
        }
        conf.set(key, Long.toString(mmWriteId));
    }

    public void addToConf(Configuration conf, String dbName, String tblName) {
        if (this.source == null) {
            this.source = this.toString();
        }
        String key = ValidWriteIds.createConfKey(dbName, tblName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting " + key + " => " + this.source + " (old value was " + conf.get(key, null) + ")");
        }
        conf.set(key, this.source);
    }

    public static void clearConf(Configuration conf, String dbName, String tblName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unsetting " + ValidWriteIds.createConfKey(dbName, tblName));
        }
        conf.unset(ValidWriteIds.createConfKey(dbName, tblName));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.highWatermark);
        buf.append(':');
        buf.append(this.lowWatermark);
        if (this.ids != null) {
            buf.append(':');
            buf.append(this.areIdsValid ? 1 : 0);
            for (long id : this.ids) {
                buf.append(':');
                buf.append(id);
            }
        }
        return buf.toString();
    }

    public boolean isValid(long writeId) {
        if (writeId < 0L) {
            throw new RuntimeException("Incorrect write ID " + writeId);
        }
        if (writeId <= this.lowWatermark) {
            return true;
        }
        if (writeId >= this.highWatermark) {
            return false;
        }
        return this.ids != null && this.areIdsValid == this.ids.contains(writeId);
    }

    public static String getMmFilePrefix(long mmWriteId) {
        return "mm_" + mmWriteId;
    }

    public static Long extractWriteId(Path file) {
        String fileName = file.getName();
        Object[] parts = fileName.split("_", 3);
        if (parts.length < 2 || !MM_PREFIX.equals(parts[0])) {
            LOG.info("Cannot extract write ID for a MM table: " + file + " (" + Arrays.toString(parts) + ")");
            return null;
        }
        long writeId = -1L;
        try {
            writeId = Long.parseLong(parts[1]);
        }
        catch (NumberFormatException ex) {
            LOG.info("Cannot extract write ID for a MM table: " + file + "; parsing " + (String)parts[1] + " got " + ex.getMessage());
            return null;
        }
        return writeId;
    }

    public static class AnyIdDirFilter
    implements PathFilter {
        public boolean accept(Path path) {
            String name = path.getName();
            if (!name.startsWith("mm_")) {
                return false;
            }
            String idStr = name.substring(ValidWriteIds.MM_PREFIX.length() + 1);
            try {
                Long.parseLong(idStr);
            }
            catch (NumberFormatException ex) {
                return false;
            }
            return true;
        }
    }

    public static class IdPathFilter
    implements PathFilter {
        private final String mmDirName;
        private final boolean isMatch;
        private final boolean isIgnoreTemp;

        public IdPathFilter(long writeId, boolean isMatch) {
            this(writeId, isMatch, false);
        }

        public IdPathFilter(long writeId, boolean isMatch, boolean isIgnoreTemp) {
            this.mmDirName = ValidWriteIds.getMmFilePrefix(writeId);
            this.isMatch = isMatch;
            this.isIgnoreTemp = isIgnoreTemp;
        }

        public boolean accept(Path path) {
            char c;
            String name = path.getName();
            if (name.equals(this.mmDirName)) {
                return this.isMatch;
            }
            if (this.isIgnoreTemp && name.length() > 0 && ((c = name.charAt(0)) == '.' || c == '_')) {
                return false;
            }
            return !this.isMatch;
        }
    }
}

